{ ABBREVU.PAS : Check sorted abbrevations textfile for unique keys


  Title   : ABBREVU
  Version : 2.0
  Date    : Nov 24,1996
  Author  : J.R. Ferguson
  Language: Borland Turbo Pascal 4.0 through 7.0
  Usage   : Refer procedure Help
}

program AbbrevUnique;


uses CvtLib, StpLib, ChrLib, DefLib, Printer, Crt;


const
  ProgIdent   = 'ABBREVU';
  ProgVersion = 'v2.0';
  OPTCHR      = '/';
  OPTHRDCPY   = 'H';
  OPTCHRPOS   = 'P';  DFLKEYPOS = 1;
  OPTCHRLEN   = 'L';  DFLKEYLEN = 8;

  ERROK       = 0;
  ERRARG      = 1;
  ERRMAX      = 5;

var
  InpFile,
  OutFile     : text;

  HrdCpy      : boolean;
  KeyPos,
  KeyLen      : byte;
  ErrCod      : integer;

const
  ErrMsg      : array[0..ERRMAX] of String[80]
              = (''
                ,'Illegal command'
                ,'error code unknown'
                ,'error code unknown'
                ,'error code unknown'
                ,'error code unknown'
                );


procedure Help;
begin
  WriteLn('Usage  : ABBREVU [<InpFile] [>OutFile] [/Pi] [/Ln]');
  WriteLn('options: /H  : hardcopy (send report listing to printer)');
  WriteLn('         /Pi : key starts at position i    default i=1');
  WriteLn('         /Ln : key length is n characters  default n=8');
  WriteLn('');
  WriteLn('Check sorted abbrevations textfile for unique keys.');
  WriteLn('Reports lines having the same key but different descriptions.');
  WriteLn('Removes duplicate lines that are fully identical.');
  WriteLn('');
end;


procedure ReadOption(arg: StpTyp);
begin
  StpDel(arg,1,1);
  case UpCase(StpcGet(arg)) of
    OPTHRDCPY : HrdCpy:= true;
    OPTCHRPOS : KeyPos:= AtoIB(arg,10);
    OPTCHRLEN : KeyLen:= AtoIB(arg,10);
    else        ErrCod:= ERRARG;
  end;
end;


procedure ReadParameters;
  var i   : word;
      Parm: StpTyp;
begin
  i:= 0;
  while (ErrCod=ERROK) and (i<ParamCount) do begin
    i:= i+1; Parm:= ParamStr(i);
    if StpcRet(Parm,1) = OPTCHR then ReadOption(Parm)
    else ErrCod:= ERRARG;
  end;
end;


procedure MainInit;
begin
  ErrCod:= ERROK;
  KeyPos:= DFLKEYPOS;
  KeyLen:= DFLKEYLEN;
  HrdCpy:= false;
  Assign(InpFile,''); Assign(OutFile,''); {allow redirection}
  Reset(InpFile)    ; Rewrite(OutFile);
  ReadParameters;
end;


procedure MainExit;
begin
  if ErrCod<>ERROK then begin
    WriteLn(ProgIdent,' ',ProgVersion);
    WriteLn(ErrMsg[ErrCod]);
    case ErrCod of
      ERRARG : Help;
      else     {nothing};
    end;
  end;
  Close(OutFile);
end;


procedure ReportLine(line: StpTyp);
begin if HrdCpy then WriteLn(Lst,line) else WriteLn(line); end;


procedure ProcessFile;
  var line0, line : StpTyp;
      key0 , key  : StpTyp;
      EqKey       : boolean;

  procedure ProcessLine;
  begin
    if line<>line0 then begin
      WriteLn(OutFile,line0);
      if key=key0  then begin
        EqKey:= true;
        ReportLine(line0);
      end
      else begin
        if EqKey then begin
          EqKey:= false;
          ReportLine(line0);
          ReportLine('');
        end;
      end
    end;
  end;

begin {ProcessFile}
  if not eof(InpFile) then begin
    ReadLn(InpFile,line); StpSub(key,line,KeyPos,KeyLen); StpUpp(key);
    EqKey:= false;
    while not eof(InpFile) do begin
      line0:= line; key0:= key;
      ReadLn(InpFile,line); StpSub(key,line,KeyPos,KeyLen); StpUpp(key);
      ProcessLine;
    end;
    line0:= line; key0:= key;
    line:= '';    key:= '';
    ProcessLine;
  end;
end;



begin {Main}
  MainInit;
  if ErrCod=ERROK then ProcessFile;
  MainExit;
end.

