
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994 Stefan Milius                }
{                                                       }
{*******************************************************}

{
  GVDRIVER.TXT GVDRIVER.DOC GINFO.TXT NEW.TXT GV.VER
}

Unit GVDriver;

{$A+,B-,D+,F+,G+,O-,R-,S-,X+,I-}

Interface

Uses MyMouse, Gr, MyFonts, Objects, Drivers, MetaGr;

 { Mouse driver routines }

 procedure InitEvents;
 procedure DoneEvents;
 procedure HideMouse;
 procedure ShowMouse;
 procedure SetCriticalArea (var R: TRect);
 procedure SetCurrentCursor (n: Integer);

 { Font routines }

 procedure InitFonts;
 procedure DoneFonts;

 { Screen routines }

 procedure InitVideo;
 procedure DoneVideo;
 procedure SetScreenMode(Mode: Byte);

 { System error handler routines }

 function SysError (ErrorCode: Integer; Drive: Byte): Integer;

 procedure InitSysError;
 procedure DoneSysError;

Const

{ System error colors }

  BkCol   : Byte = Red;
  TextCol1: Byte = White;
  TextCol2: Byte = Yellow;

{ Standard Graphics Mode }

  StdGrMode: Byte = grVGAHiStd;

{ Startup VideoMode }

  StartUpMode: Byte = 0;

{ Standard mouse cursor }

  mcNoCursor = -1;

  MCurStandard: Integer = mcStd;
  MCurrent: Integer = mcNoCursor;

Implementation

Uses Dos, CRT, Memory, ExtGraph, Misc, VgaMem, GVApp, GVTexts;

{ System Error Texts }

var
  SysErrorTexts: PStringCollection;

(*************************** Mouse driver routines **************************)

procedure InitEvents;
Begin
  RepeatDelay := 4; MaxWidth := 4; MaxLength := 31;
  InitMyMouse;
End;

procedure DoneEvents;
Begin
  DoneMyMouse;
End;

procedure ShowMouse;
Begin
  MyMouse.ShowMouse;
End;

procedure HideMouse;
Begin
  MyMouse.HideMouse;
End;

procedure SetCriticalArea;
Begin
  MyMouse.SetCriticalArea (R.A.X,R.A.Y,R.B.X,R.B.Y);
End;

procedure SetCurrentCursor;
Begin
  MCurrent:=n;
  If n=mcNoCursor then n:=MCurStandard;
  SetMCursor (n);
End;

(******************************* Font routines ******************************)

{$ifndef UseBiosFonts}

{$L Font8.OBJ}
procedure Font8; far; external;

{$L Font14.OBJ}
procedure Font14; far; external;

{$L Font16.OBJ}
procedure Font16; far; external;

{$endif UseBiosFonts}

procedure InitFonts;
var WinDir, WinFontDir: DirStr;
    Font: PFontRec;

 function SysFont: PathStr;
 var F: PStream;
     s: PathStr;
 Begin
   F:=New(PBufStream, Init(WinDir+'SYSTEM.INI', stOpenRead, 1024));
   s:=ReadValue(F^, 'BOOT', 'FONTS.FON');
   Dispose(F, Done);
   SysFont:=FirstFile('VGASYS.FON;?GASYS.FON;' + s, WinFontDir);
 End;

Begin
  InitMyFonts;
  WinDir := GetWinDir;
  WinFontDir := GetWinFontDir;

  Font := LoadWinFont(SysFont, 0, 0, 16, 0, 0, 0, 0);
  If Font = nil then
    Font := LoadBIOSFont(16, 0, 0, 0);
  DefFont(Font);

  Font := LoadWinFont(
    FirstFile('SSERIFE.FON;HELVE.FON;SSERIF?.FON;HELV?.FON', WinFontDir),
    0, 0, 13, 1, -1, 0, ftBold);
  If Font = nil
  then Font := AliasOf(2, 0, 0, 13, 0);
  DefFont(Font);

  Font := LoadBIOSFont(14, 0, 0, 0);
  DefFont(Font);

  TheStandardFont := 2;
End;

procedure DoneFonts;
Begin
  DoneMyFonts;
End;

(******************************* Screen routines ****************************)

procedure InitVideo;

	procedure FailGraphics;
	begin
	  PrintStr(GetStr(14));
	  Halt(1)
	end;

Begin
  StartupMode := LastMode;
  TextMode(CO80);
  LastMode := StartUpMode;
  {$ifdef UseBiosFonts}
  GetBiosPtr;
  {$else}
  Bios8 := @Font8;
  Bios14 := @Font14;
  Bios16 := @Font16;
  {$endif}
  SetGrMode(StdGrMode);
  If not InitGraphics
  then Begin
    If StdGrMode > gr640x480x16
    then begin
      SetGrMode(gr640x480x16);
      If not InitGraphics
      then FailGraphics;
    end
    else FailGraphics
  End;
  InitMetaGr;

  UserParams(1);
  ClipNotifyProc(gcnHaltUpd);

  SetRGBColor(56,32,32,32);
  UserParams(3);
  GrNotifyProc(gnpPalette, 0);
end;

procedure DoneVideo;
Begin
  DoneMetaGr;
  CloseGraphics;
  TextMode (StartupMode);
End;

procedure SetScreenMode;
Begin
  DoneVideo;
  StdGrMode := Mode;
  InitVideo;
End;

(************************ System error handler routines *********************)

function SelectKey: Integer; near; Assembler;
Asm
@@1:	MOV	AH,1
	INT	16H
	PUSHF
	MOV	AH,0
	INT	16H
	POPF
	JNE	@@1
	XOR	DX,DX
	CMP	AL,13
	JE	@@2
	INC	DX
	CMP	AL,27
	JNE	@@1
@@2:	PUSH	DX
	POP	AX
End;

function SysError;
var R: TRect;
    S: String;
    BackGround: Pointer;
    Back: Word absolute Background;
    Event: TEvent;
    Size: Word;

    TempClip: TRect;
    Temporig: TPoint;

    MemFlag: Boolean;

  function SysStr(Num: Integer): string;
  begin
    SysStr := PString(SysErrorTexts^.At(Num))^
  end;

Begin
  If (ErrorCode>=0) and (ErrorCode<16) then S := SysStr(ErrorCode)
				       else S := SysStr(16);

  Inc(Drive, $41);
  FormatStr (S, S, Drive);

  R.Assign (0,SizeY-21,SizeX,SizeY);
  SetCriticalArea (R);
  TempClip:=ClipRect;
  TempOrig:=DrawOrigin;
  SetDrawOrigin(0, 0);
  SetClipRectR(R);
  HideMouse;

  Size := GetSize(R.A.X, R.A.Y, R.B.X-1, R.B.Y-1);
  Back := GetVGAMem(Size);
  If Back = 0 then
  Begin
    MemFlag := True;
    Size := ImageSize (R.A.X,R.A.Y,R.B.X,R.B.Y);
    BackGround := MemAlloc (Size);
    GetImage (R.A.X,R.A.Y,R.B.X,R.B.X,Background^);
  End
  Else Begin
    MemFlag := False;
    SaveScreen(R.A.X, R.A.Y, R.B.X, R.B.Y, Back);
  End;

  SetFillStyle (SolidFill, Red);
  Bar (R.A.X, R.A.Y, R.B.X-1, R.B.Y-1);
  Dec (R.B.X,R.A.X); Dec (R.B.Y,R.A.Y);
  S := '  ' + S + SysStr(17);

  SetGVStyle (ftSystem);
  OutGVText (R.A, S, TextCol1,TextCol2, R.B, False);

  SysError := SelectKey;

  If MemFlag then
  Begin
    PutImage(R.A.X,R.A.Y,Background^,NormalPut);
    FreeMem(Background, Size);
  End
  Else Begin
    RestoreScreen(R.A.X, R.A.Y, R.A.X+R.B.X, R.A.Y+R.B.Y, R.A.X, R.A.Y,
      Back);
    FreeVGAMem(Back, Size);
  End;

  SetClipRectR(TempClip);
  SetDrawOriginP(TempOrig);
  ShowMouse;
End;

procedure InitSysError;
var
  i: Integer;
Begin
  SysErrorTexts := New(PStringCollection, Init(18, 10));
  with SysErrorTexts^ do
    For i := 15 to 32 do
      AtInsert(Count, NewStr(GetStr(i)));
  SysErrorFunc:=SysError;
  Drivers.InitSysError;
End;

procedure DoneSysError;
Begin
  Drivers.DoneSysError;
  SysErrorFunc:=SystemError;
  Dispose(SysErrorTexts, Done);
End;

End.