{$IFNDEF VER60}
{$A+,B+,F-,G+,I-,O+,P+,Q-,R-,S-,T-,V-,X+,Y-}
{$ELSE}
{$A+,B+,F-,G+,I-,O+,R-,S-,V-,X+}
{$ENDIF}
unit pngunit;
interface
uses crt,graphics,gr_vars;

  function  loadpng(px,py : integer;name: string) : byte;
  function  loadpngmem(px,py : integer;p : pointer;palstart,palend : byte) : byte;
  function  info_png(name: string;var image_info : timage_info) : byte;
  procedure resetvars;
  procedure BufferedReadfile(var desti; c : word);far;
  procedure BufferSkipBackfile(c : LongInt);far;
  procedure BufferSkipBackmem(c : LongInt);far;
  procedure BufferedReadmem(var desti; c : word);far;
  function  MyHeapErrorFunc(Size: word) : integer;far;
  procedure ResetReadBuffer;
  procedure CheckIO;
  procedure ReadChunkHead;
  function  FindChunk(c : string) : integer;
  procedure SkipChunk;
  function  GetLineSize(PixelWidth : LongInt) : LongInt;
  procedure Process_IHDR;
  procedure Process_PLTE;
  procedure Process_IDAT;
  procedure Process_Iend;
  procedure Process_GAMA;
  procedure Process_SBIT;
  procedure Process_CHRM;
  procedure Process_TRNS;
  procedure Process_BKGD;
  procedure Process_HIST;
  procedure Process_TEXT;
  procedure Process_ZTXT;
  procedure Process_PHYS;
  procedure Process_ofFS;
  procedure Process_TIME;

const
  NumChunks = 15;
  chunks : array[1..NumChunks] of
  record
    Name    : array[0..3] of char;
    Process : procedure;
    HaveIt  : boolean; {True = chunk has appeared}
  end = ((Name: 'IHDR'; Process: Process_IHDR; HaveIt: False),
         (Name: 'PLTE'; Process: Process_PLTE; HaveIt: False),
         (Name: 'IDAT'; Process: Process_IDAT; HaveIt: False),
         (Name: 'Iend'; Process: Process_Iend; HaveIt: False),
         (Name: 'gAMA'; Process: Process_GAMA; HaveIt: False),
         (Name: 'sBIT'; Process: Process_SBIT; HaveIt: False),
         (Name: 'cHRM'; Process: Process_CHRM; HaveIt: False),
         (Name: 'tRNS'; Process: Process_TRNS; HaveIt: False),
         (Name: 'bKGD'; Process: Process_BKGD; HaveIt: False),
         (Name: 'hIST'; Process: Process_HIST; HaveIt: False),
         (Name: 'tEXt'; Process: Process_TEXT; HaveIt: False),
         (Name: 'zTXt'; Process: Process_ZTXT; HaveIt: False),
         (Name: 'pHYs'; Process: Process_PHYS; HaveIt: False),
         (Name: 'ofFs'; Process: Process_ofFS; HaveIt: False),
         (Name: 'tIME'; Process: Process_TIME; HaveIt: False));

  ReadBuffSize = 65528;

type
  tReadBuff  = array[0..Pred(ReadBuffSize)] of byte;
  pReadBuff  = ^tReadBuff;

var
  infile : file;
  pstart,pend : byte;
  BufferedRead   : procedure(var desti; c : word);
  BufferSkipBack : procedure(c : LongInt);
  memreadpos     : longint;
  ReadBuff       : pReadBuff;
  rbpos,rbend    : word;
  posx,posy      : integer;
  FilterCount    : array[0..5] of LongInt;
  First          : boolean; {True = first chunk}
  ChunkHead : record
    Length : LongInt;
    Name   : array[0..3] of char
  end;

  PNGHead : Record {see the PNG spec, draft #9}
    Width,Height  : LongInt;
    BitsPerSample : byte  ;
    Colortype     : byte  ;
    CM,Filter,IL  : byte  ;
  end;
  imagep,lastrow : pointer;
  LineSize       : LongInt;{number of bytes in one row incl. filter byte}


implementation
uses crc32,adler32,inflate;

var
  RunCRC : tCRC; {see unit CRC32 for details}
  RunAdl : tAdler; {see unit Adler32 for details}

  Currentoffset : LongInt;{byte position in current row}
  Decompbytes   : LongInt;{counts decompressed bytes}
  bytesNeeded   : LongInt;{bytes actually decompressed, should be = Decompbytes}
  NumLines      : LongInt;{number of scanlines = number of filter bytes}
  OutputRow     : pReadBuff;
  PaletteSize,bytesPerLine : word;
  CurrentPass              : byte;     {Adam7 pass, 0..6}

procedure die(const msg : string);
begin
  closegraph;
  writeln('PNGimage loaderror: '+msg);
  close(infile);
  halt;
end {Die};

procedure CheckIO;
var
  iores : integer;
begin
  iores := IOResult;
  if iores <> 0 then
  if iores = 100 then
  Die('Premature end of file.')
  else
  Die('I/O error #'+makestr(iores)+' reading from input file.');
end {CheckIO};

{Some read buffer routines for faster access
 on devices with slow response time.}

procedure ResetReadBuffer;
begin
  rbpos := ReadBuffSize;
  rbend := ReadBuffSize;
  memreadpos := 0;
end {ResetReadBuffer};


procedure BufferedReadfile(var desti; c : word);
var
  ec,r : word;
label
  noload;
begin
  asm
    db 66h;xor   ax,ax
    db 66h;xor   bx,bx
    db 66h;xor   dx,dx
           mov  ax,rbpos
           mov  bx,c
           mov  cx,bx
    db 66h;add  bx,ax
           mov  dx,readbuffsize
    db 66h;cmp  bx,dx
           jna  noload
  end;
{      if rbpos+LongInt(c) > LongInt(ReadBuffSize) then begin}
  r := ReadBuffSize-rbpos;
  if rbpos < ReadBuffSize then
  Move2(ReadBuff^[rbpos],ReadBuff^,r);
  BlockRead(infile,ReadBuff^[r],rbpos,ec);
  if ec < rbpos then rbend := r+ec;
  rbpos := 0;
{      end;}
  asm
    mov ax,rbpos
    mov cx,c
    noload:
    mov dx,ds
    lds si,readbuff
    add si,ax
    les di,desti
    mov ax,cx
    shr cx,2
    jz @not4
    db 0F3h,66h,0A5h{rep movsd}
    @not4:
    mov cx,ax
    and cx,11b
    jz @end
    rep movsb
    @end:
    mov ds,dx
    mov bx,rbpos
    add bx,ax
    cmp bx,rbend
    jna @na
    mov inoutres,100
    jmp @a
    @na:
    add rbpos,ax
    @a:
  end;
end;

procedure BufferSkipBackfile(c : LongInt);
begin
  if rbpos >= c then Dec(rbpos,c)
  else begin
    ResetReadBuffer;
    Seek(infile,FilePos(infile)-c);
  end;
end {BufferSkipBack};


procedure BufferedReadmem(var desti; c : word);
var
  ec,r : word;
begin
  Move2(ptr(seg(imagep^),ofs(imagep^)+memreadpos)^,desti,c);
  inc(memreadpos,c);
end;

procedure BufferSkipBackmem(c : LongInt);
begin
  dec(memreadpos,c);
end;

procedure ReadCheck (var desti; c : word);
begin
  BufferedRead(desti,c);
  CheckIO;
  Dec(ChunkHead.Length,c);
  UpdateCRC32(RunCRC,desti,c);
end {ReadCheck};



function MyHeapErrorFunc(Size: word) : integer;
begin
  if Size = 0 then
  MyHeapErrorFUnc := 2 {success}
  else
  MyHeapErrorFunc := 1 {return NIL}
end {MyHeapErrorFunc};

{Swap a 32 bit variable (MSB<->LSB).}

procedure Swap32(var Longvar : LongInt);Assembler;
asm
  les   si,Longvar
  mov   ax,es:[si]
  mov   dx,es:[si+2]
  xchg  al,dh
  xchg  ah,dl
  mov   es:[si],ax
  mov   es:[si+2],dx
end {Swap32};

{Swap a 16 bit variable (MSB<->LSB).}

procedure Swap16(var wordvar : word);Assembler;
asm
  les   si,wordvar
  mov   ax,es:[si]
  xchg  al,ah
  mov   es:[si],ax
end {Swap16};

procedure ReadChunkHead;
begin
  BufferedRead(ChunkHead,Sizeof(ChunkHead));
  CheckIO;
  with ChunkHead do begin
    Swap32(Length);
    InitCRC32(RunCRC);
    UpdateCRC32(RunCRC,Name,4);
{    WriteLn('"'+Copy(Name,1,4)+'"'+makestr(Length)+' bytes');}
  end;
end {ReadChunkHead};

{Skip to the end of the current chunk and check the CRC.}

procedure SkipChunk;
var
  CheckCRC : tCRC;
  b        : byte;
begin
  with ChunkHead do
  if Length < 0 then begin
    BufferSkipBack(-Length);
    CheckIO;
  end
  else
  while Length > 0 do
  ReadCheck(b,1);
  BufferedRead (CheckCRC,4);
  CheckIO;
end {SkipChunk};

{Callback for inflate:  feed an input byte to inflate.}

function PNG_Readbyte : byte;Far;
var
  CheckCRC : tCRC;
  b        : byte;
begin
  while ChunkHead.Length=0 do begin
    SkipChunk;
    ReadChunkHead;
  end;
  ReadCheck(b,1);
  PNG_Readbyte := b;
end {PNG_Readbyte};

{Apply a filter to a single row of pixels.}
var
  w : word;
  bpp : word;
{procedure subfilt;
begin
for w := bpp to bytesperline-1 do
inc(mem[seg(outputrow^):ofs(outputrow^)+w+1],
mem[seg(outputrow^):ofs(outputrow^)+w-bpp+1]);
end;}
procedure subfilt;assembler;
asm
  les   di,outputrow
  mov   cx,bytesperline
  sub   cx,bpp
  inc   di
  mov   si,di
  add   di,bpp
  @lp:
    mov   al,es:[si]
    add   es:[di],al
    inc   di
    inc   si
    dec   cx
  jnz   @lp
end;

{procedure upfilt;
begin
for w := 0 to bytesperline-1 do
inc(mem[seg(outputrow^):ofs(outputrow^)+w+1],
mem[seg(lastrow^):ofs(lastrow^)+w]);
end;}
procedure upfilt;assembler;
asm
  mov   cx,bytesperline
  les   di,outputrow
  inc   di
  push  ds
  lds   si,lastrow
  @lp:
    mov   al,ds:[si]
    add   es:[di],al
    inc   di
    inc   si
    dec   cx
  jnz   @lp
  pop ds
end;

procedure averagefilt;
var
  c1 : word;
begin
  c1 := 0;
  for w := 0 to bytesperline-1 do begin
    if w >= bpp then c1 := mem[seg(outputrow^):ofs(outputrow^)+w-bpp+1];
    inc(mem[seg(outputrow^):ofs(outputrow^)+w+1],
    (c1+mem[seg(lastrow^):ofs(lastrow^)+w]) shr 1);
  end;
end;

{$IFDEF DPMI}
function PaethPredictor(a,b,c : byte) : byte;
var
  p,pa,pb,pc : word;
begin
  p  := a+b-c;
  pa := abs(integer(p)-a);
  pb := abs(integer(p)-b);
  pc := abs(integer(p)-c);
  if (pa <= pb)and(pa <= pc) then PaethPredictor := a
  else if pb <= pc then PaethPredictor := b else
  PaethPredictor := c;
end;
{$ELSE}
function PaethPredictor(a,b,c : word) : byte;assembler;
var
  p,pa,pb,pc : word;
asm
  mov si,b
  mov di,a
  push bp
  mov bp,c
  mov dx,di
  add di,si
  sub di,bp

  mov ax,di
  sub ax,dx
  jns @nexta;neg ax;@nexta:
  mov bx,di
  sub bx,si
  jns @nextb;neg bx;@nextb:
  mov cx,di
  sub cx,bp
  jns @nextc;neg cx;@nextc:

  cmp ax,bx
  jnbe @useb
  cmp ax,cx
  jnbe @useb
  mov ax,dx
  jmp @end
  @useb:
  cmp bx,cx
  jnbe @usec
  mov ax,si
  jmp @end
  @usec:
  mov ax,bp
  @end:
  pop bp
end;
{$ENDIF}

procedure paethfilt;
var
  c1,c2 : byte;
begin
  c1 := 0;
  c2 := 0;
  for w := 0 to bytesperline-1 do begin
    if w >= bpp then begin
      c1 := mem[seg(outputrow^):ofs(outputrow^)+w-bpp+1];
      c2 := mem[seg(lastrow^):ofs(lastrow^)+w-bpp];
    end;
    inc(mem[seg(outputrow^):ofs(outputrow^)+w+1],
    paethpredictor(c1,mem[seg(lastrow^):ofs(lastrow^)+w],c2));
  end;
end;

procedure ApplyFilter;
var
  f : byte;
begin {ApplyFilter}
  f := mem[seg(OutputRow^):ofs(OutputRow^)];
{      if f In [0..4] then
         Inc (FilterCount[f])
      else
         Inc (FilterCount[5]); {Illegal filter type}
    if f > 0 then begin
    case f of
      1 : subfilt;
      2 : upfilt;
      3 : averagefilt;
      4 : paethfilt;
    end;
  end;
end {ApplyFilter};

function  GetLineSize (PixelWidth : LongInt) : LongInt;
begin
  with PNGHead do
  Case Colortype of
    0 : GetLineSize := (BitsPerSample*PixelWidth+7) Shr 3+1;
    2 : GetLineSize := (BitsPerSample Shr 3)*3*PixelWidth+1;
    3 : GetLineSize := (BitsPerSample*PixelWidth+7) Shr 3+1;
    4 : GetLineSize := (BitsPerSample Shr 2)*PixelWidth  +1;
    6 : GetLineSize := (BitsPerSample Shr 1)*PixelWidth  +1;
    else
    GetLineSize := PixelWidth Shl 3 +1;
    {should be pretty save if user wants to ignore error}
  end;
end {GetLineSize};

{Tables for Adam7 interlacing.}

const  Adam7_StartRow : array[0..6] of byte
                      = (0,0,4,0,2,0,1);
       Adam7_StartCol : array[0..6] of byte
                      = (0,4,0,2,0,1,0);
       Adam7_IncrmRow : array[0..6] of byte
                      = (8,8,8,4,4,2,2);
       Adam7_IncrmCol : array[0..6] of byte
                      = (8,8,4,4,2,2,1);

var  CurY : LongInt;

{Number of pixels/row in current pass}

function PassWidth : LongInt;
begin
  PassWidth :=
  (PNGHead.Width+Adam7_IncrmCol[CurrentPass]-1-Adam7_StartCol[CurrentPass])
  Div Adam7_IncrmCol[CurrentPass];
end {PassWidth};

{Number of rows in current pass}

function PassHeight : LongInt;
begin
  PassHeight :=
  (PNGHead.Height+Adam7_IncrmRow[CurrentPass]-1-Adam7_StartRow[CurrentPass])
  Div Adam7_IncrmRow[CurrentPass]
end {PassHeight};

{Callback for inflate:  provides output data from the sliding window.}

function PNG_Flush(w : word) : integer;Far;
var
Copyoffset,CopyCount,x : word;
p   : pointer;
col : byte;
begin
      PNG_Flush  := 0;
      Copyoffset := 0;
      Inc(Decompbytes,w);
      UpdateAdler32(RunAdl,slide^,w);
      if CurrentPass > 6 then Exit; {Process_IDAT detects this}
      while w > 0 do begin
         if PNGHead.IL = 1 then begin {interlaced}
            {Skip empty passes}
            while ((PassWidth = 0) Or (PassHeight = 0)) And (CurrentPass < 7) do
            Inc(CurrentPass);
            if CurrentPass > 6 then Exit;
            bytesPerLine := GetLineSize(PassWidth);
         end
         else {non-interlaced}
            bytesPerLine := LineSize;
         if w > bytesPerLine-Currentoffset then
            CopyCount := bytesPerLine-Currentoffset
         else
            CopyCount := w;
         if Currentoffset+CopyCount <= 65528 then
            move2(slide^[Copyoffset],OutputRow^[Currentoffset],CopyCount);
         Dec(w,CopyCount);
         Inc(Copyoffset,CopyCount);
         Inc(Currentoffset,CopyCount);
         if Currentoffset >= bytesPerLine then begin {next row}
            ApplyFilter;
            Currentoffset := 0;
            if PNGHead.IL = 1 then begin {interlaced}
         if CurrentPass < 6 then
         for x := 0 to bytesperline-1 do
         putpixel(posx+x*Adam7_IncrmCol[currentpass]+Adam7_StartCol[currentpass],
         posy+cury,mem[seg(outputrow^):ofs(outputrow^)+x+1])
         else image_line(posx,posy+cury,pnghead.width,ptr(seg(OutputRow^),ofs(OutputRow^)+1));
               Inc(CurY,Adam7_IncrmRow[CurrentPass]);
               if CurY >= PNGHead.Height then begin
                  Inc(CurrentPass);
                  if CurrentPass > 6 then Exit;
                  CurY := Adam7_StartRow[CurrentPass];
               end;
            end
            else begin {non-interlaced}
            if PNGHead.colortype <> 2 then begin
            if PNGHead.bitspersample = 8 then
            image_line(posx,posy+cury,pnghead.width,ptr(seg(OutputRow^),ofs(OutputRow^)+1))
            else begin
            getmem(p,(bytesPerLine-1)*2);
            asm
            mov cx,bytesperline
            les di,p
            push ds
            lds si,outputrow
            inc si
            @lp:
            mov al,ds:[si]
            mov ah,al
            shr al,4
            and ah,$0F
            mov es:[di],ax
            inc si
            add di,2
            dec cx
            jnz @lp
            pop ds
            end;
            image_line(posx,posy+cury,pnghead.width,p);
            freemem(p,(bytesPerLine-1)*2);
            end;
            end else begin
            getmem(p,pnghead.width);
            for x := 0 to pnghead.width-1 do begin
            mem[seg(p^):ofs(p^)+x] :=
            findnearcol(mem[seg(OutputRow^):ofs(OutputRow^)+1+x*3] shr 2,
                        mem[seg(OutputRow^):ofs(OutputRow^)+2+x*3] shr 2,
                        mem[seg(OutputRow^):ofs(OutputRow^)+3+x*3] shr 2);
            end;
            image_line(posx,posy+cury,pnghead.width,p);
            freemem(p,pnghead.width);
            end;

               Inc(CurY);
{ndern! >>>}  if PNGHead.Colortype <> 3 then move2(ptr(seg(OutputRow^),ofs(OutputRow^)+1)^,lastrow^,bytesperline);
               if CurY >= PNGHead.Height then Exit;
            end;
         end;
      end;
   end {PNG_Flush};

function FindChunk(c : string) : integer;
var
   i : integer;
begin
  FindChunk := -1;
  for i := 1 to NumChunks do
  if c = Chunks[i].Name then begin
    FindChunk := i;
    Break;
  end;
end {FindChunk};

function CheckLength(l : LongInt) : LongInt; {returns actual length}
begin
  CheckLength := ChunkHead.Length;
end {CheckLength};


procedure Process_IHDR;
type
  byteSet = set of byte;
var
  w : word;
begin {Process_IHDR}
  CheckLength (Sizeof(PNGHead));
  Filldword(PNGHead,Sizeof(PNGHead),0);
  ReadCheck(PNGHead,Sizeof(PNGHead));
  with PNGHead do begin
    Swap32(Width);
    Swap32(Height);
    LineSize := GetLineSize(Width);
  end;
  if LineSize > 65528 then
    w := 65528
  else
  w := LineSize;
  GetMem(OutputRow,w);
  if OutputRow = NIL then
  Die('Not enough memory for output row ('+makestr(w)+' bytes).');
  SkipChunk;
end {Process_IHDR};


procedure Process_PLTE;
var
  dummy : longint;
  i     : byte;
begin
  with ChunkHead do PaletteSize := Length div 3;
  dummy := chunkhead.Length;
  SkipChunk;
  bufferskipback(dummy+4);
  bufferedread(pal^,dummy);
  bufferedread(dummy,4);
  shiftpal;
  if (pstart = 0)and(pend = 255) then setpal
  else for i := pstart to pend do setrgbpalette(i,pal^[i].r,pal^[i].g,pal^[i].b);
end {Process_PLTE};

procedure  Process_IDAT;
var
  AdlerCheck : LongInt;
  Result     : integer;
  w          : word  ;
begin
  if Chunks[FindChunk(ChunkHead.Name)].HaveIt then begin
    SkipChunk;
    Exit;
  end;
  w := PNG_Readbyte;
  w := (w Shl 8) Or PNG_Readbyte;
  InitAdler32 (RunAdl);
  Decompbytes := 0;
  with PNGHead do
  if IL = 1 then begin {interlaced}
    bytesNeeded := 0;
    NumLines    := 0;
    for CurrentPass := 0 to 6 do begin
      Inc(bytesNeeded,GetLineSize(PassWidth)*PassHeight);
      Inc(NumLines,PassHeight)
    end
  end
  else begin {non-interlaced}
    bytesNeeded := LineSize*Height;
    NumLines := Height
  end;
  Currentoffset := 0;
  CurrentPass   := 0;
  CurY          := 0;
  InflateRead  := PNG_Readbyte;
  InflateFlush := PNG_Flush;
  Result := InflateRun;
  for w := 1 to 4 do AdlerCheck := (AdlerCheck Shl 8) Or PNG_Readbyte;
  SkipChunk;
end {Process_IDATs};

procedure Process_Iend;
begin
  CheckLength (0);
  SkipChunk;
end {Process_Iend};

procedure  Process_GAMA;
var
  gamma : LongInt;
begin
  if CheckLength(4) >= 4 then begin
    ReadCheck(gamma,4);
    Swap32(gamma);
  end;
  SkipChunk;
end {Process_GAMA};

procedure Process_SBIT;
var
  w        : word;
  bits     : byte;
  Descript : string[4];
begin
  for w := 1 to Length(Descript) do begin
    if ChunkHead.Length <= 0 then Break;
    ReadCheck(bits,1);
  end;
  SkipChunk;
end {Process_SBIT};

procedure Process_CHRM;
var
  value : LongInt;
  w     : word  ;
  s     : string;
begin
  CheckLength(32);
  for w := 0 to 7 do begin
   if ChunkHead.Length < 4 then Break;
   ReadCheck (value,4);
   Swap32(value);
{         WriteLn('   '+ChrmName[w]^+': '+makestrr(value/100000,4,2)+'.');}
   end;
   SkipChunk;
end {Process_CHRM};

procedure  Process_TRNS;
const
  SDesc : Array[0..2] of char = 'RGB';
var
  trans : array[0..2] of word;
  w     : word;
  b     : byte;
begin
  Case PNGHead.Colortype of
    3 : begin
       for w := 0 to PaletteSize do begin
                   if ChunkHead.Length <= 0 then begin
{                      if w And 15 <> 0 then
                         WriteLn('');}
                      Break;
                   end;
                   ReadCheck (b,1);
{                   if w And 15 = 0 then
                      Write('   '+makestr(b))
                   else
                      Write(','+makestr(b));
                   if (w And 15 = 15) Or (w=PaletteSize) then
                      WriteLn('');}
                end;
             end;
         0,4 : if CheckLength(2) >= 2 then begin
                  ReadCheck(trans[0],2);
                  Swap16(trans[0]);
               end;
         2,6 : if CheckLength(6) >= 6 then begin
                  ReadCheck(trans,6);
                  for w:=0 to 2 do begin
                     Swap16(trans[w]);
                  end;
    end;
  end;
  SkipChunk;
end {Process_TRNS};

procedure Process_BKGD;
const
  SDesc : array[0..2] of char = 'RGB';
var
  back : array[0..2] of word;
  w : word;
  b : byte;
begin
  Case PNGHead.Colortype of
      3 : if CheckLength(1) >= 1 then ReadCheck (b,1);
    0,4 : if CheckLength(2) >= 2 then begin
            ReadCheck (back[0],2);
            Swap16(back[0]);
          end;
    2,6 : if CheckLength(6) >= 6 then begin
            ReadCheck(back,6);
            for w := 0 to 2 do Swap16 (back[w]);
          end;
  end;
  SkipChunk;
end {Process_BKGD};

procedure  Process_HIST;
begin
  CheckLength(PaletteSize Shl 1);
  SkipChunk;
end {Process_HIST};

procedure  Process_TEXT;
begin
  SkipChunk;
end {Process_TEXT};

procedure  Process_ZTXT;
begin
  SkipChunk;
end {Process_ZTXT};

procedure  Process_PHYS;
var
  PhysData : Record
    perx,pery : LongInt;
    unitspec  : byte
  end;
begin
  if CheckLength(Sizeof(PhysData))>=Sizeof(PhysData) then begin
    ReadCheck (PhysData,Sizeof(PhysData));
    with PhysData do begin
      Swap32(perx);
      Swap32(pery);
    end;
  end;
  SkipChunk;
end {Process_PHYS};

procedure  Process_ofFS;
var
  offsData : Record
    ofsx,ofsy : LongInt;
    unitspec  : byte
  end;
begin
  if CheckLength(Sizeof(offsData))>=Sizeof(offsData) then begin
    ReadCheck (offsData,Sizeof(offsData));
    with offsData do begin
      Swap32(ofsx);
      Swap32(ofsy);
    end;
  end;
  SkipChunk;
end {Process_ofFS};

procedure  Process_TIME;
{   const  MonthDesc : array[0..12] of string[3]
                    = ('???','Jan','Feb','Mar','Apr','May','Jun',
                       'Jul','Aug','Sep','Oct','Nov','Dec');}
var
  TimeData : Record
    year : word;
    month,day,hour,minute,second : byte;
  end;
begin
  if CheckLength(Sizeof(TimeData))>=Sizeof(TimeData) then begin
    ReadCheck (TimeData,Sizeof(TimeData));
{    with TimeData do Swap16 (year);}

  end;
  SkipChunk;
end {Process_TIME};


procedure resetvars;
var
  i : byte;
begin
  first         := false;
  LineSize      := 0;
  Currentoffset := 0;
  Decompbytes   := 0;
  bytesNeeded   := 0;
  NumLines      := 0;
  CurrentPass   := 0;
  for i := 1 to NumChunks do chunks[i].haveit := false;
  cury          := 0;
  chunkhead.name[0]:=#0;
  lastrow   := nil;
  slide     := nil;
  readbuff  := nil;
  outputrow := nil;
end;

const
  id : array[0..7] of char = #137'PNG'#13#10#26#10;

function info_png(name: string;var image_info : timage_info) : byte;
{
0 : file loaded
1 : file not found
2 : incorrect fileformat
3 : unexpected end of file
4 : not enough memory
}
var
  BufMag    : array[0..7] of char;
  i         : integer;
  oldheaperrorfunc : pointer;
procedure prepareexit(code : byte);
begin
  if lastrow <> nil then freemem(lastrow,linesize);
  if slide <> nil then freemem(slide,wsize);
  if readbuff <> nil then freemem(ReadBuff,ReadBuffSize);
  if outputrow <> nil then freemem(OutputRow,w);
  info_png := code;
  HeapError := oldheaperrorfunc;
  close(infile);
end;

begin
  pstart := 0;
  pend   := 255;
  resetvars;
  BufferedRead   := BufferedReadfile;
  BufferSkipBack := BufferSkipBackfile;

  assign(infile,name);
  reset(infile,1);
  if ioresult <> 0 then begin;prepareexit(1);exit;end;
  oldheaperrorfunc := HeapError;
  HeapError := @MyHeapErrorFunc;
  getmem(slide,wsize);
  if slide = NIL then begin;prepareexit(4);exit;end;
  getmem(ReadBuff,ReadBuffSize);
  if ReadBuff = NIL then begin;prepareexit(4);exit;end;
  ResetReadBuffer;
  Filldword(FilterCount,Sizeof(FilterCount),0);
  BufferedRead (BufMag,8);
  CheckIO;
  if BufMag <> id then begin;prepareexit(2);exit;end;
  First := True;
  with ChunkHead do
  while Name <> 'Iend' do begin
    ReadChunkHead;
    if ChunkHead.Name = 'IHDR' then begin
      Process_IHDR;
      prepareexit(0);
      with image_info do begin
{    Width,Height  : LongInt;
    BitsPerSample : byte  ;
    Colortype     : byte  ;
    CM,Filter,IL  : byte  ;}
        size.x       := pnghead.width;
        size.y       := pnghead.height;
        colordepth   := pnghead.bitspersample;
        transparency := false;
        compressed   := true;
        trans_color  := 0;
        case pnghead.bitspersample of
          8 : memsize := longint(size.x)*size.y+1024+imagedatasize;
          else memsize := longint(size.x)*size.y*colordepth div 8+imagedatasize;
        end;
        disksize     := filesize(infile);
        version      := 1;
      end;

(*      if ((PNGHead.Colortype <> 0)and(PNGHead.Colortype <> 3))
      or((PNGHead.bitspersample <> 8)and(PNGHead.bitspersample <> 4)) then
      begin;prepareexit(2);exit;end;
      if PNGHead.Colortype = 0 then
      if (PNGHead.bitspersample = 8) then
      for i := 0 to 255 do setrgbpal(i,i shr 2,i shr 2,i shr 2)
      else for i := 0 to 15 do setrgbpal(i,i shl 2,i shl 2,i shl 2);
      getmem(lastrow,linesize);
      filldword(lastrow^,linesize,0);
      bpp := linesize div pnghead.width;
    end
    else begin
      if First then begin;prepareexit(2);exit;end;
      i := FindChunk(ChunkHead.Name);
      if i >= 0 then begin
        Chunks[i].Process;
        Chunks[i].HaveIt := True;
      end
      else begin
        if byte(ChunkHead.Name[0]) and 32 = 0 then
        begin;prepareexit(2);exit;end{unknown critical chunk}
        else{Unknown ancillary chunk};
        SkipChunk;
      end;*)
    end;
    First := False;
  end;
{      if (rbpos < rbend) Or Not Eof(infile) then;
      {File contains data after Iend chunk}
{  prepareexit(0);}
end;

function loadpngmem(px,py : integer;p : pointer;palstart,palend : byte) : byte;
{
0 : file loaded
2 : incorrect fileformat
3 : unexpected end of file
4 : not enough memory
}
var
  BufMag    : array[0..7] of char;
  i         : integer;
  oldheaperrorfunc : pointer;
procedure prepareexit(code : byte);
begin
  loadpngmem := code;
  HeapError  := oldheaperrorfunc;
  if lastrow <> nil then freemem(lastrow,linesize);
  if slide <> nil then freemem(slide,wsize);
  if readbuff <> nil then freemem(ReadBuff,ReadBuffSize);
  if outputrow <> nil then freemem(OutputRow,w);
end;

begin
  pstart := palstart;
  pend   := palend;
  resetvars;
  resetreadbuffer;
  imagep := p;
  BufferedRead   := BufferedReadmem;
  BufferSkipBack := BufferSkipBackmem;
  posx := px;
  posy := py;
  if ioresult <> 0 then begin;prepareexit(1);exit;end;
  oldheaperrorfunc := HeapError;
  HeapError := @MyHeapErrorFunc;
  getmem(slide,wsize);
  if slide = NIL then begin;prepareexit(4);exit;end;
  filldword(FilterCount,Sizeof(FilterCount),0);
  BufferedRead(BufMag,8);
  if BufMag <> id then begin;prepareexit(2);exit;end;
  First := True;
  with ChunkHead do
  while Name <> 'Iend' do begin
    ReadChunkHead;
    if ChunkHead.Name = 'IHDR' then begin
      Process_IHDR;
      if ((PNGHead.Colortype <> 0)and(PNGHead.Colortype <> 3))
      or ((PNGHead.bitspersample <> 8)and(PNGHead.bitspersample <> 4)) then
      begin;prepareexit(2);exit;end;
      if PNGHead.Colortype = 0 then
      if (PNGHead.bitspersample = 8) then
      for i := 0 to 255 do setrgbpal(i,i shr 2,i shr 2,i shr 2)
      else for i := 0 to 15 do setrgbpal(i,i shl 2,i shl 2,i shl 2);
      getmem(lastrow,linesize);
      filldword(lastrow^,linesize,0);
      bpp := linesize div pnghead.width;
    end
    else begin
      if First then begin;prepareexit(2);exit;end;
      i := FindChunk(ChunkHead.Name);
      if i >= 0 then begin
        Chunks[i].Process;
        Chunks[i].HaveIt := True;
      end
      else begin
        if byte(ChunkHead.Name[0]) and 32 = 0 then
        begin;prepareexit(2);exit;end{unknown critical chunk}
        else{Unknown ancillary chunk};
        SkipChunk;
      end;
    end;
    First := False;
  end;
 {File contains data after Iend chunk}
  prepareexit(0);
end;


function loadpng(px,py : integer;name: string) : byte;
{
0 : file loaded
1 : file not found
2 : incorrect fileformat
3 : unexpected end of file
4 : not enough memory
}
var
  BufMag    : array[0..7] of char;
  i         : integer;
  oldheaperrorfunc : pointer;
procedure prepareexit(code : byte);
begin
  if lastrow <> nil then freemem(lastrow,linesize);
  if slide <> nil then freemem(slide,wsize);
  if readbuff <> nil then freemem(ReadBuff,ReadBuffSize);
  if outputrow <> nil then freemem(OutputRow,w);
  loadpng := code;
  HeapError := oldheaperrorfunc;
  close(infile);
end;

begin
  pstart := 0;
  pend   := 255;
  resetvars;
  BufferedRead   := BufferedReadfile;
  BufferSkipBack := BufferSkipBackfile;

  posx := px;
  posy := py;
  assign(infile,name);
  reset(infile,1);
  if ioresult <> 0 then begin;prepareexit(1);exit;end;
  oldheaperrorfunc := HeapError;
  HeapError := @MyHeapErrorFunc;
  getmem(slide,wsize);
  if slide = NIL then begin;prepareexit(4);exit;end;
  getmem(ReadBuff,ReadBuffSize);
  if ReadBuff = NIL then begin;prepareexit(4);exit;end;
  ResetReadBuffer;
  Filldword(FilterCount,Sizeof(FilterCount),0);
  BufferedRead (BufMag,8);
  CheckIO;
  if BufMag <> id then begin;prepareexit(2);exit;end;
  First := True;
  with ChunkHead do
  while Name <> 'Iend' do begin
    ReadChunkHead;
    if ChunkHead.Name = 'IHDR' then begin
      Process_IHDR;
      if ((PNGHead.Colortype <> 0)and(PNGHead.Colortype <> 3))
      or((PNGHead.bitspersample <> 8)and(PNGHead.bitspersample <> 4)) then
      begin;prepareexit(2);exit;end;
      if PNGHead.Colortype = 0 then
      if (PNGHead.bitspersample = 8) then
      for i := 0 to 255 do setrgbpal(i,i shr 2,i shr 2,i shr 2)
      else for i := 0 to 15 do setrgbpal(i,i shl 2,i shl 2,i shl 2);
      getmem(lastrow,linesize);
      filldword(lastrow^,linesize,0);
      bpp := linesize div pnghead.width;
    end
    else begin
      if First then begin;prepareexit(2);exit;end;
      i := FindChunk(ChunkHead.Name);
      if i >= 0 then begin
        Chunks[i].Process;
        Chunks[i].HaveIt := True;
      end
      else begin
        if byte(ChunkHead.Name[0]) and 32 = 0 then
        begin;prepareexit(2);exit;end{unknown critical chunk}
        else{Unknown ancillary chunk};
        SkipChunk;
      end;
    end;
    First := False;
  end;
{      if (rbpos < rbend) Or Not Eof(infile) then;
      {File contains data after Iend chunk}
  prepareexit(0);
end;

begin
end.
