{$IFNDEF VER60}
{$A+,B+,F-,G+,I-,O+,P+,Q-,R-,S-,T-,V-,X+,Y-}
{$ELSE}
{$A+,B+,F-,G+,I-,O+,R-,S-,V-,X+}
{$ENDIF}
unit graphics;
{**** GRAFX *****************************************************************
 * Author    : Stefan Goehler, Germany                                      *
 * Version   : official 1.3c                                                *
 * Task      : Replacing the unit graph with much more speed and features   *
 * References: . C'T 6/95, C'T 2/97 (the BEST german computer magazine)     *
 *             . t1-svga1.zip                                               *
 *             . vgadoc4b.zip (look with Altavista or sth. else for them)   *
 *             . COMPUTER GRAPHICS: principles and practice (second edition)*
 *               - english version (ISBN 0-201-12110-7)                     *
 *             . PC Intern 5 (very well german-only book)                   *
 *             . some graphicunits and standalone-units                     *
 *             . some FPK-Sources                                           *
 *             . SWAG                                                       *
 *             . my own knowledge :)                                        *
 * Copyright : You can use this unit entired in your own programs. Using    *
 *             parts of it or ripping any code off is not allowed without   *
 *             my permission. If you wanna use this unit in commercial      *
 *             products, I mean if you wanna get ANY money or other for     *
 *             software based on one of my units, you'll have to contact me *
 *             - we'll find a way.                                          *
 * Comments  :-have fun, it's only to 80,333 percent compatible with unit   *
 *             graph ;)                                                     *
 *            -if u think, the pascal routines are slow.. I already tried to*
 *             rewrite some to assembler with only little speedup (2 %)     *
 *            -this unit uses some special speedups - my S3card is 43%(!)   *
 *             faster when I use this speedup in addition to standard VESA  *
 ******** INFORMATION *******************************************************
 * my homepage: http://sourcenet.home.pages.de                              *
 * ^^^note that you can get there always the actual version of this unit    *
 * if you have additions, tips or sth. else, mail to stefan.goehler@gmx.de  *
 ******** TESTS *************************************************************
 * Proc Board           Grapicscard               Memory    HD        Check *
 * P100/Intel Zappa    /Hercules GT S3Trio64 2MB /32MB EDO /2,5;1,6GB OK    *
 * ^^ That's my system :)                                                   *
 * P90 /Acer board     /Cirrus 5434 Chip     1MB /16MB PM  /1,2 GB    OK    *
 * P150/Notebook GW2000/C&T F65554 Chip      2MB /32MB EDO /1,4 GB    OK    *
 * P166MMX/Unknown     /Cirrus 5446          2MB /16MB EDO /2,1 GB    OK    *
 * All checks have been done with and without hardware acceleration.        *
 ******** HISTORY ***********************************************************
 * The history is now at the end of the file (it's really too long ;)       *
 ******** ACCELERATION ******************************************************
 * This unit uses at the moment accelerated functions of these chips:       *
 * -S3 (all versions)                                                       *
 * -Cirrus (bankswitch on all cards, acceleration begins with 5426 chips    *
 ******** LAST WORDS ********************************************************
 * I know the source may look a bit crappy - only few comments and a lot of *
 * ugly outcommented things. Well, I have the overview, so don't get        *
 * concerned about these things ;). And the unit works fine.                *
 ****************************************************************************}

{$DEFINE ACCELERATION}
interface
{$IFDEF ACCELERATION}
{$IFDEF DPMI}
uses crt,winapi,gr_vars,gr_s3{,gr_tseng},gr_cirr{,gr_ati};
{$ELSE}
uses crt,gr_vars,gr_s3{,gr_tseng},gr_cirr{,gr_ati};
{$ENDIF}
{$ELSE}
{$IFDEF DPMI}
uses crt,winapi,gr_vars;
{$ELSE}
uses crt,gr_vars;
{$ENDIF}
{$ENDIF}

type
  LineSettingsType = record
    linestyle : word;
    pattern   : word;
    thickness : word;
  end;
  FillSettingsType = record
    pattern : word;
    color   : word;
  end;
  PointType = record
    x,y : integer;
  end;

  polygon = array[0..8191] of pointtype;
  timage_info = record
    size         : pointtype;
    colordepth   : byte;
    transparency : boolean;
    compressed   : boolean;
    trans_color  : longint;
    memsize      : longint;
    disksize     : longint;
    version      : longint;
  end;

const
  modeset : array[0..9] of record
    mode,sx,sy : word;
  end=((mode:$013;sx:0319;sy:0199),
       (mode:$100;sx:0639;sy:0399),
       (mode:$101;sx:0639;sy:0479),
       (mode:$103;sx:0799;sy:0599),
       (mode:$105;sx:1023;sy:0767),
       (mode:$107;sx:1279;sy:1023),
       (mode:$120;sx:1599;sy:1199),{maybe that's not the same on all cards}
       (mode:0;sx:1;sy:1),
       (mode:0;sx:1;sy:1),
       (mode:0;sx:1;sy:1));
  imagedatasize : word = 4;

  { Errorcodes for imageloaders }
  image_noerror      = 0;
  image_filenotfound = 1;
  image_falseformat  = 2;
  image_falseend     = 3;
  image_nomem        = 4;

  image_errorstr : array[0..4] of string = ('No error',
                                            'File not found',
                                            'Format not supported',
                                            'Unexpexted end of file',
                                            'Not enough memory');

{TEXTMODE-functions for GFX/TEXTMODES}
{procedure textcolor(c : byte);
 procedure clrscr;
 procedure writeln(s : string);
 procedure write(s : string);}

{Palette-functions}
  procedure getpal;
  procedure setpal;
  procedure shiftpal;
  procedure getuserpal(var pal);
  procedure setuserpal(var pal);
  procedure setrgbpalette(colornum,redvalue,greenvalue,bluevalue : integer);
  procedure getrgbpalette(col : byte;var r,g,b : byte);
  procedure setrgbpal(i,r,g,b : byte);
  procedure getrgbpal(i : byte;var r,g,b : byte);
  function  findnearcol(nr,ng,nb : byte) : byte;
  function  loadjascpal(path : string) : boolean;
  function  loadpal(name : string;pal : pointer) : boolean;

{ procedure getvesamodeinfo(m : word);}
  function  openimage(var p : pointer;sx,sy : word) : word;
  procedure clearimage(p : pointer);
  procedure closeimage(var p : pointer);
  procedure setaccelerationmode(mode : byte);
  procedure set256mode(mode : integer);
  function  grapherrormsg(errorcode : integer) : string;
  function  graphresult : integer;
  function  getdrivername : string;
  procedure getaspectratio(var xasp,yasp : word);
  function  getmaxmode : integer;
  procedure closegraph;
  procedure waitretrace;
{ procedure pageretrace;}
  procedure hretrace;
  procedure setscreen(on : boolean);
  procedure setviewport(x1,y1,x2,y2 : integer;clip : boolean);
  procedure getviewsettings(var viewport : viewporttype);
  procedure clearviewport;

{graphical functions}
  procedure getimagesize(p : pointer;var x,y : word);
  procedure setimagesize(p : pointer;x,y : word);
  function  imagesize(x1,y1,x2,y2 : integer) : word;
  procedure scale(image : pointer;px,py : integer;sx,sy : word);
  function  getpixel(x,y : integer) : word;
  procedure putpixel(x,y : integer;color : word);
  procedure putsprite(x,y: integer;p : pointer;key : byte);
  procedure getimage(x1,y1,x2,y2 : integer;p : pointer);
  procedure putimage(x,y: integer;p : pointer);
var
  bar     : procedure(x1,y1,x2,y2: integer);
  line    : procedure(x1,y1,x2,y2: integer);
  bitblit : procedure(x1,y1,x2,y2,dstx,dsty : integer);

  procedure rbar(x1,y1,x2,y2 : integer;r : word);
  procedure fillcircle(x,y : integer;r : word);
  procedure fillellipse(x,y : integer;rx,ry : word);
  procedure circle(px,py : integer;r : word);
  procedure ellipse(px,py,rx,ry : integer);
  procedure hline(x1,y1,sizex : integer;col : byte);
  procedure patternline(x1,y1,sizex : integer;col : byte);
  procedure vline(x1,y1,sizey : integer;col : byte);
  procedure putline(x1,y1,sizex: integer;p : pointer);

const
  image_line : procedure(x1,y1,sizex: integer;p : pointer) = putline;
  {Change this procedure to use your own image output procedure}

  procedure spriteline(x1,y1,sizex : integer;p : pointer;key : byte);
  procedure getline(x1,y1,sizex : integer;p : pointer);
{ procedure progline(x,y: integer;sizex,mempos : word;p : pointer);}
var
  fillpoly : procedure(numpoints : word;var polypoints);
{  procedure fastpoly(numpoints : word;var polypoints);}
  procedure drawpoly(numpoints : word;var polypoints);
  procedure rectangle(x1,y1,x2,y2 : integer);
  procedure rrectangle(x1,y1,x2,y2 : integer;r : word);
  var cleardevice : procedure;
  procedure floodfill(x,y : integer;border : word);

{Text-functions}
  procedure readgraphline(x1,y1,col,maxchars,posx : word;var s2 : string);

  procedure writexy(x,y : integer;s : string);
  procedure setfont(fnt,size : byte);
  procedure settextstyle(font,direction,charsize : word);
  procedure gettextsettings(var textinfo : textsettingstype);
  function  textwidth(s : string) : word;
  function  textheight : word;
  procedure settextjustify(horiz,vert : word);
const
  outtextxy : procedure(x,y : integer;textstring : string) = writexy;

  procedure setactivepage(page : word);
  procedure setvisualpage(page : word);
  procedure copypage(source,destination : word);
var
  scroll : procedure(ypos : word);
  setfillstyle : procedure(pattern : word; color : word);
  procedure setcolor(col : word);
  procedure setbkcolor(colornum : word);
  function  getcolor : word;
  procedure getfillsettings(var FillInfo: FillSettingsType);
  procedure setfillcolor(col : byte);
  procedure setfillpattern(pattern : fillpatterntype;color : word);
  procedure setlinestyle(style : word;pattern : word;thickness : word);
  procedure getlinesettings(var lineinfo: linesettingstype);

{ procedure setbank(bank : word);
 function  getbank : word;
 procedure setbank2(bank : word);
 procedure incbank;
 procedure decbank;}
  function  getmaxcolor : word;
  procedure calccircle(r : integer);
  function  calcbank(x,y : integer) : word;


var
  setbank  : procedure(bank : word);
  setbank2 : procedure(bank : word);
  incbank  : procedure;
  decbank  : procedure;
  setwritemode : procedure(mode : byte);

  mxx,mxy,maxx,maxy: integer;
  actpage : byte;

const
  Black        = 0;
  Blue         = 1;
  Green        = 2;
  Cyan         = 3;
  Red          = 4;
  Magenta      = 5;
  Brown        = 6;
  LightGray    = 7;
  DarkGray     = 8;
  LightBlue    = 9;
  LightGreen   = 10;
  LightCyan    = 11;
  LightRed     = 12;
  LightMagenta = 13;
  Yellow       = 14;
  White        = 15;

  normalput  = 0;
  copyput    = 0;
  andput     = 3; {not supported}
  orput      = 2; {not supported}
  xorput     = 1;
  notput     = 0; {not supported}

{Fill patterns}
  EmptyFill     =  0;
  SolidFill     =  1;
  LineFill      =  2;
  LtSlashFill   =  3;
  SlashFill     =  4;
  BkSlashFill   =  5;
  LtBkSlashFill =  6;
  HatchFill     =  7;
  XHatchFill    =  8;
  InterleaveFill=  9;
  WideDotFill   =  10;
  CloseDotFill  =  11;
  UserFill      =  12;

{Line style settings - support for circle implemented}
  SolidLn    = 0;
  DottedLn   = 1;
  CenterLn   = 2;
  DashedLn   = 3;
  UserBitLn  = 4;

  NormWidth  = 1;
  ThickWidth = 1;{not supported}

{Font constants}
  DefaultFont  = 0;
  TriplexFont  = 2;
  SmallFont    = 2;
  SansSerifFont= 2;
  GothicFont   = 2;
  HorizDir     = 0;
  VertDir      = 1;{not supported}
  UserCharSize = 0;
{Settextjustify-constants}
{Horizontal}
  LeftText     = 0;
  RightText    = 2;
{Vertikal}
  BottomText   = 0;
  TopText      = 2;
{vertikal and horizontal}
  CenterText   = 1;
{constants for setviewport}
  ClipOn       = True;
  ClipOff      = False;

  {graphresult constants - I removed some because they're not needed here}
  grOk             =  0;
  grNotDetected    =  2;
  grFontNotFound   =  8;
  grNoFontMem      =  9;
  grInvalidMode    = 10;
  grError          = 11;
  grIOerror        = 12;
  grInvalidFont    = 13;
  grInvalidFontNum = 14;
  grNoMouseFound   = 15;

  grafx_version = 'GRAFX 1.3c';

  m320x200x256   = 0;
  m640x400x256   = 1;
  m640x480x256   = 2;
  m800x600x256   = 3;
  m1024x768x256  = 4;
  m1280x1024x256 = 5;
  m1600x1200x256 = 6;

implementation
var
  load,i : integer;
  screen : pointer;
  getted : boolean;
  cpos   : pointtype;

{crspos : record
x,y : word;
end;
lastcol : byte;
const
txtcol : byte = lightgray;

procedure textcolor(c : byte);
begin
if not gfx_inited then crt.textcolor(c) else
txtcol := c;
end;

procedure clrscr;
begin
if not gfx_inited then crt.clrscr
else begin
cleardevice;
crspos.x := 0;
crspos.y := 0;
end;
end;

procedure scrolltext;
begin
bitblit(0,textheight,mxx,(maxy div 8)*8,0,0);
setfillcolor(0);
bar(0,(maxy div 8)*8-textheight,mxx,mxy);
end;

procedure writeln(s : string);
begin
if not gfx_inited then system.writeln(s)
else begin
lastcol := getcolor;
setcolor(txtcol);
setfont(0,0);
if crspos.y > maxy div 8-1 then begin
scrolltext;
crspos.y :=  maxy div 8-1;
end;
writexy(crspos.x*8,crspos.y*8,s);
inc(crspos.y);
crspos.x := 0;
setcolor(lastcol);
end;
end;

procedure write(s : string);
begin

if not gfx_inited then system.write(s)
else begin
lastcol := getcolor;
setcolor(txtcol);
setfont(0,0);
writexy(crspos.x*8,crspos.y*8,s);
inc(crspos.x,length(s));
setcolor(lastcol);
end;
end;}
function openimage(var p : pointer;sx,sy : word) : word;
{Get memory for an image and set it's size there}
var
  size : word;
begin
  size := imagesize(0,0,sx,sy);
  openimage := size;
  if size = 0 then exit;
  getmem(p,size);
  memw[seg(p^):ofs(p^)]   := sx;
  memw[seg(p^):ofs(p^)+2] := sy;
end;

procedure closeimage(var p : pointer);
{Free the memory of an image}
var
  size : word;
begin
  size := imagesize(0,0,memw[seg(p^):ofs(p^)],memw[seg(p^):ofs(p^)+2]);
  freemem(p,size);
end;

procedure clearimage(p : pointer);assembler;
{a little clearer for images getted
with getimage or sized with setimagesize}
asm
  cld
  les   di,p
  mov   ax,es:[di]
  inc   ax
  mov   bx,es:[di+2]
  inc   bx
  mul   bx
  mov   cx,ax
  mov   bx,ax
  shr   cx,2
  add   di,imagedatasize
  db    66h;xor ax,ax
  db    0F3h,66h,0ABh{rep stosd}
  mov   cx,bx
  and   cx,11b
  jz    @end
  rep   stosb
  @end:
end;

procedure pageretrace;assembler;
{avoids flickering when using setvisualpage}
asm
  cmp  pr,0
  je   @end
  mov  dx,03DAh
  @lp1:
    in    al,dx
    test  al,8
  jnz   @lp1
  @lp2:
    in    al,dx
    test  al,8
  jz   @lp2
  @end:
end;

procedure setactivepage(page : word);
{sets page to draw at}
begin
  if numofpages >= page then begin
    pageadd := page*maxy;
    graphics.actpage := page;
    actscreen.mxy := lasty-pageadd;
  end;
end;

procedure setvisualpage(page : word);assembler;
{sets visible page}
asm
  mov   bx,page
  mov   ax,maxy
  mul   bx
  mov   dx,ax
  cmp   numofpages,bl
  jnae  @end
  @next:
    push  dx
    call  scroll
  @end:
  call  pageretrace {avoid flickering}
end;

procedure copypage(source,destination : word);
begin
  bitblit(0,source*maxy,mxx,mxy+source*maxy,0,maxy*destination);
end;

procedure scroll_vesa(ypos : word);far;assembler;
asm
  mov   dx,ypos
  mov   ax,4f07h
  xor   bx,bx
  xor   cx,cx
  int   10h
end;

procedure fill(var dest;times,d1,d2 : word);assembler;
{fills dest with times dwords}
asm
  mov   ax,d2
  db    66h;shl ax,16
  mov   ax,d1
  les   di,dest
  mov   cx,times
  cld
  db    0F3h,66h,0ABh{rep stosd}
end;

procedure cleardevice_vesa;far;{guess...}
var
  w    : word   ;
  l    : longint;
begin
  calcbank(0,pageadd);
  w := pageadd*bytesperscanline;
  l := longint(bytesperscanline)*maxy;
  if w > 0 then
  filldword(ptr(writeptr,w)^,65536-w,0) else
  fill(ptr(writeptr,0)^,16384,0,0);
  dec(l,65536-w);
  repeat
    incbank;
    if l >= longint(65536) then
    fill(ptr(writeptr,0)^,16384,0,0) else
    filldword(ptr(writeptr,0)^,l,0);
    dec(l,65536);
  until l <= 0;
end;


(*procedure progline(x,y: integer;sizex,mempos : word;p : pointer);assembler;
{Progressive line putting, internal - better don't use it}
asm
          mov   ax,fillviewport.mxx
          inc   ax
          mov   bx,sizex
          mov   cx,x
          mov   dx,y

          cmp   cx,ax
          jnb   @end
          mov   si,cx
          add   si,bx
          js    @end
{         cmp  dx,maxy
          jnb  @end
          mov  dx,pageadd
          add  y,dx}

          or    cx,cx
          jns   @ns
          add   bx,cx
          mov   di,bx
          mov   x,0
          jmp   @cmpend
@ns:      mov   si,cx
          add   si,bx
          cmp   si,ax
          jna   @na
          sub   ax,cx
          mov   di,ax
          jmp   @cmpend
@na:      mov   di,bx
@cmpend:  mov   cx,mempos
          mov   bx,di
          add   bx,cx
          jc    @nextbank
{         push word ptr p[2]
          push word ptr p[0]
          push writeptr
          push cx
          push di
          call move2screen}
 xchg  di,cx
 mov   bx,writeptr
 mov   dx,ds
 lds   si,p
 mov   es,bx
 mov   ax,cx
 cmp   cx,8
 jb    @start
 mov   cx,di
 and   cx,11b
 jz    @iszero
 mov   bx,4
 sub   bx,cx
 mov   cx,bx
 rep   movsb
 sub   ax,bx
 @iszero:
 mov   cx,ax
 @start:
  shr   cx,2
  db    0F3h,66h,0A5h{rep movsd}
  mov   cx,ax
  and   cx,11b
  jz    @end2
  rep   movsb
 @end2:
 mov   ds,dx

          jmp   @end
@nextbank:mov   si,65535
          mov   ax,cx
          dec   ax
          sub   si,ax
          push  si;push di
          push  word ptr p[2]
          push  word ptr p[0]
          push  writeptr
          push  cx
          push  si
          call  move2screen
          pop   di;pop si
          call  incbank
          mov   ax,di
          sub   ax,si
          push  word ptr p[2]
          mov   bx,word ptr p[0]
          add   bx,si
          push  bx
          push  writeptr
          push  0
          push  ax
          call  move2
          jmp   @next
          @end:
          mov   ax,mempos
          add   ax,bytesperscanline
          jnc   @next
          call  incbank
@next:
end;*)

procedure scale(image : pointer;px,py : integer;sx,sy : word);
{Not very professional, but scales on my P100 with S3 Trio64
 from 160x120 to 640x480 at 85 pics per second and more (realmode)}
var
  x,y,maxx,maxy,posx,posy,old,vmempos,memsize,putx,puty : word;
  umrx,umry                   : longint;
  xtable                      : array[0..2047] of word;
  p                           : pointer;
begin
  if (sx = 0)or(sy = 0) then exit;
  vmempos := calcbank(px,py+pageadd);

  memsize := sx+8;
  getmem(p,memsize);
  getimagesize(image,maxx,maxy);
  umry := 0;
  umrx := 0;
{  for x := 0 to sx-1 do begin
    xtable[x] := umrx div sx;
    inc(umrx,maxx+1);
  end;}
  asm
    db 66h;xor   bx,bx { umrx              }
    db 66h;xor   cx,cx { sx                }
    db 66h;xor   si,si { maxx+1            }
           xor   di,di { pointer to xtable }
           mov   cx,sx
           mov   x,cx  { counter           }
           mov   si,maxx
    @lp:
    db 66h;mov   ax,bx
    db 66h,99h         { cdq               }
    db 66h;div   cx
           mov   word ptr xtable[di],ax
    db 66h;add   bx,si { umrx += maxx+1    }
           add   di,2
           dec   x
           jnz   @lp
    db 66h;xor   ax,ax
    db 66h;mov   word ptr xtable,ax
  end;
  old := 0;
  if actviewport.clip then if sx+px > actviewport.mxx+1 then sx := actviewport.mxx+1-px;

  if sx+px+actviewport.x1 > graphics.maxx then sx := graphics.maxx-px-actviewport.x1;

  putx := sx;
  sx   := sx and $FFFE;
  puty := sy;
{  if actviewport.clip then}
  if py+sy+fillviewport.y1 > fillviewport.mxy+1 then puty := fillviewport.mxy+1-py;

  if (sy < maxy) then begin
    for y := 0 to puty-1 do begin
      posy := (umry div sy);
      if old <> posy then begin
        old := posy;

        asm
          mov   cx,maxx
          inc   cx
          mov   ax,posy
          mul   cx
          add   ax,4

          cmp   old,ax
          je    @end
          mov   old,ax
          push  ds

          lds   di,image
          add   di,ax

          les   bx,p
          mov   si,sx
          add   bx,si
          add   si,si

     @lp: mov   dx,word ptr xtable[si]
          add   di,dx
          mov   al,ds:[di]
          sub   di,dx
          mov   dx,word ptr xtable[si+2]
          add   di,dx
          mov   ah,ds:[di]
          sub   di,dx

          mov   es:[bx],ax
          sub   bx,2
          sub   si,4
         jns   @lp
         pop   ds
         @end:
        end;
        putline(px,py+y,sx,p);
{        inc(vmempos,bytesperscanline);}
      end;

      inc(umry,maxy+1);
    end;
  end else
  for y := 0 to puty-1 do begin
    posy := (umry div sy);
    asm
      mov   cx,maxx
      inc   cx
      mov   ax,posy
      mul   cx
      add   ax,4

      cmp   old,ax
      je    @end
      mov   old,ax
      push  ds

      lds   di,image
      add   di,ax

      les   bx,p
      mov   si,sx
      add   bx,si
      add   si,si

    @lp:
      mov   dx,word ptr xtable[si]
      add   di,dx
      mov   al,ds:[di]
      sub   di,dx
      mov   dx,word ptr xtable[si+2]
      add   di,dx
      mov   ah,ds:[di]
      sub   di,dx

      mov   es:[bx],ax
      sub   bx,2
      sub   si,4
      jns   @lp
      pop   ds
      @end:
    end;
    putline(px,py+y,putx,p);
{    inc(vmempos,bytesperscanline);}
    inc(umry,maxy+1);
  end;
  freemem(p,memsize);
end;



(*function calcbank(x,y : integer) : word;assembler;
{calculates position x,y in GFXmem, sets bank and
 returns the memory-position}
asm
  db    66h;xor cx,cx
  db    66h;xor ax,ax
  mov   bx,x
  add   bx,actviewport.x1
  mov   ax,actviewport.y1
  mov   cx,bytesperscanline
  add   ax,y
  db    66h;mul cx
  mov   cx,bx
  db    66h;add ax,cx
  mov   si,ax
  db    66h;shr ax,16
  cmp   ax,lastbank
  je    @end
  push  ax
  call  setbank2
 @end:
  mov   ax,si
end;*)

function calcbank(x,y : integer) : word;assembler;
{calculates position x,y in GFXmem, sets bank and
 returns the memory-position}
asm
  mov   bx,x
  add   bx,actviewport.x1
  mov   ax,actviewport.y1
  mov   cx,bytesperscanline
  add   ax,y
  mul   cx
  add   ax,bx
  adc   dx,0
  mov   si,ax
  cmp   dx,lastbank
  je    @end
  push  dx
  call  setbank2
@end:
  mov   ax,si
end;

var
  size_last_circle : word;

procedure calccircle(r : integer);assembler;
asm
  mov   bx,r
  cmp   bx,size_last_circle
  je    @end                  {if the last circle had the same size, exit}

  mov   size_last_circle,bx
  mov   di,bx
  add   di,di
  mov   word ptr point,0
  mov   word ptr point[di],bx
  mov   si,1
  sub   si,bx                 { d := 1-r               }
  xor   cx,cx                 { x := 0                 }
  mov   ax,bx                 { y := r                 }
  or    ax,ax
  jbe   @end

  xor   di,di
  add   bx,bx

@start:                       { while y > x do begin   }
  or    si,si                 { if d < 0 then begin    }
  jns   @next
    mov   dx,cx
    add   dx,dx
    add   dx,3
    add   si,dx               { inc(d,x shl 1 + 3)     }
    inc   cx                  { inc(x)                 }
    sub   bx,2
    jmp   @stop               { end                    }
  @next:                      { else begin             }
    mov   dx,cx
    sub   dx,ax
    add   dx,dx
    add   dx,3
    add   si,dx               { inc(d,(x-y) shl 1 + 3) }
    inc   cx                  { inc(x)                 }
    sub   bx,2
    dec   ax                  { dec(y)                 }
    add   di,2
  @stop:                      { end                    }
  mov   word ptr point[di],cx { point[r-y] := x        }
  mov   word ptr point[bx],ax { point[r-x] := y        }
  cmp   ax,cx
  jg    @start
@end:
end;

procedure calcellipse(rx,ry : longint);
var
  x,mx1,mx2,my1,my2 : integer;
  aq,bq,dx,dy,r,a,b : longint;
begin
  stylecounter := 1;
  mx1 := -rx;
  my1 := 0;
  mx2 := rx;
  my2 := 0;

  aq := longint(rx) * rx;
  bq := longint(ry) * ry;
  dx := aq shl 1;
  dy := bq shl 1;
  r  := rx * bq;
  a := r shl 1;
  b := 0;
  x  := rx;
  while x > 0 do begin
    if r > 0 then begin
      inc(my1);
      dec(my2);
      inc(b,dx);
      dec(r,b);
    end;
    if r <= 0
    then begin
      dec(x);
      inc(mx1);
      dec(mx2);
      dec(a,dy);
      inc(r,a);
    end;
    point[ry-my1] := mx1;
  end;
end;

procedure fillcircle(x,y : integer;r : word);
{draws a filled circle}
var
  i  : integer;
begin
  if (r > 500)or(r = 0) then exit;
  dec(y,r);
  calccircle(r);
    for i := 0 to r-1 do begin
      patternline(x-point[i],y,point[i] shl 1,fillcolor);
      inc(y);
    end;
    for i := r-1 downto 0 do begin
      patternline(x-point[i],y,point[i] shl 1,fillcolor);
      inc(y);
    end
end;

procedure fillellipse(x,y : integer;rx,ry : word);
{draws a filled ellipse}
var
  i : integer;
begin
  if (ry > 500)or(rx = 0)or(ry = 0) then exit;
  dec(y,ry);
  if rx <> ry then calcellipse(rx,ry) else calccircle(rx);
    for i := 0 to ry-1 do begin
      patternline(x-point[i],y,point[i] shl 1,fillcolor);
      inc(y);
    end;
    for i := ry-1 downto 0 do begin
      patternline(x-point[i],y,point[i] shl 1,fillcolor);
      inc(y);
    end
end;


procedure circle(px,py : integer;r : word);
{draws a traced circle}
var
  a,b,d : integer;
begin
  if r > 1 then begin
    a := 0;
    b := r;
    d := 1-r;
    stylecounter := 1;

    while b >= a do begin
      if d < 0 then begin
        inc(d,a shl 1 + 3);
        inc(a);
      end else begin
        inc(d,(a - b) shl 1 + 5);
        inc(a);
        dec(b);
      end;
      inc(stylecounter,stylecounter);
      if stylecounter = 0 then stylecounter := 1;
      if stylecounter and linestyle <> 0 then begin
        putpixel(px+a,py-b,currentcolor);
        putpixel(px-a,py-b,currentcolor);
        putpixel(px+b,py-a,currentcolor);
        putpixel(px-b,py-a,currentcolor);
        putpixel(px+b,py+a,currentcolor);
        putpixel(px-b,py+a,currentcolor);
        putpixel(px+a,py+b,currentcolor);
        putpixel(px-a,py+b,currentcolor);
      end;
    end;
    {algorythm won't calculate the first pixels - we have to put them ourself}
    putpixel(px,py-r,currentcolor);
    putpixel(px-r,py,currentcolor);
    putpixel(px+r,py,currentcolor);
    putpixel(px,py+r,currentcolor);
  end else putpixel(px,py,currentcolor);
end;


procedure ellipse(px,py,rx,ry : integer);
var
  x,mx1,mx2,my1,my2 : integer;
  aq,bq,dx,dy,r,a,b : longint;
begin
  stylecounter := 1;
  mx1 := px - rx;
  my1 := py;
  mx2 := px + rx;
  my2 := py;

  putpixel(mx2,py,currentcolor);
  putpixel(mx1,py,currentcolor);

  aq := longint(rx) * rx;
  bq := longint(ry) * ry;
  dx := aq shl 1;
  dy := bq shl 1;
  r  := rx * bq;
  a := r shl 1;
  b := 0;
  x  := rx;
  while x > 0 do begin
    if r > 0 then begin
      inc(my1);
      dec(my2);
      inc(b,dx);
      dec(r,b);
    end;
    if r <= 0
    then begin
      dec(x);
      inc(mx1);
      dec(mx2);
      dec(a,dy);
      inc(r,a);
    end;
    inc(stylecounter,stylecounter);
    if stylecounter = 0 then stylecounter := 1;
    if stylecounter and linestyle <> 0 then begin
      putpixel(mx1,my1,currentcolor);
      putpixel(mx2,my1,currentcolor);
      putpixel(mx1,my2,currentcolor);
      putpixel(mx2,my2,currentcolor);
    end;
  end;
end;

procedure putimage(x,y: integer;p : pointer);
var
  sizex,sizey,i,i2,i3,i4,oli2,putmaxx : word;
  x2,y2                               : integer;
  switched                            : boolean;
begin
  sizex := succ(memw[seg(p^):ofs(p^)]);
  sizey := memw[seg(p^):ofs(p^)+2];
{ if longint(sizex)*sizey+imagedatasize > 65528 then exit;
 if (x < actviewport.mxx+1)and(x+sizex > 0)and(y+sizey >= 0)and((y < actviewport.mxy+1)or(not actviewport.clip)) then begin
   if actviewport.clip then
   if y+sizey > actviewport.mxy then inc(sizey,(actviewport.mxy-(y+sizey)));
   i4 := imagedatasize;
   if y < 0 then begin
     i4 := i4-(y*sizex);
     sizey := sizey+y;
     y := 0;
   end;
   if x < 0 then begin
     i4 := i4-x;
     putmaxx := sizex+x;
     x := 0;
   end else begin
     if x+sizex > actviewport.mxx then putmaxx := actviewport.mxx-x+1 else
     putmaxx := sizex;
   end;
   if putmaxx+x > maxx then putmaxx := maxx-x;
   inc(y,pageadd);
   i2 := calcbank(x,y);}

  inc(x,actviewport.x1);
  inc(y,actviewport.y1);
  x2 := x+sizex;
  y2 := y+sizey;


  i4      := imagedatasize;

  if (y > fillviewport.y2) or (y2 < fillviewport.y1) then exit;
  if (x > fillviewport.x2) or (x2 < fillviewport.x1) then exit;
  if x  < fillviewport.x1 then begin
    inc(i4,fillviewport.x1-x);
    x       := fillviewport.x1;
  end;
  if x2 > fillviewport.x2 then x2 := fillviewport.x2;
  if y  < fillviewport.y1 then begin
    inc(i4,sizex*(fillviewport.y1-y));
    y  := fillviewport.y1;
  end;
  if y2 > fillviewport.y2 then y2 := fillviewport.y2;

  putmaxx := abs(x2-x);
  sizey := abs(y2-y);
  inc(y,pageadd);
  i2 := calcbank(x-actviewport.x1,y-actviewport.y1);

   oli2 := i2;
   switched := false;
   for i := y to y+sizey do begin
     if i2 < i2+putmaxx then begin
       if (oli2 > i2)and(not switched) then incbank;
       move2screen(ptr(seg(p^),ofs(p^)+i4)^,ptr(writeptr,i2)^,putmaxx);
       switched := false;
     end else begin
       i3 := 0-i2;
       move2screen(ptr(seg(p^),ofs(p^)+i4)^,ptr(writeptr,i2)^,i3);
       incbank;
       switched := true;
       move2(ptr(seg(p^),ofs(p^)+i4+i3)^,ptr(writeptr,0)^,putmaxx-i3);
     end;
     inc(i4,sizex);
     oli2 := i2;
     inc(i2,bytesperscanline);
   end;
{ end;}
end;


procedure putsprite(x,y: integer;p : pointer;key : byte);
{key is the transparent color (color key)}
var
  sizex,sizey,i,i2,i3,i4,oli2,putmaxx : word;
  x2,y2                               : integer;
  switched                            : boolean;
begin
  sizex := succ(memw[seg(p^):ofs(p^)]);
  sizey := memw[seg(p^):ofs(p^)+2];
{  if longint(sizex)*sizey+imagedatasize > 65528 then exit;
  if (x < actviewport.mxx+1)and(x+sizex > 0)and(y+sizey > -1)and((y < actviewport.mxy+1)or(not actviewport.clip)) then begin
    if actviewport.clip then
    if y+sizey > actviewport.mxy then sizey := sizey+(actviewport.mxy-(y+sizey));
    i4 := imagedatasize;
    if y < 0 then begin
      i4 := i4-(y*sizex);
      sizey := sizey+y;
      y := 0;
    end;
    if x < 0 then begin
      i4 := i4-x;
      putmaxx := sizex+x;
      x := 0;
    end else begin
      if actviewport.clip then
      if x+sizex > actviewport.mxx then putmaxx := actviewport.mxx-x+1 else
      putmaxx := sizex;
    end;
    if putmaxx+x > maxx then putmaxx := maxx-x;
    inc(y,pageadd);
    i2 := calcbank(x,y);}
  inc(x,actviewport.x1);
  inc(y,actviewport.y1);
  x2 := x+sizex;
  y2 := y+sizey;


  i4 := imagedatasize;

  if (y > fillviewport.y2)or(y2 < fillviewport.y1) then exit;
  if (x > fillviewport.x2)or(x2 < fillviewport.x1) then exit;
  if x  < fillviewport.x1 then begin
    inc(i4,fillviewport.x1-x);
    x       := fillviewport.x1;
  end;
  if x2 > fillviewport.x2 then x2 := fillviewport.x2;
  if y  < fillviewport.y1 then begin
    inc(i4,sizex*(fillviewport.y1-y));
    y  := fillviewport.y1;
  end;
  if y2 > fillviewport.y2 then y2 := fillviewport.y2;

  putmaxx := abs(x2-x);
  sizey := abs(y2-y);
  inc(y,pageadd);
  i2 := calcbank(x-actviewport.x1,y-actviewport.y1);

    oli2 := i2;
    switched := false;
    for i := y to y+sizey do begin
      if i2 < i2+putmaxx then begin
        if (oli2 > i2)and(not switched) then incbank;
        sprite2mem(ptr(seg(p^),ofs(p^)+i4)^,ptr(writeptr,i2)^,putmaxx,key);
        switched := false;
      end else begin
        i3 := 0-i2;
        sprite2mem(ptr(seg(p^),ofs(p^)+i4)^,ptr(writeptr,i2)^,i3,key);
        incbank;
        switched := true;
        sprite2mem(ptr(seg(p^),ofs(p^)+i4+i3)^,ptr(writeptr,0)^,putmaxx-i3,key);
      end;
      inc(i4,sizex);
      oli2 := i2;
      inc(i2,bytesperscanline);
    end;
{  end;}
end;

procedure getimage(x1,y1,x2,y2 : integer;p : pointer);
var
  sizex,sizey,i,i2,i3,i4,oli2,getmaxx : word;
  lastbank      : word   ;
  switched      : boolean;
  i5            : integer;
begin
  inc(y1,pageadd);
  inc(y2,pageadd);
  if x1 > x2 then swap(x1,x2);
  if y1 > y2 then swap(y1,y2);
  sizex := succ(abs(x2-x1));
  sizey := abs((y2-y1));
  setimagesize(p,sizex-1,sizey);
  i2 := calcbank(x1,y1);
  oli2 := i2;
  i4 := imagedatasize;
  if x1+sizex > maxx then getmaxx := maxx-x1 else{Fehldarstellungen am Rand!}
  getmaxx := sizex;
  if actviewport.clip then
  if (y1-pageadd)+sizey > mxy then sizey := sizey+(mxy-((y1-pageadd)+sizey));
  switched := false;
  for i := y1 to y1+sizey do begin
    if i2 < i2+getmaxx then begin
      if (oli2 > i2)and(not switched) then incbank;
      movefromscreen(ptr(readptr,i2)^,ptr(seg(p^),ofs(p^)+i4)^,getmaxx);
      switched := false;
    end
    else begin
      i3 := 0-i2;
      movefromscreen(ptr(readptr,i2)^,ptr(seg(p^),ofs(p^)+i4)^,i3);
      incbank;
      switched := true;
      move2(ptr(readptr,0)^,ptr(seg(p^),ofs(p^)+i4+i3)^,getmaxx-i3);
    end;
    inc(i4,sizex);
    oli2 := i2;
    inc(i2,bytesperscanline);
  end;
end;

procedure bar_vesa(x1,y1,x2,y2: integer);far;
var
  sizex,sizey,i,i2,i3,oli2 : word;
  switched                 : boolean;
begin
  if y1 > y2 then swap(y1,y2);
  if x1 > x2 then swap(x1,x2);
  inc(x1,actviewport.x1);
  inc(y1,actviewport.y1);
  inc(x2,actviewport.x1);
  inc(y2,actviewport.y1);


  if (y1 > fillviewport.y2) or (y2 < fillviewport.y1) then exit;
  if (x1 > fillviewport.x2) or (x2 < fillviewport.x1) then exit;
  if x1 < fillviewport.x1 then x1 := fillviewport.x1;
  if x2 > fillviewport.x2 then x2 := fillviewport.x2;
  if y1 < fillviewport.y1 then y1 := fillviewport.y1;
  if y2 > fillviewport.y2 then y2 := fillviewport.y2;

  sizex := succ(abs(x2-x1));
  sizey := abs(y2-y1);
  inc(y1,pageadd);
  i2 := calcbank(x1-actviewport.x1,y1-actviewport.y1);
  oli2 := i2;
  switched := false;
  if fillstylenum < 2 then
  for i := y1 to y1+sizey do begin
    if i2 < i2+sizex then begin
      if (oli2 > i2)and(not switched) then incbank;
      filldword(ptr(writeptr,i2)^,sizex,fillcolor);
      switched := false;
    end
    else begin
      i3 := 0-i2;
      filldword(ptr(writeptr,i2)^,i3,fillcolor);
      incbank;
      switched := true;
      filldword(ptr(writeptr,0)^,sizex-i3,Fillcolor);
    end;
    oli2 := i2;
    inc(i2,bytesperscanline);
  end else
  for i := y1 to y1+sizey do begin
    if i2 < i2+sizex then begin
      if (oli2 > i2)and(not switched) then incbank;
      fillpattern(ptr(writeptr,i2)^,sizex,fillcolor,bkcolor,x1 and 7,fillstyle[i and 7+1]);
      switched := false;
    end
    else begin
      i3 := 0-i2;
      fillpattern(ptr(writeptr,i2)^,i3,fillcolor,bkcolor,x1 and 7,fillstyle[i and 7+1]);
      incbank;
      switched := true;
      fillpattern(ptr(writeptr,0)^,sizex-i3,fillcolor,bkcolor,x1 and 7+i3 and 7,fillstyle[i and 7+1]);
    end;
    oli2 := i2;
    inc(i2,bytesperscanline);
  end;
end;

procedure rbar(x1,y1,x2,y2 : integer;r : word);
{bar with rounded edges - radius of circle is r}
var
  i,sizex  : word;
  x,y      : word;
begin
  sizex := abs(x2-x1);
  calccircle(r);
  hline(x1+r-point[0],y1,sizex-(r-point[0])*2+1,currentcolor);
  vline(x1,y1+r,y2-y1-r*2,currentcolor);
  hline(x1+r-point[0],y2,sizex-(r-point[0])*2+1,currentcolor);
  vline(x2,y1+r,y2-y1-r*2,currentcolor);
  for y := 1 to r do
  for x := r-point[y] to r-point[y-1] do begin
    putpixel(x1+x,y1+y,currentcolor);
    putpixel(x2-x,y1+y,currentcolor);
  end;
  for y := 1 to r do
  for x := r-point[y] to r-point[y-1] do begin
    putpixel(x1+x,y2-y,currentcolor);
    putpixel(x2-x,y2-y,currentcolor);
  end;
  for y := 1 to r do
  patternline(x1+r-point[y-1]+1,y1+y,sizex-(r*2-point[y-1]*2)-1,fillcolor);
  bar(x1+1,y1+r+1,x2-1,y2-r-1);
  for y := r downto 1 do
  patternline(x1+r-point[y-1]+1,y2-y,sizex-(r*2-point[y-1]*2)-1,fillcolor);
end;

(*procedure bitblit_vesa(x1,y1,x2,y2,dstx,dsty : integer);far;
{implementation is not very fast, but it works}
var
  y,sx    : integer;
  oldclip : boolean;
  p       : pointer;
begin
  oldclip := actviewport.clip;
  actviewport.clip := false;
  sx := abs(x2-x1)+1;
  if sx > maxx then sx := maxx;
  if sx = 0 then exit;
  if y1 > y2 then swap(y1,y2);
  getmem(p,sx);
  if y1 > dsty then
  for y := y1 to y2 do begin
    getline(x1,y,sx,p);
    putline(dstx,dsty+y-y1,sx,p);
  end else
  for y := y2 downto y1 do begin
    getline(x1,y,sx,p);
    putline(dstx,dsty+y-y1,sx,p);
  end;
  actviewport.clip := oldclip;
  freemem(p,sx);
end;*)

procedure bitblit_vesa(x1,y1,x2,y2,dstx,dsty : integer);far;
{faster version, needs also more memory... seems to run ok}
var
  y,sx,sy,memy : integer;
  oldviewport  : viewporttype;
  p            : pointer;
begin
  getmem(p,bitblit_memsize+imagedatasize);
  oldviewport := actviewport;
  setviewport(0,0,mxx,mxy,false);
  sx := abs(x2-x1);
  sy := abs(y2-y1);
  if sx > maxx then sx := maxx;
  if sx = 0 then exit;
  if y1 > y2 then swap(y1,y2);
  memy := bitblit_memsize div sx;
  if memy >= sy then begin
    getimage(x1,y1,x1+sx,y1+sy,p);
    putimage(dstx,dsty,p);
  end else begin

    if y1 > dsty then begin
      for y := 0 to sy div memy-1 do begin
        getimage(x1,y1+y*memy,x1+sx,y1+memy+y*memy-1,p);
        putimage(dstx,dsty+y*memy,p);
      end;
      if sy mod memy > 0 then begin
        y := succ(y)*memy;
        getimage(x1,y1+y,x1+sx,y1+y+sy mod memy,p);
        putimage(dstx,dsty+y,p);
      end;
    end else begin
      if sy mod memy > 0 then begin
        y := (sy div memy)*memy;
        getimage(x1,y1+y,x1+sx,y1+y+sy mod memy,p);
        putimage(dstx,dsty+y,p);
      end;
      for y := sy div memy-1 downto 0 do begin
        getimage(x1,y1+y*memy,x1+sx,y1+memy+y*memy-1,p);
        putimage(dstx,dsty+y*memy,p);
      end;
    end;
  end;
  with oldviewport do setviewport(x1,y1,x2,y2,clip);
  freemem(p,bitblit_memsize+imagedatasize);
end;



procedure rrectangle(x1,y1,x2,y2 :integer;r:word);
{rectangle with rounded edges - radius of circle is r}
var
  i,sizex  : word;
  x,y      : word;
begin
  inc(y1,pageadd);
  inc(y2,pageadd);
  sizex := abs(x2-x1);
  calccircle(r);
  hline(x1+r-point[0],y1,sizex-(r-point[0])*2+1,currentcolor);
  vline(x1,y1+r,y2-y1-r*2,currentcolor);
  hline(x1+r-point[0],y2,sizex-(r-point[0])*2+1,currentcolor);
  vline(x2,y1+r,y2-y1-r*2,currentcolor);
  for y := 1 to r do
  for x := r-point[y] to r-point[y-1] do begin
    putpixel(x1+x,y1+y,currentcolor);
    putpixel(x2-x,y1+y,currentcolor);
  end;
  for y := 1 to r do
  for x := r-point[y] to r-point[y-1] do begin
    putpixel(x1+x,y2-y,currentcolor);
    putpixel(x2-x,y2-y,currentcolor);
  end;
end;

procedure hline(x1,y1,sizex: integer;col : byte);
{draw a horizontal line}
var
  i2,i3   : word;
{  x2      : integer;}
label
  endofproc;
begin
  asm
    mov   cx,sizex
    mov   ax,x1
    or    cx,cx
    jz    endofproc
    jns   @next
      neg   cx
      sub   ax,cx
    @next:
    add   ax,actviewport.x1
    mov   bx,ax
    add   bx,cx
    mov   di,y1
    add   di,actviewport.y1
    cmp   di,fillviewport.y1
    jl    endofproc
    cmp   di,fillviewport.y2
    jg    endofproc
    mov   cx,fillviewport.x1
    mov   dx,fillviewport.x2
    cmp   ax,dx
    jge   endofproc
    cmp   bx,cx
    jle   endofproc
    cmp   ax,cx
    jnl   @next1
      mov   ax,cx
    @next1:
    inc   dx
    cmp   bx,dx
    jng   @next2
      mov   bx,dx
    @next2:
    sub   bx,ax
    mov   sizex,bx
    sub   ax,actviewport.x1
    sub   di,actviewport.y1
    add   di,pageadd
    push  ax
    push  di
    call  calcbank
    mov   i2,ax
  end;
{  if sizex = 0 then exit;
  if sizex < 0 then begin
    sizex := -sizex;
    dec(x1,sizex);
  end;
  inc(x1,actviewport.x1);
  inc(y1,actviewport.y1);
  x2 := x1+sizex;
  if (y1 < fillviewport.y1)or(y1 > fillviewport.y2) then exit;
  if (x1 >= fillviewport.x2)or(x2 <= fillviewport.x1) then exit;
  if x1 < fillviewport.x1 then x1 := fillviewport.x1;
  if x2 > fillviewport.x2+1 then x2 := fillviewport.x2+1;
  sizex := x2-x1;
  i2 := calcbank(x1-actviewport.x1,y1-actviewport.y1+pageadd);}
  if i2 < i2+word(sizex) then
  filldword(ptr(writeptr,i2)^,sizex,col)
  else begin
    i3 := 0-i2;
    filldword(ptr(writeptr,i2)^,i3,col);
    incbank;
    filldword(ptr(writeptr,0)^,sizex-i3,col);
  end;
  endofproc:
end;

procedure patternline(x1,y1,sizex: integer;col : byte);
{draw a horizontal line}
var
  i2,i3   : word;
{  x2      : integer;}
label
  endofproc;
begin
  asm
    mov   cx,sizex
    mov   ax,x1
    or    cx,cx
    jz    endofproc
    jns   @next
      neg   cx
      sub   ax,cx
    @next:
    add   ax,actviewport.x1
    mov   bx,ax
    add   bx,cx
    mov   di,y1
    add   di,actviewport.y1
    cmp   di,fillviewport.y1
    jl    endofproc
    cmp   di,fillviewport.y2
    jg    endofproc
    mov   cx,fillviewport.x1
    mov   dx,fillviewport.x2
    cmp   ax,dx
    jge   endofproc
    cmp   bx,cx
    jle   endofproc
    cmp   ax,cx
    jnl   @next1
      mov   ax,cx
    @next1:
    inc   dx
    cmp   bx,dx
    jng   @next2
      mov   bx,dx
    @next2:
    sub   bx,ax
    mov   sizex,bx
    sub   ax,actviewport.x1
    mov   x1,ax
    sub   di,actviewport.y1
    add   di,pageadd
    push  ax
    push  di
    call  calcbank
    mov   i2,ax
  end;
{  if sizex = 0 then exit;
  if sizex < 0 then begin
    sizex := -sizex;
    dec(x1,sizex);
  end;
{  inc(x1,actviewport.x1);
  inc(y1,actviewport.y1);
  x2 := x1+sizex;
  if (y1 < fillviewport.y1)or(y1 > fillviewport.y2) then exit;
  if (x1 >= fillviewport.x2)or(x2 <= fillviewport.x1) then exit;
  if x1 < fillviewport.x1 then x1 := fillviewport.x1;
  if x2 > fillviewport.x2+1 then x2 := fillviewport.x2+1;
  sizex := x2-x1;
  i2 := calcbank(x1-actviewport.x1,y1-actviewport.y1+pageadd);}
  if (fillstylenum < 2) then begin
    if i2 < i2+word(sizex) then
    filldword(ptr(writeptr,i2)^,sizex,col)
    else begin
      i3 := 0-i2;
      filldword(ptr(writeptr,i2)^,i3,col);
      incbank;
      filldword(ptr(writeptr,0)^,sizex-i3,col);
    end;
  end else begin
    if i2 < i2+word(sizex) then
    fillpattern(ptr(writeptr,i2)^,sizex,col,bkcolor,x1 and 7,fillstyle[y1 and 7+1])
    else begin
      i3 := 0-i2;
      fillpattern(ptr(writeptr,i2)^,i3,col,bkcolor,x1 and 7,fillstyle[y1 and 7+1]);
      incbank;
      fillpattern(ptr(writeptr,0)^,sizex-i3,col,bkcolor,x1 and 7+i3 and 7,fillstyle[y1 and 7+1]);
    end;
  end;
  endofproc:
end;

procedure vline(x1,y1,sizey: integer;col : byte);assembler;
{draw a vertical line}
{var
  y2            : integer;
begin}
{  if sizey = 0 then exit;
  if sizey < 0 then begin
    sizey := -sizey;
    dec(y1,sizey);
  end;
  inc(x1,actviewport.x1);
  inc(y1,actviewport.y1);
  y2 := y1+sizey;
  if (x1 < fillviewport.x1)or(x1 > fillviewport.x2) then exit;
  if (y1 >= fillviewport.y2)or(y2 <= fillviewport.y1) then exit;
  if y1 < fillviewport.y1 then y1 := fillviewport.y1;
  if y2 > fillviewport.y2+1 then y2 := fillviewport.y2+1;}
  asm
    mov   cx,sizey
    mov   ax,y1
    or    cx,cx
    jz    @end
    jns   @next
      neg   cx
      sub   ax,cx
    @next:
    add   ax,actviewport.y1
    mov   bx,ax
    add   bx,cx
    mov   di,x1
    add   di,actviewport.x1
    cmp   di,fillviewport.x1
    jl    @end
    cmp   di,fillviewport.x2
    jg    @end
    mov   cx,fillviewport.y1
    mov   dx,fillviewport.y2
    cmp   ax,dx
    jge   @end
    cmp   bx,cx
    jle   @end
    cmp   ax,cx
    jnl   @next1
      mov   ax,cx
    @next1:
    inc   dx
    cmp   bx,dx
    jng   @next2
      mov   bx,dx
    @next2:
    sub   bx,ax
    mov   sizey,bx
    sub   ax,actviewport.y1
    sub   di,actviewport.x1
    add   ax,pageadd
    push  di
    push  ax
    call  calcbank
{    mov   i2,ax
  end;

  asm
    mov   ax,y1
    mov   bx,x1
    add   ax,pageadd
    sub   ax,actviewport.y1
    sub   bx,actviewport.x1
    push  bx
    push  ax
    call  calcbank}
    mov   di,writeptr
    mov   es,di
    mov   di,ax
    mov   al,col
{    mov   cx,y2
    sub   cx,y1}
    mov   cx,sizey
    mov   bx,bytesperscanline
      @lp:
      mov   es:[di],al
      add   di,bx
      jc    @nextbank
      @again:
      dec    cx
      jnz    @lp
    jmp    @end
       @nextbank:
       call  incbank
       jmp   @again
    @end:
{  end;}
end;

procedure putline(x1,y1,sizex: integer;p : pointer);
{draw a horizontal line with image of the pointer p}
var
  i2,i3,mempos : word;
  olx1         : integer;
{  x2      : integer;}
label
  endofproc;
begin
{  if sizex = 0 then exit;
  if sizex < 0 then begin
    sizex := -sizex;
    dec(x1,sizex);
  end;
  inc(x1,actviewport.x1);
  inc(y1,actviewport.y1);
  olx1 := x1;
  x2 := x1+sizex;
  if (y1 < fillviewport.y1)or(y1 > fillviewport.y2) then exit;
  if (x1 >= fillviewport.x2)or(x2 <= fillviewport.x1) then exit;
  if x1 < fillviewport.x1 then x1 := fillviewport.x1;
  if x2 > fillviewport.x2+1 then x2 := fillviewport.x2+1;
  sizex := x2-x1;
  i2 := calcbank(x1-actviewport.x1,y1-actviewport.y1+pageadd);
  mempos := x1-olx1;}
  asm
    mov   cx,sizex
    mov   ax,x1
    or    cx,cx
    jz    endofproc
    jns   @next
      neg   cx
      sub   ax,cx
    @next:
    add   ax,actviewport.x1
    mov   olx1,ax
    mov   bx,ax
    add   bx,cx
    mov   di,y1
    add   di,actviewport.y1
    cmp   di,fillviewport.y1
    jl    endofproc
    cmp   di,fillviewport.y2
    jg    endofproc
    mov   cx,fillviewport.x1
    mov   dx,fillviewport.x2
    cmp   ax,dx
    jge   endofproc
    cmp   bx,cx
    jle   endofproc
    cmp   ax,cx
    jnl   @next1
      mov   ax,cx
    @next1:
    inc   dx
    cmp   bx,dx
    jng   @next2
      mov   bx,dx
    @next2:
    sub   bx,ax
    mov   sizex,bx
    sub   ax,actviewport.x1
    sub   di,actviewport.y1
    add   di,pageadd
    mov   bx,ax
    sub   bx,olx1
    mov   mempos,bx
    push  ax
    push  di
    call  calcbank
    mov   i2,ax
  end;
    if i2 < i2+word(sizex) then
   {move2screen(ptr(seg(p^),ofs(p^)+mempos)^,ptr(writeptr,i2)^,putmaxx)}
  asm
    mov   ax,mempos
    mov   di,i2
    mov   cx,sizex
    mov   bx,writeptr
    mov   dx,ds
    lds   si,p
    add   si,ax
    mov   es,bx
    mov   ax,cx
    cmp   cx,8
    jb    @start
    mov   cx,di
    and   cx,11b
    jz    @iszero
    mov   bx,4
    sub   bx,cx
    mov   cx,bx
    rep   movsb
    sub   ax,bx
    @iszero:
    mov   cx,ax
    @start:
      shr   cx,2
      db    0F3h,66h,0A5h{rep movsd}
      mov   cx,ax
      and   cx,11b
      jz    @end
      rep   movsb
      @end:
    mov   ds,dx
  end
  else begin
    i3 := 0-i2;
    move2screen(ptr(seg(p^),ofs(p^)+mempos)^,ptr(writeptr,i2)^,i3);
    incbank;
    move2(ptr(seg(p^),ofs(p^)+i3+mempos)^,ptr(writeptr,0)^,sizex-i3);
  end;
  endofproc:
end;

procedure spriteline(x1,y1,sizex: integer;p : pointer;key : byte);
{draw a horizontal line with image of the pointer p}
var
  i2,i3,{putmaxx,}mempos : word;
  olx1                 : integer;
label
  endofproc;
begin
{  if sizex < 1 then exit;
  if (x1 < maxx)and(x1+sizex > 0)and(y1 >= 0)and((y1 < maxy)or(not actviewport.clip)) then begin
    inc(y1,pageadd);
    mempos := 0;
    putmaxx := sizex;

    if x1 < 0 then begin
      putmaxx := sizex+x1;
      mempos := -x1;
      x1 := 0;
    end else begin
      if x1+sizex > maxx then putmaxx := maxx-x1 else
      putmaxx := sizex;
    end;

    if x1+putmaxx > maxx then putmaxx := maxx-x1;
    i2 := calcbank(x1,y1); }
  asm
    mov   cx,sizex
    mov   ax,x1
    or    cx,cx
    jz    endofproc
    jns   @next
      neg   cx
      sub   ax,cx
    @next:
    add   ax,actviewport.x1
    mov   olx1,ax
    mov   bx,ax
    add   bx,cx
    mov   di,y1
    add   di,actviewport.y1
    cmp   di,fillviewport.y1
    jl    endofproc
    cmp   di,fillviewport.y2
    jg    endofproc
    mov   cx,fillviewport.x1
    mov   dx,fillviewport.x2
    cmp   ax,dx
    jge   endofproc
    cmp   bx,cx
    jle   endofproc
    cmp   ax,cx
    jnl   @next1
      mov   ax,cx
    @next1:
    inc   dx
    cmp   bx,dx
    jng   @next2
      mov   bx,dx
    @next2:
    sub   bx,ax
    mov   sizex,bx
    sub   ax,actviewport.x1
    sub   di,actviewport.y1
    add   di,pageadd
    mov   bx,ax
    sub   bx,olx1
    mov   mempos,bx
    push  ax
    push  di
    call  calcbank
    mov   i2,ax
  end;

  if i2 < i2+word(sizex) then
  sprite2mem(ptr(seg(p^),ofs(p^)+mempos)^,ptr(writeptr,i2)^,sizex,key)
  else begin
    i3 := 0-i2;
    sprite2mem(ptr(seg(p^),ofs(p^)+mempos)^,ptr(writeptr,i2)^,i3,key);
    incbank;
    sprite2mem(ptr(seg(p^),ofs(p^)+i3+mempos)^,ptr(writeptr,0)^,sizex-i3,key);
  end;
  endofproc:
end;

procedure getline(x1,y1,sizex: integer;p : pointer);
{gets a horizontal line and puts the image to the pointer p}
var
  i2,i3,getmaxx : word;
begin
  if sizex < 1 then exit;
  if (x1 < maxx)and(x1+sizex > 0)and(y1 >= 0)and((y1 < maxy)or(not actviewport.clip)) then begin
    inc(y1,pageadd);
    if x1 < 0 then begin
      getmaxx := sizex+x1;
      x1 := 0;
    end else begin
      if x1+sizex > maxx then getmaxx := maxx-x1 else
      getmaxx := sizex;
    end;
    i2 := calcbank(x1,y1);
    if i2 < i2+getmaxx then
    movefromscreen(ptr(writeptr,i2)^,p^,getmaxx)
    else begin
      i3 := 0-i2;
      movefromscreen(ptr(writeptr,i2)^,p^,i3);
      incbank;
      move2(ptr(writeptr,0)^,ptr(seg(p^),ofs(p^)+i3)^,getmaxx-i3);
    end;
  end;
end;



{ If you have some problems with your programs with fillpoly, I mean
  some missing pixels in polygons, which you had not with graph, use
  this fillpoly here instead of the other one                        }
(*const
  StdBufferSize = 2048;
var
  buffer : array[0..stdbuffersize-1] of byte;

procedure fillpoly(numpoints : word;var polypoints);
{ Draw a filled concave polygon using floating point arithmetic : less accurate }
{ but able to fill ANY polygon, not just convex ones.                           }
type
  XValueType = Array[0..32766] Of Integer;
var
  MaxIndex,Min_y,Max_y,Index,n,h,i,j,k,l : integer;
  m      : fpu;
  XValue : ^XValueType;
  points : polygon absolute polypoints;
procedure QuickSort (l, r : Integer);
{ Quicksort to sort the X-Values fast }
var
  i,j,x,y : integer;
begin
  i := l;j := r;x := XValue^[(l+r) div 2];
  repeat
    while XValue^[i] < x do inc(i);
    while x < XValue^[j] do dec(j);
    if i <= j then begin
      y:=XValue^[i]; XValue^[i]:=XValue^[j]; XValue^[j]:=y;
      Inc (i); Dec (j);
    end;
  until i>j;
  if l < j then QuickSort(l,j);
  if i < r then QuickSort(i,r);
end;

begin
  if (NumPoints < 3) Or (NumPoints > 8191) then exit;
  MaxIndex:=StdBufferSize div 2;
  XValue:= @Buffer;
  Min_y := mxy;
  Max_y := 0;
  for n := 0 to NumPoints-1 do begin
    if Points[n].y<Min_y then Min_y := Points[n].y;
    if Points[n].y>Max_y then Max_y := Points[n].y;
  end;
  for n := Min_y to Max_y do begin
    Index := 0;
    for i := 0 to NumPoints-1 do begin
      l := (i+1) mod NumPoints;
      h := Points[i].y; j := Points[l].y;
      if h > j then begin k := h;h := j;j := k; end;
      if (h <= n)and(n < j)and(Index <= MaxIndex) then begin
        m := (Points[i].x-Points[l].x) / (Points[i].y-Points[l].y);
        XValue^[Index] := Round(m*(n-Points[l].y)) + Points[l].x;
        inc(Index);
      end;
    end;
    If Index>0 then QuickSort (0,Index-1);
    j:=0;
    while (j<Index) do begin
      patternline(XValue^[j],n,XValue^[j+1]-XValue^[j]+1,fillcolor);
      inc(j,2);  { j is guaranteed to be even ! }
    end;
  end;
end;*)

{typecast parms to longint, result to fixed}
function fixedDiv(d1,d2:longint):longint;
inline(
  $66/$59/               {pop ecx}
  $58/                   {pop ax}
  $5A/                   {pop dx}
  $66/$0F/$BF/$D2/       {movsx edx,dx}
  $66/$C1/$E0/$10/       {shl eax,16}
  $66/$F7/$F9/           {idiv ecx}
  $66/$0F/$A4/$C2/$10);  {shld edx,eax,16}   {no rounding}

procedure fillpoly_vesa(numpoints : word;var polypoints);far;
{three times faster than fillpoly!}
type
  fixed=record case byte of
    0:(f:word;i:integer);
    1:(l:longint);
  end;
var
  i,l,r,lv,rv,top,bottom,topVert : integer;
  lstep,lpos,rstep,rpos          : fixed;
  ldest,rdest                    : Pointtype;
  points : polygon absolute polypoints;
begin
  if (numpoints < 3) or (numpoints > 8191) then exit;
 {find top and bottom vertices}
  topVert := numpoints-1;
  top     := points[topVert].y;
  bottom  := top;
  for i := numpoints-2 downto 0 do if (points[i].y < top) then
  begin
    top     := points[i].Y;
    topVert := i;
  end else if (points[i].y > bottom) then bottom := points[i].y;

  if actviewport.clip then
  if bottom > actviewport.mxy then bottom := actviewport.mxy; {clip bottom}

  if top > bottom then exit;
  lv    := topVert;
  rv    := topVert;
  ldest := points[topVert];
  rdest := ldest;
  i     := top;
  repeat
    if i >= ldest.y then begin
      lpos.f := 0;
      lpos.i := ldest.x;
      dec(lv);
      if lv < 0 then lv := numpoints-1;
      ldest := points[lv];
      if ldest.y = i then begin
        if ldest.x < lpos.i then lpos.i := ldest.x;
        lstep.l := 0;
      end
      else lstep.l := fixedDiv(ldest.x-lpos.i,ldest.y-i);
    end;
    if i >= rdest.y then begin
      rpos.f := 0;
      rpos.i := rdest.x;
      inc(rv);
      if rv >= numpoints then rv:=0;
      rdest := points[rv];
      if rdest.y = i then begin
        if rdest.x > rpos.i then rpos.i := rdest.x;
        rstep.l := 0;
      end
      else rstep.l := fixedDiv(rdest.x-rpos.i,rdest.y-i);
    end;
{  if i>=0 then begin                             {clip top}
{   if lpos.i>0 then l:=lpos.i else l:=0;      {clip left}
{   if rpos.i<actviewport.mxx then r:=rpos.i else r:=actviewport.mxx;      {clip right}
    if (lpos.i < rpos.i) then
    patternline(lpos.i,i,rpos.i-lpos.i+1,fillcolor) else
    patternline(rpos.i,i,lpos.i-rpos.i+1,fillcolor);
{   end;}
    inc(lpos.l,lstep.l);
    inc(rpos.l,rstep.l);
    inc(i);
  until i > bottom;
end;


procedure drawpoly(numpoints : word;var polypoints);
{draw a traced polygon}
var
  i : word;
  points : ^polygon;
begin
  points := @polypoints;
  if (numpoints = 0)or(numpoints > 16383) then exit;
  for i := 0 to numpoints-1 do
  line(points^[i].x,points^[i].y,points^[(i+1) mod numpoints].x,points^[(i+1) mod numpoints].y);
end;

function getmaxcolor : word;assembler;
{only for compatibility}
asm
  mov   ax,255
end;

procedure setbank_vesa(bank : word);far;assembler;
{set the graphical bank of vesa}
asm
 push cx
 cmp  m,0
 je   @end
 mov  dx,bank
 cmp  dx,lastbank
 je   @end
 mov  lastbank,dx
 mov  cl,shifter
 shl  dx,cl
 xor  cl,cl
 xor  bx,bx
{$IFDEF DPMI}
 mov  ax,4F05h
 int  10h
{$ELSE}
 call winfuncptr
{$ENDIF}
 mov  bl,twowins{for old GFX-cards... not tested yet}
 or   bl,bl
 jz   @end
 xor  bh,bh
{$IFDEF DPMI}
 mov  ax,4F05h
 int  10h
{$ELSE}
 call winfuncptr
{$ENDIF}
 @end:
 pop cx
end;

(*function getbank_vesa : word;far;assembler;
{get the graphical bank of vesa}
asm
 push cx
 cmp m,0
 je @end
{$IFDEF DPMI}
 mov ax,4F05h
 xor bh,bh
 mov bl,01h
 int 10h
{$ELSE}
 mov bh,01h
 call winfuncptr
{$ENDIF}
 mov ax,dx
 mov lastbank,ax
 mov cl,shifter
 shr ax,cl
 @end:
 pop cx
end;*)

procedure decbank_vesa;far;assembler;
{decrease the graphical bank of vesa}
asm
 pusha
 mov  dx,lastbank
 dec  dx
 mov  lastbank,dx
 mov  cl,shifter
 shl  dx,cl
 xor  cl,cl
 xor  bx,bx
{$IFDEF DPMI}
 mov  ax,4F05h
 int  10h
{$ELSE}
 call winfuncptr
{$ENDIF}
 mov  bl,twowins{for old GFX-cards... not tested yet}
 or   bl,bl
 jz   @end
 xor  bh,bh
{$IFDEF DPMI}
 mov  ax,4F05h
 int  10h
{$ELSE}
 call winfuncptr
{$ENDIF}
 @end:
 popa
end;

procedure incbank_vesa;far;assembler;
{increase the graphical bank of vesa}
asm
 pusha
 mov  dx,lastbank
 inc  dx
 mov  lastbank,dx
 mov  cl,shifter
 shl  dx,cl
 xor  cx,cx
 xor  bx,bx
{$IFDEF DPMI}
 mov  ax,4F05h
 int  10h
{$ELSE}
 call winfuncptr
{$ENDIF}
 mov  bl,twowins{for old GFX-cards... not tested yet}
 or   bl,bl
 jz   @end
 xor  bh,bh
{$IFDEF DPMI}
 mov  ax,4F05h
 int  10h
{$ELSE}
 call winfuncptr
{$ENDIF}
 @end:
 popa
end;

procedure setbank2_vesa(bank : word);far;assembler;
{set the actual bank- don't look, if this bank is already setted}
asm
 push cx
 cmp  m,0
 je   @end
 mov  dx,bank
 mov  lastbank,dx
 mov  cl,shifter
 shl  dx,cl
 xor  cl,cl
 xor  bx,bx
{$IFDEF DPMI}
 mov  cl,shifter
 shl  dl,cl
 xor  cl,cl
 mov  ah,4Fh
 mov  al,05h
 int  10h
{$ELSE}
 call winfuncptr
{$ENDIF}
 mov  bl,twowins{for old GFX-cards... not tested yet}
 or   bl,bl
 jz   @end
 xor  bh,bh
{$IFDEF DPMI}
 mov  ax,4F05h
 int  10h
{$ELSE}
 call winfuncptr
{$ENDIF}
 @end:
 pop  cx
end;

procedure dummyproc;far;
begin
end;

(*procedure putpixel(x,y :word;color : byte);assembler;
{non-clipped version - faster}
asm
 db 66h;xor  cx,cx
        mov  bx,x
        add  bx,actviewport.x1
        mov  cx,bytesperscanline
        cmp  bx,cx
        jnb  @end
        mov  ax,y
        add  ax,pageadd
        add  ax,actviewport.y1
 db 66h;mul  cx
        mov  cx,bx
 db 66h;add  ax,cx
        mov  si,ax
 db 66h;shr  ax,16
        cmp  ax,lastbank
        je   @next
        push ax
        call setbank2
 @next:
        mov  ax,writeptr
        mov  es,ax
        mov  al,color
        mov  bl,writemode
        cmp  bl,xorput
        je   @doxor
        mov  es:[si],al
        jmp  @end
 @doxor:xor  es:[si],al
 @end:
end;*)

{procedure putpixel(x,y : integer;color : word);assembler;
asm
  cmp   actviewport.clip,0
  je    @noclip
  db 66h;xor   cx,cx
         mov   bx,x
         or    bx,bx
         js    @end
         cmp   bx,actviewport.mxx
         ja    @end
         add   bx,actviewport.x1
         mov   cx,bytesperscanline
         cmp   bx,cx
         jnb   @end
         mov   ax,y
         or    ax,ax
         js    @end
         cmp   ax,actviewport.mxy
         ja    @end
         add   ax,pageadd
         add   ax,actviewport.y1
  db 66h;mul   cx
         mov   cx,bx
  db 66h;add   ax,cx
         mov   si,ax
  db 66h;shr   ax,16
         cmp   ax,lastbank
         je    @next
         push  ax
         call  setbank2
         jmp   @next
 @noclip:
  db 66h;xor   cx,cx
         mov   bx,x
         add   bx,actviewport.x1
         mov   cx,bytesperscanline
         cmp   bx,cx
         jnb   @end
         mov   ax,y
         add   ax,pageadd
         add   ax,actviewport.y1
  db 66h;mul   cx
         mov   cx,bx
  db 66h;add   ax,cx
         mov   si,ax
  db 66h;shr   ax,16
         cmp   ax,lastbank
         je    @next
         push  ax
         call  setbank2

 @next:  mov   es,[writeptr]
         mov   al,byte ptr color
         cmp   writemode,0
         jne   @doxor
         mov   es:[si],al
         jmp   @end
 @doxor: xor   es:[si],al
 @end:
end;}

procedure putpixel(x,y : integer;color : word);assembler;
asm
         mov   bx,x
         add   bx,actviewport.x1
         cmp   bx,fillviewport.x1
         jl    @end
         cmp   bx,fillviewport.x2
         jg    @end
         mov   cx,bytesperscanline
         cmp   bx,cx
         jnb   @end
         mov   ax,y
         add   ax,actviewport.y1
         cmp   ax,fillviewport.y1
         jl    @end
         cmp   ax,fillviewport.y2
         jg    @end
         add   ax,pageadd
         mul   cx
         add   ax,bx
         adc   dx,0
         mov   si,ax
         cmp   dx,lastbank
         je    @next
         push  dx
         call  setbank2
 @next:  mov   es,[writeptr]
         mov   al,byte ptr color
         cmp   writemode,0
         jne   @doxor
         mov   es:[si],al
         jmp   @end
 @doxor: xor   es:[si],al
 @end:
end;


(*function getpixel(x,y : integer) : word;assembler;
asm
  db    66h;xor cx,cx
  mov   bx,x
  mov   cx,bytesperscanline
 { cmp  bx,cx
  jnb  @end}
  mov   ax,y
  add   ax,pageadd
  db    66h;mul cx
  mov   cx,bx
  db    66h;add ax,cx
  mov   si,ax
  db    66h;shr ax,16
  cmp   ax,lastbank
  je    @next
  push  ax
  call  setbank2
  @next:

  mov   es,[readptr]
  mov   al,es:[si]
  xor   ah,ah
  @end:
end;*)

function getpixel(x,y : integer) : word;assembler;
asm
         mov   bx,x
         add   bx,actviewport.x1
         cmp   bx,fillviewport.x1
         jl    @end
         cmp   bx,fillviewport.x2
         jg    @end
         mov   cx,bytesperscanline
         cmp   bx,cx
         jnb   @end
         mov   ax,y
         add   ax,actviewport.y1
         cmp   ax,fillviewport.y1
         jl    @end
         cmp   ax,fillviewport.y2
         jg    @end
         add   ax,pageadd
         mul   cx
         add   ax,bx
         adc   dx,0
         mov   si,ax
         cmp   dx,lastbank
         je    @next
         push  dx
         call  setbank2
  @next: mov   es,[readptr]
         mov   al,es:[si]
         xor   ah,ah
         @end:
end;


procedure waitretrace;assembler;
{waits until kathod-beam runs to the top of the screen - avoids flickering}
asm
  mov   dx,03DAh
  @lp1:
    in    al,dx
    test  al,8
  jz   @lp1
  @lp2:
    in    al,dx
    test  al,8
  jnz   @lp2
end;


procedure hretrace;assembler;
{waits until kathod-beam is in next scanline}
asm
  mov   dx,3DAh
  @lp1:
    in    al,dx
    test  al,1D
  jnz   @lp1
  @lp2:
    in    al,dx
    test  al,1D
  jz   @lp2
end;

procedure getimagesize(p : pointer;var x,y : word);assembler;
{gets the size of an image in memory}
asm
  mov   dx,ds
  les   di,p
  mov   ax,es:[di]
  mov   bx,es:[di+2]
  lds   si,x
  mov   ds:[si],ax
  lds   si,y
  mov   ds:[si],bx
  mov   ds,dx
end;

procedure setimagesize(p : pointer;x,y : word);assembler;
{sets the size of an image in memory}
asm
  les   di,p
  mov   ax,x
  mov   es:[di],ax
  mov   ax,y
  mov   es:[di+2],ax
end;

function imagesize(x1,y1,x2,y2 : integer) : word;
var
  l : longint;
begin
  l := succ(longint(abs(x2-x1)))*succ(abs(y2-y1))*bytesperpixel+imagedatasize;
  if l > 65528 then begin
    l       := 0;
    gresult := -11;
  end;
  imagesize := l;
end;

procedure setrgbpalette(colornum,redvalue,greenvalue,bluevalue : integer);assembler;
{sets color i to rgb value}
asm
  mov   al,byte ptr colornum
  mov   dx,03C8h
  out   dx,al
  inc   dx
  mov   al,byte ptr redvalue
  out   dx,al
  mov   al,byte ptr greenvalue
  out   dx,al
  mov   al,byte ptr bluevalue
  out   dx,al
end;

procedure setbkcolor(colornum : word);assembler;
asm
  mov   al,byte ptr colornum
  mov   bkcolor,al
end;

procedure setpal;assembler;
{sets whole palette.. faaast}
asm
  xor   bx,bx
  les   di,pal
  mov   al,0
  mov   dx,03C8h
  out   dx,al
  inc   dx

  @lp:
  db 66h;mov   ax,es:[di]
         out   dx,al
  db 66h;shr   ax,8
         out   dx,al
  db 66h;shr   ax,8
         out   dx,al
         add   di,3
         inc   bx
  cmp   bx,255
  jna   @lp
end;


procedure shiftpal;
var
  i : integer;
begin
  for i := 0 to 255 do begin
    pal^[i].r := pal^[i].r shr 2;
    pal^[i].g := pal^[i].g shr 2;
    pal^[i].b := pal^[i].b shr 2;
  end;
end;


procedure setuserpal(var pal);assembler;
{sets the user-palette from pointer pal}
asm
  xor   bx,bx
  les   di,pal

  mov   al,0
  mov   dx,03C8h
  out   dx,al
  inc   dx
  @lp:
  db 66h;mov   ax,es:[di]
         out   dx,al
  db 66h;shr   ax,8
         out   dx,al
  db 66h;shr   ax,8
         out   dx,al
         add   di,3
         inc   bx
  cmp   bx,255
  jna   @lp
end;

procedure getrgbpalette(col : byte;var r,g,b : byte);assembler;
asm
  mov   al,col
  mov   dx,03C7h
  add   dx,2
  in    al,dx
  les   di,r
  mov   es:[di],al
  in    al,dx
  les   di,g
  mov   es:[di],al
  in    al,dx
  les   di,b
  mov   es:[di],al
end;

procedure getpal;
begin
  for i := 0 to 255 do begin
    Port[$3C7] := i;
    Pal^[i].r  := Port[$3C9];
    Pal^[i].g  := Port[$3C9];
    Pal^[i].b  := Port[$3C9];
  end;
end;

procedure getuserpal(var pal);
{gets the actual palette to pointer pal}
begin
  for i := 0 to 255 do begin
    Port[$3C7] := i;
    mem[seg(pal):ofs(pal)+i*3]  := Port[$3C9];
    mem[seg(pal):ofs(pal)+i*3+1]:= Port[$3C9];
    mem[seg(pal):ofs(pal)+i*3+2]:= Port[$3C9];
  end;
end;

procedure setrgbpal(i,r,g,b : byte);
{sets color i in virtual palette}
begin
  pal^[i].r := r;
  pal^[i].g := g;
  pal^[i].b := b;
end;

procedure getrgbpal(i : byte;var r,g,b : byte);
{sets color i in virtual palette}
begin
  r := pal^[i].r;
  g := pal^[i].g;
  b := pal^[i].b;
end;


function loadjascpal(path : string) : boolean;
{loads JASC-Palettes made with Paint Shop Pro
 into virtual palette.. you have to call thereafter
 setpal if you want to set the palette}
var
  i2,setted  : byte   ;
  maxcol     : word   ;
  f          : text   ;
  s,s2       : string ;
  code,r,g,b : integer;
begin
  loadjascpal := false;
  i := ioresult;
  assign(f,path);
  filemode := 64;
  reset(f);
  if ioresult <> 0 then begin
    gresult := grIOerror;
    exit;
  end;
  readln(f,s);
  if s <> 'JASC-PAL' then exit;
  if eof(f) then begin
    close(f);
    exit;
  end;
  readln(f);
  if eof(f) then begin
    close(f);
    exit;
  end;
  readln(f,maxcol);
  dec(maxcol);
  if eof(f) then begin
    close(f);
    exit;
  end;
  s2 := '';
  for i := 0 to maxcol do begin
    readln(f,s);
    setted := 0;
    for i2 := 1 to length(s) do begin
      if s[i2] <> ' ' then s2 := s2+s[i2];
      if (s[i2] = ' ')or(i2 = length(s)) then begin
        case setted of
          0 : val(s2,r,code);
          1 : val(s2,g,code);
          2 : val(s2,b,code);
        end;
        if code <> 0 then exit;
        inc(setted);
        s2 := '';
      end;
    end;
    pal^[i].r := r shr 2;
    pal^[i].g := g shr 2;
    pal^[i].b := b shr 2;
    if eof(f) then begin
      close(f);
      exit;
    end;
  end;
  close(f);
  loadjascpal := true;
end;

function loadpal(name : string;pal : pointer) : boolean;
var
  f : file;
begin
  loadpal := false;
  assign(f,name);
  filemode := 64;
  reset(f,1);
  if filesize(f) <> 768 then begin
    close(f);
    exit;
  end;
  blockread(f,pal^,768);
  close(f);
  loadpal := true;
end;

procedure setcolor(col : word);assembler;
{sets current color for script and lines}
asm
  mov   al,byte ptr col
  mov   byte ptr currentcolor,al
end;

function getcolor : word;assembler;
{gets current color}
asm
  mov   al,byte ptr currentcolor
  xor   ah,ah
end;

var
  line_uncl : procedure(x1,y1,x2,y2 : integer);

procedure line_norm(x1,y1,x2,y2 : integer);far;forward;
procedure line_styl(x1,y1,x2,y2 : integer);far;forward;

procedure setlinestyle(style : word;pattern: word;thickness : word);
begin
  if style < 4 then linestyle := linepattern[style] else
  linestyle := pattern;
  linestylenum := style;
  if linestyle = $FFFF then line_uncl := line_norm else
                            line_uncl := line_styl;
end;

procedure getlinesettings(var lineinfo: linesettingstype);
begin
  lineinfo.linestyle := linestylenum;
  lineinfo.pattern   := linestyle;
  lineinfo.thickness := 1;
end;

procedure setfillstyle_vesa(pattern : word;color : word);far;
{sets current fillstyle}
{asm
  mov  al,col
  mov  fillcolor,al

  mov  ax,pattern
  cmp  ax,12
  jna  @na12
    mov  ax,12
  @na12:
  mov  fillstylenum,ax
  shl  ax,4
  mov  di,seg fillstyle
  mov  es,di
  mov  di,offset fillstyle
  mov  si,seg gr_vars.fillpattern

  mov  dx,ds
  mov  ds,si
  mov  si,offset gr_vars.fillpattern
  add  si,ax
  mov  cx,2
  db   0F3h,66h,0A5h
  mov  ds,dx}
begin
  fillcolor := color;
  fillstyle := gr_vars.filloutpattern[pattern];
  fillstylenum := pattern;
end;

procedure setfillpattern(pattern : fillpatterntype;color : word);
begin
  gr_vars.filloutpattern[12] := pattern;
  fillstyle               := pattern;
  fillstylenum            := 12;
  fillcolor               := color;
end;

procedure getfillsettings(var FillInfo: FillSettingsType);
begin
  fillinfo.pattern := fillstylenum;
  fillinfo.color   := fillcolor;
end;

procedure setfillcolor(col: byte);assembler;
{sets current fillstyle}
asm
  mov   al,col
  mov   byte ptr fillcolor,al
end;

procedure setwritemode_vesa(mode : byte);far;assembler;
asm
  mov   al,mode
  mov   writemode,al
end;

procedure line_norm(x1,y1,x2,y2 : integer);assembler;
var
  w : word;
asm
{Complete description in C'T 2/97
 Listing in VESA8.ASM with full comments and little bit
 other form... I had to adjust something for my own unit..
 it's a little bit faster than it's original (Pentii-optimized) :>}
  mov   ax,pageadd
  add   y1,ax
  add   y2,ax
  mov   ax,fillviewport.x1
  add   x1,ax
  add   x2,ax
  mov   ax,fillviewport.y1
  add   y1,ax
  add   y2,ax

  push  BP
  mov   SI,X2         { XE }
  sub   SI,X1         { XE - X }
  JNS   @PutLine_2
  mov   AX,X2
{  XCHG   AX,X1}{_very_ slow on a Pentii}
  mov   BX,AX
  mov   AX,X1
  mov   X1,BX
  mov   X2,AX
  mov   AX,Y2
{  XCHG   AX,Y1}
  mov   BX,AX
  mov   AX,Y1
  mov   Y1,BX
  mov   Y2,AX
  NEG   SI		{ DLTX:= -DLTX }
@PutLine_2:
           pushA
    db 66h;xor   AX,AX
    db 66h;xor   DX,DX
           mov   AX,bytesperscanline
           mov   DX,Y1
    db 66h;MUL   DX
           mov   DX,X1
    db 66h;add   AX,DX
           mov   W,AX
    db 66h;shr   AX,16
           cmp   ax,lastbank
           je    @next
           push  AX
           CALL  setbank2
           @next:
           POPA
           mov   DI,W
           mov   ES,writeptr

		CMP   writemode,0
		JNE   @PutLine_X

		mov   AL,byte ptr currentcolor	{ AL := Farbe }

		mov   ES:[DI],AL
		mov   BX,Y2
		sub   BX,Y1
		JNS   @PutLine_8
		NEG   BX		{ DLTY := -DLTY }
                CMP   SI,BX
		JG    @PutLine_20
		mov   CX,BX		{ Loopcount = DLTY }
                OR    CX,CX
		JZ    @PutLine_0	{ Loopcount = 0 ? }
                mov   BP,BX
		NEG   BP		{ SUM = - DLTY }
		add   SI,SI		{ 2 * DLTX }
		add   BX,BX		{ 2 * DLTY }
@PutLine_12:    sub   DI,bytesperscanline         { Y := Y - 1 }
		JC    @PutLine_13	{ Achte auf Bankswitch }
@PutLine_14:    add   BP,SI		{ SUM := SUM + 2 DLTX }
		JS    @PutLine_16	{ Skip, wenn SUM < 0 }
		sub   BP,BX		{ SUM = SUM - 2 DLTY }
		INC   DI		{ X := X + 1 }
		JZ    @PutLine_15	{ Achte auf Bankswitch }
@PutLine_16:    mov   ES:[DI],AL	{ Setze Pixel }
		DEC   CX
		jnz   @PutLine_12	{ Loop mit DLTY }
		JMP   @PutLine_0
@PutLine_13:	CALL  DecBank
		JMP   @PutLine_14
@PutLine_15:	CALL  IncBank
		JMP   @PutLine_16
@PutLine_20:	mov   CX,SI		{ Loopcount = DLTX }
		JCXZ  @PutLine_0	{ Loopcount = 0 ? }
		mov   BP,SI
		NEG   BP		{ SUM = - DLTX }
		add   SI,SI		{ 2 * DLTX }
		add   BX,BX		{ 2 * DLTY }
@PutLine_22:    INC   DI			{ X := X + 1 }
		JZ    @PutLine_23	        { Achte auf Bankswitch }
@PutLine_24:    add   BP,BX			{ SUM := SUM + 2 DLTY }
		JS    @PutLine_26	        { Skip, wenn SUM < 0 }
		sub   BP,SI			{ SUM := SUM - 2DLTX }
		sub   DI,bytesperscanline         	{ Y := Y - 1 }
		JC    @PutLine_25	        { Achte auf Bankswitch }
@PutLine_26:    mov   ES:[DI],AL		{ Setze Pixel }
		DEC   CX
		jnz   @PutLine_22	        { Loop mit DLTX }
@PutLine_0:     POP   BP
                JMP   @END
@PutLine_23:	CALL  IncBank
		JMP   @PutLine_24
@PutLine_25:	CALL  DecBank
		JMP   @PutLine_26
@PutLine_8:	CMP   SI,BX
		JG    @PutLine_40
		mov   CX,BX		{ Loopcount = DLTY }
		JCXZ  @PutLine_0	{ Loopcount = 0 ? }
		mov   BP,BX
		NEG   BP		{ SUM = - DLTY }
		add   SI,SI		{ 2 * DLTX }
		add   BX,BX		{ 2 * DLTY }
@PutLine_32:    add   DI,bytesperscanline         { Y := Y + 1 }
		JC    @PutLine_33	        { Achte auf Bankswitch }
@PutLine_34:    add   BP,SI			{ SUM := SUM + 2 DLTX }
		JS    @PutLine_36	        { Skip, wenn SUM < 0 }
		sub   BP,BX			{ SUM := SUM - 2 DLTY }
		INC   DI			{ X := X + 1 }
		JZ    @PutLine_35	        { Achte auf Bankswitch }
@PutLine_36:    mov   ES:[DI],AL		{ Setze Pixel }
		DEC   CX
		jnz   @PutLine_32	        { Loop mit DLTY }
		JMP   @PutLine_0
@PutLine_33:	CALL  IncBank
		JMP   @PutLine_34
@PutLine_35:	CALL  IncBank
		JMP   @PutLine_36
@PutLine_40:	mov   CX,SI		{ Loopcount = DLTX }
		JCXZ  @PutLine_0	{ Loopcount = 0 ? }
		mov   BP,SI
		NEG   BP		{ SUM = - DLTX }
		add   SI,SI		{ 2 * DLTX }
		add   BX,BX		{ 2 * DLTY }
@PutLine_42:    INC   DI			{ X := X + 1 }
		JZ    @PutLine_43	        { Achte auf Bankswitch }
@PutLine_44:    add   BP,BX			{ SUM := SUM + 2 DLTY }
		JS    @PutLine_46	        { Skip, wenn SUM < 0 }
		sub   BP,SI			{ SUM := SUM - 2 DLTX }
		add   DI,bytesperscanline                 { Y := Y + 1 }
		JC    @PutLine_45	        { Achte auf Bankswitch }
@PutLine_46:    mov   ES:[DI],AL		{ Setze Pixel }
		DEC   CX
		jnz   @PutLine_42	        { Loop mit DLTX }
		JMP   @PutLine_0
@PutLine_43:	CALL  IncBank
		JMP   @PutLine_44
@PutLine_45:	CALL  IncBank
		JMP   @PutLine_46
@PutLine_X:     mov   AL,byte ptr currentcolor	{ AL := Farbe }
                xor   ES:[DI],AL
                mov   BX,Y2
		sub   BX,Y1
		JNS   @PutLinX_8
		NEG   BX		{ DLTY := -DLTY }
                CMP   SI,BX
		JG    @PutLinX_20
		mov   CX,BX		{ Loopcount = DLTY }
		JCXZ  @PutLinX_0	{ Loopcount = 0 ? }
                mov   BP,BX
		NEG   BP		{ SUM = - DLTY }
		add   SI,SI		{ 2 * DLTX }
		add   BX,BX		{ 2 * DLTY }
@PutLinX_12:    sub   DI,bytesperscanline         { Y := Y - 1 }
		JC    @PutLinX_13	        { Achte auf Bankswitch }
@PutLinX_14:    add   BP,SI			{ SUM := SUM + 2 DLTX }
		JS    @PutLinX_16	        { Skip, wenn SUM < 0 }
		sub   BP,BX			{ SUM = SUM - 2 DLTY }
		INC   DI			{ X := X + 1 }
		JZ    @PutLinX_15	        { Achte auf Bankswitch }
@PutLinX_16:    xor   ES:[DI],AL		{ Setze Pixel }
		DEC   CX
		jnz   @PutLinX_12	        { Loop mit DLTY }
		JMP   @PutLinX_0
@PutLinX_13:	CALL  DecBank
		JMP   @PutLinX_14
@PutLinX_15:	CALL  IncBank
		JMP   @PutLinX_16
@PutLinX_20:	mov   CX,SI		{ Loopcount = DLTX }
		JCXZ  @PutLinX_0	{ Loopcount = 0 ? }
                mov   BP,SI
		NEG   BP		{ SUM = - DLTX }
		add   SI,SI		{ 2 * DLTX }
		add   BX,BX		{ 2 * DLTY }
@PutLinX_22:    INC   DI			{ X := X + 1 }
		JZ    @PutLinX_23	        { Achte auf Bankswitch }
@PutLinX_24:    add   BP,BX			{ SUM := SUM + 2 DLTY }
		JS    @PutLinX_26	        { Skip, wenn SUM < 0 }
		sub   BP,SI			{ SUM := SUM - 2DLTX }
		sub   DI,bytesperscanline                 { Y := Y - 1 }
		JC    @PutLinX_25	        { Achte auf Bankswitch }
@PutLinX_26:    xor   ES:[DI],AL		{ Setze Pixel }
		DEC   CX
		jnz   @PutLinX_22	        { Loop mit DLTX }
@PutLinX_0:     JMP   @PutLine_0
@PutLinX_23:	CALL  IncBank
		JMP   @PutLinX_24
@PutLinX_25:	CALL  DecBank
		JMP   @PutLinX_26
@PutLinX_8:	CMP   SI,BX
		JG    @PutLinX_40
		mov   CX,BX		{ Loopcount = DLTY }
		JCXZ  @PutLinX_0	{ Loopcount = 0 ? }
                mov   BP,BX
		NEG   BP		{ SUM = - DLTY }
		add   SI,SI		{ 2 * DLTX }
		add   BX,BX		{ 2 * DLTY }
@PutLinX_32:    add   DI,bytesperscanline         { Y := Y + 1 }
		JC    @PutLinX_33	{ Achte auf Bankswitch }
@PutLinX_34:    add   BP,SI			{ SUM := SUM + 2 DLTX }
		JS    @PutLinX_36	        { Skip, wenn SUM < 0 }
		sub   BP,BX			{ SUM := SUM - 2 DLTY }
		INC   DI			{ X := X + 1 }
		JZ    @PutLinX_35	        { Achte auf Bankswitch }
@PutLinX_36:    xor   ES:[DI],AL		{ Setze Pixel}
		DEC   CX
		jnz   @PutLinX_32	        { Loop mit DLTY}
		JMP   @PutLinX_0
@PutLinX_33:	CALL  IncBank
		JMP   @PutLinX_34
@PutLinX_35:	CALL  IncBank
		JMP   @PutLinX_36
@PutLinX_40:	mov   CX,SI		{ Loopcount = DLTX}
		JCXZ  @PutLinX_0	{ Loopcount = 0 ?}
                mov   BP,SI
		NEG   BP		{ SUM = - DLTX}
		add   SI,SI		{ 2 * DLTX }
		add   BX,BX		{ 2 * DLTY }
@PutLinX_42:    INC   DI			{ X := X + 1}
		JZ    @PutLinX_43	        { Achte auf Bankswitch}
@PutLinX_44:    add   BP,BX			{ SUM := SUM + 2 DLTY}
		JS    @PutLinX_46	        { Skip, wenn SUM < 0}
		sub   BP,SI			{ SUM := SUM - 2 DLTX}
		add   DI,bytesperscanline                 { Y := Y + 1}
		JC    @PutLinX_45	        { Achte auf Bankswitch}
@PutLinX_46:    xor   ES:[DI],AL		{ Setze Pixel}
		DEC   CX
		jnz   @PutLinX_42	        { Loop mit DLTX}
		JMP   @PutLinX_0
@PutLinX_43:	CALL  IncBank
		JMP   @PutLinX_44
@PutLinX_45:	CALL  IncBank
		JMP   @PutLinX_46
@end:
end;


(*procedure line_styl(x1,y1,x2,y2 : integer);
var
  d,dx,dy,aincr,bincr,xincr,yincr,x,y : integer;
begin
  stylecounter := 0;
  if (abs(x2-x1) < abs(y2-y1)) then
  begin
    if (y1 > y2) then
    begin
      swap(x1,x2);
      swap(y1,y2);
    end;


    if (x2 > x1) then xincr := 1 else
                      xincr := -1;

    dy := y2 - y1;
    dx := abs(x2-x1);
    d  := dx shl 1 - dy;
    aincr := (dx - dy) shl 1;
    bincr := dx shl 1;
    x := x1;
    y := y1;
{      inc(stylecounter,stylecounter);
      if stylecounter = 0 then stylecounter := 1;
      if stylecounter and linestyle <> 0 then
      putpixel(x,y,currentcolor);}
    asm
      mov  ax,stylecounter
      add  ax,ax
      jnz  @nooverflow
        mov  ax,1
      @nooverflow:
      mov  stylecounter,ax
      test linestyle,ax
      jz   @nopixel
        push x
        push y
        push word ptr currentcolor
        call putpixel
      @nopixel:
    end;
    for y := y1+1 to y2 do
    begin
      if (d >= 0) then
      begin
        inc(x,xincr);
        inc(d,aincr);
      end else
      inc(d,bincr);
    asm
      mov  ax,stylecounter
      add  ax,ax
      jnz  @nooverflow
        mov  ax,1
      @nooverflow:
      mov  stylecounter,ax
      test linestyle,ax
      jz   @nopixel
        push x
        push y
        push word ptr currentcolor
        call putpixel
      @nopixel:
    end;
    end;
  end
  else
  begin
    if (x1 > x2) then
    begin
      swap(x1,x2);
      swap(y1,y2);
    end;

    if (y2 > y1) then yincr := 1
                 else yincr := -1;

    dx := x2 - x1;
    dy := abs(y2-y1);
    d  := dy shl 1 - dx;
    aincr := (dy - dx) shl 1;
    bincr := dy shl 1;
    x := x1;
    y := y1;
    asm
      mov  ax,stylecounter
      add  ax,ax
      jnz  @nooverflow
        mov  ax,1
      @nooverflow:
      mov  stylecounter,ax
      test linestyle,ax
      jz   @nopixel
        push x
        push y
        push word ptr currentcolor
        call putpixel
      @nopixel:
    end;
    for x := x1+1 to x2 do              { Line auf X-Achse durchlaufen }
    begin
      if (d >= 0) then
      begin
        inc(y,yincr);
        inc(d,aincr);
      end
      else
      inc(d,bincr);
    asm
      mov  ax,stylecounter
      add  ax,ax
      jnz  @nooverflow
        mov  ax,1
      @nooverflow:
      mov  stylecounter,ax
      test linestyle,ax
      jz   @nopixel
        push x
        push y
        push word ptr currentcolor
        call putpixel
      @nopixel:
    end;
    end;
  end;
end;*)
var
  mempos : longint;

procedure pixel;assembler;
asm
  db 66h;mov   ax,word ptr mempos
         mov   si,ax
  db 66h;shr   ax,16
         cmp   ax,lastbank
         je    @next
         push  ax
         call  setbank2

  @next: mov   es,[writeptr]
         mov   al,byte ptr currentcolor
         cmp   writemode,0
         jne   @doxor
         mov   es:[si],al
         jmp   @end
  @doxor:xor   es:[si],al
  @end:
end;

procedure line_styl(x1,y1,x2,y2 : integer);
{Since I was too lazy, this proc is fairly optimized yet...
 only partially converted to asm (and not very well ;)       }
var
  d,dx,dy,aincr,bincr,xincr,x,y,yincr : integer;
begin
  stylecounter := 0;
  asm
    mov   ax,fillviewport.x1
    add   x1,ax
    add   x2,ax
    mov   ax,fillviewport.y1
    add   y1,ax
    add   y2,ax
  end;
  if (abs(x2-x1) < abs(y2-y1)) then
  begin
    if (y1 > y2) then
    begin
      swap(x1,x2);
      swap(y1,y2);
    end;
    if (x2 > x1) then xincr := 1 else
                      xincr := -1;
    dy := y2 - y1;
    dx := abs(x2-x1);
    d  := dx shl 1 - dy;
    aincr := (dx - dy) shl 1;
    bincr := dx shl 1;
    x := x1;
    y := y1;
    calcbank(x,y);
    mempos := longint(y+pageadd)*bytesperscanline+x;
    asm
      mov  ax,stylecounter
      add  ax,ax
      jnz  @nooverflow
        mov  ax,1
      @nooverflow:
      mov  stylecounter,ax
      test linestyle,ax
      jz   @nopixel
        call pixel
      @nopixel:
    end;
    for y := y1+1 to y2 do
    begin
      if (d >= 0) then
      begin
        inc(mempos,xincr);
        inc(d,aincr);
      end else
      inc(d,bincr);
    asm
      mov  ax,stylecounter
      add  ax,ax
      jnz  @nooverflow
        mov  ax,1
      @nooverflow:
      mov  stylecounter,ax
      test linestyle,ax
      jz   @nopixel
        call pixel
      @nopixel:
db 66h;xor  ax,ax
       mov  ax,bytesperscanline
db 66h;add  word ptr mempos,ax
    end;
    end;
  end
  else
  begin
    if (x1 > x2) then
    begin
      swap(x1,x2);
      swap(y1,y2);
    end;
    if (y2 > y1) then yincr := bytesperscanline
                 else yincr := -bytesperscanline;

    dx := x2 - x1;
    dy := abs(y2-y1);
    d  := dy shl 1 - dx;
    aincr := (dy - dx) shl 1;
    bincr := dy shl 1;
    x := x1;
    y := y1;
    calcbank(x,y);
    mempos := longint(y+pageadd)*bytesperscanline+x;
    asm
      mov  ax,stylecounter
      add  ax,ax
      jnz  @nooverflow
        mov  ax,1
      @nooverflow:
      mov  stylecounter,ax
      test linestyle,ax
      jz   @nopixel
        call pixel
      @nopixel:
    end;
      asm
               mov  cx,x2
               sub  cx,x1

       @xlp:   cmp  d,0
               jae @noyinc
        db 66h;xor  ax,ax
               mov  ax,yincr
        db 66h;add  word ptr mempos,ax
               mov  ax,aincr
               add  d,ax
               jmp  @yinced
      @noyinc: mov  ax,bincr
               add  d,ax
      @yinced:

        mov  ax,stylecounter
        add  ax,ax
        jnz  @nooverflow
          mov  ax,1
        @nooverflow:
        mov  stylecounter,ax
        test linestyle,ax
        jz   @nopixel
          call pixel
        @nopixel:
        db 66h;inc word ptr mempos
        loop @xlp
    end;
  end;
end;


(*procedure line_vesa(x1,y1,x2,y2 : integer);far;
var
  p1,p2 : record
    l,r,o,u : boolean; {links, rechts, oben, unten}
  end;
  e,a,b   : fpu; {Hilfsvariablen}
  dontcheck : boolean;
begin
  dontcheck := ((y2 <= actviewport.mxy)and(y1 <= actviewport.mxy) or
               (not actviewport.clip))and(y1 >= 0)and(y2 >= 0)and
               (x1 >= 0)and(x1 <= actviewport.mxx)and
               (x2 >= 0)and(x2 <= actviewport.mxx);
  if dontcheck then begin
    line_uncl(x1+actviewport.x1,y1+actviewport.y1,
              x2+actviewport.x1,y2+actviewport.y1);
    exit;
  end;

  if (x1 > x2)or(y2 < y1) then begin
    swap(x1,x2);
    swap(y1,y2);
  end;
  if gr_vars.actviewport.clip then
  begin {Clipping nach Cohen und Sutherland,
         beschrieben in "Computergrafik, Algorithmen und Implementierung",
         Springer Verlag; Seite 23}
    p1.l := x1 < gr_vars.actviewport.x1; p1.r := x1 > gr_vars.actviewport.x2;
    p1.o := y1 < gr_vars.actviewport.y1; p1.u := y1 > gr_vars.actviewport.y2;

    p2.l := x2 < gr_vars.actviewport.x1; p2.r := x2 > gr_vars.actviewport.x2;
    p2.o := y2 < gr_vars.actviewport.y1; p2.u := y2 > gr_vars.actviewport.y2;

    if not (p1.l or p1.r or p1.o or p1.u or
            p2.l or p2.r or p2.o or p2.u) {vollstndig sichtbar}
    then     line_uncl(x1,y1,x2,y2)
 else
    if (p1.l and p2.l) or (p1.r and p2.r) or
       (p1.o and p2.o) or (p1.u and p2.u) {nicht sichtbar}
    then exit else
    begin
      if p1.l or p1.r or p1.o or p1.u {p1 auerhalb?}
      then begin
        if p1.l then begin
          e := y2-y1;
          a := actviewport.x1-x1;
          b := x2-actviewport.x1;
          x1:= actviewport.x1;
          y1:= round(e*a/(b+a)+y1);
        end else
        if p1.r then begin
          e := y2-y1;
          a := actviewport.x2-x1;
          b := x2-actviewport.x2;
          x1:= actviewport.x2;
          y1:= round(e*a/(b+a)+y1);
        end else
        if p1.o then begin
          e := x2-x1;
          a := actviewport.y1-y1;
          b := y2-actviewport.y1;
          x1:= round(e*a/(b+a)+x1);
          y1:= actviewport.y1;
        end else
        if p1.u then begin
          e := x2-x1;
          a := actviewport.y2-y1;
          b := y2-actviewport.y2;
          x1:= round(e*a/(b+a)+x1);
          y1:= actviewport.y2;
        end;
      end else
      if p2.l or p2.r or p2.o or p2.u {p2 auerhalb?}
      then begin
        if p2.l then begin
          e := y1-y2;
          a := actviewport.x1-x2;
          b := x1-actviewport.x1;
          x2:= actviewport.x1;
          y2:= round(e*a/(b+a)+y2);
        end else
        if p2.r then begin
          e := y1-y2;
          a := actviewport.x2-x2;
          b := x1-actviewport.x2;
          x2:= actviewport.x2;
          y2:= round(e*a/(b+a)+y2);
        end else if p2.o then begin
          e := x1-x2;
          a := actviewport.y1-y2;
          b := y1-actviewport.y1;
          x2:= round(e*a/(b+a)+x2);
          y2:= actviewport.y1;
        end else if p2.u then begin
          e := x1-x2;
          a := actviewport.y2-y2;
          b := y1-actviewport.y2;
          x2:= round(e*a/(b+a)+x2);
          y2:= actviewport.y2;
        end;
      end else     line_uncl(x1,y1,x2,y2);

      line_vesa(x1,y1,x2,y2);
    end;
  end else     line_uncl(x1,y1,
              x2,y2);

end;*)

procedure line_vesa(x1,y1,x2,y2 : integer);far;
type
  edge = (left,right,bottom,top);
  outcode = set of edge;
var
  accept,done                  : boolean;
  outcode0,outcode1,outcodeout : outcode;
  x,y                          : integer;
{  viewport                     : viewporttype;}

  procedure compoutcode(x,y : fpu;var code : outcode);
  begin
    code := [];
    if y > fillviewport.mxy then code := [top]
    else if y < 0 then code := [bottom];
    if x > fillviewport.mxx then code := code+[right]
    else if x < 0 then code := code+[left];
  end;
begin
{    viewport := fillviewport;}
  if not actviewport.clip then begin
    inc(x1,actviewport.x1);
    inc(x2,actviewport.x1);
    inc(y1,actviewport.y1);
    inc(y2,actviewport.y1);
  end;
  accept := false;
  done   := false;
  compoutcode(x1,y1,outcode0);
  compoutcode(x2,y2,outcode1);
  repeat
    if (outcode0 = [])and(outcode1 = []) then begin
      accept := true;
      done   := true;
    end else if outcode0*outcode1 <> [] then
    done := true else
    begin
      if outcode0 <> [] then
      outcodeout := outcode0 else outcodeout := outcode1;

      if top in outcodeout then begin
        x := x1+(x2-x1)*(fillviewport.mxy-y1) div (y2-y1);
        y := fillviewport.mxy;
      end else if bottom in outcodeout then begin
        x := x1+(x2-x1)*(-y1) div (y2-y1);
        y := 0;
      end else if right in outcodeout then begin
        x := fillviewport.mxx;
        y := y1+(y2-y1)*(fillviewport.mxx-x1) div (x2-x1);
      end else if left in outcodeout then begin
        x := 0;
        y := y1+(y2-y1)*(-x1) div (x2-x1);
      end;
      if (outcodeout = outcode0) then begin
        x1 := x;
        y1 := y;
        compoutcode(x1,y1,outcode0);
      end else begin
        x2 := x;
        y2 := y;
        compoutcode(x2,y2,outcode1);
      end;
    end;
  until done;
  if accept then line_uncl(x1,y1,x2,y2);
end;

procedure rectangle(x1,y1,x2,y2: integer);
begin
  if (linestyle = $FFFF)and(writemode = normalput) then begin
    hline(x1,y1,x2-x1+1,currentcolor);
    vline(x1,y1,y2-y1,currentcolor);
    vline(x2,y1,y2-y1,currentcolor);
    hline(x1,y2,x2-x1+1,currentcolor);
  end else begin
    line(x1,y1,x2,y1);
    line(x1,y1,x1,y2);
    line(x2,y1,x2,y2);
    line(x1,y2,x2,y2);
  end;
end;

function getclock: longint;assembler; {Taken from the FLILIB source}
asm
  xor   ah,ah           { get tick count from Dos and use For hi 3 Bytes }
  int   01Ah            { lo order count in DX, hi order in CX }
  mov   ah,dl
  mov   dl,dh
  mov   dh,cl
  xor   al,al           { read lo Byte straight from timer chip }
  out   43h,al          { latch count }

  mov   al,1
  out   43h,al          { set up to read count }
  in    al,40h          { read in lo Byte (and discard) }
  in    al,40h          { hi Byte into al }
  neg   al              { make it so counting up instead of down }
end;


procedure readgraphline(x1,y1,col,maxchars,posx : word;var s2 : string);
{ read a line (like readln) from graphical screen
  x1,y1    : position on screen
  col      : color of the text
  maxchars : maximum amount of chars to read
  posx     : position (cursor) in the text, should be >= 1
  s2       : string where to read in (can be prefilled)  }
var
  waittime           : longint;
  chars,i,y,width    : integer;
  ch,lch             : char;
  s                  : string;
  p                  : pointer;
  con                : boolean;

{procedure delete2(var s : string;chpos,num : byte);
begin
  system.delete(s,chpos,num);
  insert(' ',s,80);
end;}

function txtpos : word;
var
  s2 : string ;
  i  : integer;
begin
  s2 := '';
  for i := 1 to posx-1 do s2 := s2 + s[i];
  txtpos := textwidth(s2);
end;

procedure showtxt;
begin
  putimage(x1,y1,p);
  writexy(x1+1,y1,s);
  line(txtpos+x1,y1,txtpos+x1,textheight+y1);
  con := true;
end;


begin
  setcolor(col);
  chars := length(s2);
  s := s2;
  for i := 0 to maxchars-length(s2) do s := s + ' ';
  filldword(s2[1],maxchars,ord('T'));
  s2[0] := chr(maxchars);
  width := textwidth(s2);
  openimage(p,width+1,textheight);
  getimage(x1,y1,width+x1+1,textheight+y1,p);
  filldword(s2[0],80,0);
  lch := #1;
  showtxt;
  waittime := getclock+1250;
  repeat
    if waittime <= getclock then begin
      if con then begin
        for y := 0 to textheight do
        putpixel(x1+txtpos,y1+y,mem[seg(p^):ofs(p^)+imagedatasize+(width+2)*y+txtpos]);
      end else
      line(x1+txtpos,y1,x1+txtpos,y1+textheight);
      con := not con;
      waittime := getclock+1250;
    end;
    if keypressed then begin
      lch := ch;
      ch := readkey
    end else ch := #1;

    if (ord(ch)> 1)and(lch <> #0) then
    case ch of
      #8  : if posx > 1 then begin dec(chars);dec(posx);delete{2}(s,posx,1);showtxt;end;
  #13,#27 : begin;for i := 1 to chars do s2 := s2 + s[i];end;
       else if chars < maxchars then begin
         inc(chars);inc(posx); insert(ch,s,posx-1);
         showtxt;
       end;
     end;
     if (ch <> #1)and(lch = #0) then begin
      case ch of
        #71 : begin posx := 1;showtxt;end;
        #79 : begin posx := chars+1;showtxt;end;
        #75 : if posx > 1 then begin;dec(posx);showtxt;end;
        #77 : if posx <= chars then begin;inc(posx);showtxt;end;
        #83 : if posx <= chars then begin dec(chars);delete{2}(s,posx,1);showtxt;end;
       else lch := #1;
      end;
    end;

  until (ch = #27)or(ch = #13);
  if con then begin
    for y := 0 to textheight do
    putpixel(txtpos+x1,y1+y,mem[seg(p^):ofs(p^)+imagedatasize+(width+2)*y+txtpos]);
  end;
  closeimage(p);
end;


const
  tolerance : word = 20;

function findnearcol(nr,ng,nb : byte) : byte;assembler;
{search for nearest color in virtal palette}
asm
  mov   al,nr
  add   al,ng
  add   al,nb
  jz    @stop
  mov   al,nr
  add   al,4
  mov   ah,ng
  add   ah,4
  add   nb,4
  mov   dl,255
  mov   si,1024
  les   di,graphics.pal
  add   di,770
  xor   ch,ch
  @lp:
    sub   di,3
    xor   bh,bh
    mov   bl,nb
    sub   bl,es:[di]
    mov   cl,ah
    sub   cl,es:[di-1]
    add   bx,cx
    mov   cl,al
    sub   cl,es:[di-2]
    add   bx,cx
    cmp   bx,si
    jnb   @end
      mov   si,bx
      mov   dh,dl
      cmp   si,tolerance
      jb    @stop
    @end:
  dec   dl
  jnz   @lp
  @stop:
  mov   al,dh
end;


procedure getvesamodeinfo(m : word);
var
  i,state : word;
begin
  if m < 10 then i := modeset[m].mode
  else i := m;
{$IFDEF DPMI}
  asm
    cmp   m,0
    je    @end
    push  0
    push  256
    call  globaldosalloc
    mov   segment,dx
    mov   selector,ax

    mov   cx,i
    mov   di,offset RealModeRegs
    mov   word ptr [di].TRealRegs.RealSP,0
    mov   word ptr [di].TRealRegs.RealSS,0
    mov   word ptr [di].TRealRegs.RealEAX,4F01h
    mov   word ptr [di].TRealRegs.RealECX,cx
    mov   word ptr [di].TRealRegs.RealES, dx
    mov   word ptr [di].TRealRegs.RealEDI, 0
    mov   ax,ds
    mov   es,ax
    mov   ax,0300h
    mov   bx,0010h
    int   31h
    @end:
    mov   di,offset RealModeRegs
    mov   ax,word ptr [di].TRealRegs.RealEAX
    mov   state,ax
  end;
  move2(ptr(selector,0)^,modeinfoblock,256);
  globaldosfree(selector);
{$ELSE}
  asm
    cmp   m,0
    je    @end
    mov   ax,4f01h
    mov   cx,i
    mov   di,seg modeinfoblock
    mov   es,di
    mov   di,offset modeinfoblock
    int   10h
    @end:
    mov   state,ax
  end;
{$ENDIF}
  winfuncptr := modeinfoblock.winfuncptr;
  bytesperscanline := modeinfoblock.bytesperscanline;
  bitsperpixel := modeinfoblock.bitsperpixel;
  bytesperpixel := round(bitsperpixel / 8);
  lastbank := 255;
  if m < 10 then begin
    mxx  := modeset[m].sx;
    mxy  := modeset[m].sy;
    maxx := succ(mxx);
    maxy := succ(mxy);
  end else begin
    mxx  := modeinfoblock.xresolution-1;
    mxy  := modeinfoblock.yresolution-1;
    maxx := modeinfoblock.xresolution;
    maxy := modeinfoblock.yresolution;
  end;
  if maxy = 0 then maxy := 1;
  if bytesperscanline = 0 then bytesperscanline := 1;
  numofpages := ((longint(vesainfoblock.totalmemory) shl 16) div bytesperscanline-8) div maxy;
  if (hi(vesainfoblock.vesaversion) = 1)and(lo(vesainfoblock.vesaversion) = 0)
  then numofpages := 0;
  lasty := (longint(vesainfoblock.totalmemory) shl 16) div bytesperscanline-8;
  shifter := 7;
  i := modeinfoblock.WinGranularity;
  repeat
    i := i shr 1;
    dec(shifter)
  until i = 0;
  if state <> $4F then gresult := grInvalidMode;
end;


function getbit(value,bit : byte) : boolean;assembler;
asm
  mov   cl,bit
  mov   bl,1
  shl   bl,cl
  mov   al,value
  and   al,bl
end;

procedure setscreen(on : boolean);
begin
  port[$3c4] := 1;
  if on then
  port[$3c5] := port[$3c5] and not 32 else
  port[$3c5] := port[$3c5] or 32;
end;


function initvesamode(mode : word) : boolean;assembler;
asm
  mov   ax,4F02h
  mov   bx,mode
  int   10h
  xor   ax,004Fh { ah<>0 if mode fail, al<>4F if no vesa }
  jnz   @@fail
  mov   ax,1     { true                                  }
  jmp   @@end
@@fail:
  xor   ax,ax    { false                                 }
@@end :
end;


procedure initvgamode(mode : word);assembler;
asm
  mov   ax,mode
  int   10h
end;

function graphresult : integer;assembler;
asm
  mov   ax,gresult
  mov   gresult,0
end;

procedure resetprocs;
begin
  setbank      := setbank_vesa;
  setbank2     := setbank2_vesa;
  incbank      := dummyproc;
  decbank      := dummyproc;
  bar          := bar_vesa;
  line         := line_vesa;
  setwritemode := setwritemode_vesa;
  setfillstyle := setfillstyle_vesa;
  cleardevice  := cleardevice_vesa;
  bitblit      := bitblit_vesa;
  scroll       := scroll_vesa;
  fillpoly     := fillpoly_vesa;
  line_uncl    := line_norm;
end;

{$IFDEF ACCELERATION}
procedure resetoutput;
begin
  resetprocs;
  incbank    := incbank_vesa;
  decbank    := decbank_vesa;
   if (card.fastid = S3) then begin
     if (card.speedup) then begin
       if card.speedupmode = 0 then begin
         FAST_WRITE_BUFFER_ON;
         enableext_s3;
       end;
       setbank  := setbank_s3;
       setbank2 := setbank2_s3;
       incbank  := incbank_s3;
       decbank  := decbank_s3;
       if card.speedupfunc then begin
         if card.speedups.bar then begin
           bar          := bar_s3;
           cleardevice  := cleardevice_s3;
           setfillstyle := setfillstyle_s3;
{           if card.speedups.polygon then fillpoly := fillpoly_s3;}
         end;
{      line           := line_s3;}
{         setwritemode   := setwritemode_s3;}
         if card.speedups.bitblit then bitblit := bitblit_s3;
         scroll         := scroll_s3;
         card.upspeeded := true;
       end;
     end;
   end;
   if (card.fastid = CIRRUS) then begin
     if (card.speedup) then begin
       if card.speedupmode = 0 then enableext_cirrus;
       setbank  := setbank_cirrus;
       setbank2 := setbank2_cirrus;
       incbank  := incbank_cirrus;
       decbank  := decbank_cirrus;
       scroll   := scroll_cirrus;
       if card.speedupfunc then begin
         if card.speedups.bar then begin
           bar          := bar_cirrus;
           cleardevice  := cleardevice_cirrus;
           setfillstyle := setfillstyle_cirrus;
         end;
       if card.speedups.bitblit then bitblit := bitblit_cirrus;
         card.upspeeded := true;
       end;
     end;
{   if (card.fastid = ATI) then begin
     if (card.speedup) then begin
       if card.speedups.banking then begin
         setbank  := setbank_ati;
         setbank2 := setbank2_ati;
         incbank  := incbank_ati;
         decbank  := decbank_ati;
       end;
     end;
   end;}
  end;
end;
{$ENDIF}

procedure resetgdc;assembler;
asm
  mov   dx,3CEh  {GDC}
  mov   al,5     {GDC mode}
  out   dx,al
  inc   dx
  in    al,dx    {get values}
  and   al,0FCh  {cpu byte manipulation on}
  out   dx,al
end;

procedure setaccelerationmode(mode : byte);
begin
  card.upspeeded := false;
  if mode > 0 then card.speedup := true else card.speedup := false;
  if mode > 1 then card.speedupfunc := true else card.speedupfunc := false;
  {$IFDEF ACCELERATION}
  if (gfx_inited)and(m > 0) then resetoutput;
  {$ENDIF}
  card.speedupmode := mode;
end;

{function currenttime : longint;assembler;
asm
  xor   ah,ah
  int   1Ah
  mov   ax,dx
  mov   dx,cx
end;}
function currenttime : longint;assembler;
asm
  mov es,[seg0040]
  mov ax,es:[6Ch]
  mov dx,es:[6Eh]
end;


procedure detectflicker; {leasts about 1/2 second - should be precise enough...}
var
  endtime : longint;
  count   : array[0..1] of word;
begin
  count[0] := 0;
  count[1] := 0;
  pr    := true;
  endtime := currenttime + 1;
  repeat until currenttime <> endtime;{synchronize}
  endtime := currenttime + 4;
  repeat
    waitretrace;
    inc(count[0]);
  until currenttime >= endtime;
  endtime := currenttime + 4;
  repeat
    scroll(pageadd);
    inc(count[1]);
  until currenttime >= endtime;
  if count[1] div 2 > count[0] then pr := true else pr := false;
end;

procedure set256mode(mode : integer);
begin
  if gfx_inited then closegraph;
  gresult := 0;
  m := mode;
  gettext;
  if modeset[m].mode = 0 then begin
    gresult := grInvalidMode;
    exit;
  end;
  if mode > 0 then begin
    getvesamodeinfo(m);
    if gresult <> 0 then exit; {getvesamodeinfo failed...}
    textmode(3); {for S3-cards in PM - DON'T REmovE!}
    if not initvesamode(modeset[m].mode) then begin
      gresult := grInvalidMode;
      exit;
    end;
  end else initvgamode(modeset[m].mode);
  resetprocs;
  resetgdc;
  gfx_inited := true;
  if m > 0 then begin
    incbank    := incbank_vesa;
    decbank    := decbank_vesa;

{$IFDEF ACCELERATION}
    i := card.speedupmode;
    card.speedupmode := 0;
    if i = 3 then setaccelerationmode(2) else setaccelerationmode(i);
    resetoutput;
{$ENDIF}
    if getbit(modeinfoblock.winBAttributes,2) then writeptr := getrmselector(modeinfoblock.winBsegment);
    if getbit(modeinfoblock.winAAttributes,2) then writeptr := getrmselector(modeinfoblock.winAsegment);

    if getbit(modeinfoblock.winBAttributes,1) then readptr := getrmselector(modeinfoblock.winBsegment);
    if getbit(modeinfoblock.winAAttributes,1) then readptr := getrmselector(modeinfoblock.winAsegment);
  end else begin
    numofpages := 0;
    mxx := modeset[m].sx;
    mxy := modeset[m].sy;
    maxx := succ(mxx);
    maxy := succ(mxy);
    bytesperscanline := maxx;
    readptr       := getrmselector($A000);
    writeptr      := readptr;
    bitsperpixel  := 8;
    bytesperpixel := 1;
    lasty         := mxy;
  end;
  pageadd := 0;
  if (getbit(modeinfoblock.winAAttributes,1))and
     (getbit(modeinfoblock.winAAttributes,2)) then
     twowins := false else twowins := true;

  if writeptr <> readptr then twowins := true;

  for i := 0 to numofpages do begin
    setactivepage(i);
    cleardevice_vesa;
  end;
  setactivepage(0);
  setviewport(0,0,mxx,mxy,true);
  gresult := grok;
  gr_vars.mxx  := mxx;
  gr_vars.mxy  := mxy;
  gr_vars.maxx := maxx;
  gr_vars.maxy := maxy;
  actscreen    := actviewport;
  actscreen.y2 := {mxy}lasty;
  actscreen.mxy:= {mxy}lasty;
  actscreen.clip := true;
  getpal;
  setfillstyle(solidfill,white);
  detectflicker;
end;

function grapherrormsg(errorcode : integer) : string;
begin
  case errorcode of
    grNotDetected    : grapherrormsg := 'No Vesa card detected';
    grFontNotFound   : grapherrormsg := 'Font file not found';
    grNoFontMem      : grapherrormsg := 'Not enough memory for font';
    grInvalidMode    : grapherrormsg := 'Mode is not available on this card';
    grError          : grapherrormsg := 'Generic failure';
    grIOerror        : grapherrormsg := 'Disk I/O error';
    grInvalidFont    : grapherrormsg := 'Font is no valid GSoft charset';
    grInvalidFontNum : grapherrormsg := 'Font not available';
    grNoMouseFound   : grapherrormsg := 'No mousedriver found';
    else               grapherrormsg := 'Unknown error';
  end;
end;

function getdrivername : string;
begin
  getdrivername := card.chipid+' '+card.chipname;
end;

procedure getaspectratio(var xasp,yasp : word);
begin
  xasp := 10000;
  yasp := 10000;
end;

procedure setviewport(x1,y1,x2,y2 : integer;clip : boolean);
begin
  actviewport.x1  := x1;
  actviewport.y1  := y1;
  actviewport.x2  := x2;
  actviewport.y2  := y2;
  actviewport.clip:= clip;
  actviewport.mxx := x2-x1;
  actviewport.mxy := y2-y1;
  if clip then fillviewport := actviewport else
  fillviewport := actscreen;
end;

procedure getviewsettings(var viewport : viewporttype);
begin
  move2(actviewport,viewport,sizeof(actviewport));
end;

procedure clearviewport;
begin
  oldcol    := fillcolor;
  fillcolor := black;
  with actviewport do bar(0,0,mxx,mxy);
  fillcolor := oldcol;
end;

function getmaxmode : integer;
begin
{  for i := 1 to 9 do if modeset[i].mode = 0 then break;
  getmaxmode := i-1;}
  getmaxmode := 4;
end;

procedure getavailablemodes;
var
  segm,w,i : word;
  available : array[1..9] of boolean;
begin
    if vesainfoblock.vesaversion >= $0102 then for i := 1 to 9 do
    modeset[i].mode := 0 else
    for i := 1 to 9 do available[i] := false;

    segm := getrmselector(seg(vesainfoblock.Videomodeptr^));
    w := 0;
    while memw[segm:ofs(vesainfoblock.Videomodeptr^)+w*2] <> $FFFF do begin
      m := memw[segm:ofs(vesainfoblock.Videomodeptr^)+w*2];
      getvesamodeinfo(m);
      if vesainfoblock.vesaversion < $0102 then
      if modeinfoblock.bitsperpixel = 8 then begin
        for i := 1 to 9 do if modeset[i].mode = m then available[i] := true;
      end else begin
        for i := 1 to 9 do if modeinfoblock.yresolution = modeset[i].sy then
        modeset[i].mode := m;
      end;
     inc(w);
    end;
    if vesainfoblock.vesaversion < $0102 then for i := 1 to 9 do
      if not available[i] then modeset[i].mode := 0;
end;

procedure closegraph;assembler;
asm
  cmp   gfx_inited,0
  je @end
    push  lastmode
    call  textmode
    call  puttext
    mov   gfx_inited,0
    mov   card.speedupmode,3
  @end:
end;


procedure floodfill(x,y : integer;border : word);
{not made by me - comes from FPKpas sources, but it seems to run}
var
  start,ende,xx : integer;
  col           : word;
begin
  xx := x;
  col:= getpixel(xx,y);
  if col = border then exit;
  while (col <> border)and(xx > 0)and(col <> fillcolor) do begin
    dec(xx);
    col := getpixel(xx,y);
  end;
  start := xx+1;

  xx := x+1;
  col:= getpixel(xx,y);
  while (col <> border)and(xx <= fillviewport.mxx)and(col <> fillcolor)
  do begin
    inc(xx);
    col := getpixel(xx,y);
  end;
  ende := xx-1;

  patternline(start,y,ende-start+1,fillcolor);

  if (y > 0)then begin
    xx := start;
    repeat
      col := getpixel(xx,y-1);
      if (col <> border)and(col <> fillcolor) then begin
        floodfill(xx,y-1,border);
        break;
      end;
      inc(xx);
    until xx > ende;
  end;

  if (y > 0) then begin
    xx := start;
    repeat
      col := getpixel(xx,y+1);
      if (col <> border) and (col <> fillcolor) then floodfill(xx,y+1,border);
      inc(xx);
    until xx > ende;
  end;
end;




procedure settextjustify(horiz,vert : word);
begin
  textx := horiz;
  texty := vert;
end;

procedure setfont(fnt,size : byte);
{set actual font}
begin
  if fontinfo[fnt].available then begin
    font        := fnt;
    currentsize := size;
  end else gresult := grinvalidfont;
end;

procedure settextstyle(font,direction,charsize : word);
{only for compatibility}
begin
  setfont(font,charsize);
end;

procedure gettextsettings(var textinfo : textsettingstype);
begin
  textinfo.font      := font;
  textinfo.direction := 0;
  textinfo.charsize  := currentsize;
  textinfo.horiz     := currentsize;
  textinfo.vert      := currentsize;
end;

function textheight : word;
var
  i2,sy,chw,cy,cr : byte;
  crs,height      : byte;
  dummy,i,i3      : word;
  incer           : word;
begin
 if header[font].chartype = 1 then begin
   crs := header[font].charsize;
   cr  := ord('T');
   height := 0;
{   for i2 := 0 to charpoints^[cr].numofpoints do with charpoints^[cr] do begin
     cy := pointpos[i2].y*currentsize div crs;
     if height < cy then height := cy;
   end;}
(*       for i2 := 1 to charpoints^[cr].numofpoints do
       begin
         cx := charpoints^[cr].pointpos[i2].x;
         {if (cr >= ord('0'))and((cr <= ord('9'))) then width := 12;}
         if width < cx then width := cx;
       end;*)
       asm
         les di,charpoints
         mov ax,word ptr cr   { get the char to draw                   }
         xor ah,ah

         mov bx,ax
         shl ax,6
         add ax,bx             {hehe - saved some cpu time!            }

{         mov cx,65            { one vec-char : 65 bytes                }
{         mul cx               { and calculate memory position          }
         add di,ax
         mov al,es:[di]       { get the amount of lines to draw        }
         dec al
         mov i2,al            { and save it in i2                      }
         mov i3,0             { now reset i3                           }
         @lp:

           push di            { save di for next loop                  }
           mov dx,i3          { load i3                                }
           add dx,4           { increment it by 4,                     }
           mov i3,dx          { write the value back                   }
           lea ax,es:[di+1]
           add ax,dx          { add now i3 to ax                       }
           mov di,ax          { now we have the actual memory position }
           mov bl,es:[di+1]   { so load x and y value to bx            }
           pop di
           cmp height,bl
           jnb @next
           mov height,bl
           @next:
         dec i2
         jnz @lp
         mov  bl,crs
         mov  al,height
         mul  currentsize
         div  bl
         mov  height,al
       end;

   textheight := height;
 end else textheight := header[font].height;
end;

function textwidth(s : string) : word;
var
  i2,cr,sy,chw,cx : byte;
  crs,width       : byte;
  dummy,i,i3      : word;
  xwidth          : word;
  incx            : word;
  incer,px        : word;
  chp             : pointer;
  dist            : byte;
begin
  if length(s) = 0 then begin
    textwidth := 0;
    exit;
  end;
  if header[font].chartype = 1 then begin
    xwidth := 0;
    crs    := header[font].charsize;
    incx   := (crs*currentsize) div 12;

    for i := 0 to pred(ord(s[0])) do begin
      cr := ord(s[i+1]);
      width := 0;
      if cr <> 32 then begin
(*        for i2 := 1 to charpoints^[cr].numofpoints do
        begin
          cx := charpoints^[cr].pointpos[i2].x;
          {if (cr >= ord('0'))and((cr <= ord('9'))) then width := 12;}
          if width < cx then width := cx;
        end;*)
        asm
          les di,charpoints
          mov ax,word ptr cr   { get the char to draw                   }
          xor ah,ah
          mov bx,ax
          shl ax,6
          add ax,bx             {hehe - saved some cpu time!            }

{          mov cx,65            { one vec-char : 65 bytes                }
{          mul cx               { and calculate memory position          }
          add di,ax
          mov al,es:[di]       { get the amount of lines to draw        }
          dec al
          mov i2,al            { and save it in i2                      }
          mov i3,0             { now reset i3                           }
          @lp:

            push di            { save di for next loop                  }
            mov dx,i3          { load i3                                }
            add dx,4           { increment it by 4,                     }
            mov i3,dx          { write the value back                   }
            lea ax,es:[di+1]
            add ax,dx          { add now i3 to ax                       }
            mov di,ax          { now we have the actual memory position }
            mov bl,es:[di]     { so load x and y value to bx            }
            pop di
            cmp width,bl
            jnb @next
            mov width,bl
            @next:
          dec i2
          jnz @lp
        end;
      end else width := (crs*currentsize) div 7;
      asm
        mov   bl,crs
        mov   al,width
        mul   currentsize
        div   bl
        xor   ah,ah
        mov   bx,xwidth
        add   bx,ax
        add   bx,incx
        mov   xwidth,bx
      end;
    end;
    textwidth := xwidth;
  end else if header[font].chartype = 2 then
  textwidth := (header[font].width+header[font].distance)*length(s)
  else if header[font].chartype = 3 then begin
    xwidth := 0;
    chp    := chars[font];
    dist   := header[font].distance;

    for i := 0 to pred(ord(s[0])) do begin
      cr := ord(s[i+1]);
      px := memw[seg(chp^):ofs(chp^)+(cr-header[font].startchar)*2]+
      (header[font].endchar-header[font].startchar+1)*2;
      width := memw[seg(chp^):ofs(chp^)+px+2];
      if (cr <> 32)and(width > 0)and(cr >= header[font].startchar)
      and(cr <= header[font].endchar) then
      inc(xwidth,width+dist)
      else
      inc(xwidth,header[font].width);
    end;
    textwidth := xwidth;
  end;
end;

procedure writexy(x,y : integer;s : string);
var
  i2,cr,sy,chw,cx,chh : byte;
  crs,width,dist      : byte;
  dummy,i,i3,sc       : word;
  xwidth              : word;
  px,py,lx,ly         : word;
  incx                : word;
  incer               : word;
  chp                 : pointer;
begin
  case textx of
    centertext : x := x-textwidth(s) div 2;
    righttext  : x := x-textwidth(s);
  end;
  case texty of
    centertext : y := y-textheight div 2;
    bottomtext : y := y-textheight;
  end;
  if length(s) = 0 then exit;
  sc := header[font].startchar;
  if header[font].chartype = 1 then begin
    xwidth := x;
    crs    := header[font].charsize;
    incx   := (crs*currentsize) div 12;
    for i := 0 to pred(ord(s[0])) do begin
      cr := ord(s[i+1]);
      width := 0;
      if xwidth > actviewport.mxx then break;
      if cr <> 32 then begin
        lx := charpoints^[cr].pointpos[0].x*currentsize div crs+xwidth;
        ly := charpoints^[cr].pointpos[0].y*currentsize div crs+y;
        asm
          les di,charpoints
          mov ax,word ptr cr   { get the char to draw                   }
          xor ah,ah

          mov bx,ax
          shl ax,6
          add ax,bx            { hehe - saved some cpu time!            }

{          mov cx,65            { one vec-char : 65 bytes                }
{          mul cx               { and calculate memory position          }
          add di,ax
          mov al,es:[di]       { get the amount of lines to draw        }
          dec al
          mov i2,al            { and save it in i2                      }
          mov i3,0             { now reset i3                           }
          @drawlp:

            push di            { save di for next loop                  }
            mov dx,i3          { load i3                                }
            add dx,4           { increment it by 4,                     }
            mov i3,dx          { write the value back                   }
            {xor dh,dh}
            lea ax,es:[di+1]
            add ax,dx          { add now i3 to ax                       }
            mov di,ax          { now we have the actual memory position }
            mov bx,es:[di]     { so load x and y value to bx            }

            mov dl,currentsize { load current charsize                  }
            xor dh,dh
            xor ch,ch
            mov cl,crs         { load relative charsize of the font     }
            xor ah,ah          { we don't need ah any more              }
            mov al,bl          { move x value to al                     }
            mul dx             { and multiply with the charsize         }
            div cx             { now divide it by the relative charsize }
            mov si,ax
            add si,xwidth      { add the x-screenpos. to the point      }

            mov dl,currentsize { load current size again for multiply   }
            mov al,bh          { load the y-position to al              }
            mul dx             { and multiply it with the charsize      }
            div cx             { and divide it by the relative charsize }
            add ax,y           { and add y-screenposition               }


            cmp bl,width       { is the actual line wider than the      }
            jna @na            { last line? If yes: save new width      }
              mov width,bl
            @na:

            mov cx,lx          { save last point-positions for the next }
            mov dx,ly          { line-drawing                           }
            mov lx,si          { ...and save new values in it           }
            mov ly,ax
            mov bl,es:[di-2]   { should the next line be drawed? If no: }
            or bl,bl           { overjump line-drawing                  }
            jnz @end
            push es            { save es because of the pointer to the  }
                               { font                                   }
            push cx            { push all points for line               }
            push dx
            push si
            push ax
            call line          { ...and draw the line                   }

            pop es             { restore es                             }
            @end:
          pop di
          dec i2               { decrease number of lines to write      }
          jnz  @drawlp
        end;
      end else width := (crs*currentsize) div 7;
      asm
        mov   bl,crs
        mov   al,width
        mul   currentsize
        div   bl
        xor   ah,ah
        mov   bx,xwidth
        add   bx,ax
        add   bx,incx
        mov   xwidth,bx
      end;
    end;
  end
  else if header[font].colordepth = 1 then begin
    if ((y < fillviewport.mxy+1)or(not actviewport.clip))and(x < fillviewport.mxx+1)and(y >= 0) then begin
      chw := header[font].width;
      chh := header[font].height;
      chp := chars[font];
      dist:= header[font].distance;
      sy  := header[font].height;
      if (sy+y > fillviewport.mxy) then sy := (fillviewport.mxy+1)-y;
      inc(y,pageadd);
      if actviewport.clip then
      if (x+ord(s[0])*(chw+dist)) > fillviewport.mxx+1 then begin
        i := ((actviewport.mxx+1)-x) div (chw+dist);
        if (i > 32768)or(i = 0) then exit;
        s[0] := chr(i);
      end;

      inc(x,actviewport.x1);
      inc(y,actviewport.y1);
      if x < fillviewport.x1 then begin
        i := ((x-actviewport.x1)+ord(s[0])*(chw+dist));
        if (i > 32768)or(i = 0) then exit;
        x := i mod (chw+dist)+actviewport.x1;
        i := i div (chw+dist);
        if  i = 0 then exit;
        move2(s[length(s)-i+1],s[1],i);
        s[0] := chr(i);
      end;
      xwidth := x;
      incer := bytesperscanline-header[font].width;
      asm
        db   66h;xor  ax,ax
        mov  ax,writeptr
        mov  es,ax                { load screenpointer into es          }

        mov  i,0                  { begin with char 0                   }
        xor  ch,ch
        @lp3:
          mov  py,0               { reset y-position                    }

          mov  si,i               { load stringposition                 }
          db   66h;xor cx,cx
          mov  cl,chh
          mov  ax,word ptr s[si+1]{ load char from position+1           }
          xor  ah,ah
          add  ax,sc              { add first availible char            }
          xor  ah,ah
          mul  cx                 { ...and calculate it's memposition   }
          mov  di,ax              { now save this in di                 }

          mov  cx,bytesperscanline{ calculate position in gfx-memory    }
          mov  ax,y
          db   66h;mul cx
          mov  cx,xwidth
          db   66h;add ax,cx
          mov  si,ax              { and save the lower 16bit in si      }

          db   66h;shr ax,16
          cmp  ax,lastbank        { actual bank = setted bank?          }
          je   @next              { if yes, goto next                   }
          push ax
          call setbank2           { if not, switch to new bank          }
          @next:

          mov  al,byte ptr currentcolor    { save drawcolor in al       }
          xor  dh,dh
          mov  dl,chw             { save charwidth in dl                }
          mov  bx,xwidth          { and load actual x-position          }
          add  bx,dx
          mov  cx,maxx
          cmp  bx,cx              { is char over maxx?                  }
          jna  @na
            sub  bx,cx
            mov  dl,bl
          @na:
          mov  dh,sy              { load charheight in dh               }

          push ds
          lds  bx,chp
          add  di,bx
          @lp2:
            mov  cl,dl            { reset x-position                    }
            mov  ch,1             { reset byteposition                  }
            mov  bl,ds:[di]       { load new line of char...            }
            inc  di               { and increase lineposition           }
            @lp:
              test  bl,ch         { bit setted?                         }
              jz    @noput
                mov  es:[si],al   { yes: put pixel                      }
              @noput:
              inc  si             { next pixel                          }
              jz @inc1            { overflow? Then increase bank!       }
@continue1:   add  ch,ch          { next bit                            }
              dec  cl             { increase x-Position in the byte     }
            jnz  @lp              { charline full drawed? If no: all again}
            add  si,incer         { Next row                            }
            jc  @inc2             { Overflow?                           }
            @continue2:
            dec  dh               { decrease lines to draw              }
            jnz  @lp2             { At the end of the char? If no: next line}
          pop  ds
          @overmaxx:
          mov  al,dist
          xor  ah,ah
          add  ax,dx
          add  xwidth,ax          { icrease actual x-screenposition     }
          mov  ax,i               { load i into ax..                    }
          inc  ax                 { increase ax(i)..                    }
          mov  i,ax               { and save it into i                  }
          cmp  al,byte ptr s[0]   { All chars drawed?                   }
        jne  @lp3                 { If no : next char                   }
       jmp @end
     @inc1:   pop  ds
              pusha
              call incbank        { switch to next bank                 }
              popa
              push ds
              push bx
              lds  bx,chp
              pop  bx
              jmp  @continue1
     @inc2:   pop  ds
              pusha
              call incbank        { switch to next bank                 }
              popa
              push ds
              push bx
              lds  bx,chp
              pop  bx
              jmp  @continue2
        @end:
      end;
    end;
  end else if header[font].colordepth = 8 then begin
    xwidth := x;
    chp    := chars[font];
    dist   := header[font].distance;

    for i := 0 to pred(ord(s[0])) do begin
      cr := ord(s[i+1]);
      px := memw[seg(chp^):ofs(chp^)+(cr-header[font].startchar)*2]+
      (header[font].endchar-header[font].startchar+1)*2;
      width := memw[seg(chp^):ofs(chp^)+px+2];
      if (cr <> 32)and(width > 0)and(cr >= header[font].startchar)
      and(cr <= header[font].endchar) then begin
        putsprite(xwidth+mem[seg(chp^):ofs(chp^)+px],y+mem[seg(chp^):ofs(chp^)+px+1],
                  ptr(seg(chp^),ofs(chp^)+px+2),0);
        inc(xwidth,width+dist);
      end else
      inc(xwidth,header[font].width);
    end;
  end;
end;

var
  oldexit : pointer;

procedure exit_grafx;far;
begin
  if gfx_inited then closegraph;
  exitproc := oldexit;
end;

begin
  oldexit  := exitproc;
  exitproc := @exit_grafx;
  vesainfoblock.vesasignature := 'VBE2';{tell the VESA-Driver you want extended information}
  getvesainfo;
  if vesainfoblock.vesasignature = 'VESA' then {getavailablemodes} else
  for i := 1 to 9 do modeset[i].mode := 0;

  resetprocs;
  card.speedup        := true;
  card.speedupfunc    := true;
  card.chipid         := 'VESA';
  card.chipname       := '';
  card.chipnum        := 0;
  card.fastid         := 0;
  card.upspeeded      := false;
  card.speedupmode    := 3;
  card.upspeedable    := false;

  if paramcount > 0 then for i := 1 to paramcount do begin
    if pos('accoff',paramstr(i)) <> 0 then card.speedupfunc := false;
    if pos('safemode',paramstr(i)) <> 0 then card.speedup := false;
  end;
  {$IFDEF ACCELERATION}
    card.upspeeded := false;
    if detect_s3 then begin
      card.chipid := 'S3';
      card.fastid := S3;
      card.upspeedable := true;
    end else
(*    if detect_tseng then begin{not tested yet :( }
      card.chipid := 'TSENG';
      card.fastid := TSENG;
    end else*)
    if detect_cirrus then begin
      card.chipid := 'CIRRUS';
      card.fastid := CIRRUS;
      card.upspeedable := true;
{      pr          := false;}
{    end else
    if detect_ati then begin
      card.chipid := 'ATI';
      card.fastid := ATI;}
    end;

  if card.fastid = S3 then if lo(card.chipnum) <= $D1 {not if >= Trio32} then
  for i := 2 to 5 do begin
    { Check if all accelerated S3-Modes are available }
    getvesamodeinfo(modeset[i].mode+$100);
    if graphresult = grOk then
    inc(modeset[i].mode,$100); { Special S3 accelerated modes }
  end;
  {$ENDIF}

(*  if (b)and((card.speedupfunc)and(card.speedup)) then begin
    move(ptr(getrmselector(
    (longint(vesainfoblock.oemstringptr) shr 16)),
    (longint(vesainfoblock.oemstringptr) and $FFFF))^,s[1],255);
    for i := 1 to 255 do if s[i] = #0 then break;
    s[0] := chr(i);
    if pos('Universal',s) <> 0 then begin
      clrscr;
      writeln('Warning:');
      writeln('You''re running UniVBE with a S3 card!');
      writeln('Since this program uses hardware functions of such cards and');
      writeln('UniVBE is INCOMPATIBLE with it, better remove UniVBE from memory!');
      writeln('If you cannot do that, use as parameter "accoff" to switch off');
      writeln('hardware acceleration or use "safeoff" to use _only_ VESA.');
      writeln('BTW: UniVBE makes this program even slower!');
      writeln('Press any key to continue...');
      writeln(#7);{beep}
      readkey;
      clrscr;
    end;
  end;*)
end.
{****************************************************************************
 * History                                                                  *
 * Version 1.0   first public available Version (9th Aug.1997)              *
 * Version 1.1   +added some comments so that other persons know how to use *
 *                the procedures                                            *
 *               +added circle-routines (filled and traced)                 *
 *               *fixed a bug in procedure sprite2mem                       *
 *               *fixed a bug in readgraphline                              *
 *               +added scrollsupport                                       *
 *               *changed the cursor in readgraphline to see it better      *
 *               +added special waitretrace for setvisualpage (pageretrace) *
 *                (12th Aug.1997)                                           *
 * Version 1.11  *fixed some minor bugs                                     *
 * Version 1.2   +added setviewport                                         *
 *                ^please note that there could be some little bugs - I had *
 *                 not enough time to check all out... you know: school ;)  *
 *               +added vline                                               *
 *               *changed some things for PM - should run on S3 cards now   *
 *                faster and on other cards where it didn't run it runs now *
 *               +added some variables for compatibility with the unit graph*
 *               *fixed a bug with a wrong variable that causes a terrible  *
 *                display on some special gfx-cards (i.e. Matrox)           *
 *               *changed S3-Chip-detection because the detection runned    *
 *                sometimes not correctly                                   *
 *         thanx to Carsten Krger for his support with the last 2 things   *
 *                (27th Sep.1997)                                           *
 * Version 1.21  *writexy-vectorscript module rewritten to assembler - is   *
 *                now nearly 2 times faster                                 *
 *               *fixed a bug in putimage and similar procedures            *
 *                bug was caused by the implementation of setviewport       *
 *                (28th Sep.1997)                                           *
 * Version 1.25  +added support for 8-Bit fonts                             *
 *               *fixed a little bug in circle-procedure                    *
 *               *fixed a bug in writexy which causes with 1bit font wrong  *
 *                display if the font wents over the right edge             *
 *               +1bit fonts are now clipped also on the left edges         *
 *                (3rd Oct.1997)                                            *
 * Version 1.26  *changed putsprite to use other transparent colors than 0  *
 *                too                                                       *
 *               *fixed a bug in writexy/outtextxy-procedure with bankswitch*
 *               +added procedure spriteline for use with i.e. transparent  *
 *                gif's                                                     *
 *               *lines are now clipped too with setviewport                *
 *               *putpixel can also put xorpixels (with setwritemode)       *
 *                (12th Oct 1997)                                           *
 * Version 1.3   +added procedures fillpoly and drawpoly and fastpoly       *
 *               +graphresult support implemented                           *
 *               *S3cards are now in PMode as fast as in realmode - the     *
 *                bankswitching uses direct the S3-card - no use of vesa -  *
 *                so this unit runs also fast with univesa! (which was in-  *
 *                compatible with the integrated speedup)                   *
 *               +the hardware acceleration of S3cards is now used          *
 *               +added procedure Bitblit - software emulation and if S3chip*
 *                present, it uses hardware acceleration                    *
 *               +All the same for Cirrus cards                             *
 *               *implemented faster circle routine (nearly 30 times faster)*
 *               *lots of other speedups                                    *
 *               +documentation comes now with this unit (not good yet ;)   *
 *               *fixed some bugs with setviewport                          *
 *               *fixed a bug in writexy                                    *
 *               *bugfix in floodfill - hanged sometimes the machine        *
 *               *fixed a lot of other bugs(I'm too lazy to list them all :)*
 *               +added partially support for setlinestyle                  *
 *                ^^supported by line, circle, rectangle and ellipse now    *
 *               +added full support for setfillstyle                       *
 *               +added function getdrivername - returns the detected card  *
 *               +added function grapherrormsg                              *
 *               +added procedure ellipse and fillellipse                   *
 *               *fixed a bug in pageretrace                                *
 *               *pageretrace is now automatically called after setvisualpage*
 *               +added function loadpal                                    *
 *               *speeded up findnearcol a little bit                       *
 *               *changed up some things for sooncoming Grafx2              *
 *               *increased speed of writexy (25%)                          *
 *               *removed a bug in putimage - every time the clipping was   *
 *                switched off, the program hanged...                       *
 *               *removed some clipping problems                            *
 *               *fixed bug with bankswitching on ATI-cards                 *
 *               *very fast and safe line-clipping algorithm implemented    *
 *               +added procedures openimage and closeimage - they'll make  *
 *                the memory/image managemant a lot easier                  *
 *               +procedure closefont added                                 *
 *               *changed procedure calccircle - a little bit faster and now*
 *                also only ONE version for Rm AND Pm                       *
 *               *increased speed of vline                                  *
 *               *clipping bugs removed                                     *
 * Phew... ever seen such a long revisionlist? ;) Well, the work is almost  *
 * finished now... I never thought I would have to write a half year...     *
 * a heap of alpha and beta-versions and an endless bugfixing. But I think  *
 * the work was worth it - the unit had never such few bugs like now.       *
 * Release date of version 1.3c was the 19th May 1998                       *
 ****************************************************************************}
