;    Sample assembler file for FULLDB
;
;    Assemble using
;      TASM /Zd parse
;
;    Copyright 1991, D.J. Murdoch
;    Registered users of FULLDB may use this code in their own programs.

IDEAL

SEGMENT  code BYTE PUBLIC
         ASSUME cs:code

         MODEL TPASCAL

PUBLIC   WordCount
PROC     WordCount FAR s:DWORD
         push   ds
         lds    si,[s]        ; ds:si := ^s
         cld
         lodsb
         xor    ah,ah
         mov    cx,ax         ; cx := length(s);
         xor    bx,bx         ; bx := 0;
         jcxz   @@done
         mov    al,' '
         mov    di,si
         push   ds
         pop    es
@@whitespace:                     ; whitespace loop
         repe   scasb
         jcxz     @@done

@@inword:
         inc    bx                ; inword loop
         repne  scasb
         or     cx,cx
         jnz    @@whitespace

@@done:
         mov    ax,bx
         pop    ds
         ret
ENDP

PUBLIC   GetWord
PROC     GetWord FAR result:DWORD,n:WORD,s:DWORD

         push   ds
         les    di,[result]
         xor    ax,ax
         stosb                ; length(result) := 0
         lds    si,[s]        ; ds:si := ^s
         cld
         lodsb
         mov    cx,ax         ; cx := length(s);
         jcxz   @@done        ; done if zero
         mov    bx,[n]        ; bx := n;
         mov    al,' '
         mov    di,si
         push   ds
         pop    es
@@whitespace:                     ; whitespace loop
         repe   scasb
         jcxz   @@done

@@inword:
         dec    bx                ; inword loop
         jz     @@foundit
         repne  scasb
         or     cx,cx
         jnz    @@whitespace

@@done:
         pop    ds
         pop    bp                ; explicit return since we don't want
         ret    6                 ; to pop the result pointer

@@foundit:
         mov    si,di
         dec    si                ; back up one character
         inc    cx
         les    di,[result]
         inc    di
@@loop:                           ; copy word into result
         lodsb
         cmp    al,' '
         jz     @@gotitall
         stosb
         inc    bx
         loop   @@loop
@@gotitall:
         les    di,[result]       ; set the length
         mov    byte ptr es:[di],bl
         jmp    @@done

ENDP

ENDS
END
