Program Test_EMS_Unit;

{----------------------------------------------------------------}
{ This simple program test whether EMM exists, if it does exists,}
{ all pages are allocated to create the largest possiable array  }
{ in EMS, then it will be written and read in three array types  }
{----------------------------------------------------------------}

Uses EMS;

Var
   A                         : EMSArray;
   Pages,
   KiloByte,
   EachPage,
   EachElement,
   ElementNum                : Word;

   Procedure ReadAndWrite(ArrayType: Byte);
    Var
      VerifyFail : Boolean;

     Begin
     {----------------------------------}
     { Write and Read each page in      }
     { in  ArrayType:                   }
     {  ArrayType = 1  Byte    Array    }
     {  ArrayType = 2  Integer Array    }
     {  ArrayType = 3  Real    Array    }
     {----------------------------------}
     Case ArrayType of
       1: ElementNum := PAGESIZE DIV Sizeof(Byte);
       2: ElementNum := PAGESIZE DIV Sizeof(Integer);
       3: ElementNum := PAGESIZE DIV Sizeof(Real);
     End;
     WriteLn('Each element of the array is writing ...');
     For EachPage := 0 to Pages-1 Do
        Begin
          { Map in a logical page to physical page 0 }
          A.MapIn(EachPage, 0);
          For EachElement := 1 To ElementNum Do
           Case ArrayType of
            1: A.ByteArry^[ EachElement ] := 10;
            2: A.IntArry^[ EachElement ] := 25;
            3: A.RealArry^[ EachElement ] := 3.5;
           End;
        End;

     WriteLn('Reading back each element of array and verifying...');
     For EachPage := 0 to Pages-1 Do
        Begin
          { Map in a logical page to physical page 0 }
          A.MapIn(EachPage, 0);
          For EachElement := 1 To ElementNum Do
           Case ArrayType of
            1: VerifyFail := (A.ByteArry^[ EachElement ] <> 10);
            2: VerifyFail := (A.IntArry^[ EachElement ] <> 25);
            3: VerifyFail := (A.RealArry^[ EachElement ] <> 3.5);
           End;
             If VerifyFail Then
               Begin
                 WriteLn('Verify failed!');
                 Halt(1);
               End;
        End;

     End;  {  **** ReadAndWrite Procedure **** }

Begin
  If A.Ems_Installed Then
    Begin
     Pages:=A.Pages_Available;
     KiloByte := Pages * 16;
     WriteLn('There are ', Pages, ' pages expand memory, That is ',
              KiloByte, ' Kb!');
     A.Alloc(Pages);

     {----------------------------------}
     { If There are some probles, Exit  }
     {----------------------------------}
     If EmsError<>0 Then
       Begin
        WriteLn ('Alloc ', Pages, ' Pages Error!' );
        A.Release;
        Halt(1);
       End;

     WriteLn;
     WriteLn('Read and Write as *Integer* Array');
     ReadAndWrite(2);
     WriteLn('Verify Passed, Good!');

     WriteLn;
     WriteLn('Read and Write as *Real* Array');
     ReadAndWrite(3);
     WriteLn('Verify Passed, Good!');

     WriteLn;
     WriteLn('Read and Write as *Byte* Array');
     ReadAndWrite(1);
     WriteLn('Verify Passed, Good!');

     A.Release
    End
  Else
    Begin
     WriteLn('EMM does not exists');
     Halt(1);
    End;
End.

