{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Technlgy/Plug.pas                [x] Protected mode

  Demonstration of the Plug Technology with respect to ADT's.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;


uses EFPLUG, EFFILE, EFADT, EFARRAY;

var T : tTemporaryFile; A : tArray; P : pPlugManager;

begin
     T.Initialize ( 1024 ); { 1K buffer }
     A.Initialize ( 10, 10 );

     P := New ( pPlugManager, Initialize  (@A) );
     P^.Install ( New (pKeyPlug, Initialize (P) ) );
     P^.Install ( New (pQuickSortPlug, Initialize (P) ) );

       { Let us store the plug manager, including the two
         plugs, to a temporary file, and then load it. The
         result is an instance equal to the original plug manager. }
       with T do begin
            Put ( P ); P^.Free;
            Reset; P := pPlugManager (Get);
       end;


     WriteLn ('Our plug manager have ', P^.Register^.Instances, ' plugs.');
     P^.Free;
     A.Intercept;
     T.Intercept; { Delete temporary file }
end.