{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/Perform.pas              [x] Protected mode

  String performance and integrity check. This program demonstrates
  the speed in EFLIB's string class.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;


uses EFSTRING;


const NumberOfStrings = 1000;

var A : array [1..NumberOfStrings] of pString;
    B : string; i, j : word;
    StartMem : longint;

begin
     StartMem := MemAvail;
     Randomize;

     WriteLn ('Performing some intensive string operations (', NumberOfStrings, ' strings).');

     for i := 1 to NumberOfStrings do begin

         B := ''; { Build a random Pascal string }
         for j := 1 to Random(255) do B := B + Char(Random(255));

         { Create a tString instance and do some
           things with it. }
         A[i] := New (pString, InitializeEmpty);
         A[i]^.AssignPascal (B);
         A[i]^.CopyString (A[1], 0, Random(255));
         A[i]^.InsertPascal (B, 0);
     end;

     { Destruct all tString instances }
     for i := 1 to NumberOfStrings do A[i]^.Free;

     if StartMem <> MemAvail
        then WriteLn ('Memory failure.')
        else WriteLn ('Done.');
end.