{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Data.pas                 [x] Protected mode

  This program demonstrates data streams - a sophisticated way
  of giving any variable with an address the stream interface.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFKERNEL, EFSTREAM;


var FirstStream, SecondStream : pStream;
    SomeData1, SomeData2 : string;

begin

     { Some external variables }
     SomeData1 := 'A FLOWER';
     SomeData2 := 'A CAR';

     { Initialize two data streams for associated to two memory regions
       of any size: }
     FirstStream := New (pDataStream, Initialize (@SomeData1[0], SizeOf(SomeData1)));
     SecondStream := New (pDataStream, Initialize (@SomeData2[0], SizeOf(SomeData2)));

     { Transfer some data between them }
     FirstStream^.CopyOut (SecondStream, FirstStream^.Size);

     { Dispose and destruct the streams }
     FirstStream^.Free; SecondStream^.Free;

     { Verify the transfer }
     WriteLn ('We have moved ', SomeData2, ' into a memory stream.');

end.