{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/CRC16.pas                [x] Protected mode

  An example on how you generate CRC16 validation code for data.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFSTREAM, EFFILTER, EFTEXT;


const CRCBuffer = 4096;

var CRC  : pCRC16Filter;
    Null : pNullStream;

{ ParamStr(1) must contain a filename }

begin
     { This program uses a CRC filter to calculate X-MODEM style
       CRC16 validation codes. }

     if ParamStr(1) = '' then begin
        WriteLn ('No file specified!'); Halt (1); end;

     { Initialize CRC filter with a file stream as base }
     CRC := New ( pCRC16Filter,
                  Initialize ( New ( pFileStream,
                                     { Base stream }
                               Initialize (ParamStr(1), CRCBuffer))   )    );
                                         { Filename } { Buffer size }

     Null := New (pNullStream, Initialize);
     CRC^.MoveOut (Null, CRC^.Size);
     WriteLn ('The CRC16 is ', Copy (StringHexNumber(CRC^.Result), 1, 255), 'h.');

     { Use $DEFINE CRCTABLES for faster but more memory consuming
       CRC calculations. }

     CRC^.Free; { Dispose filter including base stream }
     Null^.Free; { Dispose the null stream }
end.