{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Location/Matrix4.pas             [x] Protected mode

  Matrix algebra demonstration: Gauss-elimination in an arbitrary
  matrix (ie. solving a arbitrary equation system described with
  a coefficient matrix and a result matrix).

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFMATH;


var Matrix1, Matrix2 : tMatrix;

begin
     WriteLn ('*** Advanced matrix algebra ***');

     with Matrix1 do begin

          { Build a square matrix }
          Initialize (4, 4);

          WriteLn ('(a) Dimension check');
          if IsSquare then WriteLn ('    Rows = Columns; square matrix!');

          SetElement (1, 1, 1); SetElement (1, 2, 1);  SetElement (1, 3, 1);  SetElement (1, 4, 1);
          SetElement (2, 1, 1); SetElement (2, 2, 1);  SetElement (2, 3, 1);  SetElement (2, 4, -1);
          SetElement (3, 1, 1); SetElement (3, 2, 1);  SetElement (3, 3, -1); SetElement (3, 4, -1);
          SetElement (4, 1, 1); SetElement (4, 2, -1); SetElement (4, 3, -1); SetElement (4, 4, -1);

          WriteLn ('(b) Transposal');
          Transpose;
          StreamWrite (StdIO);
          Transpose;

          WriteLn ('(c) Inversion');
          Invert; { Invert this matrix }

          WriteLn ('    Matrix1 was inverted: ');
          StreamWrite (StdIO);

          { Invert the matrix again to restore the original
            matrix. }
          Invert;

          with Matrix2 do begin

               { Build a row-matrix for an equation system }
               Initialize (4, 1);

               SetElement (1, 1, 0); { (Row, Column, Real number) }
               SetElement (2, 1, 4);
               SetElement (3, 1, 6);
               SetElement (4, 1, 2);

               WriteLn ('(d) Compatibility checks');
               if IsCompatible (@Matrix1) then
                  WriteLn ('    Matrix1 has the same number of rows ',
                           'and columns as Matrix2 has.');

               if Matrix1.IsResultMatrix (@Matrix2) then
                  WriteLn ('    Matrix1 is a valid coefficient matrix for Matrix2.');

               WriteLn ('(e) Gauss elimination');
               if Matrix1.Gauss (@Matrix2) then begin

                  WriteLn ('    The equation system has the solution: ');
                  Matrix2.StreamWrite (StdIO);
                  WriteLn ('    Verification; should be (X, Y, Z, W) = (1, 2, -1, -2).');

               end else WriteLn ('    Not solvable or no solutions.');

               Intercept;
          end;

          Intercept;
     end;
end.