{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Sorting2.pas            [x] Protected mode

  Sorting demonstration. This program compares the sorting performance
  in different EFLIB ADT's. It uses some of the most common sorting
  algorithms.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFBASIC, EFADT, EFARRAY, EFLIST, EFSORT, CRT, EFTEST;


const NumberOfElements = 100; { Try more elements, e.g. 1000! }
      GrowthSize = 10;

var Data : array [1..3] of pLinearADT;
    Current : pLinearADT; Timer : tTimer;
    Index, Number : word;


procedure Build;
begin
     { Build structure }
     Current^.Clear;

     for Index := 1 to NumberOfElements do begin
         Number := Succ(Random(High(Number)));
         Current^.Store (Number); { Add element }
     end;
end;


procedure Test;
begin
     RandSeed := 0; { Control random seed }

     Build;
     Current^.InstallPlug (New (pInsertionSortPlug, Initialize (NIL)));

     Timer.Initialize;
     Current^.Sort (AscendingOrder);
     Write (Timer.ElapsedMS:15:0);
     Timer.Intercept;


     Build;
     Current^.InstallPlug (New (pQuickSortPlug, Initialize (NIL)));

     Timer.Initialize;
     Current^.Sort (AscendingOrder);
     Write (Timer.ElapsedMS:16:0);
     Timer.Intercept;


     Build;
     Current^.InstallPlug (New (pMergeSortPlug, Initialize (NIL)));

     Timer.Initialize;
     Current^.Sort (AscendingOrder);
     Write (Timer.ElapsedMS:16:0);
     Timer.Intercept;

end;


begin
     MemPush; { EFTEST }

     WriteLn; TextBackground (Blue);
     Write ('Data type', '':16, 'Insertion sort .... Quick sort .... Merge sort [ms] ', '':2);
     TextBackground (Black); WriteLn;

     Write ('Bounded array       ');
     Data[1] := New(pBoundedArray, Initialize (NumberOfElements, SizeOf(Number)));
     Current := Data[1]; Test; WriteLn;

     Write ('Virtual array       ');
     Data[2] := New(pVirtualArray, Initialize (0, GrowthSize, SizeOf(Number)));
     Current := Data[2]; Test; WriteLn;

     Write ('Linked list         ');
     Data[3] := New(pList, Initialize (SizeOf(Number)));
     Current := Data[3]; Test; WriteLn;

     WriteLn ('Verifying sort order ...');

     for Index := 1 to SizeOf(Data) div SizeOf(pADT) do
         if Data[Index]^.IsInitialized then
            if not Data[Index]^.IsSorted (AscendingOrder) then
               WriteLn ('Data type ', Index, ' was not correctly sorted.');

     WriteLn ('Done.');

     { Dispose all data structures }
     for Index := 1 to SizeOf(Data) div SizeOf(pADT) do
         if Data[Index]^.IsInitialized then Data[Index]^.Free;

     MemPop; { EFTEST }
end.