{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Elements/Compare.pas    [ ] Protected mode

  Demonstration of element comparison: a built-in feature in the
  polymorphic elements in EFLIB ADT's.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;


uses EFARRAY, EFLIST;

var MyArray : tArray;
    MyNode  : pLinkage;
    Something : string;


begin
     with MyArray do begin

          { Initialize an array }
          Initialize ( SizeOf(Something), 100 );


          { Store some equally long text strings
            (must be equally long since the first
            byte is of importance if tGenericElement
            is used - override tArray if you want
            other elements). }

          Something := 'Cars    '; Store (Something);
          Something := 'Bicycles'; Store (Something);

          { (i) Complex element access: Get returns
                a pElement instance which we can access.
                tElement.Data returns the conents, we
                choose the first position Data(0): }
          Write (String(Get(High)^.Data(0)^), ' are ');

          { Compare the last element (highest used; index MyArray.High)
            with the first element (lowest used; index MyArray.Low). }
          case Get(High)^.Compare (Get (Low)) of

               -1 : Write ('smaller than');
               0  : Write ('equal with');
               1  : Write ('bigger than');

          end;

          { (i) can be replaced with the following,
            analogous statement, though this one is
            for the highest used element, not for the
            lowest used, and the text is somewhat different: }
          Retrieve (Something, Low);
          WriteLn (' ', Something);

          { Intercept }
          Intercept;
     end;
end.