{
	CTOPUNIT	LastMod	 6 Mar 89  SAC
			Created  6 Oct 88  SAC

##############################################################################

	This unit contains the standard routines needed to support
	programs translated by CtoP.

	(c) 1988, 1989 Knowledge Software Ltd.

	Permission is given to amend and distribute this source provided
	that this copyright header is always included.

##############################################################################
}

Unit CtoPunit;

Interface

Const
	Char_Size	= 1;

Type
	UnsLongint	= Longint;
{$IFOPT N+}
	LDouble		= Double;
{$ENDIF}
	LLongint	= Longint;
	UnsLLongint	= UnsLongint;
	SWord		= Word;
	SInteger	= Integer;
	SgnChar		= Char;
	UnsChar		= Char;

Function If_Then_Else(Condition : Boolean;
		      True_Exp  : Longint;
		      False_Exp : Longint) : Longint;

Function ITE_Bool(Condition : Boolean;
		  True_Exp  : Boolean;
		  False_Exp : Boolean) : Longint;

Function ITE_C(Condition : Boolean) : Boolean;

Function ITE_T(True_Exp : Longint) : Boolean;

Function ITE_E(False_Exp : Longint) : Boolean;

Function SEq_Char(Var Target;
		      Source : Char) : Char;

Function SEq_SgnChar(Var Target;
		         Source : SgnChar) : SgnChar;

Function SEq_UnsChar(Var Target;
		         Source : UnsChar) : UnsChar;

Function SEq_Word(Var Target;
		      Source : Word) : Word;

Function SEq_Integer(Var Target;
			 Source : Integer) : Integer;

Function SEq_SInteger(Var Target;
			  Source : SInteger) : SInteger;

Function SEq_Longint(Var Target;
			 Source : Longint) : Longint;

Function SEq_Pointer(Var Target;
			 Source : Pointer) : Pointer;

{$IFOPT N+}
Function SEq_Double(Var Target;
			Source : Double) : Double;

Function SEq_Single(Var Target;
			Source : Single) : Single;
{$ELSE}
Function SEq_Real(Var Target;
		      Source : Real) : Real;
{$ENDIF}

Function PoI_Integer(Var Variable) : Integer;

Function PoI_SInteger(Var Variable) : SInteger;

Function PoI_Word(Var Variable) : Word;

Function PoI_SWord(Var Variable) : SWord;

Function PoI_Longint(Var Variable) : Longint;

Function PoI_Char(Var Variable) : Char;

Function PoI_SgnChar(Var Variable) : SgnChar;

Function PoI_UnsChar(Var Variable) : UnsChar;

Function PoI_Pointer(Var Variable;
			 Amount   : Integer) : Pointer;

Function PoD_Integer(Var Variable) : Integer;

Function PoD_SInteger(Var Variable) : SInteger;

Function PoD_Word(Var Variable) : Word;

Function PoD_SWord(Var Variable) : SWord;

Function PoD_Longint(Var Variable) : Longint;

Function PoD_Char(Var Variable) : Char;

Function PoD_SgnChar(Var Variable) : SgnChar;

Function PoD_UnsChar(Var Variable) : UnsChar;

Function PoD_Pointer(Var Variable;
			 Amount   : Integer) : Pointer;

Function PrI_Integer(Var Variable) : Integer;

Function PrI_SInteger(Var Variable) : SInteger;

Function PrI_Word(Var Variable) : Word;

Function PrI_SWord(Var Variable) : SWord;

Function PrI_Longint(Var Variable) : Longint;

Function PrI_Char(Var Variable) : Char;

Function PrI_SgnChar(Var Variable) : SgnChar;

Function PrI_UnsChar(Var Variable) : UnsChar;

Function PrI_Pointer(Var Variable;
			 Amount   : Integer) : Pointer;

Function PrD_Integer(Var Variable) : Integer;

Function PrD_SInteger(Var Variable) : SInteger;

Function PrD_Word(Var Variable) : Word;

Function PrD_SWord(Var Variable) : SWord;

Function PrD_Longint(Var Variable) : Longint;

Function PrD_Char(Var Variable) : Char;

Function PrD_SgnChar(Var Variable) : SgnChar;

Function PrD_UnsChar(Var Variable) : UnsChar;

Function PrD_Pointer(Var Variable;
			 Amount   : Integer) : Pointer;

Procedure Inc_Pointer(Var Variable;
			  Amount   : Integer);

Procedure Dec_Pointer(Var Variable;
			  Amount   : Integer);

Function StrAddr(ActualStr : String) : Pointer;

Function Add_Eq_Word(Var Left; Right : Integer) : Integer;
Function Sub_Eq_Word(Var Left; Right : Integer) : Integer;
Function Mul_Eq_Word(Var Left; Right : Integer) : Integer;
Function Div_Eq_Word(Var Left; Right : Integer) : Integer;
Function Mod_Eq_Word(Var Left; Right : Integer) : Integer;
Function And_Eq_Word(Var Left; Right : Integer) : Integer;
Function Or_Eq_Word(Var Left; Right : Integer) : Integer;
Function Xor_Eq_Word(Var Left; Right : Integer) : Integer;
Function Lsh_Eq_Word(Var Left; Right : Integer) : Integer;
Function Rsh_Eq_Word(Var Left; Right : Integer) : Integer;

Function Add_Eq_SWord(Var Left; Right : Integer) : Integer;
Function Sub_Eq_SWord(Var Left; Right : Integer) : Integer;
Function Mul_Eq_SWord(Var Left; Right : Integer) : Integer;
Function Div_Eq_SWord(Var Left; Right : Integer) : Integer;
Function Mod_Eq_SWord(Var Left; Right : Integer) : Integer;
Function And_Eq_SWord(Var Left; Right : Integer) : Integer;
Function Or_Eq_SWord(Var Left; Right : Integer) : Integer;
Function Xor_Eq_SWord(Var Left; Right : Integer) : Integer;
Function Lsh_Eq_SWord(Var Left; Right : Integer) : Integer;
Function Rsh_Eq_SWord(Var Left; Right : Integer) : Integer;

Function Add_Eq_Integer(Var Left; Right : Integer) : Integer;
Function Sub_Eq_Integer(Var Left; Right : Integer) : Integer;
Function Mul_Eq_Integer(Var Left; Right : Integer) : Integer;
Function Div_Eq_Integer(Var Left; Right : Integer) : Integer;
Function Mod_Eq_Integer(Var Left; Right : Integer) : Integer;
Function And_Eq_Integer(Var Left; Right : Integer) : Integer;
Function Or_Eq_Integer(Var Left; Right : Integer) : Integer;
Function Xor_Eq_Integer(Var Left; Right : Integer) : Integer;
Function Lsh_Eq_Integer(Var Left; Right : Integer) : Integer;
Function Rsh_Eq_Integer(Var Left; Right : Integer) : Integer;

Function Add_Eq_Pointer(Var Left; Right : Integer) : Pointer;
Function Sub_Eq_Pointer(Var Left; Right : Integer) : Pointer;

Procedure Add_SEq_Word(Var Left; Right : Integer);
Procedure Sub_SEq_Word(Var Left; Right : Integer);
Procedure Mul_SEq_Word(Var Left; Right : Integer);
Procedure Div_SEq_Word(Var Left; Right : Integer);
Procedure Mod_SEq_Word(Var Left; Right : Integer);
Procedure And_SEq_Word(Var Left; Right : Integer);
Procedure Or_SEq_Word(Var Left; Right : Integer);
Procedure Xor_SEq_Word(Var Left; Right : Integer);
Procedure Lsh_SEq_Word(Var Left; Right : Integer);
Procedure Rsh_SEq_Word(Var Left; Right : Integer);

Procedure Add_SEq_Integer(Var Left; Right : Integer);
Procedure Sub_SEq_Integer(Var Left; Right : Integer);
Procedure Mul_SEq_Integer(Var Left; Right : Integer);
Procedure Div_SEq_Integer(Var Left; Right : Integer);
Procedure Mod_SEq_Integer(Var Left; Right : Integer);
Procedure And_SEq_Integer(Var Left; Right : Integer);
Procedure Or_SEq_Integer(Var Left; Right : Integer);
Procedure Xor_SEq_Integer(Var Left; Right : Integer);
Procedure Lsh_SEq_Integer(Var Left; Right : Integer);
Procedure Rsh_SEq_Integer(Var Left; Right : Integer);

Procedure Add_SEq_Pointer(Var Left; Right : Integer);
Procedure Sub_SEq_Pointer(Var Left; Right : Integer);

Function Comma_Integer(Left, Right : Integer) : Integer;

{$IFOPT N+}
Function Float(Value : Longint) : Double;
{$ELSE}
Function Float(Value : Longint) : Real;
{$ENDIF}

{
	Now some dummy variables that can be used to
	'throw away' results of functions
}
Var
	Dummy_Char	: Char;
	Dummy_Integer	: Integer;
	Dummy_SInteger	: SInteger;
	Dummy_Word	: Word;
	Dummy_SWord	: SWord;
	Dummy_Longint	: Longint;
	Dummy_LLongint	: LLongint;
{$IFOPT N+}
	Dummy_Single	: Single;
	Dummy_Double	: Double;
	Dummy_LDouble	: LDouble;
{$ELSE}
	Dummy_Real	: Real;
{$ENDIF}
	Dummy_Void	: Integer;
	Dummy_Pointer	: Pointer;
	Dummy_SgnChar	: SgnChar;
	Dummy_UnsChar	: UnsChar;
{
	Other support variables:
}
	ITE_Cnd		: Boolean;	{ used by ITE_Bool }

Implementation

Var
	IFE_Then,
	IFE_Else	: Longint;	{ values of long-winded IFE tests }

Function ITE_Bool;
Begin
If ITE_Cnd Then
  ITE_Bool := IFE_Then
Else
  ITE_Bool := IFE_Else;
End; { ITE_Bool }

Function If_Then_Else;
Begin
If Condition Then
  If_Then_Else := True_Exp
Else
  If_Then_Else := False_Exp;
End; { If_Then_Else }

Function ITE_C;
Begin
ITE_C := Condition;
ITE_Cnd := Condition;
End; { ITE_C }

Function ITE_T;
Begin
IFE_Then := True_Exp;
ITE_T := True;
End; { ITE_T }

Function ITE_E;
Begin
IFE_Else := False_Exp;
ITE_E := False;
End; { ITE_E }

Function SEq_Char;
Begin
Char(Target) := Source;
SEq_Char := Source;
End; { SEq_Char }

Function SEq_UnsChar;
Begin
UnsChar(Target) := Source;
SEq_UnsChar := Source;
End; { SEq_UnsChar }

Function SEq_SgnChar;
Begin
SgnChar(Target) := Source;
SEq_SgnChar := Source;
End; { SEq_SgnChar }

Function SEq_Word;
Begin
Word(Target) := Source;
SEq_Word := Source;
End; { SEq_Word }

Function SEq_Integer;
Begin
Integer(Target) := Source;
SEq_Integer := Source;
End; { SEq_Integer }

Function SEq_SInteger;
Begin
SInteger(Target) := Source;
SEq_SInteger := Source;
End; { SEq_Integer }

Function SEq_Longint;
Begin
Longint(Target) := Source;
SEq_Longint := Source;
End; { SEq_Longint }

Function SEq_Pointer;
Begin
Pointer(Target) := Source;
SEq_Pointer := Source;
End; { SEq_Pointer }

{$IFOPT N+}
Function SEq_Double;
Begin
Double(Target) := Source;
SEq_Double := Source;
End; { SEq_Double }

Function SEq_Single;
Begin
Single(Target) := Source;
SEq_Single := Source;
End; { SEq_Single }
{$ELSE}
Function SEq_Real;
Begin
Real(Target) := Source;
SEq_Real := Source;
End; { SEq_Real }
{$ENDIF}

Function PoI_Integer;
Begin
PoI_Integer := Integer(Variable);
Integer(Variable) := Integer(Variable) + 1;
End; { PoI_Integer }

Function PoI_SInteger;
Begin
PoI_SInteger := SInteger(Variable);
SInteger(Variable) := SInteger(Variable) + 1;
End; { PoI_SInteger }

Function PoI_Longint;
Begin
PoI_Longint := Longint(Variable);
LongInt(Variable) := Longint(Variable) + 1;
End; { PoI_Longint }

Function PoI_Char;
Begin
PoI_Char := Char(Variable);
Byte(Variable) := Byte(Variable) + 1;
End; { PoI_Char }

Function PoI_SgnChar;
Begin
PoI_SgnChar := SgnChar(Variable);
Byte(Variable) := Byte(Variable) + 1;
End; { PoI_SgnChar }

Function PoI_UnsChar;
Begin
PoI_UnsChar := UnsChar(Variable);
Byte(Variable) := Byte(Variable) + 1;
End; { PoI_UnsChar }

Function PoI_Pointer;
Begin
PoI_Pointer := Pointer(Variable);
Longint(Variable) := Longint(Variable) + Amount;
End; { PoI_Pointer }

Function PoI_Word;
Begin
PoI_Word := Word(Variable);
Word(Variable) := Word(Variable) + 1;
End; { PoI_Word }

Function PoI_SWord;
Begin
PoI_SWord := SWord(Variable);
SWord(Variable) := SWord(Variable) + 1;
End; { PoI_SWord }

Function PoD_Integer;
Begin
PoD_Integer := Integer(Variable);
Integer(Variable) := Integer(Variable) - 1;
End; { PoD_Integer }

Function PoD_SInteger;
Begin
PoD_SInteger := SInteger(Variable);
SInteger(Variable) := SInteger(Variable) - 1;
End; { PoD_SInteger }

Function PoD_Longint;
Begin
PoD_Longint := Longint(Variable);
Longint(Variable) := Longint(Variable) - 1;
End; { PoD_Longint }

Function PoD_Char;
Begin
PoD_Char := Char(Variable);
Byte(Variable) := Byte(Variable) - 1;
End; { PoD_Char }

Function PoD_SgnChar;
Begin
PoD_SgnChar := SgnChar(Variable);
Byte(Variable) := Byte(Variable) - 1;
End; { PoD_SgnChar }

Function PoD_UnsChar;
Begin
PoD_UnsChar := UnsChar(Variable);
Byte(Variable) := Byte(Variable) - 1;
End; { PoD_UnsChar }

Function PoD_Pointer;
Begin
PoD_Pointer := Pointer(Variable);
Longint(Variable) := Longint(Variable) - Amount;
End; { PoD_Pointer }

Function PoD_Word;
Begin
PoD_Word := Word(Variable);
Word(Variable) := Word(Variable) - 1;
End; { PoD_Word }

Function PoD_SWord;
Begin
PoD_SWord := SWord(Variable);
SWord(Variable) := SWord(Variable) - 1;
End; { PoD_SWord }

Function PrI_Integer;
Begin
Integer(Variable) := Integer(Variable) + 1;
PrI_Integer := Integer(Variable);
End; { PrI_Integer }

Function PrI_SInteger;
Begin
SInteger(Variable) := SInteger(Variable) + 1;
PrI_SInteger := SInteger(Variable);
End; { PrI_SInteger }

Function PrI_Longint;
Begin
Longint(Variable) := Longint(Variable) + 1;
PrI_Longint := Longint(Variable);
End; { PrI_Longint }

Function PrI_Char;
Begin
Byte(Variable) := Byte(Variable) + 1;
PrI_Char := Char(Variable);
End; { PrI_Char }

Function PrI_SgnChar;
Begin
Byte(Variable) := Byte(Variable) + 1;
PrI_SgnChar := SgnChar(Variable);
End; { PrI_SgnChar }

Function PrI_UnsChar;
Begin
Byte(Variable) := Byte(Variable) + 1;
PrI_UnsChar := UnsChar(Variable);
End; { PrI_UnsChar }

Function PrI_Pointer;
Begin
Longint(Variable) := Longint(Variable) + Amount;
PrI_Pointer := Pointer(Variable);
End; { PrI_Pointer }

Function PrI_Word;
Begin
Word(Variable) := Word(Variable) + 1;
PrI_Word := Word(Variable);
End; { PrI_Word }

Function PrI_SWord;
Begin
SWord(Variable) := SWord(Variable) + 1;
PrI_SWord := SWord(Variable);
End; { PrI_SWord }

Function PrD_Integer;
Begin
Integer(Variable) := Integer(Variable) - 1;
PrD_Integer := Integer(Variable);
End; { PrD_Integer }

Function PrD_SInteger;
Begin
SInteger(Variable) := SInteger(Variable) - 1;
PrD_SInteger := SInteger(Variable);
End; { PrD_Integer }

Function PrD_Longint;
Begin
Longint(Variable) := Longint(Variable) - 1;
PrD_Longint := Longint(Variable);
End; { PrD_Longint }

Function PrD_Char;
Begin
Byte(Variable) := Byte(Variable) - 1;
PrD_Char := Char(Variable);
End; { PrD_Char }

Function PrD_SgnChar;
Begin
Byte(Variable) := Byte(Variable) - 1;
PrD_SgnChar := SgnChar(Variable);
End; { PrD_SgnChar }

Function PrD_UnsChar;
Begin
Byte(Variable) := Byte(Variable) - 1;
PrD_UnsChar := UnsChar(Variable);
End; { PrD_UnsChar }

Function PrD_Pointer;
Begin
Longint(Variable) := Longint(Variable) - Amount;
PrD_Pointer := Pointer(Variable);
End; { PrD_Pointer }

Function PrD_Word;
Begin
Word(Variable) := Word(Variable) - 1;
PrD_Word := Word(Variable);
End; { PrD_Word }

Function PrD_SWord;
Begin
SWord(Variable) := SWord(Variable) - 1;
PrD_SWord := SWord(Variable);
End; { PrD_SWord }

Procedure Inc_Pointer;
Begin
Longint(Variable) := Longint(Variable) + Amount;
End; { Inc_Pointer }

Procedure Dec_Pointer;
Begin
Longint(Variable) := Longint(Variable) - Amount;
End; { Dec_Pointer }

Function StrAddr;
{
	Given a string, we must somehow return the 'address' of it.

	About the only way to do this, is to allocate space on the
	heap, copy the string in and return that address.  Note that
	excessive use of StrAddr will cause a heap overflow!
}
Var
	HeapStr	: ^String;
Begin
GetMem(Pointer(HeapStr), 1 + Word(Length(ActualStr)));
	{ we grab enough memory for the string & its length byte }
HeapStr^ := ActualStr;
	{ copy the string to the heap }
StrAddr := HeapStr;
	{ return the 'address of the string' }
End; { StrAddr }

Function Add_Eq_Word;
Begin
Word(Left) := Word(Left) + Right;
Add_Eq_Word := Word(Left);
End;

Function Sub_Eq_Word;
Begin
Word(Left) := Word(Left) - Right;
Sub_Eq_Word := Word(Left);
End;

Function Mul_Eq_Word;
Begin
Word(Left) := Word(Left) * Right;
Mul_Eq_Word := Word(Left);
End;

Function DIV_Eq_Word;
Begin
Word(Left) := Word(Left) DIV Right;
Div_Eq_Word := Word(Left);
End;

Function Mod_Eq_Word;
Begin
Word(Left) := Word(Left) Mod Right;
Mod_Eq_Word := Word(Left);
End;

Function And_Eq_Word;
Begin
Word(Left) := Word(Left) AND Right;
And_Eq_Word := Word(Left);
End;

Function Or_Eq_Word;
Begin
Word(Left) := Word(Left) OR Right;
Or_Eq_Word := Word(Left);
End;

Function Xor_Eq_Word;
Begin
Word(Left) := Word(Left) XOR Right;
Xor_Eq_Word := Word(Left);
End;

Function Lsh_Eq_Word;
Begin
Word(Left) := Word(Left) SHL Right;
Lsh_Eq_Word := Word(Left);
End;

Function Rsh_Eq_Word;
Begin
Word(Left) := Word(Left) SHR Right;
Rsh_Eq_Word := Word(Left);
End;

Function Add_Eq_SWord;
Begin
SWord(Left) := SWord(Left) + Right;
Add_Eq_SWord := SWord(Left);
End;

Function Sub_Eq_SWord;
Begin
SWord(Left) := SWord(Left) - Right;
Sub_Eq_SWord := SWord(Left);
End;

Function Mul_Eq_SWord;
Begin
SWord(Left) := SWord(Left) * Right;
Mul_Eq_SWord := SWord(Left);
End;

Function DIV_Eq_SWord;
Begin
SWord(Left) := SWord(Left) DIV Right;
Div_Eq_SWord := SWord(Left);
End;

Function Mod_Eq_SWord;
Begin
SWord(Left) := SWord(Left) Mod Right;
Mod_Eq_SWord := SWord(Left);
End;

Function And_Eq_SWord;
Begin
SWord(Left) := SWord(Left) AND Right;
And_Eq_SWord := SWord(Left);
End;

Function Or_Eq_SWord;
Begin
SWord(Left) := SWord(Left) OR Right;
Or_Eq_SWord := SWord(Left);
End;

Function Xor_Eq_SWord;
Begin
SWord(Left) := SWord(Left) XOR Right;
Xor_Eq_SWord := SWord(Left);
End;

Function Lsh_Eq_SWord;
Begin
SWord(Left) := SWord(Left) SHL Right;
Lsh_Eq_SWord := SWord(Left);
End;

Function Rsh_Eq_SWord;
Begin
SWord(Left) := SWord(Left) SHR Right;
Rsh_Eq_SWord := SWord(Left);
End;

Function Add_Eq_Integer;
Begin
Integer(Left) := Integer(Left) + Right;
Add_Eq_Integer := Integer(Left);
End;

Function Sub_Eq_Integer;
Begin
Integer(Left) := Integer(Left) - Right;
Sub_Eq_Integer := Integer(Left);
End;

Function Mul_Eq_Integer;
Begin
Integer(Left) := Integer(Left) * Right;
Mul_Eq_Integer := Integer(Left);
End;

Function DIV_Eq_Integer;
Begin
Integer(Left) := Integer(Left) DIV Right;
Div_Eq_Integer := Integer(Left);
End;

Function Mod_Eq_Integer;
Begin
Integer(Left) := Integer(Left) Mod Right;
Mod_Eq_Integer := Integer(Left);
End;

Function And_Eq_Integer;
Begin
Integer(Left) := Integer(Left) AND Right;
And_Eq_Integer := Integer(Left);
End;

Function Or_Eq_Integer;
Begin
Integer(Left) := Integer(Left) OR Right;
Or_Eq_Integer := Integer(Left);
End;

Function Xor_Eq_Integer;
Begin
Integer(Left) := Integer(Left) XOR Right;
Xor_Eq_Integer := Integer(Left);
End;

Function Lsh_Eq_Integer;
Begin
Integer(Left) := Integer(Left) SHL Right;
Lsh_Eq_Integer := Integer(Left);
End;

Function Rsh_Eq_Integer;
Begin
Integer(Left) := Integer(Left) SHR Right;
Rsh_Eq_Integer := Integer(Left);
End;

Function Add_Eq_Pointer;
Begin
Longint(Left) := Longint(Left) + Right;
Add_Eq_Pointer := Pointer(Left);
End;

Function Sub_Eq_Pointer;
Begin
Longint(Left) := Longint(Left) - Right;
Sub_Eq_Pointer := Pointer(Left);
End;

Procedure Add_SEq_Word;
Begin
Word(Left) := Word(Left) + Right;
End;

Procedure Sub_SEq_Word;
Begin
Word(Left) := Word(Left) - Right;
End;

Procedure Mul_SEq_Word;
Begin
Word(Left) := Word(Left) * Right;
End;

Procedure DIV_SEq_Word;
Begin
Word(Left) := Word(Left) DIV Right;
End;

Procedure Mod_SEq_Word;
Begin
Word(Left) := Word(Left) Mod Right;
End;

Procedure And_SEq_Word;
Begin
Word(Left) := Word(Left) AND Right;
End;

Procedure Or_SEq_Word;
Begin
Word(Left) := Word(Left) OR Right;
End;

Procedure Xor_SEq_Word;
Begin
Word(Left) := Word(Left) XOR Right;
End;

Procedure Lsh_SEq_Word;
Begin
Word(Left) := Word(Left) SHL Right;
End;

Procedure Rsh_SEq_Word;
Begin
Word(Left) := Word(Left) SHR Right;
End;

Procedure Add_SEq_Integer;
Begin
Integer(Left) := Integer(Left) + Right;
End;

Procedure Sub_SEq_Integer;
Begin
Integer(Left) := Integer(Left) - Right;
End;

Procedure Mul_SEq_Integer;
Begin
Integer(Left) := Integer(Left) * Right;
End;

Procedure DIV_SEq_Integer;
Begin
Integer(Left) := Integer(Left) DIV Right;
End;

Procedure Mod_SEq_Integer;
Begin
Integer(Left) := Integer(Left) Mod Right;
End;

Procedure And_SEq_Integer;
Begin
Integer(Left) := Integer(Left) AND Right;
End;

Procedure Or_SEq_Integer;
Begin
Integer(Left) := Integer(Left) OR Right;
End;

Procedure Xor_SEq_Integer;
Begin
Integer(Left) := Integer(Left) XOR Right;
End;

Procedure Lsh_SEq_Integer;
Begin
Integer(Left) := Integer(Left) SHL Right;
End;

Procedure Rsh_SEq_Integer;
Begin
Integer(Left) := Integer(Left) SHR Right;
End;

Procedure Add_SEq_Pointer;
Begin
Longint(Left) := Longint(Left) + Right;
End;

Procedure Sub_SEq_Pointer;
Begin
Longint(Left) := Longint(Left) - Right;
End;

Function Comma_Integer;
Begin
Comma_Integer := Right;
End;

Function Float;
Begin
Float := 0.0 + Value;
End;

Begin { Unit Initialization }
End.
