program demo;

{ Program to demonstrate use of BGIRES unit. }

{ WARNING:  this program should be compiled to disk, not run from memory in
            the IDE.  If you ignore this warning, it may write to TURBO.EXE. }

 { The first time you run it, you need to give the path to your BGI files.
 It'll load the one it needs, and after that it won't need the separate BGI
 files any more, unless you switch graphics boards. }

uses objects,graph,crt,   { These are the standard Borland units }
     bgires;              { The thing we're demoing! }

procedure DrawPicture;
{ A silly ad for BGIRES; hit any key to stop it.}
const
  colour : array[0..1] of integer = (Black, White);
  count = 200;
var
  i : integer;
  width, xwidth, ywidth, x, y : word;
  xvel, yvel, xpos, ypos, yaccel,decel : real;
  msg : string;
begin
  xwidth := getmaxx;
  ywidth := getmaxy;
  msg := 'BGIRES';
  settextstyle(defaultfont, horizdir, 2);
  width := textwidth(msg);
  xpos := 0.1 + random*0.9;
  ypos := 1;
  repeat
    xvel := (random-0.5)*0.003;
  until abs(xvel) > 0.0005;
  yvel := 0;
  yaccel := -0.001+random*0.0005;
  decel := (1+random)/2;
  colour[0] := random(16);
  repeat
    setcolor(colour[trunc(random*1.05)]);
    x := trunc(xpos*xwidth) - width div 2;
    y := trunc((1-ypos)*ywidth);
    outtextxy(x,y, msg);
    xpos := xpos + xvel;
    ypos := ypos + yvel;
    yvel := yvel + yaccel;
    if ypos < 0 then
    begin
      ypos := 0;
      yvel := -yvel*decel;
    end;
  until keypressed or (xpos < 0) or (xpos > 1 ) ;
end;

var
  res : TResourceFile2;   { New resource file type that can pack itself }
  graphdriver,graphmode:integer;
  i : integer;
  k : char;
begin

  { First, open the executable as the resource file.  It'll be empty on
    the first run. }

  res.init(New(PBufStream, Init(paramstr(0),stOpen, 1024)));
  if res.stream^.status <> stOK then
    halt(99);
  writeln('Initial size of ',paramstr(0),'=',res.stream^.getsize);

  if res.count = 0 then
  begin
    { Put all bgi drivers into the .EXE }
    writeln('Storing all drivers from path "',paramstr(1),'"');
    if putalldrivers(paramstr(1),res,false) <> 0 then
    begin
      writeln('Warning:  Some drivers not stored!');
      writeln('SYNTAX:  DEMO bgipath');
      writeln(' where bgipath is a path (terminated with a "\") to the .BGI files');
    end;
    writeln('   After adding drivers, size=',res.stream^.getsize);
  end;
  res.flush;
  { and then take out all of them except the one we'll need. }
  DetectGraph(graphdriver,graphmode);
  for i:=1 to 10 do
    if drivernum[i] <> drivernum[graphdriver] then
      DelDriver(i,res);

  res.pack;            { Now pack to release the deleted space }

  writeln('After packing resources, size=',res.stream^.getsize);
  writeln('Hit any key to continue...');
  while keypressed do k:=readkey;
  repeat until keypressed;
  while keypressed do k:=readkey;

  { A better way to do the above would be to use the graphdriver value
    to pick the correct driver out of Drivernames, e.g.
      PutDriver(paramstr(1)+ DriverName[DriverNum[GraphDriver]],
                res, true);
    but I wanted to demonstrate DelDriver and PackResources. }

  graphdriver := detect;
  resinitgraph(graphdriver,graphmode,res,'');

  randomize;
  repeat
    DrawPicture
  until keypressed;
  closegraph;

  res.done;
end.
