;
;*****************************************************************************
;
GETBIT		MACRO
		LOCAL	GOTSOME
		LOCAL	EOF
		LOCAL	still_full
		CMP	AH,0
		JG	GOTSOME
		push	ds
		push	si
		pushf
		mov	si,cs:_srcbuff
		mov	ds,cs:_srcbuff+2
		cld
		lodsb
		popf
		mov	cs:_srcbuff,si
		cmp	si,cs:_endbuff
		pop	si
		pop	ds
		jle	still_full
		mov	ah,0ffh	
		JMP	EOF
still_full:	MOV	AH,8
GOTSOME:	DEC	AH
		SHL	AL,1
EOF:
		ENDM

page
;*****************************************************************************
;* DCOMPRES - Decompress raw image data 				     *
;*									     *
;*	Input:	AH	Residual bit count				     *
;*		AL	Residual data byte				     *
;*		ES:DI	Address of raw image buffer			     *
;*		CX	Maximum length of raw image data (in bits, 1/14/87)  *
;*									     *
;*	Output: AH	Residual bit count				     *
;*		AL	Residual data byte				     *
;*		CX	Length of raw image data			     *
;*		[ES:DI] Buffer contains raw image data			     *
;*									     *
;*									     *
;*****************************************************************************
;

	EXTRN	_GetDecompByte:FAR

_dcompres_TEXT	 SEGMENT BYTE PUBLIC 'CODE'

	EXTRN	_srcbuff:word
	EXTRN	_endbuff:word

	ASSUME	CS:_dcompres_TEXT,DS:_dcompres_TEXT

		PUBLIC	_dcompres

_dcompres	 PROC   FAR
		PUSH	DS		; make the data seqment point
		PUSH	CS		; at the code segment
		POP	DS		;
		PUSH	CX		; the image data length in bits
		JCXZ	DCOMPRES2	; if zero, we're done
		MOV	DX,CX		; save it in dx ?
;1/15/87
		add	cx,7		; convert the bit count to byte
		shr	cx,1
		shr	cx,1
		shr	cx,1

		PUSH	AX		; save the byte count and pointer
		PUSH	DI		; start 
		MOV	AL,00H		; zero out the buffer to avoid 
		CLD			; having to write white bits
		REP STOSB			; zero out buffer
		POP	DI
		POP	AX

		MOV	CX,0			; running bit count
		CALL	FAR PTR WHITE_RUN	; go get the first white 
						; run.  all tiff files
						; start with a white run
		JNS	DCOMPRES1		; if the sign bit set,
						; this call failed
		CMP	BX,-1			; bx contains the return
		JNZ	DCOMPRES2		; code set to -1
		POP	CX			; to indicate failure
		MOV	CX,0			; cx contains the number 
		JMP	FAR PTR DCOMPRES9	; of bits decomped.

DCOMPRES1:	CALL	FAR PTR BLACK_RUN	; now repeatadly call black
						; and white run until	
		JS	DCOMPRES2		; one line has been decomp.
		CALL	FAR PTR WHITE_RUN
		JNS	DCOMPRES1

DCOMPRES2:
		POP	CX		; restore values of called 
					; registers
DCOMPRES9:	POP	DS
		RET
_dcompres	ENDP

page
;***************************************************************************
;
; white_run search the binary tree for the number of bits this code reps.
;	White_run does not write any bits
; 	to the buffer, because it assumes that the destination buffer has
; 	already been filled with zeros
;	the function expects to have bx,dx and cx set to values
;	es:di points to destination
;	ax cotains a byte from which the run is being calculated

WHITE_RUN	PROC	FAR
		LEA	SI,WHITE_TREE
		CALL	FAR PTR GET_RUN
		JS	WHITE_RUN2
		SUB	DX,BX
		JS	WHITE_RUN2
		JZ	WHITE_RUN1
		PUSH	BX
		ADD	BX,CX
		MOV	CX,BX
		SHR	BX,1
		SHR	BX,1
		SHR	BX,1		; convert bit count to bytes.
		ADD	DI,BX
		AND	CX,0007H
		POP	BX
		TEST	BX,BX
		JMP	short WHITE_RUN2
WHITE_RUN1:	DEC	DX
WHITE_RUN2:	RET
WHITE_RUN	ENDP

page
;***************************************************************************
;
BLACK_RUN	PROC	FAR
		LEA	SI,BLACK_TREE
		CALL	FAR PTR GET_RUN
		JS	BLACK_RUN9
		SUB	DX,BX
		JS	BLACK_RUN9
		PUSH	AX
		PUSH	BX		; black run length
		PUSH	DX
		JCXZ	BLACK_RUN2
		MOV	DX,8
		SUB	DX,CX
		CMP	BX,DX
		JGE	BLACK_RUN1
;
; portion of current byte
;
		MOV	AX,0FF00H
		XCHG	CL,BL
		SHR	AX,CL
		XCHG	CL,BL
		SHR	AL,CL
		OR	byte ptr(ES:[DI]),AL
		ADD	CX,BX
		JMP	BLACK_RUN4
;
; remainder of current byte
;
BLACK_RUN1:	MOV	AL,0FFH
		SHR	AL,CL
		OR	byte ptr(ES:[DI]),AL
		INC	DI
		SUB	BX,DX
		MOV	CX,0
		JZ	BLACK_RUN4
BLACK_RUN2:	MOV	AL,0FFH
		MOV	CX,BX
		AND	CX,0FFF8H
		JCXZ	BLACK_RUN3
		SUB	BX,CX
		SHR	CX,1
		SHR	CX,1
		SHR	CX,1
		CLD
		REP STOSB
BLACK_RUN3:	MOV	CX,BX
		JCXZ	BLACK_RUN4
		MOV	AX,0FF00H
		SHR	AX,CL
		OR	byte ptr(ES:[DI]),AL
BLACK_RUN4:	POP	DX
		POP	BX
		POP	AX
		DEC	DX		; set CC.S if DX = 0 (end of line)
		JS	BLACK_RUN9
		INC	DX
BLACK_RUN9:	RET
BLACK_RUN	ENDP

page
;***************************************************************************
;
GET_RUN 	PROC	FAR
		PUSH	SI		; save binary tree address
		CALL	FAR PTR FIND_RUN; get make-up or termination code
		POP	SI		; restore address
		JS	GET_RUN3	; jump if illegal sequence
		CMP	BX,64		; is first part make-up code?
		JL	GET_RUN2	; jump if not
		PUSH	BX		; save make-up code
		CALL	FAR PTR FIND_RUN; get termination code
		POP	SI		; restore make-up (BX = term code)
		JS	GET_RUN3	; jump if illegal sequence
		CMP	BX,64		; got another make-up code?
		JG	GET_RUN1	; jump if second make-up code
		ADD	BX,SI		; compute total run length
		JMP	short GET_RUN3
GET_RUN1:	MOV	BX,-2
GET_RUN2:	CMP	BX,0
GET_RUN3:	RET
GET_RUN 	ENDP

page
;***************************************************************************
;
FIND_RUN	PROC	FAR			; Search binary tree for run length
		CMP	word ptr[SI],0		; leaf node?
		JNZ	FOUND_RUN		; yes, report value of leaf
		GETBIT		; get next bit in input stream
						; returns bit in carry flag
		PUSHF
		CMP	AH,0FFH
		JZ	FOUND_2
		POPF
		JC	FOUND_1 		; jump if 1 bit found
FOUND_0:	ADD	SI,4			; point to 0 found node
		JMP	short FIND_RUN		; search subtree
FOUND_1:	MOV	SI,word ptr[SI+2]	; point to 1 found node
		JMP	short FIND_RUN		; search subtree
FOUND_RUN:	MOV	BX,word ptr[SI+2]	; get value of leaf
		CMP	BX,0			; test for legal sequence
		RET
FOUND_2:	POPF
		MOV	BX,-1
		CMP	BX,0
		RET
FIND_RUN	ENDP

page
;***************************************************************************
; Decompression Tables
;
WHITE_TREE	LABEL	WORD
W		DW	0,W1
W0		DW	0,W01
W00		DW	0,W001
W000		DW	0,W0001
W0000		DW	0,W00001
W00000		DW	0,W000001
W000000 	DW	0,W0000001
W0000000	DW	0,W00000001
W00000000	DW	0,W000000001
W000000000	DW	0,W0000000001
W0000000000	DW	0,W00000000001
W00000000000	DW	0,W000000000001
W000000000000	DW	1,-2
W000000000001	DW	1,-1	; EOL
W00000000001	DW	1,-2
W0000000001	DW	1,-2
W000000001	DW	1,-2
W00000001	DW	0,W000000011
W000000010	DW	0,W0000000101
W0000000100	DW	0,W00000001001
W00000001000	DW	1,1792
W00000001001	DW	0,W000000010011
W000000010010	DW	1,1984
W000000010011	DW	1,2048
W0000000101	DW	0,W00000001011
W00000001010	DW	0,W000000010101
W000000010100	DW	1,2112
W000000010101	DW	1,2176
W00000001011	DW	0,W000000010111
W000000010110	DW	1,2240
W000000010111	DW	1,2304
W000000011	DW	0,W0000000111
W0000000110	DW	0,W00000001101
W00000001100	DW	1,1856
W00000001101	DW	1,1920
W0000000111	DW	0,W00000001111
W00000001110	DW	0,W000000011101
W000000011100	DW	1,2368
W000000011101	DW	1,2432
W00000001111	DW	0,W000000011111
W000000011110	DW	1,2496
W000000011111	DW	1,2560
W0000001	DW	0,W00000011
W00000010	DW	1,29
W00000011	DW	1,30
W000001 	DW	0,W0000011
W0000010	DW	0,W00000101
W00000100	DW	1,45
W00000101	DW	1,46
W0000011	DW	1,22
W00001		DW	0,W000011
W000010 	DW	0,W0000101
W0000100	DW	1,23
W0000101	DW	0,W00001011
W00001010	DW	1,47
W00001011	DW	1,48
W000011 	DW	1,13
W0001		DW	0,W00011
W00010		DW	0,W000101
W000100 	DW	0,W0001001
W0001000	DW	1,20
W0001001	DW	0,W00010011
W00010010	DW	1,33
W00010011	DW	1,34
W000101 	DW	0,W0001011
W0001010	DW	0,W00010101
W00010100	DW	1,35
W00010101	DW	1,36
W0001011	DW	0,W00010111
W00010110	DW	1,37
W00010111	DW	1,38
W00011		DW	0,W000111
W000110 	DW	0,W0001101
W0001100	DW	1,19
W0001101	DW	0,W00011011
W00011010	DW	1,31
W00011011	DW	1,32
W000111 	DW	1,1
W001		DW	0,W0011
W0010		DW	0,W00101
W00100		DW	0,W001001
W001000 	DW	1,12
W001001 	DW	0,W0010011
W0010010	DW	0,W00100101
W00100100	DW	1,53
W00100101	DW	1,54
W0010011	DW	1,26
W00101		DW	0,W001011
W001010 	DW	0,W0010101
W0010100	DW	0,W00101001
W00101000	DW	1,39
W00101001	DW	1,40
W0010101	DW	0,W00101011
W00101010	DW	1,41
W00101011	DW	1,42
W001011 	DW	0,W0010111
W0010110	DW	0,W00101101
W00101100	DW	1,43
W00101101	DW	1,44
W0010111	DW	1,21
W0011		DW	0,W00111
W00110		DW	0,W001101
W001100 	DW	0,W0011001
W0011000	DW	1,28
W0011001	DW	0,W00110011
W00110010	DW	1,61
W00110011	DW	1,62
W001101 	DW	0,W0011011
W0011010	DW	0,W00110101
W00110100	DW	1,63
W00110101	DW	1,0
W0011011	DW	0,W00110111
W00110110	DW	1,320
W00110111	DW	1,384
W00111		DW	1,10
W01		DW	0,W011
W010		DW	0,W0101
W0100		DW	0,W01001
W01000		DW	1,11
W01001		DW	0,W010011
W010010 	DW	0,W0100101
W0100100	DW	1,27
W0100101	DW	0,W01001011
W01001010	DW	1,59
W01001011	DW	1,60
W010011 	DW	0,W0100111
W0100110	DW	0,W01001101
W01001100	DW	0,W010011001
W010011000	DW	1,1472
W010011001	DW	1,1536
W01001101	DW	0,W010011011
W010011010	DW	1,1600
W010011011	DW	1,1728
W0100111	DW	1,18
W0101		DW	0,W01011
W01010		DW	0,W010101
W010100 	DW	0,W0101001
W0101000	DW	1,24
W0101001	DW	0,W01010011
W01010010	DW	1,49
W01010011	DW	1,50
W010101 	DW	0,W0101011
W0101010	DW	0,W01010101
W01010100	DW	1,51
W01010101	DW	1,52
W0101011	DW	1,25
W01011		DW	0,W010111
W010110 	DW	0,W0101101
W0101100	DW	0,W01011001
W01011000	DW	1,55
W01011001	DW	1,56
W0101101	DW	0,W01011011
W01011010	DW	1,57
W01011011	DW	1,58
W010111 	DW	1,192
W011		DW	0,W0111
W0110		DW	0,W01101
W01100		DW	0,W011001
W011000 	DW	1,1664
W011001 	DW	0,W0110011
W0110010	DW	0,W01100101
W01100100	DW	1,448
W01100101	DW	1,512
W0110011	DW	0,W01100111
W01100110	DW	0,W011001101
W011001100	DW	1,704
W011001101	DW	1,768
W01100111	DW	1,640
W01101		DW	0,W011011
W011010 	DW	0,W0110101
W0110100	DW	0,W01101001
W01101000	DW	1,576
W01101001	DW	0,W011010011
W011010010	DW	1,832
W011010011	DW	1,896
W0110101	DW	0,W01101011
W01101010	DW	0,W011010101
W011010100	DW	1,960
W011010101	DW	1,1024
W01101011	DW	0,W011010111
W011010110	DW	1,1088
W011010111	DW	1,1152
W011011 	DW	0,W0110111
W0110110	DW	0,W01101101
W01101100	DW	0,W011011001
W011011000	DW	1,1216
W011011001	DW	1,1280
W01101101	DW	0,W011011011
W011011010	DW	1,1344
W011011011	DW	1,1408
W0110111	DW	1,256
W0111		DW	1,2
W1		DW	0,W11
W10		DW	0,W101
W100		DW	0,W1001
W1000		DW	1,3
W1001		DW	0,W10011
W10010		DW	1,128
W10011		DW	1,8
W101		DW	0,W1011
W1010		DW	0,W10101
W10100		DW	1,9
W10101		DW	0,W101011
W101010 	DW	1,16
W101011 	DW	1,17
W1011		DW	1,4
W11		DW	0,W111
W110		DW	0,W1101
W1100		DW	1,5
W1101		DW	0,W11011
W11010		DW	0,W110101
W110100 	DW	1,14
W110101 	DW	1,15
W11011		DW	1,64
W111		DW	0,W1111
W1110		DW	1,6
W1111		DW	1,7

BLACK_TREE	LABEL	WORD
B		DW	0,B1
B0		DW	0,B01
B00		DW	0,B001
B000		DW	0,B0001
B0000		DW	0,B00001
B00000		DW	0,B000001
B000000 	DW	0,B0000001
B0000000	DW	0,B00000001
B00000000	DW	1,-2
B00000001	DW	0,B000000011
B000000010	DW	0,B0000000101
B0000000100	DW	0,B00000001001
B00000001000	DW	1,1792
B00000001001	DW	0,B000000010011
B000000010010	DW	1,1984
B000000010011	DW	1,2048
B0000000101	DW	0,B00000001011
B00000001010	DW	0,B000000010101
B000000010100	DW	1,2112
B000000010101	DW	1,2176
B00000001011	DW	0,B000000010111
B000000010110	DW	1,2240
B000000010111	DW	1,2304
B000000011	DW	0,B0000000111
B0000000110	DW	0,B00000001101
B00000001100	DW	1,1856
B00000001101	DW	1,1920
B0000000111	DW	0,B00000001111
B00000001110	DW	0,B000000011101
B000000011100	DW	1,2368
B000000011101	DW	1,2432
B00000001111	DW	0,B000000011111
B000000011110	DW	1,2496
B000000011111	DW	1,2560
B0000001	DW	0,B00000011
B00000010	DW	0,B000000101
B000000100	DW	0,B0000001001
B0000001000	DW	1,18
B0000001001	DW	0,B00000010011
B00000010010	DW	0,B000000100101
B000000100100	DW	1,52
B000000100101	DW	0,B0000001001011
B0000001001010	DW	1,640
B0000001001011	DW	1,704
B00000010011	DW	0,B000000100111
B000000100110	DW	0,B0000001001101
B0000001001100	DW	1,768
B0000001001101	DW	1,832
B000000100111	DW	1,55
B000000101	DW	0,B0000001011
B0000001010	DW	0,B00000010101
B00000010100	DW	0,B000000101001
B000000101000	DW	1,56
B000000101001	DW	0,B0000001010011
B0000001010010	DW	1,1280
B0000001010011	DW	1,1344
B00000010101	DW	0,B000000101011
B000000101010	DW	0,B0000001010101
B0000001010100	DW	1,1408
B0000001010101	DW	1,1472
B000000101011	DW	1,59
B0000001011	DW	0,B00000010111
B00000010110	DW	0,B000000101101
B000000101100	DW	1,60
B000000101101	DW	0,B0000001011011
B0000001011010	DW	1,1536
B0000001011011	DW	1,1600
B00000010111	DW	1,24
B00000011	DW	0,B000000111
B000000110	DW	0,B0000001101
B0000001100	DW	0,B00000011001
B00000011000	DW	1,25
B00000011001	DW	0,B000000110011
B000000110010	DW	0,B0000001100101
B0000001100100	DW	1,1664
B0000001100101	DW	1,1728
B000000110011	DW	1,320
B0000001101	DW	0,B00000011011
B00000011010	DW	0,B000000110101
B000000110100	DW	1,384
B000000110101	DW	1,448
B00000011011	DW	0,B000000110111
B000000110110	DW	0,B0000001101101
B0000001101100	DW	1,512
B0000001101101	DW	1,576
B000000110111	DW	1,53
B000000111	DW	0,B0000001111
B0000001110	DW	0,B00000011101
B00000011100	DW	0,B000000111001
B000000111000	DW	1,54
B000000111001	DW	0,B0000001110011
B0000001110010	DW	1,896
B0000001110011	DW	1,960
B00000011101	DW	0,B000000111011
B000000111010	DW	0,B0000001110101
B0000001110100	DW	1,1024
B0000001110101	DW	1,1088
B000000111011	DW	0,B0000001110111
B0000001110110	DW	1,1152
B0000001110111	DW	1,1216
B0000001111	DW	1,64
B000001 	DW	0,B0000011
B0000010	DW	0,B00000101
B00000100	DW	1,13
B00000101	DW	0,B000001011
B000001010	DW	0,B0000010101
B0000010100	DW	0,B00000101001
B00000101000	DW	1,23
B00000101001	DW	0,B000001010011
B000001010010	DW	1,50
B000001010011	DW	1,51
B0000010101	DW	0,B00000101011
B00000101010	DW	0,B000001010101
B000001010100	DW	1,44
B000001010101	DW	1,45
B00000101011	DW	0,B000001010111
B000001010110	DW	1,46
B000001010111	DW	1,47
B000001011	DW	0,B0000010111
B0000010110	DW	0,B00000101101
B00000101100	DW	0,B000001011001
B000001011000	DW	1,57
B000001011001	DW	1,58
B00000101101	DW	0,B000001011011
B000001011010	DW	1,61
B000001011011	DW	1,256
B0000010111	DW	1,16
B0000011	DW	0,B00000111
B00000110	DW	0,B000001101
B000001100	DW	0,B0000011001
B0000011000	DW	1,17
B0000011001	DW	0,B00000110011
B00000110010	DW	0,B000001100101
B000001100100	DW	1,48
B000001100101	DW	1,49
B00000110011	DW	0,B000001100111
B000001100110	DW	1,62
B000001100111	DW	1,63
B000001101	DW	0,B0000011011
B0000011010	DW	0,B00000110101
B00000110100	DW	0,B000001101001
B000001101000	DW	1,30
B000001101001	DW	1,31
B00000110101	DW	0,B000001101011
B000001101010	DW	1,32
B000001101011	DW	1,33
B0000011011	DW	0,B00000110111
B00000110110	DW	0,B000001101101
B000001101100	DW	1,40
B000001101101	DW	1,41
B00000110111	DW	1,22
B00000111	DW	1,14
B00001		DW	0,B000011
B000010 	DW	0,B0000101
B0000100	DW	1,10
B0000101	DW	1,11
B000011 	DW	0,B0000111
B0000110	DW	0,B00001101
B00001100	DW	0,B000011001
B000011000	DW	1,15
B000011001	DW	0,B0000110011
B0000110010	DW	0,B00001100101
B00001100100	DW	0,B000011001001
B000011001000	DW	1,128
B000011001001	DW	1,192
B00001100101	DW	0,B000011001011
B000011001010	DW	1,26
B000011001011	DW	1,27
B0000110011	DW	0,B00001100111
B00001100110	DW	0,B000011001101
B000011001100	DW	1,28
B000011001101	DW	1,29
B00001100111	DW	1,19
B00001101	DW	0,B000011011
B000011010	DW	0,B0000110101
B0000110100	DW	0,B00001101001
B00001101000	DW	1,20
B00001101001	DW	0,B000011010011
B000011010010	DW	1,34
B000011010011	DW	1,35
B0000110101	DW	0,B00001101011
B00001101010	DW	0,B000011010101
B000011010100	DW	1,36
B000011010101	DW	1,37
B00001101011	DW	0,B000011010111
B000011010110	DW	1,38
B000011010111	DW	1,39
B000011011	DW	0,B0000110111
B0000110110	DW	0,B00001101101
B00001101100	DW	1,21
B00001101101	DW	0,B000011011011
B000011011010	DW	1,42
B000011011011	DW	1,43
B0000110111	DW	1,0
B0000111	DW	1,12
B0001		DW	0,B00011
B00010		DW	0,B000101
B000100 	DW	1,9
B000101 	DW	1,8
B00011		DW	1,7
B001		DW	0,B0011
B0010		DW	1,6
B0011		DW	1,5
B01		DW	0,B011
B010		DW	1,1
B011		DW	1,4
B1		DW	0,B11
B10		DW	1,3
B11		DW	1,2

temp		db	?

_dcompres_TEXT		 ENDS
		END
