//-------------------------------------------------------------------
// 1 Feb 2000
//-------------------------------------------------------------------

#include "print.h"
#include "labels.h"
#include "parse.h"
#include <stdlib.h>
#include <process.h>
#include "grid.h"

struct HorizontalPage
{
	int numpages;              //r # of actual pages within that horizontal pg
	int numlines;            	//r # of lines to print starting from y1
	int numcols;               //r # of cell cols (or len of letters)
	int stletter;            //the starting col letter
};




char bigletters[28];        //all the visable cols within the range to
									 //be printed
int biglen;						 //len of bigletters string

HorizontalPage hpages[26];		//room for 26 possible horizontal pages
										//each element of the array refers to
										//the data in the struct for that horizontal
										//page.
//for example, assume cell cols A to D are 1 horizontal page
//and assume there are 56 lines per printed page. If there are at least
//57 or more nonblank lines on the spreadsheet within in the cols A to D then
//there are two actual printed pages for that horizontal page A to D
//the next horizontal page might be E to H, so we count the number of
//actual pages to be printed within that range also; and so on
//until we have printed all the cells within the range x1, y1, x2, y2
int numhpages;         //total nun of horizontal pages
int numpages;          //total

int NumOfNonBlankLines(int x1, int y1, int x2, int y2);
int GetBigLetters(int x1, int x2);
int GetMaxCols(int x1, int x2);
int GetHorizontalPages(int x1, int y1, int x2, int y2);
int WaitPage(int p);

int PrintHorizontalPage(FILE *out, int hpage, int previouspages,
												int totpages, int y1, char *namebuf);



int NormalPrintOut(int x1, int y1, int x2, int y2, char *namebuf);
int PrintOut(int sel, char *namebuf);
int PrintText();
char printerbuf[160]; //buf for line of text to send to printer
//-------------------------------------------------------------------
//Within the range x1, y1, x2, y2 find the last nonblank lines
//by scanning backwards from the bottom
//Exit:
// ax = r # of nonblank lines within that range.
//      (It can be 0 if all are blank, or more)
int NumOfNonBlankLines(int x1, int y1, int x2, int y2)
{
	int x, y, rlines =0;
	char cell_name[6];
	Cell *j;

	for(y = y2; y>=y1; y--)
	{
		itoa(y+1, &cell_name[1], 10);
		for(x = x1; x<= x2; x++)
		{
			if(!g->colwidths[x]) continue;   //skip any invisible columns
			cell_name[0] = x+'A';
			par->errnum =0;
			j = par->Find(cell_name);
			if(j != NULL)
			{
				if(j->answer.type)     //if cell not empty
				{
					rlines = (y - y1)+1;
					break; 	           //break out of inner for loop
				}
			}

		}
		if(rlines) break; 	 		//if we broke out of the inner loop breakout
											//altogether
	}


	return rlines;       //0 or more lines with in range can be printed.
}                       //if 0 its means none.

//----------------------------------------------------------------------
//fill the bigletters string with all the visable letters of the
//printed range
//Exit:
//	ax = r # of cols to print
int GetBigLetters(int x1, int x2)
{
	int x;

	biglen =0;
	for(x = x1; x<= x2; x++)
	{

		if(!g->colwidths[x]) continue;	//skip invisable col
		bigletters[biglen] = 'A'+x;
		biglen++;
	}

	bigletters[biglen] =0;
	return biglen;
}
//----------------------------------------------------------------------
//Within the range x1, y1, x2, y2, and starting at col x1
//find the r num of cell cols that can be printed within a line
//of width maxlen (normally maxlen is 75 chars)
//Exit:
//	ax = r # of visible cols starting from col x1
// but if x1 is an invisible col and all other upto x2 are also
// invisible then ax = 0 which means no text can be printer for this
// col range: (x1 to x2)
int GetMaxCols(int x1, int x2)
{
	int t, acc =0, maxcols =0;
	for(t = x1; t<=x2; t++)
	{
		if(!g->colwidths[t]) continue;  //if col invisible skip

		if(acc + g->colwidths[t] >maxplen)
		{
			break;
		}
		acc += g->colwidths[t];
		maxcols++;
	}

	return maxcols;
}
//----------------------------------------------------------------------
//given the total range (x1, y1, x2, y2) to be printed
//fill the hpages struct with its data relevant to the
//each horizontal page, and return the total num of horizontal
//pages.

int GetHorizontalPages(int x1, int y1, int x2, int y2)
{
	int t, x, y, len, cols, hpage=0;
	int fx1, fx2, pos=0;



	len = GetBigLetters(x1, x2);    //fill the bigletters[] str with all the
	fx1 = bigletters[0] - 'A';
	fx2 = bigletters[len-1] -'A';


	do{										//visable letters within the big printed range.
			x = bigletters[pos]-'A';
			cols = GetMaxCols(x, fx2);   //max # of cell cols that can be printed
												 //for that horizontal page
			hpages[hpage].numcols = cols;
			hpages[hpage].stletter = x+'A';
			hpages[hpage].numlines = NumOfNonBlankLines(x, y1, x+cols-1, y2);
			hpages[hpage].numpages = ((hpages[hpage].numlines-1) / lpp) +1;
			if(hpages[hpage].numlines == 0) hpages[hpage].numpages =0;
			pos += cols;
			if(hpages[hpage].numpages) hpage++; //if this not a blank page inc
															//the page counter, else use the
															//same page position in the array
															//for the next page.
	  } while (pos<len);




	numhpages = hpage;
	//reduce the total # of horizontal pages to be printed if
	//pages scanning from the extreme right are blank
	for(t = hpage; t>0; t--)
	{
		if(hpages[t-1].numpages) break;
		numhpages--;
	}

	return numhpages;
}
//----------------------------------------------------------------------
// Display a message for the user asking him to press a key before
// printing the next page.
int WaitPage(int p)
{
	int i;
	char buf[50];
	static char *pchar[4] = {"Printer Waiting...",
														 " ",
														 "Print page 1 ?          ",
														 " " };

		  sprintf(buf, "     Print Page %d ?", p);
		  strcpy(&pchar[2][0], buf);
		  a->CursorOn();
		  a->ShowMouse();
		  i = a->ShowDialogBox(&pchar[0], 3, 3, 3, 0);

	return i;
}

//-------------------------------------------------------------------
//Entry:
//	cx = the absolute starting col. It must be a visible one.
// numcols = the r # of visable cols from and including col cx to
//           get text from. if a col is blank, or its cell empty
//           just get that col's width amount of white spaces.
// cy =      the absolute (zero based) line in the spreadsheet to
//           fetch the cell from.
int GetTextForPageLine(int cx, int numcols, int cy)
{
	int i, l, len, x, t, chr, basecol, colour, pos;
	char *p;
	chr = 'A'+cx;
	p = strchr(bigletters, chr);
	if(p == NULL) exit(0);  //error because caller's col not in bigletter

	chr = 'A'+cx;
	p = strchr(bigletters, chr);
	if(p == NULL) exit(0);  //error because caller's col not in bigletter
	basecol = p - bigletters; //the starting pos in the bigletters string
									  //where the caller's col is at.
	memset(printerbuf, ' ', maxplen);
	printerbuf[maxplen] =0;
	pos =0;
	for(t = 0; t< numcols; t++)
	{
		x = bigletters[basecol+t] - 'A';
		i = g->GetLineBuf(linebuf1, linebuf2, x, cy, &colour);
		if(i) //if not blank
		{
			//insert whatever is in linebuf1 into printerbuf at
			//position pos
			len = strlen(linebuf1);
			if((pos+ len) > maxplen) len = maxplen - pos;

			for(l = 0; l < len; l++)
			{
				printerbuf[pos+l] = linebuf1[l];
			}

		}
		//If the cell was blank then there is already blank spaces
		//in printerbuf the width of the blank cell.
		//In any case we position pos to the starting position
		//within printerbuf where the next cell's contents (if any)
		//will begin. But if the next cell is empty and the previous cell's
		//text over shot its own width, then the overshot bit will not be
		//overwritten by the next adjacent cell if that adcacent cell is empty.
		pos += g->colwidths[x];
	}

	return numcols;
}
//-------------------------------------------------------------------
//Print out all the vertical pages within this horizontal page.
//poping up a dialog box after each vertical page to ask if user wants
//to continue. If no don't print any more.
//Entry:
//	out = the pointer to the opened file.
//	hpage = the (zero based horizontal page)
// prevpages = r # of actual pages already printed out
// totpages = total # of pages
// y1 = the offset spreadsheet line to begin printing from.
// Exit:
// 	ax = 27 if user wants print run to stop
//    ax = anything else = ok

int PrintHorizontalPage(FILE *out, int hpage, int previouspages,
												int totpages, int y1, char *namebuf)
{
	int t, pp, cy, chr, line, pagelines;
	int l, x1, numcols, device;
	int baseline;
	char modebuf[10];
	char marginbuf[128];

	int prevp = previouspages;
	baseline =0;      //if its the 2nd page base line = 56
	pagelines =0;     //# of page lines printed out so far
	device =4;		 	//assume output is to a printer

	memset(marginbuf, ' ', lm+1);
	marginbuf[lm] =0;
	strcat(marginbuf,"%s\n\r");
	l = strlen(marginbuf);

	//if its not going to the printer then there is no need for the \r
	//at the end of the line

	if(!strstr(namebuf, "LPT"))  //if "LPT" not in the string assume device is
	{                            //a diskdrive
		marginbuf[l-1] =0;
		device =0; 			//not a printer, output is going to a file
	}


	for(pp = 0; pp < hpages[hpage].numpages; pp++)
	{

		baseline = pp*lpp; 	//if its the second time in the outer loop
									//then baseline = 56
		if(!prevp)
			strcpy(modebuf, "wt");   //new file: open for writing only
		else
			strcpy(modebuf, "a+t");  //open for appending next page to file

		if((out = fopen(namebuf, modebuf)) == NULL)
		{
			fprintf(stderr, "Error: Matrix cannot open the output file to print to it.\n");
			return 27;
		}

		pagelines =0;     //# of page lines printed out so far
		for(line = 0; line < lpp; line++)
		{
			if(pagelines < hpages[hpage].numlines)
			{
				x1 = hpages[hpage].stletter - 'A';
				numcols = hpages[hpage].numcols;
				//fill printerbuf with text from sheet for 1 printer line of cells
				//for that row
				cy = y1+pagelines+baseline;
				GetTextForPageLine(x1, numcols, cy);
				pagelines++;
			}
			else  //print a blank line because less then a full page was printed
			{
				memset(printerbuf, ' ', maxplen);
				printerbuf[maxplen] =0;
			}
			fprintf(out, marginbuf, printerbuf);
		}


		//We have just printed out 56 lines.
		//print out the page number at the foot of the page
		sprintf(linebuf2, "Page %d of %d", previouspages+pp+1, totpages);
		lenbuf2 = strlen(linebuf2);
		t = 40 - (lenbuf2 /2);
		memset(linebuf1, ' ', t);
		linebuf1[t] =0;
		strcat(linebuf1, linebuf2);
		if(device ==4)
			fprintf(out, "\n\r%s%c", linebuf1, 12);
		else
			fprintf(out, "\n%s\n", linebuf1);

		fclose(out);  //close printer channel
		//---

		if(previouspages+pp+1 < totpages && device ==4)  //if there is another page left
		{
			chr = WaitPage(previouspages+pp+2);   //wait for the user to press ok or cancle before
								//printing the next page
			if(chr == 27) goto ex;

		}
		prevp++;
	}// next pp (next vertical page within that horizontal page if any more)

ex:
	return chr;
}
//-------------------------------------------------------------------
//print out all the pages, poping up a dialog box after each page
//to wait for user response
//Exit:
// ax = 1 if error
int NormalPrintOut(int x1, int y1, int x2, int y2, char *namebuf)
{
	int shorterlines;
	FILE *out;

	int i, prevpages, topln, botln, off_set, totalpages;
	int j, t, actuallines, rlines;
	char ch;

	i = GetHorizontalPages(x1, y1, x2, y2);
	if(!i) return i;  //no pages to print out because sheet is blank.


	//count the total number of pages to be printed.
	totalpages =0;
	for(t =0; t< numhpages; t++)
	{
		totalpages += hpages[t].numpages;
	}


	prevpages = 0;
	for(t =0; t < numhpages; t++)
	{
		i = PrintHorizontalPage(out, t, prevpages, totalpages, y1, namebuf);
		prevpages += hpages[t].numpages;
		if( i == 27) break;      //user chose to cancle the print job.
	}


	return 0;
}
//-------------------------------------------------------------------
int PrintOut(int sel, char *namebuf)
{
	int x1, y1, x2, y2;

	if(sel ==1 && g->block.validsw !=0)
	{
		x1 = g->block.x1;
		y1 = g->block.y1;
		x2 = g->block.x2;
		y2 = g->block.y2;
	}
	else //no range selected so print out entire spreadsheet
	{
		x1 =0;
		y1 =0;
		x2 = 25;
		y2 = y99;
	}

	NormalPrintOut(x1, y1, x2, y2, namebuf);

	return 0;
}
//---------------------------------------------------------------------
int PrintText()
{

	int x, l, i, ii, iii, t, ch, lines, cursorfield;
	int xlen, ylen;
	int sel =0;
	static char *pchar[8] = {"Print",
								 "Print to                          ",
								 " ",
								 "( ) Selected Text Only",
								 "( ) Complete Document",
								 " ",
								 " ",
								 " "};


	FILE *out;
	TMousePos MousePos[4];
	x = -3;
	MousePos[0].x1 = 25+x;
	MousePos[0].y1 = 11;
	MousePos[0].x2 = 46+x;
	MousePos[0].y2 = 11;

	MousePos[1].x1 = 25+x;
	MousePos[1].y1 = 12;
	MousePos[1].x2 = 46+x;
	MousePos[1].y2 = 12;

	MousePos[2].x1 = 25-3;
	MousePos[2].y1 = 16;
	MousePos[2].x2 = 32-3;
	MousePos[2].y2 = 16;

	MousePos[3].x1 = 44+3;
	MousePos[3].y1 = 16;
	MousePos[3].x2 = 53+3;
	MousePos[3].y2 = 16;


	//if the block select is on is it really a block range or just
	//a single cell?.
	//if just a single cell ask user if he wants to print out the
	//entire sheet.
	if(g->block.validsw)
	{
		g->TwistBlockVars();
		xlen = (g->block.x2 - g->block.x1)+1;
		ylen = (g->block.y2 - g->block.y1)+1;
		if(ylen+xlen <3) g->block.validsw =0;

	}


	if(g->block.validsw)
	{
		pchar[3][1] = 7;
		pchar[4][1] = 32;
	}
	else
	{
		pchar[3][1] = 32;
		pchar[4][1] = 7;
	}
	//---
	char tempbuf[81];
	strcpy(tempbuf, "F1=Help  Enter=Execute  Esc=Cancel  Tab=Next Field");
	a->WriteLine(tempbuf, 1, 24, 78, gbc[3]*16+gfc[3]);

	//---

	a->CursorOn();
	i = a->ShowDialogBox(&pchar[0], 5, 3, 5, 0, 1);
	strcpy(&linebuf1[1], printerfile);
	linebuf1[0] = 34;
	l = strlen(linebuf1);
	if(l<= 27)
	{
		linebuf1[l] = 34;
		linebuf1[l+1] =0;
	}

	a->WriteLine(linebuf1, 31, 9, 28, LIGHTGRAY*16+BLACK);
	if(pchar[3][1] ==7) cursorfield =0;
	else cursorfield =1;

get:
	switch(cursorfield)  //determine where to show the little cursor
	{
		case 0:
			gotoxy(MousePos[0].x1+2, MousePos[0].y1+1);
			a->m_buttonpressed =0;
			a->m_buttonscursorpos =0;
			a->ShowButtons();
			break;

		case 1:
		  gotoxy(MousePos[1].x1+2, MousePos[1].y1+1);
		  a->m_buttonpressed =0;
			a->m_buttonscursorpos =0;
			a->ShowButtons();
		  break;

		case 2:
		  gotoxy(MousePos[2].x1+4, MousePos[2].y1+1);
		  break;

		case 3:
		  gotoxy(MousePos[3].x1+3, MousePos[3].y1+1);
		  break;
	}





	i = a->WaitGetMouseOrKey();
	//a->ShowCoordinates();

	switch(i)
	{
		case 256:
			goto get;

		case 257:   //click
			ii = a->WhichFieldIsMouseIn2(&MousePos[0], &mouse, 4);
			if(i ==-1) goto get;

			switch(ii)  //a click occurred in a field
			{
				case 0: //clicked in "Selected Text Only"
					if(mouse.ButtonState) //button pressed down
					{
						cursorfield =0;
						a->ColourLine(MousePos[0].x1, MousePos[0].y1, 3, BLACK*16+LIGHTGRAY);
						a->WaitMouseButtonRelease(-1);
a1:				   pchar[3][1] = 7;
						pchar[4][1] =32;
a2:				   a->WriteLine(&pchar[3][0], MousePos[0].x1, MousePos[0].y1, -1, LIGHTGRAY*16+BLACK);
						a->WriteLine(&pchar[4][0], MousePos[1].x1, MousePos[1].y1, -1, LIGHTGRAY*16+BLACK);
						//if(pchar[3][1] ==7) gotoxy(MousePos[0].x1+2, MousePos[0].y1+1);
						//else  gotoxy(MousePos[1].x1+2, MousePos[1].y1+1);

						goto get;
					}
					//click in "Selected Text Only: button released
					//show as selected
					goto a1;

				case 1: //clicked in "Complete Document"
					if(mouse.ButtonState) //button pressed down
					{
						cursorfield =1;
						a->ColourLine(MousePos[1].x1, MousePos[1].y1, 3, BLACK*16+LIGHTGRAY);
						a->WaitMouseButtonRelease(-1);
b1:				   pchar[3][1] = 32;
						pchar[4][1] =7;
						goto a2;

					}
					//click in "Complete Document: button released
					//show as selected
					cursorfield =1;
					goto b1;

				case 2: //clicked in ok button
					if(mouse.ButtonState)  //button pressed
					{
						a->m_buttonpressed =1;
						a->m_buttonscursorpos =0;
						a->ShowButtons();
						gotoxy(MousePos[2].x1+4, MousePos[2].y1+1);
						a->WaitMouseButtonRelease(-1);
						a->m_buttonpressed =0;
						a->ShowButtons();
						gotoxy(MousePos[2].x1+4, MousePos[2].y1+1);

						iii = a->WhichFieldIsMouseIn2(&MousePos[0], &mouse, 4);
						if(iii != 2)   //not released on button
						{
							cursorfield = 2;
							goto get;
						}
						else
							goto con;  //user chose "ok" button

					}
					//released on ok button
					goto get;


				case 3: //clicked in cancel button
					if(mouse.ButtonState)  //button pressed
					{
						a->m_buttonpressed =2;
						a->ShowButtons();
						gotoxy(MousePos[3].x1+3, MousePos[3].y1+1);
						a->WaitMouseButtonRelease(-1);
						a->m_buttonpressed =0;
						a->m_buttonscursorpos =1;
						a->ShowButtons();
						gotoxy(MousePos[3].x1+3, MousePos[3].y1+1);

						iii = a->WhichFieldIsMouseIn2(&MousePos[0], &mouse, 4);
						if(iii != 3)   //not released on button
						{
							cursorfield = 3;
							goto get;
						}
						else
							goto ex;  //user chose "cancel" button

					}
					//a click released on cancel button
					goto get;






				default:
					goto get;

			} //end of switch for a click occurred in a field


		case 9: //user pressed tab  goto next field
			if(cursorfield == 3)
				cursorfield =0;
			else
				cursorfield++;
			if(cursorfield == 3)
			{
				a->m_buttonpressed =0;
				a->m_buttonscursorpos =1;
				a->ShowButtons();

			}
			if(cursorfield==0) goto a1;
			if(cursorfield ==1) goto b1;
			goto get;


		case 13:
			if(cursorfield == 2) goto con;  //hit return on "ok" button
			if(cursorfield == 3) goto ex;   //hit return on "cancel" button
			goto get;

		default:
			goto get;
	}




con:      //user wants to print out something: either selected text or
			 //the complete document
	a->CloseBox();

	//TODO
	//must decide whether to print out complete document or selected text.
	//Must check if selected text valid, else cancle operation

	if(pchar[3][1] ==7) sel =1;
	PrintOut(sel, printerfile);
	goto ex1;
//----------------
//user chose cancel
ex:
	a->CloseBox();
ex1:
	return 0;
}
//--------------------------------------------------------------------
