; font14.asm: Return the correct pointer to the 14-line font.
;
; Jason Hood, 15 February, 2000.
;
; I use AltMode3 to fix a 28-line display (ie. the 14-line font). When I
; upgraded my computer (mach64 to Rage IIc), the Windows blue-screen was
; unreadable. I traced the problem back to AltMode3. It seems some BIOS cards
; return a pointer to the 16-line font, when the 14-line font was requested.
; This program solves the problem by converting the 16-line font to 14 lines.
; It does so by removing the top and bottom lines of each character and
; patching the 14-line font interrupt request.
;
; Usage: font14 [t|i|l|u|r]
;
; No parameters will detect which font is returned and install if necessary.
;   If unnecessary it will display a message suggesting the use of 't'.
; 't' will set the 14-line font according to what was returned. Use "mode co80"
;   (or another font-setting utility) to restore the screen.
; 'i' will unconditionally install, in case the detection fails.
; 'l' will unconditionally install, but using top end of low memory.
; 'u' or 'r' will uninstall or remove Font14 from memory.
;
; Contact: jadoxa@hotmail.com
;	   http://adoxa.homepage.com/tm/

	.model	tiny
	.code
	.286
	org	100h

CRLF	equ	<13, 10>
EOL	equ	<13, 10, '$'>

font14:
	jmp	main
	db	8, 8, 8 	; For people that like to TYPE .com files

helpstr db	"Font14 v1.0, by Jason Hood.", CRLF
	db	"15 February, 2000. Freeware.", CRLF
	db	"jadoxa@hotmail.com. http://adoxa.homepage.com/tm/", CRLF
	db	CRLF
	db	"Usage: font14 [t|i|l|r|u]", CRLF
	db	CRLF
	db	"t - Test the 14-line font", CRLF
	db	"i - Force install", CRLF
	db	"l - Force install (top of low memory)", CRLF
	db	"r - Remove from memory", CRLF
	db	"u - Uninstall (same as 'r')", EOL

	db	8, ' ', 26


NOWARN ALN
align	16				; Below needs to be paragraph-aligned
resident_begin	label byte


new_int_10 proc far
	cmp	ax,1130h		; Get font information
	je	is_font
exit:	db	0eah ; jmp far
old_10	dw	?, ?

is_font:
	cmp	bh,2			; 14-line font?
	jne	exit

	pushf
	call	cs:dword ptr old_10	; Setup return parameters
	push	cs
	pop	es
	mov	bp,offset font
	iret
new_int_10 endp

font	db	14 * 256 dup (?)	; The "new" 14-line font


resident_end label byte
resident_len = resident_end - resident_begin


intdos	MACRO	function, service
	IFB	<service>
	mov	ah, function
	ELSE
	mov	ax, (function shl 8) + service
	ENDIF
	int	21h
	ENDM

print	MACRO	string
	push	cs
	pop	ds			; Ensure DS is correct
	IFNB	<string>
	mov	dx, offset string
	ENDIF
	intdos	9
	intdos	4ch, 0
	ENDM

MCBName db	"Font14", 0, 0

notstr	db	"It doesn't look like you'll need this program.", CRLF
	db	"Try running with parameter 't'; if the screen", CRLF
	db	'becomes garbled type "mode co80" to restore it', CRLF
	db	"and then run with parameter 'i' or 'l'.", EOL

teststr db	"14-line font in use.", EOL

istr	db	"Font14 is now installed.", EOL
rstr	db	"Font14 has been removed.", EOL
oopsstr db	"Font14 cannot be removed at the moment.", EOL

main:
	mov	si,81h
param:
	lodsb
	cmp	al,' '
	je	param
	cmp	al,9
	je	param
	cmp	al,'-'
	je	param
	cmp	al,'/'
	je	param

	cmp	al,'?'
	jne	not_help
	print	helpstr

not_help:
	or	al,20h
	cmp	al,'u'
	je	remove
	cmp	al,'r'
	je	remove

	push	ax
	mov	bh,2		; Get the pointer to the BIOS
	mov	ax,1130h	;  14-line font in ES:BP.
	int	10h
	pop	ax

	cmp	al,'t'
	je	tester
	cmp	al,'l'
	jne	try_i
	dec	byte ptr umbs
	inc	byte ptr topmem
	jmp	install
try_i:
	cmp	al,'i'
	je	install

	; 112 is the start of character 7 for 16, character 8 for 14.
	; Character 7 should start with a blank line, character 8 with a solid.
	; If 112 is a zero, it's a blank line, so it is really the 16.
	; (Yeah, I could get the 16-line pointer and compare it with the
	;  14-line, but where's the fun in that?)
	cmp	byte ptr es:[bp+112],0
	je	install
	print	notstr

tester:
	push	ds es
	pop	ds es
	mov	si,bp		; DS:SI -> BIOS font
	mov	di,offset font	; ES:DI -> our copy
	mov	bp,di
	mov	cx,256 * 14 / 2
	rep	movsw
	mov	ax,1110h 	; Set user-specified pattern
	mov	bx,0e00h	; 14 lines, block 0
	xor	dx,dx		; First character is 0
	mov	cx,256		; 256 characters
	int	10h		; ES:BP points to the font
	print	teststr

remove:
	intdos	35h, 10h	; Retrieve the current int 10 vector
	mov	ax,es
	push	ax
	shr	bx,4
	add	ax,bx
	dec	ax		; Should be the MCB of Font14
	mov	es,ax
	mov	si,offset MCBName
	mov	di,8
	mov	cx,4
	repe	cmpsw		; Match the name
	mov	dx,offset oopsstr
	jne	oops		;  or not
	inc	ax
	mov	es,ax
	pop	ds
	lds	dx,dword ptr old_10
	intdos	25h, 10h	; Restore the original vector
	intdos	49h		; Free the memory
	mov	dx,offset rstr
oops:
	print

install:
	push	ds es
	pop	ds es
	mov	si,bp		; DS:SI -> BIOS font
	mov	di,offset font	; ES:DI -> our copy
	mov	ax,256		; 256 characters
copy:
	inc	si		; Skip the top line
	mov	cx,7
	rep	movsw
	inc	si		; Skip the bottom line
	dec	ax
	jnz	copy
	push	cs
	pop	ds

	mov	bx, 1000h	; Make the program the 64k it should be
	intdos	4ah

	intdos	58h, 2		; Get current UMB state
	push	ax		;  and save it
	intdos	58h, 0		; Get current allocation strategy
	push	ax		;  and save it
	mov	bx, 1		; Link in UMB (turn it off if using low memory)
umbs	equ	$ - 2
	intdos	58h, 3
strat:
	mov	bx, 1		; Best fit (last fit if using low memory)
topmem	equ	$ - 2
	intdos	58h, 1
	mov	bx, (resident_len + 15) shr 4
	intdos	48h			; Allocate the memory
	dec	ax
	mov	es,ax			; The MCB of the newly allocated memory
	inc	ax
	mov	word ptr es:[1],ax	; Make the memory block own itself
	pop	bx			; Restore allocation strategy
	intdos	58h, 1
	pop	bx			; Restore UMB state
	intdos	58h, 3

	mov	si,offset MCBName	; Change the MCB name
	mov	di,8			;  (I think lowercase looks better)
	movsw
	movsw
	movsw
	movsw

	mov	ax,es
	mov	bx,offset resident_begin
	shr	bx,4			; Adjust the segment to reflect the
	dec	bx			; offset (eg. E556:0000 = E542:0140)
	sub	ax,bx
	push	ax			; Remember resident segment

	intdos	35h, 10h		; Remember the old interrupt 10
	mov	old_10,bx
	mov	old_10+2,es

	pop	es			; Retrieve resident segment for reloc
	push	es			; Remember it again for int10
	mov	si,offset resident_begin	; Relocate
	mov	di,si
	mov	cx,resident_len
	rep	movsb

	mov	dx,offset new_int_10	; Point to the new interrupt 10
	pop	ds			; in the resident segment
	intdos	25h, 10h

	print	istr

end	font14
