/*
  tmfont.c: Font information for tm.c.

  Jason Hood, 30 September, 1999.

  font6 is from font58.asm, uncredited, from the Assembly Snippets, version 4.0.

  font12 is from my old mach64 BIOS, converted from the 14-line font (which
  is what the new Rage IIc does to 16 to get 14).
*/

typedef unsigned char Byte;

Byte font12[] =
{
  0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 0
  0x00, 0x7e,0x81,0xa5,0x81,0x81, 0xbd,0x99,0x81,0x7e,0x00, 0x00,	// 1
  0x00, 0x7e,0xff,0xdb,0xff,0xff, 0xc3,0xe7,0xff,0x7e,0x00, 0x00,	// 2
  0x00, 0x00,0x6c,0xee,0xfe,0xfe, 0xfe,0x7c,0x38,0x10,0x00, 0x00,	// 3
  0x00, 0x00,0x10,0x38,0x7c,0xfe, 0x7c,0x38,0x10,0x00,0x00, 0x00,	// 4
  0x00, 0x00,0x10,0x38,0x10,0x6c, 0xee,0x6c,0x10,0x38,0x00, 0x00,	// 5
  0x00, 0x10,0x38,0x7c,0x7c,0xfe, 0xfe,0x6c,0x10,0x38,0x00, 0x00,	// 6
  0x00, 0x00,0x00,0x00,0x18,0x3c, 0x3c,0x18,0x00,0x00,0x00, 0x00,	// 7
  0xff, 0xff,0xff,0xff,0xe7,0xc3, 0xc3,0xe7,0xff,0xff,0xff, 0xff,	// 8
  0x00, 0x00,0x00,0x18,0x3c,0x66, 0x66,0x3c,0x18,0x00,0x00, 0x00,	// 9
  0xff, 0xff,0xff,0xe7,0xc3,0x99, 0x99,0xc3,0xe7,0xff,0xff, 0xff,	// 10
  0x00, 0x1e,0x0e,0x1e,0x36,0x78, 0xcc,0xcc,0xcc,0x78,0x00, 0x00,	// 11
  0x00, 0x3c,0x66,0x66,0x66,0x3c, 0x18,0x7e,0x18,0x18,0x00, 0x00,	// 12
  0x00, 0x1e,0x1a,0x1e,0x18,0x18, 0x18,0x78,0xf8,0x70,0x00, 0x00,	// 13
  0x3e, 0x36,0x3e,0x36,0x36,0x76, 0xf6,0x66,0x0e,0x1e,0x0c, 0x00,	// 14
  0x18, 0xdb,0x7e,0x3c,0x66,0x66, 0x3c,0x7e,0xdb,0x18,0x00, 0x00,	// 15
  0x00, 0x80,0xe0,0xf0,0xfc,0xfe, 0xfc,0xf0,0xe0,0x80,0x00, 0x00,	// 16
  0x00, 0x02,0x0e,0x3e,0x7e,0xfe, 0x7e,0x3e,0x0e,0x02,0x00, 0x00,	// 17
  0x00, 0x18,0x3c,0x7e,0x18,0x18, 0x18,0x7e,0x3c,0x18,0x00, 0x00,	// 18
  0x00, 0x66,0x66,0x66,0x66,0x66, 0x66,0x00,0x66,0x66,0x00, 0x00,	// 19
  0x00, 0x7f,0xdb,0xdb,0xdb,0x7b, 0x1b,0x1b,0x1b,0x1b,0x00, 0x00,	// 20
  0x7c, 0xc6,0xc6,0x60,0x7c,0xf6, 0xde,0x7c,0x0c,0xc6,0xc6, 0x7c,	// 21
  0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,0xfe,0xfe,0xfe,0x00, 0x00,	// 22
  0x00, 0x18,0x3c,0x7e,0x18,0x18, 0x7e,0x3c,0x18,0x7e,0x00, 0x00,	// 23
  0x00, 0x18,0x3c,0x7e,0x18,0x18, 0x18,0x18,0x18,0x18,0x00, 0x00,	// 24
  0x00, 0x18,0x18,0x18,0x18,0x18, 0x18,0x7e,0x3c,0x18,0x00, 0x00,	// 25
  0x00, 0x00,0x00,0x0c,0x0e,0xff, 0x0e,0x0c,0x00,0x00,0x00, 0x00,	// 26
  0x00, 0x00,0x00,0x30,0x70,0xfe, 0x70,0x30,0x00,0x00,0x00, 0x00,	// 27
  0x00, 0x00,0x00,0x00,0xc0,0xc0, 0xc0,0xfe,0x00,0x00,0x00, 0x00,	// 28
  0x00, 0x00,0x00,0x24,0x66,0xff, 0x66,0x24,0x00,0x00,0x00, 0x00,	// 29
  0x00, 0x10,0x38,0x38,0x38,0x7c, 0x7c,0xfe,0xfe,0x00,0x00, 0x00,	// 30
  0x00, 0xfe,0xfe,0x7c,0x7c,0x7c, 0x38,0x38,0x10,0x00,0x00, 0x00,	// 31
  0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 32
  0x00, 0x18,0x3c,0x3c,0x3c,0x18, 0x18,0x00,0x18,0x18,0x00, 0x00,	// 33
  0x36, 0x36,0x36,0x14,0x00,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 34
  0x00, 0x6c,0x6c,0x6c,0xfe,0x6c, 0x6c,0xfe,0x6c,0x6c,0x00, 0x00,	// 35
  0x18, 0x18,0x7c,0xc6,0xc0,0x78, 0x3c,0x06,0xc6,0x7c,0x18, 0x18,	// 36
  0x00, 0x00,0x00,0x62,0x66,0x0c, 0x18,0x30,0x66,0xc6,0x00, 0x00,	// 37
  0x00, 0x38,0x6c,0x38,0x38,0x76, 0xf6,0xce,0xcc,0x76,0x00, 0x00,	// 38
  0x0c, 0x0c,0x0c,0x18,0x00,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 39
  0x00, 0x0c,0x18,0x30,0x30,0x30, 0x30,0x30,0x18,0x0c,0x00, 0x00,	// 40
  0x00, 0x30,0x18,0x0c,0x0c,0x0c, 0x0c,0x0c,0x18,0x30,0x00, 0x00,	// 41
  0x00, 0x00,0x00,0x6c,0x38,0xfe, 0x38,0x6c,0x00,0x00,0x00, 0x00,	// 42
  0x00, 0x00,0x00,0x18,0x18,0x7e, 0x18,0x18,0x00,0x00,0x00, 0x00,	// 43
  0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,0x0c,0x0c,0x0c,0x18, 0x00,	// 44
  0x00, 0x00,0x00,0x00,0x00,0xfe, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 45
  0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x18,0x18,0x00, 0x00,	// 46
  0x00, 0x00,0x02,0x06,0x0c,0x18, 0x30,0x60,0xc0,0x80,0x00, 0x00,	// 47
  0x00, 0x7c,0xc6,0xce,0xde,0xf6, 0xe6,0xc6,0xc6,0x7c,0x00, 0x00,	// 48
  0x00, 0x18,0x78,0x18,0x18,0x18, 0x18,0x18,0x18,0x7e,0x00, 0x00,	// 49
  0x00, 0x7c,0xc6,0xc6,0x0c,0x18, 0x30,0x60,0xc6,0xfe,0x00, 0x00,	// 50
  0x00, 0x7c,0xc6,0x06,0x06,0x3c, 0x06,0x06,0xc6,0x7c,0x00, 0x00,	// 51
  0x00, 0x0c,0x1c,0x3c,0x6c,0xcc, 0xfe,0x0c,0x0c,0x0c,0x00, 0x00,	// 52
  0x00, 0xfe,0xc0,0xc0,0xc0,0xfc, 0x06,0x06,0xc6,0x7c,0x00, 0x00,	// 53
  0x00, 0x7c,0xc6,0xc0,0xc0,0xfc, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 54
  0x00, 0xfe,0xc6,0x0c,0x18,0x30, 0x30,0x30,0x30,0x30,0x00, 0x00,	// 55
  0x00, 0x7c,0xc6,0xc6,0xc6,0x7c, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 56
  0x00, 0x7c,0xc6,0xc6,0xc6,0x7e, 0x06,0x06,0xc6,0x7c,0x00, 0x00,	// 57
  0x00, 0x00,0x00,0x0c,0x0c,0x00, 0x00,0x0c,0x0c,0x00,0x00, 0x00,	// 58
  0x00, 0x00,0x00,0x0c,0x0c,0x00, 0x00,0x0c,0x0c,0x0c,0x18, 0x00,	// 59
  0x00, 0x0c,0x18,0x30,0x60,0xc0, 0x60,0x30,0x18,0x0c,0x00, 0x00,	// 60
  0x00, 0x00,0x00,0x00,0xfe,0x00, 0xfe,0x00,0x00,0x00,0x00, 0x00,	// 61
  0x00, 0x60,0x30,0x18,0x0c,0x06, 0x0c,0x18,0x30,0x60,0x00, 0x00,	// 62
  0x00, 0x7c,0xc6,0xc6,0x0c,0x18, 0x18,0x00,0x18,0x18,0x00, 0x00,	// 63
  0x00, 0x7c,0xc6,0xc6,0xde,0xde, 0xde,0xdc,0xc0,0x7e,0x00, 0x00,	// 64
  0x00, 0x38,0x6c,0xc6,0xc6,0xc6, 0xfe,0xc6,0xc6,0xc6,0x00, 0x00,	// 65
  0x00, 0xfc,0x66,0x66,0x66,0x7c, 0x66,0x66,0x66,0xfc,0x00, 0x00,	// 66
  0x00, 0x3c,0x66,0xc0,0xc0,0xc0, 0xc0,0xc0,0x66,0x3c,0x00, 0x00,	// 67
  0x00, 0xf8,0x6c,0x66,0x66,0x66, 0x66,0x66,0x6c,0xf8,0x00, 0x00,	// 68
  0x00, 0xfe,0x66,0x60,0x60,0x7c, 0x60,0x60,0x66,0xfe,0x00, 0x00,	// 69
  0x00, 0xfe,0x66,0x60,0x60,0x7c, 0x60,0x60,0x60,0xf0,0x00, 0x00,	// 70
  0x00, 0x7c,0xc6,0xc6,0xc0,0xc0, 0xce,0xc6,0xc6,0x7c,0x00, 0x00,	// 71
  0x00, 0xc6,0xc6,0xc6,0xc6,0xfe, 0xc6,0xc6,0xc6,0xc6,0x00, 0x00,	// 72
  0x00, 0x3c,0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x3c,0x00, 0x00,	// 73
  0x00, 0x3c,0x18,0x18,0x18,0x18, 0x18,0xd8,0xd8,0x70,0x00, 0x00,	// 74
  0x00, 0xc6,0xcc,0xd8,0xf0,0xf0, 0xd8,0xcc,0xc6,0xc6,0x00, 0x00,	// 75
  0x00, 0xf0,0x60,0x60,0x60,0x60, 0x60,0x62,0x66,0xfe,0x00, 0x00,	// 76
  0x00, 0xc6,0xc6,0xee,0xfe,0xd6, 0xd6,0xd6,0xc6,0xc6,0x00, 0x00,	// 77
  0x00, 0xc6,0xc6,0xe6,0xe6,0xf6, 0xde,0xce,0xce,0xc6,0x00, 0x00,	// 78
  0x00, 0x7c,0xc6,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 79
  0x00, 0xfc,0x66,0x66,0x66,0x7c, 0x60,0x60,0x60,0xf0,0x00, 0x00,	// 80
  0x00, 0x7c,0xc6,0xc6,0xc6,0xc6, 0xc6,0xc6,0xd6,0x7c,0x06, 0x00,	// 81
  0x00, 0xfc,0x66,0x66,0x66,0x7c, 0x78,0x6c,0x66,0xe6,0x00, 0x00,	// 82
  0x00, 0x7c,0xc6,0xc0,0x60,0x38, 0x0c,0x06,0xc6,0x7c,0x00, 0x00,	// 83
  0x00, 0x7e,0x5a,0x18,0x18,0x18, 0x18,0x18,0x18,0x3c,0x00, 0x00,	// 84
  0x00, 0xc6,0xc6,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 85
  0x00, 0xc6,0xc6,0xc6,0xc6,0xc6, 0xc6,0x6c,0x38,0x10,0x00, 0x00,	// 86
  0x00, 0xc6,0xc6,0xd6,0xd6,0xd6, 0xfe,0xee,0xc6,0xc6,0x00, 0x00,	// 87
  0x00, 0xc6,0xc6,0x6c,0x38,0x38, 0x38,0x6c,0xc6,0xc6,0x00, 0x00,	// 88
  0x00, 0x66,0x66,0x66,0x66,0x3c, 0x18,0x18,0x18,0x3c,0x00, 0x00,	// 89
  0x00, 0xfe,0xc6,0x8c,0x18,0x30, 0x60,0xc2,0xc6,0xfe,0x00, 0x00,	// 90
  0x00, 0x7c,0x60,0x60,0x60,0x60, 0x60,0x60,0x60,0x7c,0x00, 0x00,	// 91
  0x00, 0x00,0x80,0xc0,0x60,0x30, 0x18,0x0c,0x06,0x02,0x00, 0x00,	// 92
  0x00, 0x7c,0x0c,0x0c,0x0c,0x0c, 0x0c,0x0c,0x0c,0x7c,0x00, 0x00,	// 93
  0x10, 0x38,0x6c,0xc6,0x00,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 94
  0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00, 0xff,	// 95
  0x18, 0x18,0x18,0x0c,0x00,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 96
  0x00, 0x00,0x00,0x00,0x78,0x0c, 0x7c,0xcc,0xdc,0x76,0x00, 0x00,	// 97
  0x00, 0xe0,0x60,0x60,0x7c,0x66, 0x66,0x66,0x66,0xfc,0x00, 0x00,	// 98
  0x00, 0x00,0x00,0x00,0x7c,0xc6, 0xc0,0xc0,0xc6,0x7c,0x00, 0x00,	// 99
  0x00, 0x1c,0x0c,0x0c,0x7c,0xcc, 0xcc,0xcc,0xcc,0x7e,0x00, 0x00,	// 100
  0x00, 0x00,0x00,0x00,0x7c,0xc6, 0xfe,0xc0,0xc6,0x7c,0x00, 0x00,	// 101
  0x00, 0x1c,0x36,0x30,0x30,0xfc, 0x30,0x30,0x30,0x78,0x00, 0x00,	// 102
  0x00, 0x00,0x00,0x00,0x76,0xce, 0xc6,0xc6,0x7e,0x06,0xc6, 0x7c,	// 103
  0x00, 0xe0,0x60,0x60,0x6c,0x76, 0x66,0x66,0x66,0xe6,0x00, 0x00,	// 104
  0x00, 0x18,0x18,0x00,0x38,0x18, 0x18,0x18,0x18,0x3c,0x00, 0x00,	// 105
  0x00, 0x0c,0x0c,0x00,0x1c,0x0c, 0x0c,0x0c,0x0c,0xcc,0xcc, 0x78,	// 106
  0x00, 0xe0,0x60,0x60,0x66,0x6c, 0x78,0x6c,0x66,0xe6,0x00, 0x00,	// 107
  0x00, 0x18,0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x1c,0x00, 0x00,	// 108
  0x00, 0x00,0x00,0x00,0x6c,0xfe, 0xd6,0xd6,0xc6,0xc6,0x00, 0x00,	// 109
  0x00, 0x00,0x00,0x00,0xdc,0x66, 0x66,0x66,0x66,0x66,0x00, 0x00,	// 110
  0x00, 0x00,0x00,0x00,0x7c,0xc6, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 111
  0x00, 0x00,0x00,0x00,0xdc,0x66, 0x66,0x66,0x7c,0x60,0x60, 0xf0,	// 112
  0x00, 0x00,0x00,0x00,0x76,0xcc, 0xcc,0xcc,0x7c,0x0c,0x0c, 0x1e,	// 113
  0x00, 0x00,0x00,0x00,0xdc,0x66, 0x60,0x60,0x60,0xf0,0x00, 0x00,	// 114
  0x00, 0x00,0x00,0x00,0x7c,0xc6, 0x70,0x1c,0xc6,0x7c,0x00, 0x00,	// 115
  0x00, 0x30,0x30,0x30,0xfc,0x30, 0x30,0x30,0x36,0x1c,0x00, 0x00,	// 116
  0x00, 0x00,0x00,0x00,0xcc,0xcc, 0xcc,0xcc,0xcc,0x76,0x00, 0x00,	// 117
  0x00, 0x00,0x00,0x00,0xc6,0xc6, 0xc6,0x6c,0x38,0x10,0x00, 0x00,	// 118
  0x00, 0x00,0x00,0x00,0xc6,0xc6, 0xd6,0xd6,0xfe,0x6c,0x00, 0x00,	// 119
  0x00, 0x00,0x00,0x00,0xc6,0x6c, 0x38,0x38,0x6c,0xc6,0x00, 0x00,	// 120
  0x00, 0x00,0x00,0x00,0xc6,0xc6, 0xc6,0xce,0x76,0x06,0xc6, 0x7c,	// 121
  0x00, 0x00,0x00,0x00,0xfe,0x8c, 0x18,0x30,0x62,0xfe,0x00, 0x00,	// 122
  0x00, 0x0e,0x18,0x18,0x18,0x70, 0x18,0x18,0x18,0x0e,0x00, 0x00,	// 123
  0x00, 0x18,0x18,0x18,0x18,0x00, 0x18,0x18,0x18,0x18,0x00, 0x00,	// 124
  0x00, 0x70,0x18,0x18,0x18,0x0e, 0x18,0x18,0x18,0x70,0x00, 0x00,	// 125
  0x00, 0x76,0xdc,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 126
  0x00, 0x00,0x00,0x10,0x38,0x38, 0x6c,0x6c,0xfe,0x00,0x00, 0x00,	// 127
  0x00, 0x3c,0x66,0xc0,0xc0,0xc0, 0xc6,0x66,0x3c,0x18,0xcc, 0x38,	// 128
  0x00, 0xc6,0x00,0x00,0xc6,0xc6, 0xc6,0xc6,0xce,0x76,0x00, 0x00,	// 129
  0x0c, 0x18,0x30,0x00,0x7c,0xc6, 0xfe,0xc0,0xc6,0x7c,0x00, 0x00,	// 130
  0x30, 0x78,0xcc,0x00,0x78,0x0c, 0x7c,0xcc,0xdc,0x76,0x00, 0x00,	// 131
  0x00, 0xcc,0x00,0x00,0x78,0x0c, 0x7c,0xcc,0xdc,0x76,0x00, 0x00,	// 132
  0x60, 0x30,0x18,0x00,0x78,0x0c, 0x7c,0xcc,0xdc,0x76,0x00, 0x00,	// 133
  0x38, 0x6c,0x38,0x00,0x78,0x0c, 0x7c,0xcc,0xdc,0x76,0x00, 0x00,	// 134
  0x00, 0x00,0x00,0x7c,0xc6,0xc0, 0xc0,0xc6,0x7c,0x18,0x6c, 0x38,	// 135
  0x30, 0x78,0xcc,0x00,0x7c,0xc6, 0xfe,0xc0,0xc6,0x7c,0x00, 0x00,	// 136
  0x00, 0xcc,0x00,0x00,0x7c,0xc6, 0xfe,0xc0,0xc6,0x7c,0x00, 0x00,	// 137
  0x30, 0x18,0x0c,0x00,0x7c,0xc6, 0xfe,0xc0,0xc6,0x7c,0x00, 0x00,	// 138
  0x00, 0x66,0x00,0x00,0x38,0x18, 0x18,0x18,0x18,0x3c,0x00, 0x00,	// 139
  0x18, 0x3c,0x66,0x00,0x38,0x18, 0x18,0x18,0x18,0x3c,0x00, 0x00,	// 140
  0x60, 0x30,0x18,0x00,0x38,0x18, 0x18,0x18,0x18,0x3c,0x00, 0x00,	// 141
  0xc6, 0x00,0x38,0x6c,0xc6,0xc6, 0xfe,0xc6,0xc6,0xc6,0x00, 0x00,	// 142
  0x6c, 0x38,0x00,0x38,0x6c,0xc6, 0xc6,0xfe,0xc6,0xc6,0x00, 0x00,	// 143
  0x18, 0x30,0x00,0xfe,0x60,0x60, 0x7c,0x60,0x60,0xfe,0x00, 0x00,	// 144
  0x00, 0x00,0x00,0x66,0xdb,0x1b, 0x7f,0xd8,0xdf,0x76,0x00, 0x00,	// 145
  0x7e, 0xd8,0xd8,0xd8,0xd8,0xfe, 0xd8,0xd8,0xd8,0xde,0x00, 0x00,	// 146
  0x30, 0x78,0xcc,0x00,0x7c,0xc6, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 147
  0x00, 0xc6,0x00,0x00,0x7c,0xc6, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 148
  0x30, 0x18,0x0c,0x00,0x7c,0xc6, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 149
  0x30, 0x78,0xcc,0x00,0xc6,0xc6, 0xc6,0xc6,0xce,0x76,0x00, 0x00,	// 150
  0x60, 0x30,0x18,0x00,0xc6,0xc6, 0xc6,0xc6,0xce,0x76,0x00, 0x00,	// 151
  0x00, 0xc6,0x00,0x00,0xc6,0xc6, 0xc6,0xce,0x76,0x06,0xc6, 0x7c,	// 152
  0xc6, 0x00,0x7c,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 153
  0xc6, 0x00,0xc6,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 154
  0x18, 0x18,0x3c,0x66,0x60,0x60, 0x66,0x3c,0x18,0x18,0x00, 0x00,	// 155
  0x00, 0x38,0x6c,0x60,0x60,0xf0, 0x60,0x66,0xf6,0x6c,0x00, 0x00,	// 156
  0x00, 0x66,0x66,0x3c,0x18,0x7e, 0x18,0x3c,0x18,0x18,0x00, 0x00,	// 157
  0xfc, 0xc6,0xfc,0xc0,0xcc,0xde, 0xcc,0xcc,0xcc,0xc6,0x00, 0x00,	// 158
  0x0e, 0x1b,0x18,0x18,0x18,0x7e, 0x18,0x18,0x18,0x18,0xd8, 0x70,	// 159
  0x0c, 0x18,0x30,0x00,0x78,0x0c, 0x7c,0xcc,0xdc,0x76,0x00, 0x00,	// 160
  0x0c, 0x18,0x30,0x00,0x38,0x18, 0x18,0x18,0x18,0x3c,0x00, 0x00,	// 161
  0x0c, 0x18,0x30,0x00,0x7c,0xc6, 0xc6,0xc6,0xc6,0x7c,0x00, 0x00,	// 162
  0x18, 0x30,0x60,0x00,0xcc,0xcc, 0xcc,0xcc,0xdc,0x76,0x00, 0x00,	// 163
  0x00, 0x76,0xdc,0x00,0xbc,0x66, 0x66,0x66,0x66,0xe6,0x00, 0x00,	// 164
  0x76, 0xdc,0x00,0xc6,0xc6,0xe6, 0xf6,0xde,0xce,0xc6,0x00, 0x00,	// 165
  0x3c, 0x6c,0x6c,0x3e,0x00,0x7e, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 166
  0x38, 0x6c,0x6c,0x38,0x00,0x7c, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 167
  0x00, 0x30,0x30,0x00,0x30,0x30, 0x60,0xc6,0xc6,0x7c,0x00, 0x00,	// 168
  0x00, 0x00,0x00,0x00,0x00,0x7e, 0x60,0x60,0x60,0x00,0x00, 0x00,	// 169
  0x00, 0x00,0x00,0x00,0x00,0x7e, 0x06,0x06,0x06,0x00,0x00, 0x00,	// 170
  0x60, 0x62,0x66,0x6c,0x18,0x30, 0x60,0xdc,0x36,0x0c,0x18, 0x3e,	// 171
  0x60, 0x62,0x66,0x6c,0x18,0x36, 0x6e,0xde,0x36,0x7e,0x06, 0x06,	// 172
  0x00, 0x18,0x18,0x00,0x18,0x18, 0x3c,0x3c,0x3c,0x18,0x00, 0x00,	// 173
  0x00, 0x00,0x00,0x36,0x6c,0xd8, 0x6c,0x36,0x00,0x00,0x00, 0x00,	// 174
  0x00, 0x00,0x00,0xd8,0x6c,0x36, 0x6c,0xd8,0x00,0x00,0x00, 0x00,	// 175
  0x44, 0x11,0x44,0x11,0x44,0x11, 0x44,0x11,0x44,0x11,0x44, 0x11,	// 176
  0xaa, 0x55,0xaa,0x55,0xaa,0x55, 0xaa,0x55,0xaa,0x55,0xaa, 0x55,	// 177
  0x77, 0xdd,0x77,0xdd,0x77,0xdd, 0x77,0xdd,0x77,0xdd,0x77, 0xdd,	// 178
  0x18, 0x18,0x18,0x18,0x18,0x18, 0x18,0x18,0x18,0x18,0x18, 0x18,	// 179
  0x18, 0x18,0x18,0x18,0x18,0x18, 0xf8,0x18,0x18,0x18,0x18, 0x18,	// 180
  0x18, 0x18,0x18,0x18,0xf8,0x18, 0xf8,0x18,0x18,0x18,0x18, 0x18,	// 181
  0x36, 0x36,0x36,0x36,0x36,0x36, 0xf6,0x36,0x36,0x36,0x36, 0x36,	// 182
  0x00, 0x00,0x00,0x00,0x00,0x00, 0xfe,0x36,0x36,0x36,0x36, 0x36,	// 183
  0x00, 0x00,0x00,0x00,0xf8,0x18, 0xf8,0x18,0x18,0x18,0x18, 0x18,	// 184
  0x36, 0x36,0x36,0x36,0xf6,0x06, 0xf6,0x36,0x36,0x36,0x36, 0x36,	// 185
  0x36, 0x36,0x36,0x36,0x36,0x36, 0x36,0x36,0x36,0x36,0x36, 0x36,	// 186
  0x00, 0x00,0x00,0x00,0xfe,0x06, 0xf6,0x36,0x36,0x36,0x36, 0x36,	// 187
  0x36, 0x36,0x36,0x36,0xf6,0x06, 0xfe,0x00,0x00,0x00,0x00, 0x00,	// 188
  0x36, 0x36,0x36,0x36,0x36,0x36, 0xfe,0x00,0x00,0x00,0x00, 0x00,	// 189
  0x18, 0x18,0x18,0x18,0xf8,0x18, 0xf8,0x00,0x00,0x00,0x00, 0x00,	// 190
  0x00, 0x00,0x00,0x00,0x00,0x00, 0xf8,0x18,0x18,0x18,0x18, 0x18,	// 191
  0x18, 0x18,0x18,0x18,0x18,0x18, 0x1f,0x00,0x00,0x00,0x00, 0x00,	// 192
  0x18, 0x18,0x18,0x18,0x18,0x18, 0xff,0x00,0x00,0x00,0x00, 0x00,	// 193
  0x00, 0x00,0x00,0x00,0x00,0x00, 0xff,0x18,0x18,0x18,0x18, 0x18,	// 194
  0x18, 0x18,0x18,0x18,0x18,0x18, 0x1f,0x18,0x18,0x18,0x18, 0x18,	// 195
  0x00, 0x00,0x00,0x00,0x00,0x00, 0xff,0x00,0x00,0x00,0x00, 0x00,	// 196
  0x18, 0x18,0x18,0x18,0x18,0x18, 0xff,0x18,0x18,0x18,0x18, 0x18,	// 197
  0x18, 0x18,0x18,0x18,0x1f,0x18, 0x1f,0x18,0x18,0x18,0x18, 0x18,	// 198
  0x36, 0x36,0x36,0x36,0x36,0x36, 0x37,0x36,0x36,0x36,0x36, 0x36,	// 199
  0x36, 0x36,0x36,0x36,0x37,0x30, 0x3f,0x00,0x00,0x00,0x00, 0x00,	// 200
  0x00, 0x00,0x00,0x00,0x3f,0x30, 0x37,0x36,0x36,0x36,0x36, 0x36,	// 201
  0x36, 0x36,0x36,0x36,0xf7,0x00, 0xff,0x00,0x00,0x00,0x00, 0x00,	// 202
  0x00, 0x00,0x00,0x00,0xff,0x00, 0xf7,0x36,0x36,0x36,0x36, 0x36,	// 203
  0x36, 0x36,0x36,0x36,0x37,0x30, 0x37,0x36,0x36,0x36,0x36, 0x36,	// 204
  0x00, 0x00,0x00,0x00,0xff,0x00, 0xff,0x00,0x00,0x00,0x00, 0x00,	// 205
  0x36, 0x36,0x36,0x36,0xf7,0x00, 0xf7,0x36,0x36,0x36,0x36, 0x36,	// 206
  0x18, 0x18,0x18,0x18,0xff,0x00, 0xff,0x00,0x00,0x00,0x00, 0x00,	// 207
  0x36, 0x36,0x36,0x36,0x36,0x36, 0xff,0x00,0x00,0x00,0x00, 0x00,	// 208
  0x00, 0x00,0x00,0x00,0xff,0x00, 0xff,0x18,0x18,0x18,0x18, 0x18,	// 209
  0x00, 0x00,0x00,0x00,0x00,0x00, 0xff,0x36,0x36,0x36,0x36, 0x36,	// 210
  0x36, 0x36,0x36,0x36,0x36,0x36, 0x3f,0x00,0x00,0x00,0x00, 0x00,	// 211
  0x18, 0x18,0x18,0x18,0x1f,0x18, 0x1f,0x00,0x00,0x00,0x00, 0x00,	// 212
  0x00, 0x00,0x00,0x00,0x1f,0x18, 0x1f,0x18,0x18,0x18,0x18, 0x18,	// 213
  0x00, 0x00,0x00,0x00,0x00,0x00, 0x3f,0x36,0x36,0x36,0x36, 0x36,	// 214
  0x36, 0x36,0x36,0x36,0x36,0x36, 0xff,0x36,0x36,0x36,0x36, 0x36,	// 215
  0x18, 0x18,0x18,0x18,0xff,0x18, 0xff,0x18,0x18,0x18,0x18, 0x18,	// 216
  0x18, 0x18,0x18,0x18,0x18,0x18, 0xf8,0x00,0x00,0x00,0x00, 0x00,	// 217
  0x00, 0x00,0x00,0x00,0x00,0x00, 0x1f,0x18,0x18,0x18,0x18, 0x18,	// 218
  0xff, 0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff, 0xff,	// 219
  0x00, 0x00,0x00,0x00,0x00,0x00, 0xff,0xff,0xff,0xff,0xff, 0xff,	// 220
  0xf0, 0xf0,0xf0,0xf0,0xf0,0xf0, 0xf0,0xf0,0xf0,0xf0,0xf0, 0xf0,	// 221
  0x0f, 0x0f,0x0f,0x0f,0x0f,0x0f, 0x0f,0x0f,0x0f,0x0f,0x0f, 0x0f,	// 222
  0xff, 0xff,0xff,0xff,0xff,0xff, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 223
  0x00, 0x00,0x00,0x76,0xdc,0xd8, 0xd8,0xd8,0xdc,0x76,0x00, 0x00,	// 224
  0x00, 0x00,0x78,0xcc,0xd8,0xfc, 0xc6,0xc6,0xc6,0xcc,0x00, 0x00,	// 225
  0x00, 0xfe,0x66,0x62,0x60,0x60, 0x60,0x60,0x60,0x60,0x00, 0x00,	// 226
  0x00, 0x00,0x00,0x00,0xfe,0x6c, 0x6c,0x6c,0x6c,0x6c,0x00, 0x00,	// 227
  0x00, 0xfe,0xc6,0x62,0x30,0x18, 0x30,0x62,0xc6,0xfe,0x00, 0x00,	// 228
  0x00, 0x00,0x00,0x00,0x7e,0xd8, 0xcc,0xcc,0xcc,0x78,0x00, 0x00,	// 229
  0x00, 0x00,0x00,0x66,0x66,0x66, 0x66,0x7c,0x60,0xc0,0x80, 0x00,	// 230
  0x00, 0x00,0x00,0x00,0x76,0xdc, 0x18,0x18,0x18,0x18,0x00, 0x00,	// 231
  0x00, 0xfe,0x38,0x6c,0xc6,0xc6, 0xc6,0x6c,0x38,0xfe,0x00, 0x00,	// 232
  0x00, 0x38,0x6c,0xc6,0xc6,0xfe, 0xc6,0xc6,0x6c,0x38,0x00, 0x00,	// 233
  0x00, 0x38,0x6c,0xc6,0xc6,0xc6, 0x6c,0x6c,0x6c,0xee,0x00, 0x00,	// 234
  0x00, 0x3e,0x60,0x30,0x3c,0x66, 0xc6,0xc6,0xcc,0x78,0x00, 0x00,	// 235
  0x00, 0x00,0x00,0x00,0x7e,0xdb, 0xdb,0x7e,0x00,0x00,0x00, 0x00,	// 236
  0x00, 0x06,0x0c,0x7c,0xde,0xf6, 0xe6,0x7c,0x60,0xc0,0x00, 0x00,	// 237
  0x00, 0x1c,0x30,0x60,0x60,0x7c, 0x60,0x60,0x30,0x1c,0x00, 0x00,	// 238
  0x00, 0x7c,0xc6,0xc6,0xc6,0xc6, 0xc6,0xc6,0xc6,0xc6,0x00, 0x00,	// 239
  0x00, 0x00,0x00,0x00,0xfe,0x00, 0xfe,0x00,0xfe,0x00,0x00, 0x00,	// 240
  0x00, 0x00,0x00,0x18,0x18,0x7e, 0x18,0x18,0x00,0x7e,0x00, 0x00,	// 241
  0x00, 0x30,0x18,0x0c,0x06,0x0c, 0x18,0x30,0x00,0x7e,0x00, 0x00,	// 242
  0x00, 0x0c,0x18,0x30,0x60,0x30, 0x18,0x0c,0x00,0x7e,0x00, 0x00,	// 243
  0x00, 0x00,0x0c,0x1e,0x1a,0x18, 0x18,0x18,0x18,0x18,0x18, 0x18,	// 244
  0x18, 0x18,0x18,0x18,0x18,0x18, 0x18,0x18,0x58,0x78,0x30, 0x00,	// 245
  0x00, 0x00,0x18,0x18,0x00,0x7e, 0x00,0x18,0x18,0x00,0x00, 0x00,	// 246
  0x00, 0x00,0x00,0x00,0x76,0xdc, 0x00,0x76,0xdc,0x00,0x00, 0x00,	// 247
  0x00, 0x78,0xcc,0xcc,0x78,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 248
  0x00, 0x00,0x00,0x00,0x00,0x18, 0x18,0x00,0x00,0x00,0x00, 0x00,	// 249
  0x00, 0x00,0x00,0x00,0x00,0x00, 0x18,0x00,0x00,0x00,0x00, 0x00,	// 250
  0x00, 0x00,0x1f,0x18,0x18,0x18, 0x18,0xd8,0x78,0x38,0x18, 0x00,	// 251
  0xd8, 0x6c,0x6c,0x6c,0x6c,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 252
  0x70, 0xd8,0x30,0x60,0xf8,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,	// 253
  0x00, 0x00,0x00,0x7e,0x7e,0x7e, 0x7e,0x7e,0x7e,0x00,0x00, 0x00,	// 254
  0x00, 0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00, 0x00	// 255
};

Byte font6[] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		// 0	 "^@"
  0x7E, 0xA5, 0x81, 0xBD, 0x99, 0x7E,		// 1	 "^A"
  0x7E, 0xDB, 0xFF, 0xC3, 0xE7, 0x7E,		// 2	 "^B"
  0x6C, 0xFE, 0xFE, 0x7C, 0x38, 0x10,		// 3	 "^C"
  0x10, 0x38, 0x7C, 0x38, 0x10, 0x00,		// 4	 "^D"
  0x38, 0x38, 0xD6, 0xFE, 0xD6, 0x38,		// 5	 "^E"
  0x10, 0x38, 0x7C, 0xFE, 0xD6, 0x38,		// 6	 "^F"
  0x00, 0x38, 0x7C, 0x7C, 0x38, 0x00,		// 7	 "^G"
  0xFE, 0xC6, 0x82, 0x82, 0xC6, 0xFE,		// 8	 "^H"
  0x00, 0x38, 0x44, 0x44, 0x38, 0x00,		// 9	 "^I"
  0xFE, 0xC6, 0xBA, 0xBA, 0xC6, 0xFE,		// 10	 "^J"
  0x0F, 0x07, 0x7D, 0xCC, 0xCC, 0x78,		// 11	 "^K"
  0x3C, 0x66, 0x3C, 0x18, 0x7E, 0x18,		// 12	 "^L"
  0x3F, 0x31, 0x3F, 0x30, 0xF0, 0xE0,		// 13	 "^M"
  0x7F, 0x63, 0x7F, 0xE3, 0xCF, 0x0E,		// 14	 "^N"
  0xDB, 0x3C, 0xE7, 0xE7, 0x3C, 0xDB,		// 15	 "^O"
  0x40, 0x70, 0x7C, 0x70, 0x40, 0x00,		// 16	 "^P"
  0x04, 0x1C, 0x7C, 0x1C, 0x04, 0x00,		// 17	 "^Q"
  0x18, 0x3C, 0x18, 0x18, 0x3C, 0x18,		// 18	 "^R"
  0x66, 0x66, 0x66, 0x00, 0x66, 0x00,		// 19	 "^S"
  0x7F, 0xDB, 0x7B, 0x1B, 0x1B, 0x00,		// 20	 "^T"
  0x3E, 0x63, 0x38, 0x38, 0xCC, 0x78,		// 21	 "^U"
  0x00, 0x00, 0x00, 0x7E, 0x7E, 0x00,		// 22	 "^V"
  0x18, 0x3C, 0x18, 0x3C, 0x18, 0xFF,		// 23	 "^W"
  0x18, 0x3C, 0x5A, 0x18, 0x18, 0x00,		// 24	 "^X"
  0x18, 0x18, 0x5A, 0x3C, 0x18, 0x00,		// 25	 "^Y"
  0x18, 0x0C, 0xFE, 0x0C, 0x18, 0x00,		// 26	 "^Z"
  0x30, 0x60, 0xFE, 0x60, 0x30, 0x00,		// 27	 "^["
  0x00, 0xC0, 0xC0, 0xFE, 0x00, 0x00,		// 28	 "^\"
  0x24, 0x66, 0xFF, 0x66, 0x24, 0x00,		// 29	 "^]"
  0x00, 0x10, 0x38, 0x7C, 0xFE, 0x00,		// 30	 "^^"
  0x00, 0xFE, 0x7C, 0x38, 0x10, 0x00,		// 31	 "^_"
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		// 32	 " "
  0x18, 0x18, 0x18, 0x00, 0x18, 0x00,		// 33	 "!"
  0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00,		// 34	 """
  0x6C, 0xFE, 0x6C, 0xFE, 0x6C, 0x00,		// 35	 "#"
  0x18, 0x3E, 0x70, 0x0E, 0x7C, 0x18,		// 36	 "$"
  0x66, 0x6C, 0x18, 0x36, 0x66, 0x00,		// 37	 "%"
  0x70, 0xD8, 0x76, 0xCC, 0x76, 0x00,		// 38	 "&"
  0x18, 0x18, 0x30, 0x00, 0x00, 0x00,		// 39	 "'"
  0x18, 0x30, 0x30, 0x30, 0x18, 0x00,		// 40	 "("
  0x30, 0x18, 0x18, 0x18, 0x30, 0x00,		// 41	 ")"
  0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00,		// 42	 "*"
  0x18, 0x18, 0x7E, 0x18, 0x18, 0x00,		// 43	 "+"
  0x00, 0x00, 0x00, 0x18, 0x18, 0x30,		// 44	 ","
  0x00, 0x00, 0x7E, 0x00, 0x00, 0x00,		// 45	 "-"
  0x00, 0x00, 0x00, 0x18, 0x18, 0x00,		// 46	 "."
  0x06, 0x0C, 0x18, 0x30, 0x60, 0x00,		// 47	 "/"
  0x3C, 0x66, 0x66, 0x66, 0x3C, 0x00,		// 48	 "0"
  0x18, 0x38, 0x18, 0x18, 0x7E, 0x00,		// 49	 "1"
  0x3C, 0x66, 0x0C, 0x38, 0x7E, 0x00,		// 50	 "2"
  0x7C, 0x06, 0x3C, 0x06, 0x7C, 0x00,		// 51	 "3"
  0x1C, 0x3C, 0x6C, 0xFE, 0x0C, 0x00,		// 52	 "4"
  0x7C, 0x60, 0x7C, 0x06, 0x7C, 0x00,		// 53	 "5"
  0x3C, 0x60, 0x7C, 0x66, 0x3C, 0x00,		// 54	 "6"
  0x7E, 0x06, 0x0C, 0x18, 0x18, 0x00,		// 55	 "7"
  0x3C, 0x66, 0x3C, 0x66, 0x3C, 0x00,		// 56	 "8"
  0x3C, 0x66, 0x3E, 0x06, 0x3C, 0x00,		// 57	 "9"
  0x18, 0x18, 0x00, 0x18, 0x18, 0x00,		// 58	 ":"
  0x18, 0x18, 0x00, 0x18, 0x18, 0x30,		// 59	 ";"
  0x0C, 0x18, 0x30, 0x18, 0x0C, 0x00,		// 60	 "<"
  0x00, 0x7E, 0x00, 0x7E, 0x00, 0x00,		// 61	 "="
  0x30, 0x18, 0x0C, 0x18, 0x30, 0x00,		// 62	 ">"
  0x7C, 0xC6, 0x1C, 0x00, 0x18, 0x00,		// 63	 "?"
  0x7C, 0xC6, 0xDE, 0xDE, 0xC0, 0x78,		// 64	 "@"
  0x18, 0x3C, 0x66, 0x7E, 0x66, 0x00,		// 65	 "A"
  0xFC, 0x66, 0x7C, 0x66, 0xFC, 0x00,		// 66	 "B"
  0x7E, 0xC2, 0xC0, 0xC0, 0x7E, 0x00,		// 67	 "C"
  0xFC, 0x66, 0x66, 0x66, 0xFC, 0x00,		// 68	 "D"
  0xFE, 0x62, 0x78, 0x62, 0xFE, 0x00,		// 69	 "E"
  0xFE, 0x62, 0x78, 0x60, 0xF0, 0x00,		// 70	 "F"
  0x7C, 0xC0, 0xDE, 0xC6, 0x7E, 0x00,		// 71	 "G"
  0x66, 0x66, 0x7E, 0x66, 0x66, 0x00,		// 72	 "H"
  0x3C, 0x18, 0x18, 0x18, 0x3C, 0x00,		// 73	 "I"
  0x1E, 0x0C, 0x0C, 0xCC, 0x78, 0x00,		// 74	 "J"
  0xE6, 0x6C, 0x78, 0x6C, 0xE6, 0x00,		// 75	 "K"
  0xF0, 0x60, 0x60, 0x62, 0xFE, 0x00,		// 76	 "L"
  0xC6, 0xEE, 0xFE, 0xD6, 0xC6, 0x00,		// 77	 "M"
  0xE6, 0xF6, 0xDE, 0xCE, 0xC6, 0x00,		// 78	 "N"
  0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0x00,		// 79	 "O"
  0xFC, 0x66, 0x7C, 0x60, 0xF0, 0x00,		// 80	 "P"
  0x78, 0xCC, 0xCC, 0x68, 0x1E, 0x00,		// 81	 "Q"
  0xFC, 0x66, 0x7C, 0x6C, 0xE6, 0x00,		// 82	 "R"
  0x7C, 0xC0, 0x7C, 0x06, 0xFC, 0x00,		// 83	 "S"
  0x7E, 0x5A, 0x18, 0x18, 0x3C, 0x00,		// 84	 "T"
  0x66, 0x66, 0x66, 0x66, 0x7E, 0x00,		// 85	 "U"
  0x66, 0x66, 0x66, 0x3C, 0x18, 0x00,		// 86	 "V"
  0xC6, 0xD6, 0xFE, 0xEE, 0xC6, 0x00,		// 87	 "W"
  0x66, 0x3C, 0x18, 0x3C, 0x66, 0x00,		// 88	 "X"
  0x66, 0x66, 0x3C, 0x18, 0x18, 0x00,		// 89	 "Y"
  0x7E, 0x4C, 0x18, 0x32, 0x7E, 0x00,		// 90	 "Z"
  0x3C, 0x30, 0x30, 0x30, 0x3C, 0x00,		// 91	 "["
  0x60, 0x30, 0x18, 0x0C, 0x06, 0x00,		// 92	 "\"
  0x3C, 0x0C, 0x0C, 0x0C, 0x3C, 0x00,		// 93	 "]"
  0x10, 0x38, 0x6C, 0x00, 0x00, 0x00,		// 94	 "^"
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,		// 95	 "_"
  0x30, 0x30, 0x18, 0x00, 0x00, 0x00,		// 96	 "`"
  0x00, 0x7C, 0xCC, 0xCC, 0x76, 0x00,		// 97	 "a"
  0xE0, 0x6C, 0x76, 0x66, 0xFC, 0x00,		// 98	 "b"
  0x00, 0x3E, 0x60, 0x60, 0x3E, 0x00,		// 99	 "c"
  0x0C, 0x6C, 0xDC, 0xCC, 0x7E, 0x00,		// 100	 "d"
  0x00, 0x3C, 0x6E, 0x70, 0x3E, 0x00,		// 101	 "e"
  0x1C, 0x30, 0x7C, 0x30, 0x78, 0x00,		// 102	 "f"
  0x00, 0x76, 0xCC, 0x7C, 0x0C, 0x78,		// 103	 "g"
  0xE0, 0x6C, 0x76, 0x66, 0xE6, 0x00,		// 104	 "h"
  0x00, 0x38, 0x18, 0x18, 0x3C, 0x00,		// 105	 "i"
  0x00, 0x1C, 0x0C, 0x0C, 0xCC, 0x78,		// 106	 "j"
  0xE0, 0x6E, 0x78, 0x6C, 0xE6, 0x00,		// 107	 "k"
  0x38, 0x18, 0x18, 0x18, 0x3C, 0x00,		// 108	 "l"
  0x00, 0xCC, 0xFE, 0xFE, 0xD6, 0x00,		// 109	 "m"
  0x00, 0xDC, 0x66, 0x66, 0x66, 0x00,		// 110	 "n"
  0x00, 0x3C, 0x66, 0x66, 0x3C, 0x00,		// 111	 "o"
  0x00, 0xFC, 0x66, 0x76, 0x6C, 0x60,		// 112	 "p"
  0x00, 0x7E, 0xCC, 0xDC, 0x6C, 0x0E,		// 113	 "q"
  0x00, 0x6E, 0x36, 0x30, 0x78, 0x00,		// 114	 "r"
  0x00, 0x3E, 0x70, 0x0E, 0x7C, 0x00,		// 115	 "s"
  0x30, 0x7C, 0x30, 0x30, 0x1C, 0x00,		// 116	 "t"
  0x00, 0xCC, 0xCC, 0xCC, 0x76, 0x00,		// 117	 "u"
  0x00, 0xE6, 0x66, 0x3C, 0x18, 0x00,		// 118	 "v"
  0x00, 0xC6, 0xD6, 0xFE, 0x6C, 0x00,		// 119	 "w"
  0x00, 0xE6, 0x6C, 0x38, 0xEE, 0x00,		// 120	 "x"
  0x00, 0xE6, 0x66, 0x3E, 0x06, 0x3C,		// 121	 "y"
  0x00, 0x7C, 0x18, 0x30, 0x7C, 0x00,		// 122	 "z"
  0x0E, 0x18, 0x70, 0x18, 0x0E, 0x00,		// 123	 "{"
  0x18, 0x18, 0x08, 0x10, 0x18, 0x18,		// 124	 "|"
  0x70, 0x18, 0x0E, 0x18, 0x70, 0x00,		// 125	 "}"
  0x76, 0xDC, 0x00, 0x00, 0x00, 0x00,		// 126	 "~"
  0x10, 0x38, 0x6C, 0xC6, 0xFE, 0x00,		// 127	 ""
  0x7E, 0xC2, 0xC0, 0x7E, 0x08, 0x30,		// 128	 ""
  0xCC, 0x00, 0xCC, 0xCC, 0x76, 0x00,		// 129	 ""
  0x03, 0x3C, 0x6E, 0x70, 0x3E, 0x00,		// 130	 ""
  0x7E, 0xC3, 0x3E, 0x66, 0x3B, 0x00,		// 131	 ""
  0xCC, 0x00, 0x7C, 0xCC, 0x76, 0x00,		// 132	 ""
  0xE0, 0x00, 0x7C, 0xCC, 0x76, 0x00,		// 133	 ""
  0x30, 0x00, 0x7C, 0xCC, 0x76, 0x00,		// 134	 ""
  0x00, 0x3E, 0x60, 0x3E, 0x08, 0x18,		// 135	 ""
  0x7E, 0xC3, 0x3C, 0x6E, 0x70, 0x3E,		// 136	 ""
  0xC3, 0x3C, 0x6E, 0x70, 0x3E, 0x00,		// 137	 ""
  0xE0, 0x3C, 0x6E, 0x70, 0x3E, 0x00,		// 138	 ""
  0x66, 0x00, 0x38, 0x18, 0x3C, 0x00,		// 139	 ""
  0x7C, 0xC6, 0x38, 0x18, 0x3C, 0x00,		// 140	 ""
  0x70, 0x00, 0x38, 0x18, 0x3C, 0x00,		// 141	 ""
  0xC6, 0x38, 0x6C, 0xFE, 0xC6, 0x00,		// 142	 ""
  0x18, 0x00, 0x3C, 0x66, 0x7E, 0x66,		// 143	 ""
  0x1E, 0xFC, 0x60, 0x78, 0x60, 0xFC,		// 144	 ""
  0x00, 0xEE, 0x3B, 0xDC, 0x77, 0x00,		// 145	 ""
  0x3E, 0x6C, 0xFE, 0xCC, 0xCE, 0x00,		// 146	 ""
  0x3C, 0x66, 0x00, 0x3C, 0x66, 0x3C,		// 147	 ""
  0x66, 0x00, 0x3C, 0x66, 0x3C, 0x00,		// 148	 ""
  0x70, 0x00, 0x3C, 0x66, 0x3C, 0x00,		// 149	 ""
  0x78, 0xCC, 0x00, 0xCC, 0xCC, 0x76,		// 150	 ""
  0xE0, 0x00, 0xCC, 0xCC, 0x76, 0x00,		// 151	 ""
  0x66, 0x00, 0x66, 0x3E, 0x06, 0x3C,		// 152	 ""
  0xC3, 0x3C, 0x66, 0x66, 0x66, 0x3C,		// 153	 ""
  0x66, 0x00, 0x66, 0x66, 0x66, 0x7E,		// 154	 ""
  0x18, 0x7E, 0xC0, 0xC0, 0x7E, 0x18,		// 155	 ""
  0x3C, 0x66, 0xF0, 0x62, 0xFE, 0x00,		// 156	 ""
  0x66, 0x3C, 0x7E, 0x18, 0x7E, 0x18,		// 157	 ""
  0xF8, 0xCC, 0xFA, 0xCF, 0xC6, 0xC7,		// 158	 ""
  0x0E, 0x1B, 0x3C, 0x18, 0xD8, 0x70,		// 159	 ""
  0x1E, 0x00, 0x7C, 0xCC, 0x76, 0x00,		// 160	 ""
  0x1C, 0x00, 0x38, 0x18, 0x3C, 0x00,		// 161	 ""
  0x0E, 0x00, 0x3C, 0x66, 0x3C, 0x00,		// 162	 ""
  0x1C, 0x00, 0xCC, 0xCC, 0x76, 0x00,		// 163	 ""
  0x7C, 0x00, 0xDC, 0x66, 0x66, 0x00,		// 164	 ""
  0x7E, 0x00, 0x76, 0x7E, 0x6E, 0x66,		// 165	 ""
  0x3C, 0x6C, 0x36, 0x00, 0x7E, 0x00,		// 166	 ""
  0x38, 0x6C, 0x38, 0x00, 0x7C, 0x00,		// 167	 ""
  0x30, 0x00, 0x70, 0xC6, 0x7C, 0x00,		// 168	 ""
  0x00, 0x00, 0x7E, 0x60, 0x60, 0x00,		// 169	 ""
  0x00, 0x00, 0x7E, 0x06, 0x06, 0x00,		// 170	 ""
  0xC6, 0xCC, 0xDE, 0x33, 0x6C, 0x0F,		// 171	 ""
  0xC6, 0xCC, 0xDB, 0x37, 0x6F, 0x03,		// 172	 ""
  0x18, 0x00, 0x18, 0x18, 0x18, 0x00,		// 173	 ""
  0x00, 0x66, 0xCC, 0x66, 0x00, 0x00,		// 174	 ""
  0x00, 0xCC, 0x66, 0xCC, 0x00, 0x00,		// 175	 ""
  0x22, 0x88, 0x22, 0x88, 0x22, 0x88,		// 176	 ""
  0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA,		// 177	 ""
  0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77,		// 178	 ""
  0x18, 0x18, 0x18, 0x18, 0x18, 0x18,		// 179	 ""
  0x18, 0x18, 0x18, 0xF8, 0x18, 0x18,		// 180	 ""
  0x18, 0xF8, 0x18, 0xF8, 0x18, 0x18,		// 181	 ""
  0x36, 0x36, 0x36, 0xF6, 0x36, 0x36,		// 182	 ""
  0x00, 0x00, 0x00, 0xFE, 0x36, 0x36,		// 183	 ""
  0x00, 0xF8, 0x18, 0xF8, 0x18, 0x18,		// 184	 ""
  0x36, 0xF6, 0x06, 0xF6, 0x36, 0x36,		// 185	 ""
  0x36, 0x36, 0x36, 0x36, 0x36, 0x36,		// 186	 ""
  0x00, 0xFE, 0x06, 0xF6, 0x36, 0x36,		// 187	 ""
  0x36, 0xF6, 0x06, 0xFE, 0x00, 0x00,		// 188	 ""
  0x36, 0x36, 0x36, 0xFE, 0x00, 0x00,		// 189	 ""
  0x18, 0xF8, 0x18, 0xF8, 0x00, 0x00,		// 190	 ""
  0x00, 0x00, 0x00, 0xF8, 0x18, 0x18,		// 191	 ""
  0x18, 0x18, 0x18, 0x1F, 0x00, 0x00,		// 192	 ""
  0x18, 0x18, 0x18, 0xFF, 0x00, 0x00,		// 193	 ""
  0x00, 0x00, 0x00, 0xFF, 0x18, 0x18,		// 194	 ""
  0x18, 0x18, 0x18, 0x1F, 0x18, 0x18,		// 195	 ""
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,		// 196	 ""
  0x18, 0x18, 0x18, 0xFF, 0x18, 0x18,		// 197	 ""
  0x18, 0x1F, 0x18, 0x1F, 0x18, 0x18,		// 198	 ""
  0x36, 0x36, 0x36, 0x37, 0x36, 0x36,		// 199	 ""
  0x36, 0x37, 0x30, 0x3F, 0x00, 0x00,		// 200	 ""
  0x00, 0x3F, 0x30, 0x37, 0x36, 0x36,		// 201	 ""
  0x36, 0xF7, 0x00, 0xFF, 0x00, 0x00,		// 202	 ""
  0x00, 0xFF, 0x00, 0xF7, 0x36, 0x36,		// 203	 ""
  0x36, 0x37, 0x30, 0x37, 0x36, 0x36,		// 204	 ""
  0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00,		// 205	 ""
  0x36, 0xF7, 0x00, 0xF7, 0x36, 0x36,		// 206	 ""
  0x18, 0xFF, 0x00, 0xFF, 0x00, 0x00,		// 207	 ""
  0x36, 0x36, 0x36, 0xFF, 0x00, 0x00,		// 208	 ""
  0x00, 0xFF, 0x00, 0xFF, 0x18, 0x18,		// 209	 ""
  0x00, 0x00, 0x00, 0xFF, 0x36, 0x36,		// 210	 ""
  0x36, 0x36, 0x36, 0x3F, 0x00, 0x00,		// 211	 ""
  0x18, 0x1F, 0x18, 0x1F, 0x00, 0x00,		// 212	 ""
  0x00, 0x1F, 0x18, 0x1F, 0x18, 0x18,		// 213	 ""
  0x00, 0x00, 0x00, 0x3F, 0x36, 0x36,		// 214	 ""
  0x36, 0x36, 0x36, 0xFF, 0x36, 0x36,		// 215	 ""
  0x18, 0xFF, 0x18, 0xFF, 0x18, 0x18,		// 216	 ""
  0x18, 0x18, 0x18, 0xF8, 0x00, 0x00,		// 217	 ""
  0x00, 0x00, 0x00, 0x1F, 0x18, 0x18,		// 218	 ""
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,		// 219	 ""
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,		// 220	 ""
  0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0,		// 221	 ""
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,		// 222	 ""
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,		// 223	 ""
  0x00, 0x76, 0xDC, 0xDC, 0x76, 0x00,		// 224	 ""
  0x3C, 0x66, 0x7C, 0x66, 0x7C, 0x60,		// 225	 ""
  0x7E, 0x32, 0x30, 0x30, 0x78, 0x00,		// 226	 ""
  0x00, 0xFE, 0x6C, 0x6C, 0x6C, 0x00,		// 227	 ""
  0x7E, 0x30, 0x18, 0x30, 0x7E, 0x00,		// 228	 ""
  0x00, 0x3F, 0x6C, 0x6C, 0x38, 0x00,		// 229	 ""
  0x00, 0x66, 0x66, 0x66, 0x7B, 0xC0,		// 230	 ""
  0x00, 0x7E, 0xD8, 0x18, 0x0C, 0x00,		// 231	 ""
  0x18, 0x7E, 0xDB, 0xDB, 0x7E, 0x18,		// 232	 ""
  0x7C, 0xC6, 0xFE, 0xC6, 0x7C, 0x00,		// 233	 ""
  0x7C, 0xC6, 0xC6, 0x6C, 0xEE, 0x00,		// 234	 ""
  0x0E, 0x18, 0x7C, 0xC6, 0x7C, 0x00,		// 235	 ""
  0x00, 0x6E, 0xDB, 0xDB, 0x76, 0x00,		// 236	 ""
  0x08, 0x7C, 0xD6, 0xD6, 0x7C, 0x20,		// 237	 ""
  0x3C, 0x60, 0x7C, 0x60, 0x3C, 0x00,		// 238	 ""
  0x3C, 0x66, 0x66, 0x66, 0x66, 0x00,		// 239	 ""
  0x7E, 0x00, 0x7E, 0x00, 0x7E, 0x00,		// 240	 ""
  0x18, 0x7E, 0x18, 0x00, 0x7E, 0x00,		// 241	 ""
  0x30, 0x18, 0x0C, 0x7E, 0x00, 0x7E,		// 242	 ""
  0x0C, 0x18, 0x30, 0x7E, 0x00, 0x7E,		// 243	 ""
  0x0E, 0x1B, 0x18, 0x18, 0x18, 0x18,		// 244	 ""
  0x18, 0x18, 0x18, 0x18, 0xD8, 0x70,		// 245	 ""
  0x18, 0x00, 0x7E, 0x00, 0x18, 0x00,		// 246	 ""
  0x76, 0xDC, 0x00, 0x76, 0xDC, 0x00,		// 247	 ""
  0x38, 0x6C, 0x38, 0x00, 0x00, 0x00,		// 248	 ""
  0x00, 0x00, 0x18, 0x18, 0x00, 0x00,		// 249	 ""
  0x00, 0x00, 0x00, 0x18, 0x00, 0x00,		// 250	 ""
  0x0E, 0x0C, 0x0C, 0x6C, 0x3C, 0x1C,		// 251	 ""
  0x6C, 0x36, 0x36, 0x36, 0x00, 0x00,		// 252	 ""
  0x38, 0x0C, 0x18, 0x3C, 0x00, 0x00,		// 253	 ""
  0x00, 0x3C, 0x3C, 0x3C, 0x00, 0x00,		// 254	 ""
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00		// 255
};
