		page
		page ,132
		title MEMCLEAR device driver - wipes clear unused memory.

		; Written by Jac Goudsmit
		; Weegbree 101, 5684 JC Best, The Netherlands.
		; Version 1.00	30 Sep 1990
		; Version 1.01	12 Dec 1990

		.radix 16
		.model small,c
		.code
		dd -1
		dw 8000
		dw offset strat
		dw offset intr
		db 'MEMCLEAR'

txt		db 0Dh,'MEMCLEAR V1.01 (C) Jac Goudsmit 12 Dec 1990.',0Dh,0A
		db 'Wipes clear all unused memory.',0Dh,0A,24,8,20,1A
end_txt 	db '    ',0Dh,0A,24
bxs		dw ?
ess		dw ?

Strat:		mov cs:bxs,bx
		mov cs:ess,es
		retf

Intr:		push ax
		push bx
		push cx
		push dx
		push si
		push di
		push ds
		push es
		cld
		cli
		mov dx,offset txt
		push cs
		pop ds
		mov ah,9
		int 21

		mov ax,cs
		add ax,1000
		and ax,0F000
		mov bx,ss
		and bx,0F000

@@:		mov es,ax
		xor di,di
		cmp ax,bx
		je stackseg
		cmp ax,9000
		jae memend

		mov cx,8000
		call printax
		rep stosw
		add ax,1000
		jmp @B

stackseg:	mov bx,ss
		sub bx,ax
		mov cl,3
		shl bx,cl
		mov cx,bx
		call printax
		xor bx,bx
		mov ax,ss
		add ax,1000
		jmp @B

memend: 	cmp ax,0A000
		jae @F
		mov bx,0A000
		sub bx,ax
		mov cl,3
		shl bx,cl
		mov cx,bx
		call printax
		rep stosw

@@:		mov dx,offset end_txt
		push cs
		pop ds
		mov ah,9
		int 21

		sti
		les bx,dword ptr cs:bxs
		mov word ptr es:[bx+3],100
		mov word ptr es:[bx+0E],0
		mov word ptr es:[bx+10],cs
		pop es
		pop ds
		pop di
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		retf

printhex:	push ax
		and al,0F
		add al,90
		daa
		adc al,40
		daa
		mov dl,al
		mov ah,2
		int 21
		pop ax
		ret

printax:	push ax
		push dx
		push cx
		mov cx,4
@@:		push cx
		mov cl,4
		rol ax,cl
		call printhex
		pop cx
		loop @B
		mov dl,0Dh
		mov ah,2
		int 21
		pop cx
		pop dx
		pop ax
		ret
		end 

