/*	scrape.c */

/*	Scrape.exe Ver 2.01 an MS-DOS Screen scraper	*/
/*	Copyright (C) 1998 A.B.Greenhalgh				*/

/*	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License (version 2) as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
	Function:
	Scrape is a relatively sophisticated text mode screen scraper/text grabber
	(not a screen dumper although it will do this if specified). Scrape will
	grab strings following recognised text or alternatively will operate at
	x,y screen coordinates. Scraped/grabbed screen strings are written to file
	or to environment variables (or both). By default the DOS master environment
	is used although any loaded program module with a valid environment block
	may be manipulated.


	Requirements:
	This code assumes that you are using a graphics adapter in
	in an 80 row x 25 col. text mode (and will check for this).

	Scrape has been tested and found to work with MS-DOS versions 5.0 and 6.22


	Installation and Execution:
	Typing 'Scrape -h <enter>' will provide some basic help.

	A sample scrape.ini file is included with this distribution. Executing
	a 'scrape -x' immediately after a 'dir scrape.*' will cause the file
	sizes of scrape.exe and scrape.c to be written to DOS environment
	variables and the file scrape.out as as well dumping the screen to the
	file scrape.scn. Scrape expects to see the scrape.ini file in the working
	directory although scrape.exe can be called from any directory as long
	as it is included in the 'PATH' environment variable.

	When running out of environment space with modules other than command.com
	try packing out the master environment space before loading your chosen
	code. Running "scrape -e" from autoexec.bat will have this effect.
	Only the first copy of command.com will have the full specified number of
	bytes in its environment. All other modules are loaded by DOS with only
	the necessary number of paragraphs and no more. Which I guess is
	predictable as environment blocks were probably not intended to be edited.


	Comments:
	When called from the command line scrape will not see the top line of
	the display as executing the scrape command will displace this line.

	Scrape was written to work with multiple telnet sessions from within
	MS-Kermit Version 3.15.

	Scrape was compiled with the Borland C/C++ Compiler Ver 3.0


	MS-Kermit 3.15 Notes:
	The MS-Kermit setenv command changes the master environment block.
	However, environment strings accessed using the \$(env_name) syntax are
	from kermits own local copy of the master environment block. There is
	very probably a good reason for this but I am unaware of it :)


	Thanks: to Ian Richardson for helpful comments on the format of the
	distribution.


	Author: Andy Greenhalgh 04/01/1998
	E-mail: ABGreenhalgh@compuserve.com
	Post: 	44 Grasmere, Macclesfield, Cheshire. SK11 8PL. UK


	Last word:
	Parts of this code are messy and inefficient and would benefit from a
	rewrite (maybe in assembler) however life is short <g>...

*/
/*
	Release Notes:

	Version No.		Comments
	-----------		--------

	Ver 1.01    	Initial release

	Ver 2.01        Rewritten for legibility, tidied and added scrape at x,y
					coordinate facility.


	Version 3.01 will include a go faster stripe and furry dice run-time
	module.

*/


/********** includes **********/
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <conio.h>


/********** defines **********/
#define MAXPARAMS 25            /* maximum number of parameter lines */
#define SCRAPE_BUFSIZE 1024     /* size of scrape buffer */
#define SCN_BUFSIZE (80*25)+(2*25) /* number of characters on a page/screen */
								/* including a cr/lf pair on each line */
#define CO80 3					/* graphics adapter display modes */
#define BW80 2
#define MONO 7
#define YES 1
#define NO 0
#define FILE_MODE 0				/* operational modes for scrape program */
#define ENVIRON_MODE 1
#define DEBUG_MODE 3
#define PROG_SEG 0				/* modes for find_module() */
#define ENV_SEG 1

/* #define DEBUG */	 			/* for when we are debugging */

/********** fuction prototype declarations ***********/
void initialise();
void prog_help();
void get_params();
void get_screen(char *vid_buf);
int get_textoffset(int pass, char *srch_buf);
void get_text(int offset, int pass);
void set_env();
unsigned int find_module(int mode);

/********** global variable declarations **********/
char vid_buf[SCN_BUFSIZE];      /* holds the screen text */
char scrape_buf[SCRAPE_BUFSIZE];/* holds scraped areas of screen */
char module[80]="";				/* name of program for env. block tweaking */
int hdl_dumpfile;               /* screen dump file handle */
int hdl_outfile;				/* output file handle */
int param_line=0; 				/* lines in scrape.ini file */
int prtscrn;					/* dump screen to file Yes/No */
int opmode;						/* scrape operational mode */
int env_bytes;      			/* allocated env. var. space */
unsigned int video_baseaddr;	/* video base memory segment */

struct type_param               /* multidimensional structure members hold
								   intialisation params */
{
	char findstr[MAXPARAMS][80];    /* string to anchor on */
	int len_getstr[MAXPARAMS];      /* length of string to scrape */
	char environ[MAXPARAMS][40];    /* env. variable to assign string to */
	int x_coord[MAXPARAMS];         /* x,y coordinates of desired text */
	int y_coord[MAXPARAMS];
};

struct type_param params;


/********** local functions **********/

void prog_help() {

printf("\nScrape.exe Ver 2.01, Copyright (C) 1998 A.B.Greenhalgh\n");
printf("\nScrape comes with no ABSOLUTELY NO WARRANTY. This is free software and");
printf("\nyou are welcome to redistribute it under certain conditions.");
printf("\nFor details see the GNU General Public License.\n\n");
printf("\nPress any key to continue...");
while (!kbhit()); 	/* wait for a key press */
printf("\n\nUsage:");
printf("\n-f     scrape text to MS-DOS file (default behaviour)");
printf("\n-eMODULE");
printf("\n       scrape text to MS-DOS environment variables");
printf("\n       module is name of program whose environment block");
printf("\n       is to be modified. Default module name is COMMAND");
printf("\n-d     also dump screen contents to file scrape.scn");
printf("\n-x     debug mode - use file and environment variables and dump screen");
printf("\n-h     this help\n");

printf("\n\n      Structure of scrape.ini (CSV format):\n");
printf("\n      field 1       field 2     field 3                   field 4 field 5");
printf("\n      anchor string,text length,environment variable name,X coord,Y coord");
printf("\n      eg. Date of Birth,8,DOB,, or ,15,DOB,15,5");
printf("\n\n      - legal coordinate ranges are X 0-79 and Y 0-24");
printf("\n      - if both coordinates and anchor text are given then coordinates override");
printf("\n      - up to 25 lines are permitted in scrape.ini and only the first");
printf("\n        instance of an anchor string results in scraped text\n");

} /* end of prog_help() */


void initialise () {
int i,j, arg_cnt=0;
int curr_page;
struct text_info ti;

/* set defaults */
prtscrn=NO;					/* default is don't dump screen to file */
opmode=FILE_MODE;   		/* default operational mode is output to file */

for (i=0;i<_argc;i++) {
		if (strcmp(_argv[i],"-d")==0) {
			prtscrn=YES;
			arg_cnt++;
			}

		if (_argv[i][0]=='-' && _argv[i][1]=='e') {
			opmode=ENVIRON_MODE;
			arg_cnt++;
			for (j=2;j<strlen(_argv[i]);j++) {
				module[j-2] = toupper(_argv[i][j]);
				}
			}

		if (strcmp(_argv[i],"-f")==0) {
			opmode=FILE_MODE;
			arg_cnt++;
			}

		if (strcmp(_argv[i],"-h")==0) {
			arg_cnt++;
			prog_help();
			exit(0);
			}

		if (strcmp(_argv[i],"-x")==0) {
			opmode=DEBUG_MODE;
			arg_cnt++;
			}

		} /* end of check _argv array */


if (arg_cnt+1 != _argc) {
	printf("\nCommand line arguments not understood !\n");
	prog_help();
}

if (opmode==ENVIRON_MODE || opmode==DEBUG_MODE) {
	/* default program module to command if not specified */
	if (strlen(module)==0) strcpy (module, "COMMAND");
	}

/* check that we are in 80*25 display mode */
gettextinfo(&ti);

if (ti.currmode!=CO80 && ti.currmode!=BW80 && ti.currmode!=MONO) {
	printf("\nNot in a suitable display mode for scrape.exe !");
	printf("\nSupported modes are all 80 * 25 text modes");
	printf("\n...current display mode is: %2d\n",ti.currmode);
	sleep(5);
	exit(1);
	}

/* set video base address according to display mode in use */

switch (ti.currmode) {
	case CO80: video_baseaddr=0xb800; break;
	case BW80: video_baseaddr=0xb800; break;
	case MONO: video_baseaddr=0xb000; break;
	}

/* Note that up to eight video pages may exist at offsets 1000h apart. It
   is not common to use this feature, however it may be accomodated by
   using the BIOS service 0fh (decimal 15) on int. 10h (decimal 16). This
   service returns the current video mode and active page (0-7). An
   appropriate base memory address can then be set.

   ...then again we could cut out the offical route <g> and look in the
   ROM BIOS data area at 0040:0062h. This byte gives us the current page
   number (0-7).
*/

/* comment - I suspect this may possibly cause problems with kermit
   if it uses different pages for different telnet sessions. Suck it
   and see... */

curr_page=peekb(0x0040,0x0062);

#ifdef DEBUG
if (curr_page!=0) {
	printf("\ncurrent page is - %d\n",curr_page);
	sleep(5);
	}
#endif

video_baseaddr=video_baseaddr + (0x0100 * curr_page);

if (prtscrn==YES || opmode==DEBUG_MODE) {
	if ((hdl_dumpfile = open("scrape.scn", O_CREAT | O_TRUNC | O_WRONLY
		| O_BINARY, S_IWRITE | S_IREAD)) == -1) {
		printf("Error opening/creating file: scrape.scn\n");
		sleep(5);
		exit(1);
		}
	}

if (opmode==FILE_MODE || opmode==DEBUG_MODE) {
	if ((hdl_outfile = open("scrape.out", O_CREAT | O_TRUNC | O_WRONLY
		| O_BINARY, S_IWRITE | S_IREAD)) == -1) {
		printf("Error opening/creating file: scrape.out\n");
		sleep(5);
		exit(1);
		}
	}

/* intialise the global buffers */
for (i=0;i<SCRAPE_BUFSIZE;i++) scrape_buf[i]=0;
for (i=0;i<SCN_BUFSIZE;i++) vid_buf[i]=0;

} /* end of initialise() */


void get_params() {
/* read setup info. from comma delimited text file */

FILE *settings;
char byte;
char file_buf[MAXPARAMS*82];
char tmp_file_buf[MAXPARAMS*82];
char tmp_len_getstr[40];
char tmp_x_coord[40];
char tmp_y_coord[40];
int param_num=0;
int i=0,j=0,k;

if ((settings = fopen("scrape.ini", "rt"))
	== NULL){
	printf("Cannot open scrape.ini file. Exiting...\n");
	sleep(5);
	exit(1);
}

/* initialise file buffer */
for(i=0;i<MAXPARAMS*82;i++) file_buf[i]=0x00;
for(i=0;i<MAXPARAMS*82;i++) tmp_file_buf[i]=0x00;

/* read file into buffer */
i=0;
while ((byte=fgetc(settings))!=EOF){
	tmp_file_buf[i]=byte;
	i++;
}

/* remove trailing cr/lfs and end of line spaces from file in buffer */
i=0; /* index into tmp_file_buf */
j=0; /* index into file_buf */

while (byte!=0x00) {
	byte=tmp_file_buf[i];
	if (file_buf[j-1]=='\n' && byte=='\n') {
		file_buf[j]=0x00;	/* loose multiple newlines from end of file */
		break;
		}
	if (byte=='\n' && file_buf[j-1]==0x20) {
		while (file_buf[j-1]==0x20) j--;
		}
	file_buf[j]=byte;
	i++;
	j++;
}

/* intialise all structure members */
for (i=0;i<MAXPARAMS;i++){
	for (j=0;j<80;j++) params.findstr[i][j]=0x00;
	params.len_getstr[i]=-1;
	for (j=0;j<40;j++) params.environ[i][j]=0x00;
	params.x_coord[i]=-1;
	params.y_coord[i]=-1;
}

/* initialise local function variables */
for (j=0;j<40;j++) tmp_len_getstr[j]=0x00;
for (j=0;j<40;j++) tmp_x_coord[j]=0x00;
for (j=0;j<40;j++) tmp_y_coord[j]=0x00;
i=0;

/* load parameters into structure */
for (k=0;k<strlen(file_buf);k++){
	byte=file_buf[k];

	/* record the information supplied in the field supplied */
	switch (param_num) {
	case 0:;
		/* findstr */
		if (byte!=',') {
			params.findstr[param_line][i]=byte;
			i++;
		}
		break;

	case 1:;
		/* len_getstr */
		if (byte!=',') {
			tmp_len_getstr[i]=byte;
			i++;
			}
		else if (byte==',') {
			params.len_getstr[param_line]=atoi(tmp_len_getstr);
			for (j=0;j<40;j++) tmp_len_getstr[j]=0x00;
		}
		break;

	case 2:;
		/* supplied environment variable name is forced to upper case
		   to be consistent with the MS-DOS set command */

		if (byte!=','){
			params.environ[param_line][i]=toupper(byte);
			i++;
		}
		break;

   case 3:;
		/* x_coord */

		if (byte!=',') {
			tmp_x_coord[i]=byte;
			i++;
			}
		else if (byte==',') {
			if (tmp_x_coord[0]!=0x00) {
				params.x_coord[param_line]=atoi(tmp_x_coord);
				}
			for (j=0;j<40;j++) tmp_x_coord[j]=0x00;

			/* check for sensible value (0 - 79) */
			if (params.x_coord[param_line]!=-1) {
				if (params.x_coord[param_line]<0 || params.x_coord[param_line]>79){
					printf("\nX coordinate of %d. (legal range 0 - 79) on line: %d",
						params.x_coord[param_line],param_line);
					sleep(5);
					exit(1);
				}
			}
		}
		break;

	case 4:;
		/* y_coord */

		if (byte!=',' && byte!='\n') {
			tmp_y_coord[i]=byte;
			i++;
			}
		else if (byte=='\n') {
			if (tmp_y_coord[0]!=0x00) {
				params.y_coord[param_line]=atoi(tmp_y_coord);
				}
			for (j=0;j<40;j++) tmp_y_coord[j]=0x00;

			/* check for sensible value (0 - 24) */
			if (params.y_coord[param_line]!=-1) {
				if (params.y_coord[param_line]<0 || params.y_coord[param_line]>24){
					printf("\nY coordinate of %d. (legal range 0 - 24) on line: %d",
					params.y_coord[param_line],param_line);
					sleep(5);
					exit(1);
					}
				}
			}
		break;
	} /* end of switch */

	if (byte=='\n') {               /* start of a new line */
		param_line++;
		/* check to see if maxparams is exceeded */
		if (param_line > MAXPARAMS) {
			printf("Maximum No. of scrape.ini lines (%d) exceeded\n",MAXPARAMS);
			printf("exiting...");
			sleep(5);
			exit(1);
			}

		param_num=0;
		i=0;
	}

	if (byte==',') {
		param_num++;       			/* start of a new parameter */
		i=0;
		}

	}	 /* end of while */

} /* end of get_params() */


void get_screen(char *vid_buf){
/* get the contents of the current screen */

int i,j=0;
unsigned vid_seg,vid_off=0;
vid_seg=video_baseaddr;

for (i=0;i<SCN_BUFSIZE;i++) {   		/* dig out current screens text */
	vid_buf[j]=peekb(vid_seg,vid_off);	/* copy video buffer to internal buffer */
	if (i%80==79) {
		vid_buf[j+1]=0x0A;          	/* insert cr/lf pair at end of row */
		vid_buf[j+2]=0x0D;
		j=j+2;
		}
	j++;
	vid_off=vid_off+2;              	/* skip video attribute byte */
	}
	sleep(1);
} /* end of get_screen() */


int get_textoffset(int pass, char *srch_buf) {
/* search *srch_buf for first instance of params.findstr[pass] */

int i,j,k; /* local i,j and k */
int offset=-1;
int skip=-1;

for (i=0;i<80*25;i++){
	if (srch_buf[i]==params.findstr[pass][0]) {
		k=0;				 /* intialise alignment counter */
		for (j=0;j<strlen(params.findstr[pass]);j++){
			if (srch_buf[i+j]==params.findstr[pass][j]) k++;
			if (k==strlen(params.findstr[pass])) {
				offset=i+strlen(params.findstr[pass]);
				skip=0;
			}
		if (skip!=-1) break;
		} /* end of check this position  */
	if (skip!=-1) break;
	}  /* end of check matching first character */
if (skip!=-1) break;
} /* end of scan buffer */

return(offset);

} /* end of get_textoffset() */


void get_text(int offset, int pass) {
/* copy the scraped text from the screen buffer into the scrape buffer */
int i,j;

j=strlen(scrape_buf);

if (offset!=-1) {
	for (i=0;i< params.len_getstr[pass];i++) {
		scrape_buf[j+i]=vid_buf[i+offset];
		if (i==(params.len_getstr[pass])-1) {
			scrape_buf[j+i+1]=0x0A;		/* cr/lf pair at end of each row */
			scrape_buf[j+i+2]=0x0D;
			}
		}
	}
else if (offset==-1) {
	scrape_buf[j]=0x0A;					/* cr/lf pair at end of each row */
	scrape_buf[j+1]=0x0D;
	}
} /* end of get_text() */


unsigned int find_module (int mode) {
int j,k,l;
unsigned int i, temp_seg, env_seg, prog_seg;
char found_module[9]="";
/*	find a code module or environment block and return its segment address */
/*	depending on mode supplied                                             */

/* Notes:

   Using MS-DOS debug I have searched the interupt vector table for the
   current command.com segment. This revealed an undocumented (in my books)
   interrupt into command.com (int 2Eh) which I have subsequently seen
   described in other sources as 'entry point into first command.com through
   interpreter'. If we know the segment where command.com has been loaded
   it is then possible to index command.com's program segment prefix in order
   to obtain the segment offset of command.com's environment block.
   If you want to check this out by hand then use debug and mem /m command.
   Beware ! though that mem /m doesn't display the program or environment
   segment but segment minus 10h, ie one paragraph below the loaded code or
   allocated memory. This I found highly confusing but ulimately rewarding
   as this paragraph contains valuable information:
   byte 0: always 4dh (signature byte on paragraph boundary for memory
   allocation paragraph)
   byte 1-2: segment of the owning program (ie who owns this memory)
   byte 3-4: number of paragraphs that have been allocated (eg 20h is
   20h*10h bytes or 512 decimal bytes - but does not include the preceeding
   paragraph).
   byte 8-15: name of the module in a (sometimes) null terminated 'C' style
   string starting at byte 8.
   Note that the module name can only be found in the program segment memory
   allocation paragraph and is sometimes terminated with a space (20h) !.
   Other memory allocation paragraphs point back to the code segment which
   will contain the modules name.

   Don't forget that all words are stored in back-words format with the
   high order byte swaped with the low order byte.

   */

if (strcmp(module, "COMMAND")==0) {
/* fast find of command.com's master copy of the environment block */

prog_seg=peek(0x00,(0x2e*4)+2); 		/* command.com's psp offset in seg 0 */
if (mode==PROG_SEG) {
	return(prog_seg);
	}
else if (mode==ENV_SEG) {
	env_seg=peek(prog_seg,0x2c);	 	/* get environment block segment addr. */

	return (env_seg);    				/* location of environment block */
	}

} /* end of fast find master environment block */

/* check all paragraph boundaries for DOS memory allocation signature byte */
/* start at end of interrupt vector table and finish at 1 meg */

for (i=0x400;i<0xffff;i++) {
	j=peekb(i,0);
	if (j==0x4d) {
		if (peek(i,1)==i+1) {   /* find the owners segment for this memory block */
			for (k=0;k<8;k++) {
				found_module[k] = (peekb(i,k+8));
				if (found_module[k]==0x00 || found_module[k]==0x20) {
					if (found_module[k]==0x20) {
						found_module[k]=0x00;
						}
					else {
						found_module[k+1]=0x00;
						}
					break;
					}
				}
			/* found program/module is now in the string: found_module */

			#ifdef DEBUG
			printf("\nFound a module at %x :%s",i+0x01,found_module);
			sleep(1);
			#endif

			if (strcmp(module, found_module)==0) {
				/* Bingo! - this is our module */
				/* move on one paragraph past the memory allocation
				   paragraph ..*/
				env_seg=peek(i+0x01,0x2C);
				prog_seg=i+0x01;

			/* the module found is the one we want */
				if (mode==PROG_SEG) {
					/* hand back the program segment */
					return(prog_seg);
					}
				else if (mode==ENV_SEG) {
					/* hand back the environment block segment */
					/* ...having first checked that it hasn't been
					   released */

					/* then check that the DOS memory allocation paragraph
					   before this segment shows the owner to be the module */

					temp_seg=peek(env_seg-0x01,1);

					if (temp_seg!=prog_seg) {
						printf("\nThe module specified (%s) does not appear to have\n",module);
						printf("an environment block.\n");
						printf("You could check this out by executing the below command:\n");
						printf ("mem /m %s /p\n",module);
						sleep(5);
						exit(1);
						}
					return(env_seg);
					}
				}
			}
		}
	} /* end of check boundaries */

/* we didn't find the module */
printf("\nThe module (%s) does not appear to be loaded\n",module);
sleep(5);
exit(1);

return(-1);
} /* end of find_module */


void set_env() {
/* write scraped text strings to specified environment variable strings */

int i,j=0,k=0,l;
int env_line=0;
int string_off_env;
int string_off_buf;
int line_ctr=0;
int bytes_used=0;
unsigned int env_seg;
unsigned int env_seg_off=0;
char last_byte[1];
char env_vars[96][160];
char temp_str[160];

/* initialise */
last_byte[0]=0x20;
env_seg=find_module(ENV_SEG);

/* find out how many paragraphs of memory have been allocated for this
   environment block */
env_bytes=(peek(find_module(ENV_SEG) - 0x01, 3)) * 0x10;

/* initialise the env. var. array */
for (i=0;i<96;i++) {
	for (j=0;j<160;j++) {
		env_vars[i][j]=0x00;
	}
}

/* copy all environment variable strings into an array */
j=0;
for (i=0;i<env_bytes;i++) {
	if (peekb(env_seg,env_seg_off)==0x00 && last_byte[0]==0x00) {
		break;	/* end of env. var. space */
		}
	env_vars[env_line][j]=peekb(env_seg,env_seg_off);
	if (peekb(env_seg,env_seg_off)==0x00) {
		env_line++; /* next string in the array */
		j=0;
		}
	else j++;

	last_byte[0]=peekb(env_seg,env_seg_off);
	env_seg_off++;
	}

/* we now have a copy of every environment variable string in env_vars[][] */

for (i=0;i<param_line;i++) {
	/* create the left hand side of the env. var. string */

	for (j=0;j<160;j++) temp_str[j]=0x00; 	/* init temp string */

	strcpy(temp_str, params.environ[i]);
	strcat(temp_str, "=");

	/* search to see if this string already exists in env_vars[][] */
	string_off_env=-1;

	for (j=0;j<env_line;j++) {
		k=0;
		for (l=0;l<strlen(temp_str);l++) {
			if (temp_str[l]==env_vars[j][l]) k++;
			if(k==strlen(temp_str)) {
				string_off_env=j;
				break; 				/* string exists */
				}
			}
		}

	/* build the right hand side of the string */

	/* first find the relevant string in the scraped buffer
	   for this pass */

	string_off_buf=0;
	line_ctr=0;

	if (i>0) {
		for (j=0;j<	SCRAPE_BUFSIZE;j++) {
			if (scrape_buf[j]==0x0A) {
				if (line_ctr==i-1) {
					string_off_buf=j+2; 	/* skip cr/lf pair */
					break;
					}
				line_ctr++;
				}
			}
		}

	/* having located the text offset in scrape_buf copy to temp string */
	l=strlen(temp_str);
	if (scrape_buf[string_off_buf]==0x0A) {
		strcat(temp_str, "TEXT_NOT_FOUND"); /* there was no string found */
	}
	else
	for (j=0;j<params.len_getstr[i];j++) {
		if (scrape_buf[j+string_off_buf]==0x0A) break;
		temp_str[l+j]=scrape_buf[j+string_off_buf];
		}

	/* now update or add the string */

	if (string_off_env!=-1) {
		/* UPDATE existing array of env. var. */
		strcpy(env_vars[string_off_env], temp_str);
	}
	else
	{
		/* ADD to the env. var. array */
		strcpy(env_vars[env_line], temp_str);
		env_line++;
	}

} /* end of for each line of scrape.ini */

/* now write everything back to DOS ...checking for space as we go !*/

for (i=0;i<env_line;i++) {
	for (j=0;j<strlen(env_vars[i])+1;j++) {
		bytes_used++;
		}
	}
bytes_used=bytes_used+1; /* account for terminating null string */

if (bytes_used > env_bytes) {
	if (strcmp(module,"COMMAND")==0) {
		printf("\nInsufficient space for environment variables in master environment:\n");
		printf("Bytes allocated = %d, Bytes required = %d\n\n",env_bytes, bytes_used);
		printf("Try restarting MS-DOS with the below line in your config.sys:\n");
		printf("shell=command.com /e:nnnn /p\n");
		printf("- where nnnn is environment space in bytes\n");
		sleep(5);
		exit(1);
		}
	else {
		printf("\nInsufficient space for environment variables in module: %s\n",module);
		printf("Bytes allocated = %d, Bytes required = %d\n\n",env_bytes, bytes_used);
		printf("Try running the below line before loading %s:\n",module);
		printf("scrape -e\n");
		sleep(5);
		exit(1);
		}
	}

#ifdef DEBUG
printf ("\nwriting %d bytes to %s at %x\n",bytes_used,module,env_seg);
sleep(2);
for (i=0;i<env_line;i++) {
	for (j=0;j<strlen(env_vars[i])+1;j++) {
		putch(env_vars[i][j]);
		}
	putch('\r');
	putch('\n');
	sleep(1);
	}
sleep(5);
#endif

env_seg_off=0;
for (i=0;i<env_line;i++) {
	for (j=0;j<strlen(env_vars[i])+1;j++) {
		pokeb(env_seg,env_seg_off,env_vars[i][j]);
		env_seg_off++;
		}
	}

pokeb(env_seg,env_seg_off,0x00);	/* null string always terminates an */
									/* environment block */

} /* end of set_env() */


/********** main code starts here **********/

main() {
int i,j; 							/* loop control variable */

/* intialise and get setup */
initialise();
get_params();

/* acquire screen contents */
get_screen(vid_buf);

/* scrape the screen */
for (i=0;i<param_line;i++) {
	/* if coordinates are given override anchor text */
	if (params.x_coord[i]!=-1 && params.y_coord[i]!=-1) {
		j=(((params.y_coord[i])*82) + params.x_coord[i]);
	}
	else {
		j=get_textoffset(i, vid_buf);
	}
	get_text(j, i);
	}

/* _write scraped text strings to file or environment variables */
if (opmode==FILE_MODE || opmode==DEBUG_MODE) {
	_write (hdl_outfile, scrape_buf, strlen(scrape_buf));
	}
if (opmode==ENVIRON_MODE || opmode==DEBUG_MODE) {
	set_env();
	}

/* write screen contents to file */
if (prtscrn==YES || opmode==DEBUG_MODE) {
	_write (hdl_dumpfile, vid_buf, SCN_BUFSIZE);
	}

return 0;
}
