;		AutoLISP routines by yours truly

(vmon)	;pages unused defun's out to disk

;This prevents the scrolling display of the whole Lisp routine at errors:
(defun *ERROR* (msg)	;must be UPPER CASE
  (princ "Ho Hum  ")
  (princ msg)
  (terpri)		;believe it or not, this is a Line Feed
)


;FILENAME - writes filename.DWG at lower left of drawing

(defun C:FILENAME()
	(setq oldblip (getvar "blipmode"))
	(setq oldecho (getvar "cmdecho"))
	(setvar "blipmode" 0)
	(setvar "cmdecho" 0)
	(wrfname)
	(setvar "blipmode" oldblip)
	(setvar "cmdecho" oldecho)
)

(defun wrfname()
	(prompt "\nPrinting Filename...\n")
	(setq org (getvar "EXTMIN"))
	(setq startpt (polar org (/ pi 5) 0.4))
	(setq fn (getvar "DWGNAME"))
	(setq fn (strcase fn))			;make upper case
	(setq fn (strcat fn ".DWG"))		;concatenate fn and ".DWG"
;	(command "LAYER" "S" "TEXT" " " " ")	;gives 'Invalid option keyword'
	(command "text" startpt 0 fn)
)


;OVAL -  Draws an oval (rectangle with rounded ends) polyline. Prompts for 
;	 center point, width, overall length, and angle of oval.
; was SLOT.LSP V1.00	1986 by Mike Pillers - mods by JIR 4/88
(defun C:OVAL () 
  (setq c1 (getpoint "Center point of OVAL:  ")
        sw (getdist c1 "\nWidth of OVAL (or point to full width):  ")
        sl (getdist c1 "\nLength of OVAL (or point to full length):  ")
        phi (getangle c1 "\nAngle of length axis: ")
        dW (mapcar '- (polar c1 (+ phi (/ pi 2)) (/ sw 2)) c1) ;1/2 width vec
        dL (mapcar '- (polar c1 phi (/ (- sl sw) 2)) c1)       ;1/2 length vec
        v1 (mapcar '+ dL (mapcar '* '(-1 -1) dW))      ; vector from cen to p1
        v3 (mapcar '+ dW dL)                           ; vector from cen to p3
        p1 (mapcar '+ c1 v1)
        p2 (polar c1 phi (/ sl 2))
        p3 (mapcar '+ c1 v3)
        p4 (mapcar '- c1 v1)
        p5 (polar c1 phi (/ sl -2))
        p6 (mapcar '- c1 v3)
  )
  (setvar "cmdecho" 0)
  (setq tmp (getvar "pdmode"))
  (setvar "pdmode" 0)
  (command "pline" p6 p1 "A" p3 "L" p4 "A" "CL")
  (setvar "pdmode" tmp)
)


; TEXTED V 1.06		Picks the text to edit with QC2.COM resident

(defun C:TEXTED()
(graphscr)				;be sure we're on graphics screen
(prompt "\nPick text entities to edit")
(setq ss1 (ssget))			;get the selection set
(setq count 0)				;set entity count to 0
(while (< count (sslength ss1))         ;if < no. of entities, do
  (setq e1 (ssname ss1 count))          ;set e1 to ename of cur position
  (setq elist (entget e1))		;get the entity list
  (cond ((= "TEXT" (cdr(assoc 0 elist))) ;is it a text entity
    (setq text (cdr(assoc 1 elist)))	;get the text from the list
    (PROMPT " <>:")			;send a false prompt to clear
    (terpri)				;cr lf
    (setq a 1)
;display the text string as a prompt, so the resident QC.COM can find it
    (prompt " <")
    (prompt text)
    (prompt ">:")
    (textscr)				;flip to text screen
    (write-char 147)			;send triger char to screen, 93h
    (write-char 8)			;back space- still shows ''
;need to check here for QC installed, message if not
    (setq text1 (getstring 5))		;user-input new string
;produce the scrolling CLS after the user hits ENTER
    (while(<= a 32)			;'while a <= 32d'
           (terpri)			;send CR LF to screen
           (setq a (+ a 1))		;'a=a+1'
    )
    (setq textcon (cons 1 text1))	;make new dotted pair
    (setq elist(subst textcon (assoc 1 elist) elist)) ;modify the elist
    (entmod elist)			;update the entity
    ))					;close cond statement
  (setq count (+ count 1))		;bump the entity counter
  )
NIL)					;force nil to screen


;TXTHGT changes text height by layer, style name, or all same as picked.

(defun texht (lyr sty thr nsz / ent nnt)
 (prompt "\nScanning the entity database...")
 (setq ename (entnext))
  (while ename
   (setq ent (entget ename))
    (if 
       (and   
          (= (cdr(assoc 0 ent)) "TEXT")
          (if (= lyr "") T (=(cdr(assoc 8 ent)) lyr))
          (if (= sty "") T (=(cdr(assoc 7 ent)) sty))   
          (if (null thr) T (=(cdr(assoc 40 ent)) thr))
       )
          (progn
            (setq nnt (subst (cons 40 nsz) (assoc 40 ent) ent))
            (entmod nnt)
          )
    )
     (setq ename (entnext (cdar ent)))
  )
)

(defun c:tht (/ lyr sty thr)
 (if 
  (null (setq ent(car(entsel "Pick an entity or <RETURN> to specify : "))))
   (progn
    (setq lyr (strcase (getstring "  Layer name for changed text <All>: ")))
    (setq sty (strcase (getstring "  Style name for changed text <All>: ")))
    (setq thr (getreal "    Text height to search for <All>: "))
   )
   (progn
    (setq ent (entget ent))
    (setq
      lyr (cdr(assoc 8 ent))
      sty (cdr(assoc 7 ent))
      thr (cdr(assoc 40 ent))
    )
   )
 )
  (setq nsz (getreal "\n   Enter new height for chosen text: "))
  (texht lyr sty thr nsz)
)
;
; TXTOUT V1.0 By Scott Hull, 11/86
; Exports ASCII text to file.  Puts lines in REVERSE ORDER if picked by W or C !
; And, of course, each entity is a new line (ought to insert tabs & spaces
; for entities within .01 of same Y location).

(defun C:TXTOUT (/ va vb vc vd ve vf vg)

 (defun *error* (st) (prompt (strcat "error: " st "\007\n")))

 (setq va (getstring "Name of ASCII file to create: ") vb (open va "r"))
 (if (/= vb nil) (progn (close vb) (setq vc (ascii (strcase (getstring
 "A file with this name already exists.\nOverwrite it? <N> ")))))
  (setq vc 89))
 (if (= vc 89) (progn
   (setq vb (open va "w") vd (ssget) ve (sslength vd) vf 0)
   (while (< vf ve)
    (if (= "TEXT" (cdr (assoc 0 (setq vg (entget (ssname vd vf))))))
     (write-line (cdr (assoc 1 vg)) vb))
    (setq vf (1+ vf)))
   (close vb)
   (eval "DONE"))))

; LEXPLODE.LSP  V 1.0  5/25/88
;Explodes a BLOCK, POLYLINE, or DIMENSION and puts the entities on the layer
;the original entity was on, instead of Layer 0.

(defun lexerr (s)                     ; If an error (such as CTRL-C) occurs

  (if (/= s "Function cancelled")
    (princ (strcat "\nError: " s))
  )
  (setvar "cmdecho" oce)              ; restore old cmdecho value
  (setq *error* olderr)               ; restore old *error* handler
  (princ)
)
;-------- COMMON FUNCTION -----------

(defun getval (n e) (cdr (assoc n e)))

;---- GET ENTITY TO EXPLODE ----------

(defun getent (t1 / no_ent e0)
(setq no_ent T)
(while no_ent
  (if (setq e0 (entsel "\nSelect block, polyline, dimension, or mesh: "))
    (if (member (getval 0 (setq e1 (entget (car e0)))) t1)
      (if (equal (getval 0 e1) "INSERT")
        (if (and (equal (getval 41 e1) (getval 42 e1))
                 (equal (getval 42 e1) (getval 43 e1)))
          (setq no_ent nil)
          (princ "\nX, Y, and Z scale factors must be equal."))
        (setq no_ent nil))
      (princ "\nNot a block, polyline, or dimension."))
    (princ " No object found."))
))

;---------- MAIN PROGRAM ------------

(defun c:lexplode (/ oce ohl e0 en e1 s0)
(setq olderr *error*
      *error* lexerr)
(setq oce (getvar "cmdecho"))         ; save value of cmdecho
(setvar "cmdecho" 0)                  ; turn cmdecho off
(setq e0 (entlast))
(setq en (entnext e0))
(while (not (null en))                ; find the last entity              
  (setq e0 en)
  (setq en (entnext e0))
)
(getent '("INSERT" "DIMENSION" "POLYLINE"))
(command "explode" (getval -1 e1))    ; explode the entity
(setq s0 (ssadd))
(while (entnext e0) (ssadd (setq e0 (entnext e0)) s0))
(command "chprop" s0 ""               ; change entities to the proper layer
         "c"   "bylayer"              ; regardless of their extrusion direction
         "lt"  "bylayer"
         "la"  (getval 8 e1) "")
(princ (strcat "\nEntities exploded onto layer " (getval 8 e1) "."))
(setvar "cmdecho" oce)                ; restore old cmdecho value
(setq *error* olderr)                 ; restore old *error* handler
(prin1))
;
(defun C:MOVE ()
 (command ".move" "auto"))
(defun C:ERASE ()
 (command ".erase" "auto"))
(defun C:COPY ()
 (command ".copy" "auto"))
(defun C:CHANGE ()
 (command ".change" "auto"))
(defun C:SCALE ()
 (command ".scale" "auto"))
(defun C:TRIM ()
 (command ".trim" "auto"))
(defun C:ROTATE ()
 (command ".rotate" "auto"))
(defun C:MIRROR ()
 (command ".mirror" "auto"))

(defun S::STARTUP ()
 (command "undefine" "end")
 (command "undefine" "move")
 (command "undefine" "copy")
 (command "undefine" "erase")
 (command "undefine" "change")
 (command "undefine" "scale")
 (command "undefine" "trim")
 (command "undefine" "rotate")
 (command "undefine" "mirror")
)
