//Simple program reads a palette color.
//by Marcio A. A. Fialho

// To be able to recompile it, read COMPILE.TXT

#include <crt.h>
#include <stdio.h>
#include <string.h>

#include "asctoi.c"

void main (int n_ent, char *ent[2])
 {
	int a0; //palette register number (0-15)
	char a1,a2,a3; //intensities in RGB
	int a4; //error code
	int a5; //auxiliar variable
	int a6; //conversion radix

	a4=0;
	if (n_ent==1)
	 {
		printf("\
GETPAL ver 1.1 - Reads a palette register color intensities\n\n\
\tUsage: GETPAL <reg num>\n\n\
\t<reg num> => palette register number (or color number) (0-15) or (0-F)h\n\n\
by Mrcio Afonso Arimura Fialho\n\
Freeware / Public Domain");
		return;
	 }

	a5=strlen(ent[1])-1;
	if (toupper (*(ent[1]+a5))=='H')
	 {
		a6=16;
		*(ent[1]+a5)=0;
	 }
	 else
		a6=10;

	if (asctoi(&a0,ent[1],a6))
		a4=1;
	else if ((unsigned)a0>15U)
		a4=2;

	if (a4)
	 {
		fputs("ERROR: Incorrect input parameter.",stdout);
		fputs("\nType GETPAL with no parameters to get help.",stdout);
		return;
	 }

	getdacreg(getpalreg(a0),&a1,&a2,&a3); //reads register color intensities (in RGB)
	printf ("\nPalette register (color) number: %d=(%X)h\n\
intensity in Red  : %d=(%X)h\n\
intensity in Green: %d=(%X)h\n\
intensity in Blue : %d=(%X)h\n",
	a0,a0,a1,a1,a2,a2,a3,a3); //and prints it on screen
 }