/* CURSOR - REPLACES ACTIVE PAGE CURSOR SHAPE                           */
// To be able to recompile it, read COMPILE.TXT

#include <stdio.h>
#include <crt.h>
#include <ctype.h>

#include "asctoi.c"
  //asctoi defined in ASCTOI.C converts a string (in radix radix) to an integer

unsigned int main (unsigned int n_ent, char *ent[3])
 {
	int a0;

	getcrtmode ();//updates crt_page

	if (n_ent>2) //in case of too input parameters
	 {
		 printf (" Too much parameters - %s",ent[2]);
		 goto fim;
	 }
	if (n_ent<2) //if required parameter is missing
	 {
		printf ("\
Current cursor shape (in hexadecimal notation) = %.4X",getcursorsh());
		goto fim;
	 }

	if (*ent[1]=='/' && *(ent[1]+1)=='?') //displays help
	 {
		printf ("\tCURSOR\t\t\t\t\tver 1.1\t\n* * * Freeware version\
 * * * CAN BE DISTRIBUTED FREELY * * *\n\
 Reads or replaces cursor shape.\n\n\t\tCURSOR [shape]\n  where :\n\
\t shape => new cursor shape (0-FFFF) (in hexadecimal notation)\n\n\
 To get current cursor shape, type CURSOR without any input parameter\n\n\
 By Marcio Afonso Arimura Fialho\n\
 http://pessoal.iconet.com.br/jlfialho\n\
 e-mail:jlfialho@iconet.com.br");
		return 0;
	 }

	if (asctoi(&a0,ent[1],16)) //converts input to a0 and verify if input is OK
	 {
	  jmp_error:
		printf ("\nERROR: Incorrect input parameter"); //displays error message
		goto fim;
	 }

	setcursorsh (a0); //changes cursor shape
	return 0;

  fim : //displays a message and then returns
	printf ("\nFor help. Type CURSOR /?");
	return 1;
 }


// By Marcio Afonso Arimura Fialho
// http://pessoal.iconet.com.br/jlfialho
// e-mail: jlfialho@iconet.com.br or (alternate) jlfialho@yahoo.com