/****************************************************************/
/* Character attribute routines of the PCcurses package         */
/*                                                              */
/****************************************************************/
/* This version of curses is based on ncurses, a curses version */
/* originally written by Pavel Curtis at Cornell University.    */
/* I have made substantial changes to make it run on IBM PC's,  */
/* and therefore consider myself free make it public domain.    */
/*              Bjorn Larsson (...mcvax!enea!infovax!bl)        */
/****************************************************************/
/* 1.0: Release:                                        870515  */
/* 1.2: Rcsid[] string for maintenance:                 881002  */
/* 1.3: MSC -W3, Turbo'C' -w -w-pro checkes:            881005  */
/****************************************************************/

#include <curses.h>
#include <curspriv.h>

char _curses_attrib_rcsid[] = "@(#)attrib.c v1.3 - 881005";

/*  Translate the attributes code into EGA/VGA attributes */

void translate_attrs(int attrs, int *ega_attrs)
{
  int  tmp;
  int  bg = ((attrs >> 11) & 0x07);
  int  fg = ((attrs >> 8)  & 0x07);
  int  md = ((attrs >> 14) & 0x03);

  switch(md)
  {
  case  (A_HIGH >> 14) & 0x03:
    fg += 8;
    md = 0;
    break;
  case  (A_REVERSE >> 14) & 0x03:
        tmp = bg;
    bg = fg;
    fg = tmp;
    md = 0;
    break;
  case  (A_BLINK >> 14) & 0x03:
    md = 1;
  }
  *ega_attrs = ((md <<15)&0x8000) | (bg << 12) | (fg << 8);
}

/****************************************************************/
/* Wattrset() sets the attributes as specified in window 'win'. */
/****************************************************************/

void wattrset(WINDOW *win, int attrs)
  {
  int   ega_attrs;

  if(attrs != A_NORMAL)
      translate_attrs(attrs, &ega_attrs);
  else
      ega_attrs = (B_BLACK < 1) | F_GRAY;
  win->_attrs = ega_attrs & ATR_MSK;
  } /* wattrset */

/****************************************************************/
/* Wattron() sets the specified attribute(s) in window 'win'.   */
/****************************************************************/

void    wattron(WINDOW *win, int attrs)
  {
  int  tmp;
  int  bg = ((attrs >> 11) & 0x07);
  int  fg = ((attrs >> 8)  & 0x07);
  int  md = ((attrs >> 14) & 0x03);
                        
  if(fg == 0)           //  Use old colours if new colours not requested
        fg = (win->_attrs >> 8)  & 0x7;
  if(bg == 0)
        bg = (win->_attrs >> 12) & 0x7;

  switch(md)            // Change in characteristics ?
  {
  case  (A_HIGH >> 14) & 0x03:
        fg |= 0x08;
        break;
  case  (A_REVERSE >> 14) & 0x03:
        tmp = bg;
        bg  = fg;
        fg  = tmp;
        md  = 0;
        break;
  case  (A_BLINK >> 14) & 0x03:
        md = 1;
  }
  win->_attrs =  ((md<<15)&0x8000) | (bg<<12) | (fg<<8);
  } /* wattron */

/****************************************************************/
/* Wattroff() clears the specified attribute(s) in window       */
/* 'win'.                                                       */
/****************************************************************/

void    wattroff(WINDOW *win, int attrs)
  {
  int  ega_attrs;

  translate_attrs(attrs, &ega_attrs);
  win->_attrs &= (~ega_attrs & ATR_MSK);
  } /* wattroff */

/****************************************************************/
/* Wstandout() starts standout mode in window 'win'.            */
/****************************************************************/

void    wstandout(WINDOW *win)
  {
  wattron(win, A_STANDOUT);
  } /* wstandout */

/****************************************************************/
/* Wstandend() clears all special attributes in window 'win'.   */
/****************************************************************/

void    wstandend(WINDOW *win)
  {
  wattroff(win, A_STANDOUT);
  } /* wstandend */

/****************************************************************/
/* Attrset() sets the attributes as specified in stdscr.        */
/****************************************************************/

void    attrset(int attrs)
  {
  wattrset(stdscr, attrs);
  } /* attrset */

/****************************************************************/
/* Attron() sets the specified attribute(s) in stdscr.          */
/****************************************************************/

void    attron(int attrs)
  {
  wattron(stdscr, attrs);
  } /* attron */

/****************************************************************/
/* Attroff() clears the specified attribute(s) in stdscr.       */
/****************************************************************/

void    attroff(int attrs)
  {
  wattroff(stdscr, attrs);
  } /* attroff */

/****************************************************************/
/* Standout() starts standout mode in stdscr.                   */
/****************************************************************/

void    standout()
  {
  wattron(stdscr, A_STANDOUT);
  } /* standout */

/****************************************************************/
/* Standend() clears all special attributes in stdscr.          */
/****************************************************************/

void    standend(void)
  {
  wattroff(stdscr, A_STANDOUT);
  } /* standend */
