                  /* * * * * * * * * * * * * * * * * * * * *
                   *  TOKEYBUF.C (c) 1994, Jim Groeneveld  *
                   * * * * * * * * * * * * * * * * * * * * *
                                Routine ToKeyBuf
                                  Version 1.0
                               Date 30 April 1994

------------------------------------------------------------------------------
 Y. (Jim) Groeneveld, Schoolweg 14, 8071 BC Nunspeet, Nederland, 03412 60413.
Email (work): groeneveld@tno.nl, groeneveld@cmi.tno.nl, groeneveld@nipg.tno.nl
------------------------------------------------------------------------------

Function ToKeyBuf feeds keys into the keyboard buffer:
It takes them from the string Bytes up to a maximum of 15 bytes (or 30 with
pairs, ByteCode 2, see below) as far as there is space left in the buffer.
Two types of keys can be fed: single and double byte (extended) codes
+ single: ByteCode = 0 or 1, one or more ascii characters in Bytes
  - if ByteCode = 0: scan codes in buffer will be set to 0: '\0'
  - if ByteCode = 1: real scan codes of keys will be fed (future)
+ double: ByteCode  2, one or more extended (or extravagant) character
  pairs in Bytes, dependent on ByteCode consisting of:
  - if ByteCode = 2: one or more extravagant pairs with any combination of
                     ascii values and scan codes, all unequal to 0
       . 1st byte: ascii character value (except '\0')
       . 2nd byte: scan code of double byte character (except '\0')
  - if ByteCode = 3: only one or more scan codes of IBM extended keys (function
                     keys etc.) (no ascii values of '\0', because these are
                     seen as end-of-string indicators in C); ascii values in
                     buffer will be set to 0: '\0'. For scan codes of extended
                     characters see a.o. BASIC manuals.
  - if ByteCode = 4: one or more Ctrl-Break characters, consisting of both
                     ascii values and scan codes of 0, to be entered as any
                     number of (dummy) characters (!=0), up to 15;
                     both ascii values and scan codes in buffer are set to 0

Disclaimer
----------
The author is not liable for any negative consequences of the use or misuse
of these routines.

-----------------------------------------------------------------------
*/

/*-----------------------------------DEFINE-----------------------------------*/

/*----------------------------------INCLUDE-----------------------------------*/
#include <string.h>
#include "tokeybuf.h"

/*----------------------------------ToKeyBuf----------------------------------*/
int ToKeyBuf (char *Bytes, int ByteCode)
{ char Head, Tail;
  int MultFactor, NtoFeed, LoopNr, NotFed, StartChars, Start0s, Nof0s;


  if (!*Bytes) return 0;
  if (ByteCode==2) MultFactor=2; else MultFactor=1;
  if (ByteCode>=3) { StartChars=1055; Start0s=1054; }
  else { StartChars=1054; Start0s=1055; }
  if (ByteCode==4) Nof0s=2; else Nof0s=1;

  peek (0, 1050, &Head, 1); peek (0, 1052, &Tail, 1);  /* both  30 and  60 */
/* If Head = Tail then the keyboard buffer is empty */

  NtoFeed = (MIN(strlen(Bytes),    /* if ByteCode=2: force even N of bytes */
                (15-((Tail-Head)/2+16)%16)*MultFactor)/MultFactor)*MultFactor;
/*                  +---KeyBufFillSize--+                                    */

  for (LoopNr=0; LoopNr<NtoFeed; LoopNr++)
  { if (ByteCode!=4)
      poke(0,StartChars+(Tail-30+2*LoopNr/MultFactor)%32,Bytes+LoopNr,1);
/* If ByteCode=1 (LATER) feed ScanCode[Bytes[LoopNr]] */
    if (ByteCode!=2) poke(0,Start0s+(Tail-30+2*LoopNr)%32,"\0\0",Nof0s);
  }

  Tail = (Tail+2*NtoFeed/MultFactor-30)%32+30;
  poke(0,1052,&Tail,1); /* Set address of 1st byte after buffer: Tail */

  NotFed = strlen(Bytes) - NtoFeed;
  return NotFed;

} /* end of <ToKeyBuf> */

/*----------------------------------ClKeyBuf----------------------------------*/
void ClKeyBuf ()                                 /* Clear the keyboard buffer */
{ char Tail;
  peek (0, 1052, &Tail, 1); poke (0, 1050, &Tail, 1);
} /* end of <ClKeyBuf> */

/*---------------------------- That's all folks! -----------------------------

   ---------------------------------History-----------------------------------
Vs. 1.0    Initial working release with support for feeding keys:
30/04-94   + standard and IBM extended ascii values (1-255, except 0)
             (scan codes, last byte, set to 0 automatically);
           + extended key codes (double bytes), starting with a 0 byte;
           + extravagant keys, double bytes, consisting of any ascii value
             and any scan code, both not 0;
           + Ctrl-Break, consisting of double 0's (ascii value and scan code)

   ----------------------------------Future-----------------------------------
- addition of real scan codes of keys with standard ascii values

   ---------------------------------Remarks-----------------------------------
*/
