;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

;============================================================================
; DECLARE EGAMONO (BYVAL Mode%)
; CALL EGAMONO (Mode%)
; Purpose:
;	Forces VGA/EGA mono display to normal MONO attributes
; 	This allows programmer to have the same attributes appear on a 
;	HERC, MONO, or EGA Mono Display
; Input:
;       Mode%  = 0 if want default mono attributes
;       Mode% <> 0 if want Herc type attributes
; Returns: Nothing
;
; Limitations:
;        For contrast, colors can only be used against White or Intense.
;        Primary colors appear as Black.
;        Only White or Intense can be contrasted against Black.
;        Blue and Intense Blue attributes are not underlined, unlike HERC/MONO
;        All intense colors appear as white.  
; Full control over VGA is not possible because of GRAY scaling and large 
; number of DAC/palette registers.  To get control over those two features would
; make the program much larger. 
; Tinkering required for mono MCGA, but who has one of those?
;============================================================================

DOSSEG
.MODEL MEDIUM
	PUBLIC	EGAMONO
.CODE
; Store info in .CODE rather than DGROUP because DGROUP is so small
; while .CODE is very large in QBASIC

; Resets EGA Palatte Table to defaults more like the MDA than CGA
EVEN
Herc_Table      db   0, 10h, 10h, 10h, 10h, 10h, 10h,  8
		db 10h, 18h, 18h, 18h, 18h, 18h, 18h, 18h
		db   0    ;this last is the border and should be 0

; Resets EGA Palatte Table to normal EGA mono defaults
Norm_Table      db     0,   8,   8,   8,   8,   8,   8,  8
		db   10h, 18h, 18h, 18h, 18h, 18h, 18h, 18h
		db   0    ;this last is the border and should be 0


Status          db      0       ; allow us to keep track
				; of prior calls
				; Never called    = 0
				; MONO EGA        = 2
				; Everything else = 1
EVEN
EGAMONO	PROC	FAR
	Push    BP              ; permit access to stack
	Mov	BP,SP
	Cmp     Status,0        ; have we done this before?
	JE	VGATest		; nope, so test display type
	Cmp	Status,2	; is it EGA MONO
	JE	Mono1		; yes so do it
	Jmp     Finis           ; not a MONO EGA, so quit

VGATest:                        ; tests only for active display
     	Mov     AX,1A00h
     	Mov     BX,10h          ; Test for VGA adapter
     	Int     10h
     	Cmp     AL,1Ah          ; If VGA adapter exists, it returns AL=1Ah
     	Jne     EGATest         ; VGA does not exist so test for EGA
	Cmp     BL,5            ; Else VGA exists, primary display info
	Je      Mono            ; BL = 5 if have EGA mono as primary
	Cmp	BL,7
	Je	Mono		; BL = 7 if have VGA mono as primary

OtherDsp:
	Mov	Status,1	; VEGA/EGA not active, report other mode & quit
	Jmp	Short Finis     ; 

EGATest:
	Mov     AX,1200h
	Mov     BX,10h
	Int     10h
	Cmp     BL,10h          ; EGA changes BL from 10h
	Je      OtherDsp        ; no EGA assume other
	Mov     DX,BX           ; Save BX temporarily in DX
	Xor     BX,BX		; read BIOS ram
	Mov     ES,BX           ; EGA active?, bit 3 of 0040:0087 set?
	Test    Byte Ptr ES:[487h],1000b
	JZ      EGA_active      ; if bit clear, then EGA is active
	Jmp     Short OtherDsp  ; else if EGA not active (primary).
				; report other display active and quit
EGA_active:
	Mov     BX,DX           ; get former value back from DX
	Or      BH,BH           ; if BH = 1 then have MONO display

	JNZ     Mono            ; report EGA Mono display
	Jmp     Short  OtherDsp ; else report other display active & quit

Mono:
	Mov	Status,2	; report have VGA/EGA mono

Mono1:
	;some unneeded code shows how to manage EGA
	;CLI                     ; must clear interrupts
	;Mov     DX,03BAh        ; reset attribute controller flip-flop
	;In      AL,DX           ; by reading toggle port
	;Mov     DX,03C0h        ; attribute controller address
	;Mov     AL,30h          ; set address of Mode Control w/o turning
 				 ; off display
	;Out     DX,AL           ; write address
	;Mov     AL,0110b        ; Turn blinking off, enable line characters
				 ; assume display type is mono
				 ; assume alpha mode
	;Out     DX,AL           ; send it out
	;STI                     ; turn on interrupts

	Mov     AX,CS           ; reload a default palette for EGA mono
	Mov     ES,AX

	Assume  DS:Nothing, ES:@code   ; This required so OFFSET works
					; when table in .CODE rather than
					; in DGROUP

	Mov     BX,[BP+6]
	Or      BX,BX            ; Is Mode% = 0
	JZ      Norm_Pal         ; then load default EGA Mono Palette

Herc_Pal:                        ; else do Herc Palette

	Mov     DX, OFFSET Herc_Table
	Mov     AX,1002h         ; reload Palette with table at ES:DX
	Int     10h              ; table is 17 bytes long

				 ; turn on underlining
	Xor     BX,BX            ; set BX to 0
	Mov     ES,BX            ; set ES to 0

	Assume  ES:Nothing

	Mov     AH,ES:[0485h]    ; read character height
	Dec     AH               ; reduce character height by 1
	Mov     DX,03B4h         ; load CRTC port address for mono display
	Mov     AL,14h           ; underline location address register
	Out     DX,AX            ; out AH to underline register


	Jmp     Short Finis

Norm_Pal:

	Assume  ES:@code

	Mov     DX, OFFSET Norm_Table
	Mov     AX,1002h         ; reload Palette with table at ES:DX
	Int     10h              ; table is 17 bytes long
				 ; turn off underlining
	Xor     BX,BX            ; set BX to 0
	Mov     ES,BX            ; set ES to 0

	Assume  ES:Nothing

	Mov     AH,ES:[0485h]    ; read character height
	Mov     DX,03B4h         ; load CRTC port address for mono display
	Mov     AL,14h           ; underline location address register
	Out     DX,AX            ; out AH to underline register

Finis:
	Assume  DS:@data, ES:Nothing
	Pop	BP
	Ret
EGAMONO	ENDP
END
