'Copyright 1997 SOFTMASTERS, PO Box 7851, Van Nuys, CA, 91409

'DEMO3.BAS 1.0 06-01-97 and part of SOFTMASTERS Packet 1.0 for BASIC.

'A BASIC source-file for demonstration purposes only of how to use all
'SOFTMASTERS BASIC procedures in the MASTERSQ.QLB BASIC Quick Library and
'the MASTERSQ.LIB stand-alone BASIC Library for Microsoft QuickBASIC 4.x
'or the MASTERSP.QLB BASIC Quick Library and the MASTERSP.LIB stand-alone
'BASIC library for Microsoft ProBASIC 7.x in your BASIC programming.
'Please see the SOFTMASTERS manual and your BASIC programming manuals for
'full details.

'Start your BASIC programming environment with the appropriate MASTERS_.QLB
'Quick Library. For example, with Microsoft QuickBASIC 4.x, from your DOS
'command line prompt type:

'                        C:> QB /L MASTERSQ DEMO3.BAS

'which starts QuickBASIC, loads MASTERSQ.QLB, and this file. Run the program
'and watch your screen display. If you wish, go back at any time and experiment
'with the any of the procedures parameters to see how they work. But first,
'please make a back-up copy of this file and perhaps a print copy to follow
'along with.

'Both the MASTERSQ.LIB and MASTERSQ.QLB files must be installed in the same
'directory as QuickBASIC, or in a library directory, and a SET LIB=<full
'pathname to the library directory> in your DOS environment so QuickBASIC
'can find both files.

'For Microsoft Pro BASIC 7.x, from the DOS command line prompt type:

'                        C:> QBX /L MASTERSP DEMO3.BAS

'Place BASIC Declare statements at the beginning of your program which is
'required for each SOFTMASTERS BASIC procedure you are going to use.

DECLARE FUNCTION Date1$ (row%, col%, fore%, back%)
DECLARE FUNCTION Date2$ (row%, col%, fore%, back%)
DECLARE FUNCTION Date3$ (row%, col%, fore%, back%)
DECLARE FUNCTION Date4$ (row%, col%, fore%, back%)
DECLARE FUNCTION Day1$ (row%, col%, fore%, back%)
DECLARE FUNCTION Day2$ (row%, col%, fore%, back%)
DECLARE FUNCTION Month1$ (row%, col%, fore%, back%)
DECLARE FUNCTION Month2$ (row%, col%, fore%, back%)
DECLARE SUB Picture (row%, col%, rows%, cols%, style%, fore%, back%)

'or you can use SOFTMASTERS MASTERS.INC file which makes use of BASICs
''$Include: Metacommand statement. Then you can avoid having to list each
'Declare statement and at the beginning of your program place the BASIC
'statement:

'                       '$INCLUDE: 'MASTERS.INC'

'The MASTERS.INC file should be in your BASIC source-files directory.

'The Keypress and Message sub-programs are not included in the SOFTMASTERS
'MASTERS_ BASIC libraries. The Keypress sub pauses the screen display and
'waits for any key to be pressed before the program can continue and the
'Message sub displays a message

DECLARE SUB Keypress ()
DECLARE SUB Message ()

'After a SOFTMASTERS BASIC procedure is declared, it is ready to use just
'like any BASIC programming statement.

DEFINT A-Z

'Microsoft BASIC programming languages default to single-precision numeric
'variables using 4 bytes each. Integers use only 2 bytes each. Always use a
'DEFINT A-Z BASIC statement in your programs so numeric variables will
'automatically be typed as an integer which will help reduce the size and
'increase the speed of your compiled BASIC programs.

'First, we'll demonstrate the SOFTMASTERS Picture BASIC procedure.

'Set the screen to 0 for text mode, enable color, display page 0, and a
'80 column by 25 row screen size.

SCREEN 0, 1, 0, 0
WIDTH 80, 25

'Set the screen colors to a white text foreground on a blue background and
'clear the screen.

COLOR 15, 1
CLS

'Display a Picture starting at screen row 10 for 6 rows down and at screen
'column 16 for 50 columns to the right, using style 1, a picture with a
'single-line frame and no background shadow, with a white frame-text color
'number 15 and a red picture color number 4.

Picture 10, 6, 16, 50, 1, 15, 4

'The screen will display a blue screen, and a red picture with a white
'single-line frame and no background shadow, occupying rows 10 to 15 and
'columns 16 to 65.

'Use the BASIC Locate and Print statements to display some text in the
'picture area. Don't print in the first or last row of the picture or it
'will overwrite the frame. The text will display in the same color as the
'Picture frame-text color.

LOCATE 12, 19
PRINT "A red picture with a white single-line frame"
LOCATE 13, 19
PRINT "and white text with no background shadow."
Keypress

'Clear the screen and display the same picture with a style 2, double-line
'frame and no background shadow, then display the text.

CLS
Picture 10, 6, 16, 50, 2, 15, 4

LOCATE 12, 19
PRINT "A red picture with a white double-line frame"
LOCATE 13, 19
PRINT "and white text with no background shadow."
Keypress

'Clear the screen and display the same picture with a style 3, solid-bar
'frame and no background shadow, then display the text.

CLS
Picture 10, 6, 16, 50, 3, 15, 4

LOCATE 12, 19
PRINT "A red picture with a white solid-bar frame"
LOCATE 13, 19
PRINT "and white text with no background shadow."
Keypress

'Clear the screen and display the same picture with a style 4, no-frame
'and no background shadow, then display the text.

CLS
Picture 10, 6, 16, 50, 4, 15, 4

LOCATE 12, 19
PRINT "A red picture with no frame and white text"
LOCATE 13, 19
PRINT "with no background shadow."
Keypress

'We'll cycle through the same pictures again but now with a background shadow,
'then display the text.

CLS
Picture 10, 6, 16, 50, 5, 15, 4
LOCATE 12, 19
PRINT "A red picture with a white single-line frame"
LOCATE 13, 19
PRINT "and white text with a background shadow."
Keypress

CLS
Picture 10, 6, 16, 50, 6, 15, 4
LOCATE 12, 19
PRINT "A red picture with a white double-line frame"
LOCATE 13, 19
PRINT "and white text with a background shadow."
Keypress

CLS
Picture 10, 6, 16, 50, 7, 15, 4
LOCATE 12, 19
PRINT "A red picture with a white solid-bar frame"
LOCATE 13, 19
PRINT "and white text with a background shadow."
Keypress

CLS
Picture 10, 6, 16, 50, 8, 15, 4
LOCATE 12, 19
PRINT "A red picture with no frame and white text"
LOCATE 13, 19
PRINT "with a background shadow."
Keypress

'There are numerous Picture display combinations. For example, a Picture with
'with blinking text.

'Display the first picture again.

CLS
Picture 10, 6, 16, 50, 4, 15, 4

'To have text in the picture blink, add 16 to the foreground color in a BASIC
'Color statement placed just before the text to be displayed. Use the same
'same screen color as the Picture color. For a white blinking foreground text,
'use 31 (white foreground color 15 + 16 = 31).

COLOR 31, 4
LOCATE 12, 19
PRINT "A red picture with no frame and blinking white"
LOCATE 13, 19
PRINT "text with no background shadow."
Keypress

'Restore the screen to non-blinking text with another BASIC Color statement
'or all your screen text will continue to blink.

COLOR 15, 1
CLS

'For another visual effect, call the picture procedure using one color for the
'Picture frame

Picture 10, 6, 14, 54, 3, 12, 4

'and a contrasting foreground color for the text in the picture with a BASIC
'Color statement just before the text

COLOR 14, 4
LOCATE 12, 18
PRINT "A red picture with a bright-red solid-bar frame"
LOCATE 13, 18
PRINT "and yellow text with no background shadow."
Keypress

'For a different visual effect, use the same color for both the screen and
'the Picture.

COLOR 15, 1
CLS

Picture 10, 6, 14, 54, 7, 15, 1

LOCATE 12, 18
PRINT "A blue picture with a white solid-bar frame and"
LOCATE 13, 18
PRINT "text with a background shadow on a blue screen."
Keypress

'The Picture variations are limited only by your imagination and ingenuity.
'If you come up with some real shockers, send them on to us. We may use them
'in future releases. You'll be given credit.

'Now, we'll demo the SOFTMASTERS Date_$, Day_$, and Month_$ BASIC procedures.

'Say you are writing a BASIC database or a checkbook program and wish to
'enter a date into your program repeatedly without having to retype the date
'every time. Simple! Just assign a BASIC string variable in your program to
'any of the Date_$ BASIC procedures and set the parameters to display the
'date at the row, column, foreground and background color you want.

'Set the screen colors to a white text foreground on a blue background, then
'clear the screen.

COLOR 15, 1
CLS

'Using the BASIC string variable d$, display the Date1$ procedure on the
'SCREEN at row 12, column 35, with a yellow foreground color number 14 and
'a red background color number 4. The Message sub-program displays a message
'at the bottom of the screen. It has no effect on the BASIC procedure and
'has to be placed before the Date1$ procedure which pauses waiting for the
'Enter key to be pressed.

Message
d$ = Date1$(12, 35, 14, 4)

'With the date displayed on the screen, use the Grey + key on the numeric
'keypad to advance the date 1-day at a time and the Grey - key to reduce the
'date 1-day at a time. When the desired date is displayed, press the ENTER
'key to end the display and the BASIC string variable d$ will be equal to
'that date.

'To verify this, use the BASIC Print and Locate statements to display the
'string variable d$ after the assignment.

COLOR 14, 1
LOCATE 16, 8
PRINT "The Date1$ procedure sets the BASIC string variable d$ = "; d$
Keypress

'Then you can use d$ anywhere you wish in your BASIC program, d$ will always
'be equal to that date until you use d$ in another assignment. Or you can use
'any other BASIC string variable such as b$ or todays_date$ in another
'assignment to the Date1$ procedure.

'We'll cycle through the rest of the Datex$, Dayx$, and Monthx$ procedures.

CLS
Message
d$ = Date2$(12, 35, 14, 4)
COLOR 14, 1
LOCATE 16, 8
PRINT "The Date2$ procedure sets the BASIC string variable d$ = "; d$
Keypress

CLS
Message
d$ = Date3$(12, 34, 14, 4)
COLOR 14, 1
LOCATE 16, 7
PRINT "The Date3$ procedure sets the BASIC string variable d$ = "; d$
Keypress

CLS
Message
d$ = Date4$(12, 34, 14, 4)
COLOR 14, 1
LOCATE 16, 7
PRINT "The Date4$ procedure sets the BASIC string variable d$ = "; d$
Keypress

CLS
Message
d$ = Day1$(12, 38, 14, 4)
COLOR 14, 1
LOCATE 16, 11
PRINT "The Day1$ procedure sets the BASIC string variable d$ = "; d$
Keypress

CLS
Message
d$ = Day2$(12, 35, 14, 4)
COLOR 14, 1
LOCATE 16, 9
PRINT "The Day2$ procedure sets the BASIC string variable d$ = "; d$
Keypress

CLS
Message
d$ = Month1$(12, 38, 14, 4)
COLOR 14, 1
LOCATE 16, 10
PRINT "The Month1$ procedure sets the BASIC string variable d$ = "; d$
Keypress

CLS
Message
d$ = Month2$(12, 35, 14, 4)
COLOR 14, 1
LOCATE 16, 9
PRINT "The Month2$ procedure sets the BASIC string variable d$ = "; d$
Keypress

'Thank you for trying SOFTMASTERS and trust that you found this BASIC program
'and the SOFTMASTERS BASIC procedures useful. If so, please register, and tell
'your family, friends, and neighbors. If not, tell us.

COLOR 15, 1
CLS
END

SUB Keypress

'Sub-program pauses the screen and displays a message waiting for any
'key to be pressed before continuing with the program.

LOCATE 24, 22
COLOR 14, 1
PRINT ". . . Press any key to continue . . .";
DO
LOOP UNTIL LEN(INKEY$)
END SUB

SUB Message

'Sub-program displays a message on the screen.

LOCATE 24, 22
COLOR 14, 1
PRINT " Press Grey + or - key  ENTER to End ";

END SUB

