'SEE8-100.BAS
'
'8 bit RAW file viewer 1.00 -- written by Lloyd Chang
'
'purpose: Displays a 8 bit RAW file in 320x200x256
'         mode (SCREEN 13)
'        
'note: The user of this program has to know the
'      horizontal size of the 8 bit RAW file beforehand.
'      The horizontal size can be designated by
'      manipulating the RAWWidth% integer.
'
'note: An error might occur when this program is
'      used in the QuickBASIC Environment.
'      Try using RAW100.EXE or recompiling RAW100.BAS
'
'note: Discoloration may occur.  This is due to the
'      available of colors in a 256 color RGB palette,
'      although the problem is caused by RAW100.BAS,
'      not SEE8-100.BAS, since dithering is not supported
'      in RAW100.BAS
'
'      However, a 256 color RGB palette is useful since
'      it replaces constant palette switching, which is
'      a hassle when writing programs such as games.
'
'      But, if the programmer is writing a picture
'      viewer, he or she should switch palettes in
'      between different picture (by loading the
'      corresponding palette of the graphic file).
'
'note: An error might occur when this program is
'      used in the QuickBASIC Environment.
'      Try reducing BufferSize%.
'
'files that should accompany this program: ASTRNAUT.24
'                                          ASTRNAUT.8
'                                          ASTRNAUT.JPG
'                                          BRUN45.EXE
'                                          FILE_ID.DIZ
'                                          INDEX.TXT
'                                          RAW100.BAS
'                                          RAW100.EXE
'                                          RGB.PAL
'                                          RGB100.BAS
'
DECLARE SUB RGBLoad ()
SCREEN 13
RGBLoad
DEFINT A-Z
RAWWidth% = 320
BufferSize% = 32766
Buffer$ = SPACE$(BufferSize%)
OPEN "ASTRNAUT.8" FOR BINARY AS #1
DO
  GET #1, , Buffer$
  FOR Count% = 1 TO BufferSize%
    Counter& = (Carrier& * BufferSize%) + Count%
    SELECT CASE Counter&
      CASE IS > LOF(1)
        EXIT FOR
    END SELECT
    Y% = Counter& \ RAWWidth%
    X% = (Counter& - 1) MOD RAWWidth%
    PSET (X%, Y%), ASC(MID$(Buffer$, Count%, 1))
  NEXT Count%
  Carrier& = Carrier& + 1
LOOP UNTIL EOF(1)
CLOSE #1

DEFSNG A-Z
SUB RGBLoad
DEFINT A-Z
RGBFile% = FREEFILE
OPEN "RGB.PAL" FOR BINARY AS #RGBFile%
RGBPalette$ = SPACE$(768)
GET #RGBFile%, , RGBPalette$
CLOSE #RGBFile%
DIM RGBPal(0 TO 255) AS LONG
FOR Count% = 0 TO 255
  Red% = (ASC(MID$(RGBPalette$, ((Count% * 3) + 1), 1)) \ 4)
  Green% = (ASC(MID$(RGBPalette$, ((Count% * 3) + 2), 1)) \ 4)
  Blue% = (ASC(MID$(RGBPalette$, ((Count% * 3) + 3), 1)) \ 4)
  RGBPal(Count%) = (65536 * Blue% + 256 * Green% + Red%)
NEXT Count%
PALETTE USING RGBPal
END SUB

