DEFINT A-Z
DECLARE SUB zipdir (f$, z() AS ANY)
DECLARE FUNCTION Seekit& (name$, search$, ptr&)
                                                'you should use these declarations
                                                ' in your application

'  the TYPE ZIPDIR record array will hold the file information
'  this record array will conform to the "Local File Header" as referred
'  to in "APPNOTE.TXT" contained within PKZIP101.EXE, except for the
'  signature bytes which are not necessary.  This approach doesn't allow
'  retrieving the file attribute, or zipfile comments, but does not
'  require passing the larger array that would be required by accessing the
'  zip directory header


' use:  QB ZIPTEST /L ZIPDIRS


TYPE zipdir
  zby AS INTEGER                                'version zipped by
  flag AS INTEGER                               'general purpose flag
  compress AS INTEGER                           'compression method
  tim  AS INTEGER                               'last mod time flag
  dat AS INTEGER                                'last mod file date
  crc  AS LONG                                  ' crc-32
  zsize AS LONG                                 'compressed size
  nsize AS LONG                                 'uncompressed size
  fnlen AS INTEGER                              'filename length
  extralen AS INTEGER                           'extra field length
  fnam AS STRING * 12                           'filename
END TYPE




REM $DYNAMIC                  
DIM z(1) AS zipdir                              'MUST be DIM'd as a dynamic
                                                'array, since it is re-dimmed
                                                'to the number of files
                                                'in the ZIP

LINE INPUT "File to zip view?:"; f$

ON ERROR GOTO handler

OPEN f$ FOR INPUT AS #1: CLOSE #1              'phony check for existence of
                                               ' zip file


CALL zipdir(f$, z())

IF z(0).zby = -1 THEN                           'zipdir sets this to a -1 if
   PRINT "Not a ZIP"                            'it can't find any zip file
   END                                          'headers
END IF

PRINT STRING$(80, "-")                          'show what we found
PRINT "Number of entries in ZIP: "; UBOUND(z)
PRINT STRING$(80, "-")
PRINT " Filename      Length    Size       Date       Time       CRC-32     Method"

FOR count = 1 TO UBOUND(z)
    
      n = z(count).dat                          'since the date is packed into
      day = n AND &H1F                          '2 bytes, we need to unpack it
  
      n = n \ 32

      mnth = n AND &HF
      n = z(count).dat
      n = n \ 512
      year = n + 1980
    
      'pretty up the date a bit for display
      dt$ = LTRIM$(RTRIM$(STR$(mnth))) + "-" + LTRIM$(RTRIM$(STR$(day))) + "-" + LTRIM$(RTRIM$(STR$(year)))
     x = LEN(dt$): IF x < 10 THEN dt$ = dt$ + SPACE$(10 - x)
    
     n = z(count).tim                           'unpack the time
     sec = n AND &H1F
     n = n \ 32
     min = n AND &H3F
     hour = z(count).tim
     hour = (hour \ 2048) AND &H1F
   
     tm$ = LTRIM$(RTRIM$(STR$(hour))) + ":" + LTRIM$(RTRIM$(STR$(min))) + "." + LTRIM$(RTRIM$(STR$(sec)))
     x = LEN(tm$): IF x < 8 THEN tm$ = tm$ + SPACE$(8 - x)
     PRINT z(count).fnam; "   ";
     PRINT USING "######"; z(count).nsize;      'uncompressed size
     PRINT "   ";
     PRINT USING "######"; z(count).zsize;      'compressed size
     PRINT "   ";
     PRINT dt$; "   "; tm$; "   "; HEX$(z(count).crc); "   ";   'crc

    SELECT CASE z(count).compress               'show method of compression
      CASE 0
         method$ = "Stored"

      CASE 1
         method$ = "Shrunk"
      CASE 2
         method$ = "Reduce-1"
      CASE 3
         method$ = "Reduce-2"
      CASE 4
         method$ = "Reduce-3"
      CASE 5
         method$ = "Reduce-4"
      CASE 6
         method$ = "Imploded"

      CASE ELSE
         method$ = "Unknown"
    END SELECT
     PRINT method$




NEXT

END
handler:
  PRINT "File does not exist"
  END

