' LANSTAT.BAS - LANTastic function calls for QB. - Chip Morrow
'
' Compile/Link via:
'
'    QB LANSTAT /O;
'    LINK LANSTAT,,NUL,QB;
'
' $INCLUDE: 'QB.BI'                       ' INTERRUPT Types/Declares
'
DEFINT A-Z                                ' Everybody's an integer

DECLARE FUNCTION NetBios% ()
DECLARE FUNCTION NetCancel% (DevName$)
DECLARE FUNCTION NetName% (Machine$)
DECLARE SUB GetDevice (DeviceNum%, DevName$, NetPath$)
DECLARE SUB Inactive (EntryNum%, Returned$)
DECLARE SUB LoggedIn (EntryNum%, LogName$)
DECLARE SUB NetVersion (Major%, Minor%)
DECLARE SUB Redirect (DevType%, DevName$, NetPath$)
DECLARE SUB Strip (A$, B$)

COMMON SHARED Registers AS RegType        ' Pass Registers TYPE variable to
                                          ' all subs/functions.

' Sample implementation of most of these routines follows.
' (Similar to LANTastic's "NET SHOW" command).

PRINT "LANStat - your current status on a LANTastic network."
PRINT

IF NetBios THEN                            ' Determine if netbios is present.
   Q = NetName(Machine$)                   ' Get machine name.
   NetVersion Major, Minor                 ' Get major and minor version #'s.
   PRINT "   LANTastic version is: ";                     ' Display results..
   PRINT LTRIM$(STR$(Major)); "."; LTRIM$(STR$(Minor))    ' ...
   PRINT "Current machine name is: "; Machine$            ' ...
   PRINT                                                  ' ...

   ' ---------------------------------------------------------------------
   ' First, get a list of devices that you are redirecting to this station.
   ' ---------------------------------------------------------------------

   Index = 0                            ' Always start at zero.

   DO                                   ' Start looping...
     GetDevice Index, D$, N$               ' Get current device redirection.
     IF D$ = "" THEN EXIT DO               ' Jump out if nothing on this pass
     PRINT D$; " is redirected to "; N$    ' Display results from GetDevice.
     Index = Index + 1                     ' Increment index.
   LOOP                                 ' Get next device entry.

   ' ------------------------------------------------------------------
   ' Next, get a list of server names that you're currently logged into.
   ' ------------------------------------------------------------------

   PRINT
   Index = 0                            ' Reset our index

   DO                                   ' Start looping...
     LoggedIn Index, Log$                  ' Get a server name
     IF Log$ = "" THEN EXIT DO             ' Jump out if nothing on this pass
     PRINT "Logged into: "; Log$           ' Display result from LoggedIn.
     Index = Index + 1                     ' Increment index.
   LOOP                                 ' Get next server name.

   ' --------------------------------------------------------------------
   ' Now get a list of available servers that you haven't yet logged into.
   ' --------------------------------------------------------------------

   PRINT
   Index = 0                            ' Reset our index

   DO                                   ' Start looping...
     Inactive Index, Log$                  ' Get inactive server name
     IF Log$ = "" THEN EXIT DO             ' If nothing, jump out
     PRINT "Available: "; Log$             ' Display result from Inactive
     Index = Index + 1                     ' Increment index
   LOOP                                 ' Get next server name

ELSE                                    ' No netbios present, so get out.

   PRINT "NetBios not installed."
   END

END IF

' --------------------------------------------------------------------
' Quickie implementation of Redirect and NetCancel routines.
' Device name to redirect or cancel should be c:, d:, prn, lpt:, etc.
' Server's path should be full path, such as \\node1\cdrive
' --------------------------------------------------------------------

DO

  PRINT "R)edirect, C)ancel redirection, or Q)uit : ";

  DO
    Z$ = UCASE$(INKEY$)
    SELECT CASE Z$
      CASE "R", "C", "Q": EXIT DO
    END SELECT
  LOOP

       PRINT Z$

       SELECT CASE Z$:

	 CASE "R":                                            ' Redirect
	    PRINT "Drive letter or logical device ---> ";
	    LINE INPUT "", ReDir$
	    PRINT "Server's path to use -------------> ";
	    LINE INPUT "", SPath$
	    PRINT "Device type = P)rinter, or D)isk -> ";
	    DO
	      Z$ = UCASE$(INKEY$)
	      SELECT CASE Z$
		CASE "P", "D": EXIT DO
	      END SELECT
	    LOOP
	    PRINT Z$
	    SELECT CASE Z$
	      CASE "P":  DevType = 3            ' 3 = printer
	      CASE ELSE: DevType = 4            ' 4 = disk
	    END SELECT

	    Redirect DevType, ReDir$, SPath$    ' Do it.

	    IF DevType > 0 THEN                 ' Devtype = 0 if no error.
	       PRINT "Error"; DevType;
	       PRINT " - no redirection performed."
	    ELSE
	       PRINT "Redirection successful."
	    END IF
	    PRINT

	 CASE "C":                                          ' Cancel
	    PRINT "Drive letter or logical device --> ";
	    LINE INPUT "", DevName$

	    Z = NetCancel(DevName$)            ' Do it.

	    IF Z > 0 THEN                      ' Z = 0 if no error.
	       PRINT "Error"; Z; " - unable to cancel redirection."
	    ELSE
	       PRINT "Redirection successfully cancelled."
	    END IF
	    PRINT

	 CASE "Q", CHR$(27):            ' Quit
	   EXIT DO

       END SELECT

LOOP

END

' End sample.  Subs & functions follow.

' **************************************************************************

SUB GetDevice (DeviceNum%, DevName$, NetPath$)   ' Get redirected device entry.
  '
  ' DeviceNum% begins at zero (for first entry).
  ' DevName$ is returned as the name of the redirected device.
  ' NetPath$ is returned as the name of the server's network path.
  '
  ' DevName$ is returned as a nul string if DeviceNum is invalid.
  '
  DIM DevNam AS STRING * 16
  DIM NetPat AS STRING * 128
  Registers.ax = &H5F02
  Registers.bx = DeviceNum
  Registers.si = VARPTR(DevNam)
  Registers.di = VARPTR(NetPat)
  INTERRUPT &H21, Registers, Registers
  Strip DevNam, DevName$
  Strip NetPat, NetPath$
END SUB

SUB Inactive (EntryNum%, Returned$)
  '
  ' Display a list of servers that are available, but that you haven't
  ' logged into.
  '
  ' EntryNum% is input to the routine, and begins at zero (for first entry).
  ' Returned$ is returned as the name of the server, or as "" if an invalid
  '           EntryNum is passed.
  '
  DIM CurrentEntry AS STRING * 16
  Registers.ax = &H5F84
  Registers.bx = EntryNum
  Registers.di = VARPTR(CurrentEntry)
  INTERRUPT &H21, Registers, Registers
  Strip CurrentEntry, Returned$
  IF Returned$ <> "" THEN
     Returned$ = "(" + Returned$ + ")"
  END IF
END SUB

SUB LoggedIn (EntryNum%, Logged$)
  '
  ' Display a list of servers that you're currently logged into.
  ' EntryNum% begins at zero (for first entry).
  ' Logged$ returns the server name, or a nul string if invalid EntryNum.
  '
  DIM CurrentEntry AS STRING * 16
  Registers.ax = &H5F80
  Registers.bx = EntryNum
  Registers.di = VARPTR(CurrentEntry)
  INTERRUPT &H21, Registers, Registers
  Strip CurrentEntry, Logged$
END SUB

FUNCTION NetBios%                     ' Determine if NetBios is present.
   '
   ' NetBios =  0 (Not installed), or
   '           -1 (Installed).
   '
   Registers.ax = 0
   INTERRUPT &H2A, Registers, Registers
   AH = Registers.ax \ 256
   IF AH = 0 THEN
      NetBios% = 0
   ELSE
      NetBios% = -1
   END IF
END FUNCTION

FUNCTION NetCancel% (DevName$)                  ' Cancel device redirection.
  '
  ' Cancel redirection of a device.
  ' DevName$ is device name to cancel redirection for,
  ' NetCancel% returns an error code if unsuccessful, zero otherwise.
  '
  Registers.ax = &H5F04
  Registers.si = SADD(DevName$)
  INTERRUPT &H21, Registers, Registers
  IF Registers.flags AND 1 THEN
     NetCancel% = Registers.ax
  ELSE
     NetCancel% = 0
  END IF
END FUNCTION

FUNCTION NetName% (Machine$)          ' Get current machine name.
  '
  ' This routine takes no inputs.  It returns:
  '
  ' NetName% is the machine number (or zero if error)
  ' Machine$ is the current machine name.
  '
  DIM MName AS STRING * 16
  Registers.ax = &H5E00
  Registers.dx = VARPTR(MName)
  INTERRUPT &H21, Registers, Registers
  IF Registers.flags AND 1 THEN       ' Carry flag is set. (Error)
     NetName% = 0
     LSET MName = "N/A"
     Strip MName, Machine$
     EXIT FUNCTION
  END IF
  CH = Registers.cx \ 256
  IF CH = 0 THEN
     NetName = 0
     EXIT FUNCTION
  END IF
  NetName = Registers.cx - (CH * 256)    ' CL
  Strip MName, Machine$
END FUNCTION

SUB NetVersion (Major%, Minor%)          ' Determine LANTastic version.
  '
  ' Nothing is input to the routine.
  ' Major%  and  Minor% are returned as the version numbers.
  ' (Version 2.57 would be returned as Major = 2, Minor = 57)
  '
  Registers.ax = &HB809
  INTERRUPT &H2F, Registers, Registers
  Major% = Registers.ax \ 256            ' AH
  Minor% = Registers.ax - (Major * 256)  ' AL
END SUB

SUB Redirect (DevType%, DevName$, NetPath$)      ' Redirect a device
  '
  ' Inputs:
  '
  ' DevType% = 3 for Printer device, or
  '            4 for disk device.
  '            DevName$ = "C:", "D:", "LPT1:", etc.
  '            NetPath$ = Server's network path to redirect, in the format:
  '                       \\server_name\device_name
  ' -----------------------------------------------------------------------
  ' OutPut:
  '
  ' DevType% returns zero if no error, or error number if one occurred.
  '
  DIM DevNam AS STRING * 16
  DIM NetPat AS STRING * 128
  LSET DevNam = DevName$ + CHR$(0)
  LSET NetPat = NetPath$ + CHR$(0)
  Registers.ax = &H5F03
  Registers.bx = DevType
  Registers.cx = 0
  Registers.si = VARPTR(DevNam)
  Registers.di = VARPTR(NetPat)
  INTERRUPT &H21, Registers, Registers           ' Duitoit.
  DevType = 0
  IF Registers.flags AND 1 THEN                  ' Carry flag indicates error.
     DevType = Registers.ax
  END IF
END SUB

SUB Strip (A$, B$)                         ' Kludge to trim down fixed-length
					   ' strings.
   B$ = ""
   FOR Z = 1 TO LEN(A$)
      C$ = MID$(A$, Z, 1)
      IF C$ <> " " AND C$ <> CHR$(0) THEN
	 B$ = B$ + C$
      END IF
   NEXT

END SUB

