;ZeroTrim.ASM
;Copyright (c) 1992 Jay Munro
;QB45 version
;Syntax
;  Trimmed$ = ZeroTrim$(XString$)
;
;  Where XString contains leading CHR$(0)'s, Spaces (32), or Ascii Zeros
;  Chr$(48).
;Compile With Masm 5.1 or later

.Model Medium, Basic
.Data

   DescLen      DW  ?
   DescAdr      DW  ?
   
.Code

ZeroTrim Proc   XString:Word
       Mov  BX,XString          ;get address of XString descriptor
       Mov  CX,[BX]             ;get length of XString
       Jcxz Done                ; goofy user, passed zero length string
       Mov  BX,[BX+2]           ;get address of XString into BX

TrimLoop:
       Mov  AL,Byte Ptr [BX]    ;get character from XString
       Or   AL,AL               ;is it a CHR$(0)?
       Jz   @F                  ;yes, go back for more
       Cmp  AL,32               ;is it a space character?
       Jz   @F                  ;yes, go back for more
       Cmp  AL,'0'              ;is it a a 0 character?
       Jnz  Done                ;no, then we're done
@@:
       Inc  BX                  ;Point BX at next character
       Loop TrimLoop            ;go back for more

Done:
       Mov  DescLen,CX          ;assign DescLen the length of trimmed XString
       Mov  DescAdr,BX          ;and address of beginning of string
       Mov  AX, OffSet DescLen  ;get address of DescLen into AX

Exit:
       Ret                      ;return to Basic with AX pointing at descriptor

ZeroTrim EndP
End
