' DIAL    BAS : Dial a phone number on the screen
' author .....: Dick Dennison [74270,3636] 1:272/34 914-374-3903 *hst 24 hrs
' supports ...: COM1 - COM4
' syntax .....: DIAL portnum%
' includes ...: None
' notes ......: Move the cursor with the arrow keys to the phone number
'             : Press the ']' key and move the right arrow key across
'             : the number and press Enter
'             : Uses Basic's OPEN COMx commands
' cost .......: Free = Credit where credit due
'             : Do not use as is for commercial use - may not be resold
'             : May not be rebundled without prior written consent
' dated ......: 10/19/91
' credits ....: Thanks to Mike Welch for CLIPMSG, and Pete Petrakis for his        
'             : notes on Com Port swapping.

DECLARE SUB Hangup (Port%)
DECLARE SUB Getnum (row%, Col%, markit%, Port%)
DECLARE SUB Setup (Port%)

COLOR 0, 7
LOCATE 25, 1
PRINT "     Move the cursor to the beginning of the phone number and press Space  ";
LOCATE 10, 1
IF VAL(COMMAND$) < 1 OR VAL(COMMAND$) > 4 THEN      'Get the portnum%
     PRINT "Port number must be on command line"
     END
ELSE Port% = VAL(COMMAND$)
END IF
                   
                    'Setup some special key functions
CR$ = CHR$(13)
Nul$ = CHR$(0)
ArrowLt$ = Nul$ + CHR$(75)
ArrowRt$ = Nul$ + CHR$(77)
ArrowUp$ = Nul$ + CHR$(72)
ArrowDn$ = Nul$ + CHR$(80)
EndKey$ = Nul$ + CHR$(79)
Esc$ = CHR$(27)
Home$ = Nul$ + CHR$(71)
SpaceBar$ = CHR$(32)
                   'Save vectors at bios Addresses for Com1-Com2
  OldPort1H = PEEK(&H400)
  OldPort1L = PEEK(&H401)
  OldPort2H = PEEK(&H402)
  OldPort2L = PEEK(&H403)

'Move cursor around
'==================================================================
DO                         'This section lets the user move
 In$ = INKEY$             'move the cursor around on the screen
 SELECT CASE In$          'to the beginning of the phone number
  CASE CR$
    IF markit% THEN       'A CR signals the end of the highlight
     row% = CSRLIN
     Col% = POS(0) - count%
     EXIT DO
    END IF
  CASE Esc$                'END
    END
  CASE Home$               'Goto the beginning of the line
     LOCATE , 1
  CASE EndKey$             'Goto the end of the line
     LOCATE , 80
  CASE ArrowUp$            'UpArrow
     x% = CSRLIN
     IF x% > 1 THEN LOCATE x% - 1
  CASE ArrowDn$            'DownArrow
     x% = CSRLIN
     IF x% < 25 THEN LOCATE x% + 1
  CASE ArrowLt$                                 'LeftArrow
     IF POS(0) > 1 THEN LOCATE , POS(0) - 1
     IF markit% THEN count% = count% - 1       'If markit% then ' ' was pressed
  CASE ArrowRt$                             'RightArrow
     
     IF markit% THEN
          count% = count% + 1               'If markit% then ' ' was pressed
          row% = CSRLIN: Col% = POS(0)
          a% = SCREEN(row%, Col%)
          PRINT CHR$(a%);
     ELSE
          IF POS(0) < 80 THEN LOCATE , POS(0) + 1
     END IF
  CASE SpaceBar$
     IF markit% THEN
          count% = count% + 1               'If markit% then ' ' was pressed
          row% = CSRLIN: Col% = POS(0)
          a% = SCREEN(row%, Col%)
          PRINT CHR$(a%);
     ELSE
          BEEP
          markit% = -1                      'Flag set for marking number
     END IF
 END SELECT
 LOCATE , , 1                   'Keep cursor flashing
LOOP
'======================================================================

         'Get the phone number off the screen
Getnum row%, Col%, count%, Port%

         'Restore old vectors
CLOSE 1
  DEF SEG = 0
     POKE &H400, OldPort1H
     POKE &H401, OldPort1L
     POKE &H402, OldPort2H
     POKE &H403, OldPort2L
  DEF SEG
END

SUB Getnum (row%, Col%, markit%, Port%)
IF row% < 1 THEN row% = 1: IF Col% < 1 THEN Col% = 1
LOCATE row%, Col%
FOR x% = 0 TO markit%           'Read the phone number off the screen
     a% = SCREEN(row%, Col% + x%)
     Dialstr$ = Dialstr$ + CHR$(a%)
NEXT x%
LOCATE 23, 25
PRINT "Dialing : "; Dialstr$;
LOCATE 25, 1
PRINT "             Pickup handset and then press space or ESC phone rings      ";
COLOR 7, 0

Setup Port%
PRINT #1, "ATM1DT" + Dialstr$     'Dial the numbar

DO
     b$ = INKEY$
     IF b$ = " " THEN
          Hangup Port%
          EXIT DO
     END IF
     IF b$ = CHR$(27) THEN
          Hangup Port%
          EXIT DO
     END IF
LOOP

END SUB

SUB Hangup (Port%)

PRINT "...Disconnecting 1";
SELECT CASE Port%                'Drop DTR
    CASE 1
        OUT &H3FC, (INP(&H3FC) AND 252)   'com1
    CASE 2
        OUT &H2FC, (INP(&H2FC) AND 252)   'com2
    CASE 3
        OUT &H3FC, (INP(&H3FC) AND 252)   'com3
    CASE 4
        OUT &H2FC, (INP(&H2FC) AND 252)   'com4
END SELECT
     PRINT "...2...";
     PRINT #1, "+++";   'Switch to modem command mode
     SLEEP 1
     PRINT #1, "ATH"    'Send hangup command
     PRINT "...CLICK";

END SUB

SUB Setup (Port%)
'Sets up the comport by swapping the address fo com4 with com2 and
'com3 with com1 if necessary
DEF SEG = 0
 POKE &H400, &HF8
 POKE &H401, 3
 POKE &H402, &HF8
 POKE &H403, 2

SELECT CASE Port%
     CASE 1
        Start$ = "COM1:2400,N,8,1,DS0"
     CASE 2
        Start$ = "COM2:2400,N,8,1,DS0"
     CASE 3
        POKE &H400, &HE8   'For com1 to com3
        POKE &H401, &H3
        Start$ = "COM1:2400,N,8,1,DS0"
     CASE 4
        POKE &H402, &HE8   'For com2 to com4
        POKE &H403, &H2
        Start$ = "COM2:2400,N,8,1,DS0"
END SELECT
DEF SEG


OPEN Start$ FOR RANDOM AS 1

END SUB

