TITLE  'Window 3D - Set and Get 3D WINDOW'
NAME   WINDOW3D
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Set & Get clipping window in 3D                        |
;   caller:      FAR call (QuickBASIC convention)                       |
;                SETWIN3D(vseg,voff)                                    |
;                GETWIN3D(vseg,voff)                                    |
;    stack:     +06 = offset of data                                    |
;                08 = segment                                           |
;  returns:      nothing                                                |
;------------------------------------------------------------------------

PARMS           = 2
ARGseg          EQU [bp+08]
ARGoff          EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

WINDOW3D_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:WINDOW3D_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  SETWIN3D
SETWIN3D        PROC    FAR

                push    bp
                mov     bp,sp
                push    si

                cld
                mov     bx,ARGoff
                mov     si,[bx]
                mov     bx,ARGseg
                mov     es,[bx]         ;es:si->(x0,y0,z0),(x1,y1,z1) data

                db 26h
                lodsw
                mov     X0clip3,ax
                db 26h
                lodsw
                mov     Y0clip3,ax
                db 26h
                lodsw
                mov     Z0clip3,ax
                db 26h
                lodsw
                mov     X1clip3,ax
                db 26h
                lodsw
                mov     Y1clip3,ax
                db 26h
                lodsw
                mov     Z1clip3,ax

                pop     si
                pop     bp
                RET     PARMS*2

SETWIN3D        ENDP

                PUBLIC  GETWIN3D
GETWIN3D        PROC    FAR

                push    bp
                mov     bp,sp
                push    di

                cld
                mov     bx,ARGoff
                mov     di,[bx]
                mov     bx,ARGseg
                mov     es,[bx]         ;es:di->(x0,y0,z0),(x1,y1,z1) data

                mov     ax,X0clip3
                stosw
                mov     ax,Y0clip3
                stosw
                mov     ax,Z0clip3
                stosw
                mov     ax,X1clip3
                stosw
                mov     ax,Y1clip3
                stosw
                mov     ax,Z1clip3
                stosw

                pop     di
                pop     bp
                RET     PARMS*2

GETWIN3D        ENDP

WINDOW3D_TEXT   ENDS
                END

