TITLE  'Boundary Fill Area with color or pattern (FILLAREAx)'
NAME   FILLAREA
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      fill area bounded by border with color or pattern      |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call FILLAREA(0,5,7,320,175)                           |
;                call FILLAREAP(0,p$,7,320,175)                         |
;    stack:     +06 = y                                                 |
;                08 = x                                                 |
;                10 = border color                                      |
;                12 = newcol (or newcol$ pattern string descriptor)     |
;                14 = replacement type                                  |
;  returns:      nothing                                                |
;     NOTE:      FILLAREAP() does not allow complex shapes to be        |
;                completely filled                                      |
;     NOTE:      first byte of pattern is shift count offset per line   |
;-----------------------------------------------------------------------|

PARMS           = 5
ARGaddtype      EQU [bp+14]
ARGpixelvalue   EQU [bp+12]
ARGdesc         EQU [bp+12]
ARGborder       EQU [bp+10]
ARGx            EQU [bp+08]
ARGy            EQU [bp+06]

include EXTRNDAT.INC

EXTRN FILLAREAln:far     ;in DrawLn
EXTRN FILLAREAlnp:far    ;in DrawLnP

dgroup          group _BSS,_DATA

FillArea_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:FillArea_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  FillArea,FillAreaP
FillArea        PROC    FAR

                push    bp
                mov     bp,sp
                push    bp
                push    ds
                push    di
                push    si

                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGpixelvalue
                mov     ax,[bx]
                mov     PixelValue,ax
                mov     bx,ARGborder
                mov     ax,[bx]
                mov     bordercol,ax
                mov     bx,ARGx
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGy
                mov     ax,[bx]
                mov     StartY,ax
                mov     patternf,0      ;regular fill
                jmp     short FA01

FillAreaP       LABEL FAR
                push    bp
                mov     bp,sp
                push    bp
                push    ds
                push    di
                push    si

                mov     bx,ARGdesc
                mov     ax,[bx]         ;get string len
                dec     ax              ;less shift count
                or      ax,ax
                jg      FA00
                jmp     Lexit1          ;must have length > 1 (sc+pattern)

FA00:           mov     StrLen,ax
                mov     bx,[bx+2]       ;[bx]->pattern$
                mov     ax,[bx]         ;ax=shift count
                sub     ah,ah           ;since we're getting data from
                mov     FillShift,ax    ;bytes here we need to zero ah
                mov     FillShiftOrg,ax
                inc     bx              ;[bx]->first value pattern byte
                mov     addrOff,bx      ;addrOff->first value in pattern
                mov     ax,[bx]         ;get the first value
                sub     ah,ah
                mov     PixelValue,ax   ;getting data from bytes here too
                mov     bx,ARGborder
                mov     ax,[bx]
                mov     bordercol,ax
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGx
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGy
                mov     ax,[bx]
                mov     StartY,ax
                mov     patternf,1      ;pattern fill

FA01:           cld                     ;now that that's out of the way
                mov     bx,x0
                mov     ax,StartY

                cmp     bx,0            ;area okay?
                jl      FA01z
                cmp     bx,MaxX
                jg      FA01z
                cmp     ax,0
                jl      FA01z
                cmp     ax,MaxY
                jg      FA01z

                mov     FAy,ax          ;for FALine
                call    FAReadDot       ;get the color we're sitting on
                cmp     ax,bordercol    ;if it's a border then outa here
                jne     FA02

FA01z:          jmp     Lexit1          ;cannot fill if point border color

FA02:           mov     ax,StartY       ;ax=y
                mov     bx,x0           ;bx=StartLeftx-1
                dec     bx
                call    ScanLeft
                mov     StartLeftx,ax
                mov     NLeftx,ax       ;for FALine

                mov     ax,StartY       ;ax=y
                mov     bx,x0           ;bx=StartRightX+1
                inc     bx
                call    ScanRight
                mov     StartRightx,ax
                mov     NRightx,ax      ;for FALine

                call    FALine

                mov     StackMax,0FFFFh ;force first sp compare to be lower
                mov     StackStart,sp
                push    StartLeftx
                push    StartRightx
                mov     ax,StartY
                dec     ax
                push    ax
                push    StartLeftx
                push    StartRightx
                mov     ax,1
                mov     FAdir,ax
                push    ax             ;StartLx,StartRx,y-1,StartLx,StartRx,dir

FA03:           call    FillREC        ;recurse y going up
                cmp     sp,StackStart
                jl      FA03
                mov     ax,StackStart
                sub     ax,StackMax
                mov     StackMax1,ax

                mov     StackMax,0FFFFh
                mov     StackStart,sp
                push    StartLeftx
                push    StartRightx
                mov     ax,StartY
                inc     ax
                push    ax
                push    StartLeftx
                push    StartRightx
                mov     ax,-1
                mov     FAdir,ax
                push    ax             ;StartLx,StartRx,y+1,StartLx,StartRx,-dir

FA04:           call    FillREC        ;recurse y going up
                cmp     sp,StackStart
                jl      FA04
                mov     ax,StackStart
                sub     ax,StackMax
                cmp     ax,StackMax1
                ja      Lexit1
                mov     ax,StackMax1    ;return greatest stack used

Lexit1:         pop     si
                pop     di
                pop     ds
                pop     bp
                mov     sp,bp
                pop     bp
                RET     PARMS*2
FillArea        ENDP

FillREC         PROC NEAR
                pop     RtnAddr
                pop     FAdir
                pop     PRightx
                pop     PLeftx
                pop     FAy
                pop     Rightx
                pop     NLeftx

FillREC00:      mov     ax,FAy
                or      ax,ax
                js      FillJMP         ;y < 0
                cmp     ax,MaxY
                jg      FillJMP         ;y > MaxY
                mov     bx,NLeftx
                call    FAReadDot
                cmp     ax,bordercol    ;IF READDOT(NLeftx,y)<>bordercol
                je      FillREC01       ; AND <>PixelValue
                cmp     ax,PixelValue
                je      FillREC01

                mov     ax,NLeftx       ;THEN
                mov     NRightx,ax      ;NRightx = NLeftx
                mov     bx,ax           ;bx=x
                mov     ax,FAy          ;ax=y
                dec     bx
                call    ScanLeft        ;(NLeftx-1,FAy)
                mov     NLeftx,ax
                jmp     short FillREC02

FillREC01:      mov     bx,NLeftx       ;ELSE
                inc     bx              ;bx=x
                mov     ax,FAy          ;ax=y
                mov     di,Rightx       ;di=rightx
                call    ScanModLeft     ;(NLeftx+1,FAy,Rightx)
                mov     NLeftx,ax
                mov     NRightx,ax

FillREC02:      mov     ax,NLeftx
                cmp     ax,Rightx       ;IF NLeftx <= Rightx
                jle     FillREC02a

FillJMP:        jmp     FillREC09
                                        ;THEN
FillREC02a:     mov     bx,NRightx      ;bx=x
                inc     bx
                mov     ax,FAy          ;ax=y
                call    ScanRight       ;(NRightx+1,FAy)
                mov     NRightx,ax

                call    FALine

                push    NLeftx
                push    NRightx
                mov     ax,FAy
                sub     ax,FAdir
                push    ax
                push    NLeftx
                push    NRightx
                push    FAdir           ;push new parms

                cmp     patternf,1      ;no complex fills for patterf
                je      FillREC09

                mov     ax,NLeftx
                mov     bx,PLeftx
                sub     bx,2
                cmp     ax,bx           ;IF NLeftx<=PLeftx-2
                jg      FillREC03

                push    ax
                push    bx
                mov     ax,FAy
                add     ax,FAdir
                push    ax
                push    NLeftx
                push    NRightx
                mov     ax,FAdir
                neg     ax
                push    ax              ;push new parms

FillREC03:      mov     ax,PRightx
                add     ax,2
                mov     bx,NRightx
                cmp     ax,bx
                jg      FillREC04

                push    ax
                push    bx
                mov     ax,FAy
                add     ax,FAdir
                push    ax
                push    NLeftx
                push    NRightx
                mov     ax,FAdir
                neg     ax
                push    ax              ;push new parms

FillREC04:      mov     ax,NRightx
                add     ax,2
                mov     NLeftx,ax
                cmp     ax,Rightx       ;loop until NLeftx > Rightx
                jg      FillREC09
                jmp     FillREC00

FillREC09:      cmp     sp,StackMax
                ja      FillREC09a
                mov     StackMax,sp
FillREC09a:     jmp     ds:[RtnAddr]
FillREC         ENDP

;read dot
;ax=y bx=x
;return value in ax
;uses es

FAReadDot       PROC NEAR
                push    bx
                push    cx
                push    dx

                mov     dx,bpl          ;calc pixel's address
                mul     dx              ;ax=y*bytes per line
                mov     cl,bl           ;low byte of x
                shr     bx,1
                shr     bx,1
                shr     bx,1            ;bx=x/8
                add     bx,ax
                mov     ax,0A000h
                mov     es,ax           ;es:bx = byte address of pixel
                and     cl,7
                xor     cl,7            ;cl = number of bits to shift left
                mov     ah,1            ;ah = unshifted bit mask

                mov     ch,ah
                shl     ch,cl           ;ch=bit mask in proper position
                mov     si,bx           ;es:si -> regen buffer byte
                xor     bl,bl           ;bl is used to accumulate the pixel value
                mov     dx,03CEh        ;dx = graphics controller port
                mov     ax,0304h        ;ah = initial bit plane number
                                        ;al = read map select reg
FARD0:          out     dx,ax           ;select bit plane
                mov     bh,es:[si]      ;bh = byte from current bit plane
                and     bh,ch           ;mask one bit
                neg     bh              ;bit 7 of bh = 1 (if mask bit = 1)
                                        ;bit 7 of bh = 0 (if mask bit = 0)
                rol     bx,1            ;bit 0 of bl = next bit from pixel value
                dec     ah              ;ah = next bit plane number
                jge     FARD0
                sub     bh,bh
                mov     ax,bx           ;al = pixel value
                pop     dx
                pop     cx
                pop     bx
                ret
FAReadDot       ENDP

;scan left
;bx=leftx
;ax=y
;return leftx in ax

ScanLeft        PROC    NEAR
                or      bx,bx           ;negative x?
                js      SL1
                mov     dx,bordercol
                mov     dh,byte ptr PixelValue
SL0:            mov     cx,ax           ;save y
                call    FAReadDot
                cmp     dl,al           ;this pixel same as border?
                je      SL1             ;yes,found a left edge then
                cmp     dh,al           ;same as fill?
                je      SL1             ;yes
                mov     ax,cx           ;get back y
                dec     bx
                jns     short SL0       ;scanleft again while bx > 0
SL1:            inc     bx              ;pos to last non-border point
                mov     ax,bx           ;return leftx
                ret
ScanLeft        ENDP

;scan right
;bx=rightx
;ax=y
;return rightx in ax

ScanRight       PROC    NEAR
                cmp     bx,MaxX         ;x > MaxX?
                jg      SR1
                mov     dx,bordercol
                mov     dh,byte ptr PixelValue
SR0:            mov     cx,ax           ;save y
                call    FAReadDot
                cmp     al,dl           ;this pixel same as border?
                je      SR1             ;yes,found a right edge then
                cmp     al,dh           ;same as fill?
                je      SR1             ;yes
                mov     ax,cx
                inc     bx
                cmp     bx,MaxX
                jle     SR0             ;scanright again (max to MaxX)
SR1:            dec     bx              ;pos to last non-border point
                mov     ax,bx           ;return rightx
                ret
ScanRight       ENDP

;scan mod left
;bx=leftx
;ax=y
;di=rightx
;return leftx in ax

ScanModLeft     PROC    NEAR
                mov     dx,bordercol
                mov     dh,byte ptr PixelValue
MSL0:           mov     cx,ax           ;save y
                call    FAReadDot
                cmp     al,dl           ;this pixel same as border?
                je      MSL0a           ;yes,keep looking
                cmp     al,dh           ;same as PixelValue?
                je      MSL0a           ;yes
                jmp     short MSL1      ;no to both, then found new left
MSL0a:          cmp     bx,di           ;have we maxed-out at rightx?
                ja      MSL1            ;yes, maxed-out
                mov     ax,cx
                inc     bx              ;no, keep looking right for non-border
                cmp     bx,MaxX
                jl      MSL0            ;scan mod again (max to MaxX)
MSL1:           mov     ax,bx           ;return leftx
                ret
ScanModLeft     ENDP

FALine          PROC NEAR
                mov     ax,NLeftx
                mov     x0,ax
                mov     ax,NRightx
                mov     x1,ax
                mov     ax,FAy
                mov     y0,ax
                mov     y1,ax
                cmp     patternf,0
                je      FALine1
                call    FillAREAlnp
                ret
FALine1:        call    FillAREAln
                ret
FALine          ENDP

FillArea_TEXT   ENDS
                END

