TITLE  'Get Bit Block Dimension EGA'
NAME   DIMBLOCK
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      return the size needed to store the block in bytes     |
;   caller:      FAR call (QuickBASIC convention)                       |
;                bytes&=DIMBLOCK&(15,0,0,319,199)                       |
;    stack:      06 = y1                                                |
;                08 = x1                                                |
;                10 = y0                                                |
;                12 = x0                                                |
;                14 = plane mask                                        |
;  returns:      long integer bytes needed for block                    |
;     NOTE:      plane mask (bit3=plane3,bit2=plane2,bit1=plane1,bit0...|
;     NOTE:      SS overrides used to access some BSS data              |
;------------------------------------------------------------------------

PARMS           =  5            ;number of arguments
ARGmask         EQU [bp+14]     ;plane mask
ARGx0           EQU [bp+12]     ;upper left col (0-based)
ARGy0           EQU [bp+10]     ;upper left row
ARGx1           EQU [bp+08]     ;lower right col
ARGy1           EQU [bp+06]     ;lower right row
ByteOffsetShift EQU 3           ;number of pixels per byte

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

DimBlock_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME  cs:DimBlock_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  DimBlock
DimBlock        PROC    FAR

                push    bp
                mov     bp,sp
                cld
                mov     bx,ARGmask
                mov     ax,[bx]
                and     ax,000Fh
                mov     PMask,ax        ;bits3-0 are plane mask
                mov     bx,ARGx0
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGx0
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGy0
                mov     ax,[bx]
                mov     y0,ax
                mov     bx,ARGx1
                mov     ax,[bx]
                mov     x1,ax
                mov     bx,ARGy1
                mov     ax,[bx]
                mov     y1,ax

                ;compute bit block dimensions

                mov     ax,x1
                sub     ax,x0
                mov     cx,0FF07h       ;ch = unshifted bit mask
                                        ;cl = AND mask for al
                and     cl,al           ;cl = pixels in last byte of row
                xor     cl,7            ;cl = bits to shift
                shl     ch,cl           ;ch = bit mask for last byte of row
                mov     cl,ch

                mov     cl,ByteOffsetShift
                shr     ax,cl
                inc     ax              ;ax = bytes per row
                mov     bx,ax

                mov     ax,y1
                sub     ax,y0
                inc     ax              ;ax = pixel rows
                mul     bx              ;ax=bytes/row * rows

                sub     bx,bx           ;get plane count
                mov     cx,PMask
                shr     cx,1
                adc     bx,0            ;*1 at least
                shr     cx,1
                adc     bx,0            ;*2?
                shr     cx,1
                adc     bx,0            ;*3?
                shr     cx,1
                adc     bx,0            ;*4?
                mul     bx              ;dx:ax=bytes needed
                add     ax,6            ;add header
                adc     dx,0
                mov     sp,bp
                pop     bp
                RET     PARMS * 2
DimBlock        ENDP
DimBlock_TEXT   ENDS
                END

