' QTimer.Bas
' $INCLUDE: 'QB.BI'

' QTimer - Fine resolution timer functions

DECLARE FUNCTION tStart& ()
DECLARE FUNCTION tFormat$ (T1 AS LONG, T2 AS LONG)
DECLARE FUNCTION tDiff! (StartTime AS LONG, EndTime AS LONG)
DECLARE FUNCTION tGet& ()
DECLARE FUNCTION LZPad$ (A AS DOUBLE, N AS INTEGER)
DECLARE FUNCTION STRa$ (A AS DOUBLE)
DECLARE SUB BlockMove ALIAS "B$ASSN" _
           (BYVAL FromSeg%, BYVAL FromOffset%, BYVAL SrcBytes%, _
            BYVAL ToSeg%, BYVAL ToOffset%, BYVAL DestBytes%)

CONST TixSec = 18.20648193#
CONST TixMin = TixSec * 60!
CONST TixHour = TixMin * 60!
CONST TixDay = TixHour * 24!

FUNCTION tGet&

' tGet& - Use the undocumented B$ASSN (QB assignment operator)
'         subroutine to move the BIOS tick counter into a
'         long integer variable.

DIM Temp AS LONG
  CALL BlockMove (&H40, &H6C, 4, VARSEG(Temp), VARPTR(Temp), 4)
  tGet& = Temp
END FUNCTION

FUNCTION tStart&

' tStart& - wait for a new tick, and return the
' tick number to the caller. The wait allows
' us to be sure the user gets a start at the
' beginning of the second

DIM StartTime AS LONG
  StartTime = tGet
  DO WHILE StartTime = tGet
	tStart& = tGet
  LOOP
END FUNCTION


FUNCTION tDiff! (StartTime AS LONG, EndTime AS LONG)

' tDiff! - compute the difference between two
'          timepoints (in seconds).

  tDiff! = (EndTime - StartTime) / TixSec
END FUNCTION

SUB GetTime (H AS INTEGER, M AS INTEGER, S AS INTEGER, S100 AS INTEGER)

' GetTime - Invoke the INT 21 function 2C to get the system time

DIM Regs AS RegType
  Regs.AX = &H2C00
  Interrupt &H21, Regs, Regs
  H = (Regs.CX \ 256) AND &HFF
  M = Regs.CX AND &HFF
  S = (Regs.DX \ 256) AND &HFF
  S100 = Regs.DX AND &HFF
END SUB

FUNCTION tFormat$ (T1 AS LONG, T2 AS LONG)

' tFormat$ - given two times, return a string that
'            is the difference in the times, formatted HH:MM:SS.ZZZ
'            (where ZZZ is hundredths of seconds)

DIM Temp AS SINGLE
DIM tStr AS STRING
DIM TempStr AS STRING
DIM TimeValue(1 TO 4) AS LONG
DIM I AS INTEGER
  Temp = T2 - T1           ' time difference
  IF Temp < 0 THEN
    Temp = Temp + TixDay   ' adjust midnight crossover
  END IF
  TimeValue(1) = INT(Temp / TixHour)
  Temp = Temp MOD TixHour
  TimeValue(2) = INT(Temp / TixMin)
  Temp = Temp MOD TixMin
  TimeValue(3) = INT(Temp / TixSec)
  Temp = Temp MOD TixSec
  TimeValue(4) = INT(Temp * 100! / TixSec + .5)
  tStr = LZPad$((TimeValue(1)), 2)
  TempStr = ""
  FOR I = 2 TO 3
     TempStr = LZPad$((TimeValue(I)), 2)
     tStr = tStr + ":" + TempStr
  NEXT I
  TempStr = LZPad$((TimeValue(4)), 3)
  tStr = tStr + "." + TempStr
  tFormat$ = tStr
END FUNCTION

'
'  Functions to pad a numeric variable
'  on the left with zeroes and return it as a string.
'  Use () to coerce the variable if not double-precision.
'
FUNCTION LZPad$ (N#, pLen%) STATIC
LZPad$ = STRING$((pLen% - LEN(STR$(N#))) + 1, "0") + STRa$(N#)
END FUNCTION

'
'  Function which is like STR$() but does not
'  stick a leading blank on the string it returns.
'  Use () to coerce the variable if not double-precision.
'
FUNCTION STRa$ (N#) STATIC
STRa$ = RIGHT$(STR$(N#), LEN(STR$(N#)) - 1)
END FUNCTION

