;		ping.asm
;========================================================================

; Copyright (C) 1991-95 by Jan.Engvald@ldc.lu.se, see file COPYING.


;************************************************************************
;*		EchoAwhile
;************************************************************************

EchoAwhile	proc	near
		assume	ds:code_s
		mov	ah,2ah			; get date
		int	21h
		mov	cYear,cx
		mov	byte ptr cMonth,dh
		mov	byte ptr cDay,dl
		mov	byte ptr cWday,al

		mov	ah,2ch			; get time
		int	21h
		mov	byte ptr cHour,ch
		mov	byte ptr cMinute,cl
		mov	byte ptr cSecond,dh

		mov	di,offset MsgLoadStart
		call	PutWeekDateTime

		call	HwTicksNoHi
		mov	EchoStart,si		; note start ticks
		mov	EchoStart+2,dx
		mov	EchoStart+4,ax
		mov	EchoLoadTime,dx

		mov	di,offset ClearStart	; clear error size table
		mov	cx,(ClearEnd-ClearStart)/2
		xor	ax,ax
		rep	stosw

;*test		mov	Echo.RxTime,dx
;		mov	Echo.TxTime,dx
		mov	bx,word ptr EchoNumDst
		add	bx,2
		mov	DspBxMax,bx

		cmp	EchoTarget,ax		; want to ping someone?
		jne	EchoYes

		test	ArgFlags,TERM_WAIT	; ping serving?
		jz	EchoNo

if MULTIPING gt 1
		inc	EchoNumDst
		inc	DspBxMax
endif ; MULTIPING gt 1
                or      GenFlags,ECHO_DISPL
  EchoNo:
		ret  


  EchoYes:
		call	InitTimer		; prepare millisecond timing

		mov	ax,ArgFlags
		and	ax,STOP_ON_ERR
		xor	ax,NO_ERR_YET+STOP_ON_ERR+NO_DROP_YET+PING_DELAY
		or	GenFlags,ax

if MULTIPING gt 1
		mov	al,EchoNumDst
		mov	ah,4
		mov	dx,REPVECLEN
		dec	al
		jz	EchoSegEnd

  EchoSegL:
		test	al,MULTIPING/2
		jnz	EchoSegEnd

		shl	ax,1
		shl	dx,1
		jmp	short EchoSegL

  EchoSegEnd:
		mov	byte ptr EchoSegInc,ah
		dec	dx
		mov	EchoRepLen1,dx
endif ; MULTIPING

		call	HardwareTicks
		mov	EchoStart,si		; note start ticks
		mov	EchoStart+2,dx
		mov	EchoStart+4,ax
		mov	EchoLoadTime,dx
		push	si
		push	dx
		push	ax

		call	DblShrX
		mov	EchoNext,ax

		mov	si,offset EchoTarget
		mov	EchoTargetPtr,si
  EchoNsTst:
		cmp	byte ptr [si],127	; dns lookup to do?
		je	EchoNsDo
		jmp	EchoNsNext
  EchoNsDo:
		mov	di,offset MsgCallName
		mov	si,EchoNamePtr
		push	si
		mov	cx,15
		lodsb
  EchoNameCpL:
		cmp	al,0fah
		je	EchoNameFill
		lodsb
		or	al,al
		jnz	EchoNameCont
		mov	al,0fah
  EchoNameCont:
		cmp	al,'-'
		jae	EchoNameFill
		mov	al,'.'
  EchoNameFill:
		stosb
		mov	byte ptr [di+MsgNameRepIP-MsgCallName-1],' '
		loop	EchoNameCpL
  EchoNameCpEnd:
		mov	dx,offset MsgCalling
		call	DosPr$
if MULTIPING gt 1
		mov	ax,EchoTargetPtr
		sub	ax,offset EchoTarget
		shr	ax,1
		shr	ax,1
		mul	kLinLen
		mov	di,offset MsgEcho+88+16
		add	di,ax
		mov	si,offset MsgCallName
		mov	cx,17
		rep	movsb
		mov	di,offset MsgEchoTarget
endif ; MULTIPING
;		mov	dx,2345h		; ping udp src port
		pop	si			; Ns question string
		mov	ax,si			; NsId

		call	NsResolveEcho		; call nameserver(s)
if MULTIPING gt 1
		mov	EchoNamePtr,si
endif ; MULTIPING
		pop	ax
		pop	dx
		pop	si
		call	HardwareTicks		; response time
		push	si
		push	dx
		push	ax
		sub	ax,EchoStart+4
		sbb	dx,EchoStart+2
;*test		sbb	si,EchoStart
if 1	;*test
  EchoNameTimChk:
		jns	EchoNameTim
		inc	dx
		jmp	short EchoNameTimChk
  EchoNameTim:
endif
		add	EchoStart+4,ax
		adc	EchoStart+2,dx
;*test		adc	EchoStart,si
		div	kTimerScale
		mov	di,offset MsgNameRepTim
		call	PutNumD4Fb

		mov	di,offset MsgNameRepIp
		mov	si,EchoTargetPtr
		cmp	byte ptr [si],127	; name resolved?
		jne	EchoResolved

		mov	dx,offset MsgBadName
		mov	al,'e'-'0'
		call	PrTerminate
  EchoResolved:
		push	si
		call	PutIpNum

		mov	dx,offset MsgNameRep	; display it.
		call	DosPr$
		pop	si
  EchoNsNext:
if MULTIPING gt 1
		mov	di,offset MsgEchoIpnr
		mov	ax,si
		sub	ax,offset EchoTarget
		push	si
		push	ax
		mul	k20
		add	di,ax
		call	PutIpNum		; put IP nr on ping row
endif ; MULTIPING
		mov	di,offset MsgEchoTarget
if MULTIPING gt 1
		pop	ax
		pop	si
		mul	k5
		add	di,ax
endif ; MULTIPING
		call	PutIpNum		; tell IP target(s)
if MULTIPING gt 1
		mov	EchoTargetPtr,si
		mov	word ptr [di],' ,'
		cmp	byte ptr [si],0
		je	EchoNsErase
		jmp	EchoNsTst
  EchoNsErase:
endif ; MULTIPING
		mov	word ptr [di],':'+256*LF
		mov	word ptr [di+2],LF+256*'$'
if HOPCHK
		inc	di
		mov	HopClrAdr,di
endif ; HOPCHK
  EchoIpAddr:
		pop	ax
		pop	dx
		pop	si
if MULTIPING gt 1
		mov	di,offset Echo
		mov	cx,MULTIPING
  EchoIndClrL:
		mov	[di].MinDly,-1	; initialize max delay
		mov	[di].TxTimeHiHi,si ; intialize timers
		mov	[di].TxTime,dx
		mov	[di].TxTimeLo,ax
		mov	[di].RxTimeHiHi,si
		mov	[di].RxTime,dx
		mov	[di].RxTimeLo,ax
		mov	[di].RxTxTimeHiHi,si
		mov	[di].RxTxTime,dx
		mov	[di].RxTxTimeLo,ax
		add	di,REPVECLEN
		loop	EchoIndClrL
else
		mov	Echo.MinDly,-1
		mov	Echo.TxTimeHiHi,si
		mov	Echo.TxTime,dx
		mov	Echo.TxTimeLo,ax
		mov	Echo.RxTimeHiHi,si
		mov	Echo.RxTime,dx
		mov	Echo.RxTimeLo,ax
		mov	Echo.RxTxTimeHiHi,si
		mov	Echo.RxTxTime,dx
		mov	Echo.RxTxTimeLo,ax
endif ; MULTIPING

if TBLBUILD
		call	TableReady		; allow tablebuilding now
endif ; TBLBUILD
		mov	ax,EchoInterval		; check interval
if MULTIPING gt 1
		test	ArgFlags,NOT_SAFE
		jnz	EchoAsIs
endif ; MULTIPING gt 1

		cmp	ax,110
		jge	EchoAsItIs
		mov	ax,110
  EchoAsItIs:
		test	ArgFlags,MICRO_100
		jz	EchoAsIs
		cmp	ax,110*10
		jge	EchoAsIs
		mov	ax,110*10
  EchoAsIs:
		mov	EchoInterval,ax
if HOPCHK
		test	MoreFlags,HOP_CHK	; hop check going on?
		jz	EchoNoHopBuf

		mov	cx,(MAXHOP)*DSPLINLEN
		mov	di,offset HopTabDsp
		mov	al,' '			; blank display buff
		rep	stosb

		mov	byte ptr MsgEchoHead+6,'e'

		mov	dx,MyIpNr
		mov	ax,MyIpNr+2
		mov	word ptr HopTabIp,dx
		mov	word ptr HopTabIp+2,ax
		call	BufAlloc
		call	MakeSendDescr
		mov	di,[bx].dPtrIp
		mov	[di].iIpSrc,dx		; my IP # to IP src
		mov	[di].iIpSrc+2,ax
		call	PutPhysSrc
		mov	si,offset TblToDo
		call	AddToList		; find my name
  EchoNoHopBuf:
endif ; HOPCHK
		call	BufAlloc		; get a send buf
		assume	ds:nothing
		call	MakeSendDescr
		mov	[bx].dTickTimeout,30*18

		mov	[di].uIcmpTypeCode,8	; type = echo request
		test	cs:GenFlags,UDP_ECHO	; ping or udpecho?
		jz	EchoUseIcmp		; print "Ping  to"

		mov	dx,'cE'			; print "Echo  to"
		mov	ax,'oh'
if HOPCHK
		test	cs:MoreFlags,HOP_CHK	; hop checking?
		jz	EchoFillEcho
		mov	dx,'rT'			; print "Trace to"
		mov	ax,'ca'
  EchoFillEcho:
endif ; HOPCHK
		mov	word ptr cs:MsgEchoHead+2,dx
		mov	word ptr cs:MsgEchoHead+4,ax

		mov	word ptr [di].uUdpSrc,0703h	; my udp echo port
		mov	word ptr [di].uUdpDst,0900h	; dst discard port
		test	cs:ArgFlags,UDP_DISCARD
		jnz	EchoUseIcmp
		mov	word ptr [di].uUdpDst,0700h	; dst echo port
  EchoUseIcmp:
		mov	cx,cs:MyGiant		; fill buffer with data
                sub     cx,HWHDRLEN+IPHDRLEN+ICMPHDRLEN+6
		shr	cx,1
		add	di,ICMPHDRLEN+6
		mov	ax,cs:EchoData
  EchoFillLoop:
		stosw
		add	ax,cs:EchoDataIncW
		loop	EchoFillLoop
  EchoFillEnd:
		push	cs
		pop	ds
		assume	ds:code_s
		mov	EchoBufSeg,es
		push	cs
		pop	es

if MULTIPING gt 1
		mov	ax,EchoBurst
		cmp	ax,1
		je	EchoBurst1
		mov	di,offset MsgEchoBurst
		mov	PutMinDigits,3
		call	PutNumFb		;   and the burst size used
		mov	al,'*'
		stosb
  EchoBurst1:
endif ; MULTIPING gt 1
		mov	dx,EchoMinSize
		sub	dx,IPHDRLEN
		cmp	dx,ICMPHDRLEN+6
		jns	EchoMinOK
		mov	dx,ICMPHDRLEN+6
  EchoMinOK:
		mov	ax,EchoSize
		neg	ax
		jns	EchoSizeNeg
		mov	dx,GIANTTR
		neg	ax
		mov	MsgEchoSweep,' '
  EchoSizeNeg:
                mov     cx,MyGiant
                sub     cx,HWHDRLEN+IPHDRLEN+ICMPHDRLEN+6
                sub     ax,IPHDRLEN+ICMPHDRLEN+6
                cmp     ax,cx
		jbe	EchoOkSize
		xor	ax,ax
  EchoOkSize:
		add	ax,ICMPHDRLEN+6
		mov	EchoSize,ax
		mov	EchoMaxSize,ax

		cmp	dx,ax
		jbe	EchoMinMax
		mov	dx,ax
  EchoMinMax:
		mov	EchoMinSize,dx

		cmp	ax,dx
		je	EchoFixedSz
		push	ax
		mov	ax,dx
		add	ax,IPHDRLEN
		mov	di,offset MsgEchoSweep-4
		call	PutNumD4Fb		;   and the min size used
		pop	ax
  EchoFixedSz:
		add	ax,IPHDRLEN
		mov	di,offset MsgEchoSize
		mov	PutMinDigits,1
		call	PutNum			;   and the packet size used

		mov	ax,EchoInterval
		push	ax
		mov	di,offset MsgEchoMs
		mov	PutMinDigits,6
		call	PutNumFb		;   and interval in ms
		pop	ax
		test	ArgFlags,MICRO_100
		jz	Echo1ms
		mov	dh,MsgEchoMs+5
		mov	dl,'.'
		mov	word ptr MsgEchoMs+5,dx
		mul	k51200			; make interval close to 0.1 ms
		jmp	short EchoPrHdr
  Echo1ms:
		mul	k64000			; make interval close to 1 ms
  EchoPrHdr:
		div	k54925
		mov	EchoInterval,ax
if MULTIPING gt 1
		mul	word ptr EchoNumDst	; compute intervall
else
		xor	dx,dx
endif
		mov	cl,7
		test	ArgFlags,MICRO_100
		jnz	EchoMicIval

		mov	cl,10
  EchoMicIval:
		call	DblShl
		mov	EchoIvalLo,ax
		mov	EchoIvalHi,dx

		push	dx			; compute blocking limit
		mul	EchoBlockLim
		mov	BlockTimLo,ax
		pop	ax
		add	ax,dx
		mul	EchoBlockLim
		mov	BlockTimHi,ax

if HOPCHK
		test	MoreFlags,HOP_CHK	; hop check going on?
		jz	EchoPrnStats

		mov	cx,offset HopTabDspEnd
		mov	di,HopClrAdr
		sub	cx,di
		mov	al,' '			; blank display buff
		rep	stosb

		jmp	short EchoAllowDsp
  EchoPrnStats:
endif ; HOPCHK
		mov	dx,offset MsgEchoHead
		call	DosPr$
  EchoAllowDsp:
                or      GenFlags,ECHO_DISPL
		and	MoreFlags, not PING_STOPPED
		mov	EchoTargetPtr,offset EchoTarget

  EchoLoop:
		call	Something2Do		; process other things

		test	GenFlags,NO_ERR_YET+CONT_ON_ERR	; want to stop on sequence errs?
		jz	EchoEnd0

		call	AnyKey			; first key stops sending
		jz	EchoNoKey
  EchoEnd0:
		or	MoreFlags,PING_STOPPED
		jmp	EchoEnd
  EchoNoKey:
		call	Something2Do		; called to slow down client

		call	HardwareTicks
		mov	es,EchoBufSeg
		mov	di,es:[bx].dPtrUdp
		mov	es:[di].uUdpData,ax
		mov	es:[di].uUdpData+2,dx
		mov	es:[di].uUdpData+4,si

		call	DblShrX
		mov	dx,EchoNext
		cmp	ax,dx			; time to send next echo pkt?
		js	EchoLoop

		add	dx,EchoInterval
		cmp	dx,ax
		jns	EchoSetNext
		mov	dx,ax
  EchoSetNext:
		mov	EchoNext,dx		; next send time

		mov	cx,EchoSize		; compute packet size
		mov	di,EchoTargetPtr
if MULTIPING gt 1
		mov	ax,EchoBurst
		mov	EchoBurstCnt,ax

		cmp	byte ptr [di],0
		jne	EchoNormSize
endif ; MULTIPING
		inc	cx
		cmp	cx,EchoMaxSize
		jbe	EchoNormSize
		mov	cx,EchoMinSize
  EchoNormSize:
		mov	EchoSize,cx

;*test		mov	di,EchoTargetPtr
if MULTIPING gt 1
		cmp	byte ptr [di],0
		jne	EchoToNextIp

		mov	di,offset EchoTarget
		mov	EchoSegInd,0
endif ; MULTIPING
  EchoToNextIp:
		mov	dx,[di]			; set IP destination
		mov	ax,[di+2]
if MULTIPING gt 1
		add	di,4
		mov	EchoTargetPtr,di
endif ; MULTIPING
		mov	ds,EchoBufSeg
		assume	ds:nothing
		call	SetIpDst

		mov	di,[bx].dPtrUdp
		mov	[bx].dPktLen,cx		; and IP data length
if MULTIPING gt 1
                mov     dx,EchoSegInd
                mov     ax,dx
                add     dx,EchoSegInc
                mov     EchoSegInd,dx

if MULTIPINGPWR + REPVECPWR-4 gt 8
		rept	8-2-MULTIPINGPWR
		shl	ax,1
		endm

		mov	byte ptr [di].uUdpData,al ; put dst index into low time

		rept	REPVECPWR-4-2 - (8-2-MULTIPINGPWR)
		shl	ax,1
		endm
else
		rept	REPVECPWR-4-2
		shl	ax,1
		endm

		mov	byte ptr [di].uUdpData,al ; put dst index into low time
endif ; MULTIPINGPWR
		add	ax,cs:MySegm
		mov	es,ax
		mov	cs:EchoSegCur,ax
		mov	dx,[di].uUdpData+4
		cli
		mov	es:Echo.TxTimeHiHi,dx
		mov	dx,[di].uUdpData+2
		mov	es:Echo.TxTime,dx
		mov	dx,[di].uUdpData
		mov	es:Echo.TxTimeLo,dx
		sti

  EchoBurstTail:
		mov	ax,cs:EchoSegCur
		mov	es,ax
		mov	di,[bx].dPtrUdp
		cli
		mov	si,es:Echo.TxLo		; increment send counters
		add	si,1
		mov	es:Echo.TxLo,si
		adc	es:Echo.TxHi,0
		mov	es:Echo.Fudge,1
		sti
		mov	cs:EchoTxIndex,es
else
		assume	ds:code_s
		mov	dx,[di].uUdpData+4
		cli
		mov	Echo.TxTimeHiHi,dx
		mov	dx,[di].uUdpData+2
		mov	Echo.TxTime,dx
		mov	dx,[di].uUdpData
		mov	Echo.TxTimeLo,dx
		sti

  EchoBurstTail:
		mov	di,[bx].dPtrUdp
		cli
		mov	si,Echo.TxLo		; increment send counters
		add	si,1
		mov	Echo.TxLo,si
		adc	Echo.TxHi,0
		mov	Echo.Fudge,1
		sti
		assume	ds:nothing
endif ; MULTIPING
		mov	[di].uUdpData+4,si	; put sequence number
if HOPCHK
		test	cs:MoreFlags,HOP_CHK
		jnz	EchoNoVec
endif ; HOPCHK
		mov	di,cs:EchoSize	 	; IP data length
		shl	di,1
		inc	word ptr cs:EchoSizeVec[di]
  EchoNoVec:

		test	cs:GenFlags,UDP_ECHO
		jnz	EchoUdp
		call	SendIcmpPkt		; send icmp echo pkt
  EchoLoop8:
if MULTIPING gt 1
		mov	ds,cs:EchoTxIndex
		assume	ds:code_s
		mov	Echo.TxStatus,cx
else
		mov	cs:Echo.TxStatus,cx
endif ; MULTIPING
		mov	ds,cs:MySegm
		assume	ds:code_s
		jnz	EchoErr 		; any errors?
  EchoLoop9:
if MULTIPING gt 1
		dec	EchoBurstCnt		; more packets in a burst?
		jnz	EchoBurstTail
endif ; MULTIPING
		jmp	EchoLoop

  EchoErr:
		test	ArgFlags,TERM_WAIT
		jnz	EchoLoop9

  EchoEnd:
if 0
		mov	ds,cs:EchoBufSeg
		assume	ds:nothing
		call	BufRelease		; release send buffer
		push	cs
		pop	ds
endif
		assume	ds:code_s
		push	cs
		pop	es
if MULTIPING gt 1
		xor	si,si
		mov	cx,MULTIPING
		mov	di,offset Echo
  EchoClearFudgeL:
		mov	word ptr [di].Fudge,si

		mov	dx,[di].ErSeqHi
		mov	ax,[di].ErSeqLo
		add	word ptr EchoSizeVec+4,ax
		adc	word ptr EchoSizeVec+2,dx

		mov	dx,[di].ErRepHi
		mov	ax,[di].ErRepLo
		add	word ptr EchoSizeVec+8,ax
		adc	word ptr EchoSizeVec+6,dx

		mov	dx,[di].ErLosHi
		mov	ax,[di].ErLosLo
		add	ax,[di].ErTmp
		adc	dx,[di].ErTmpHi
		add	word ptr EchoSizeVec+12,ax
		adc	word ptr EchoSizeVec+10,dx

		add	di,REPVECLEN
		loop	EchoClearFudgeL
else
		mov	Echo.Fudge,0
endif ; MULTIPING
		or	ArgFlags,TERM_WAIT	; wait 4 late packets to arrive
		ret

  EchoUdp:
if HOPCHK
		test	cs:MoreFlags,HOP_CHK	; hop checking?
		jnz	EchoHop
endif ; HOPCHK
		call	SendUdpPkt		; send udp echo pkt
		jmp	EchoLoop8

if HOPCHK
  EchoHop:
		call	HardwareTicks		; time stamp in ms
		mov	cl,6
		call	DblShl
		or	dh,080h			;   + 8000h
		xchg	dh,dl
		mov	[di].uUdpDst,dx		;   into dst port
		push	dx

		push	ds
		push	cs
		pop	ds
  HopWalkOver:
		mov	cx,word ptr HopCycle	; cl = HopCycle, ch = HopCount
		mov	dx,word ptr HopMax	; dl = MAXHOP, dh = MAXHOP-1
		mov	ax,word ptr HopStopThis
		div	dl			; hop cycle into al
		cmp	al,cl			; limit THIS turn?
		je	HopNextTurn

		mov	ah,HopMaxAll
		cmp	ah,dh
		jbe	HopInLim
		mov	ah,dh
  HopInLim:
		cmp	ch,ah			; reached max hops any turn?
		jb	HopSameTurn
  HopNextTurn:
		mov	HopStopThis,dh		; ignore host/net unr limit
		xor	ch,ch
		inc	cl

		cmp	cl,3			; all turns done?
		jb	HopGoOn
		mov	ax,HopReplies
		cmp	ax,HopBxMax		; any router missing?
		jl	HopGoOn

		pop	ax			; (ds)
		pop	ax			; (dx)
		jmp	EchoEnd
  HopGoOn:
		mov	HopCycle,cl

		push	cx
		mov	dx,19			; wait 1 sec before next turn
		call	DblShrX
		sub	ax,EchoInterval
		add	EchoNext,ax
		pop	cx
if 1
		mov	dx,EchoMaxSize
		mov	ax,EchoMinSize
		cmp	ax,dx			; fixed pkt size?
		jne	HopSameTurn
		inc	ax			; increase by 1 each turn
		mov	dx,MyGiant
		sub	dx,HWHDRLEN+IPHDRLEN
		cmp	ax,dx			; unless at GIANT already
		ja	HopSameTurn
		mov	EchoMinSize,ax
		mov	EchoMaxSize,ax
endif ; 1

  HopSameTurn:
		inc	ch
		mov	HopCount,ch

		cmp	cl,3			; an additional turn?
		jb	HopLowTurn
		mov	cl,2
		mov	si,word ptr HopCount
		shl	si,1
		shl	si,1
		test	HopTabStat[si],010h	; Any reply from this router?
		jz	HopLowTurn
		jmp	HopWalkOver
  HopLowTurn:
		mov	al,MAXHOP		; compute cycle and cnt
		mul	cl
		add	al,ch

		pop	ds

		mov	ah,al
		mov	al,080h
		mov	[di].uUdpSrc,ax		; 8000h+cycle into src port
		push	ax

		mov	si,[bx].dPtrIp
		mov	[si].iIpTtl,ch		; set ttl
		or	[si].iIpFlFrag,0040h	; set don't fragment
		push	si
if 1
		test	cs:ArgFlags,UDP_DISCARD	; use *PROTOCOL* unreachable?
		jz	EchoHopUdp
		mov	[si].iIpProt,241
		call	SendIpPkt
		jmp	short EchoHopAux
  EchoHopUdp:
endif ; 1
		call	SendUdpPkt		; send udp echo pkt
  EchoHopAux:
		pop	si
		mov	ax,[si].iIpId

		push	cs
		pop	ds
		mov	di,HopAuxIdx
		sub	di,2
		jns	EchoHopAux2

		mov	di,HOPAUXLEN-2
  EchoHopAux2:
		mov	HopAuxIdx,di
		cmp	di,HopAuxBeg
		jae	EchoHopAux3

		mov	HopAuxBeg,di
  EchoHopAux3:
		mov	word ptr HopAuxIpId[di],ax
		pop	ax
		mov	word ptr HopAuxCyTtl[di],ax
		pop	ax
		mov	word ptr HopAuxTime[di],ax

		xor	cx,cx
		jmp	EchoLoop8
endif ; HOPCHK
EchoAwhile	endp



;************************************************************************
;*		EchoDisplay
;************************************************************************



if DEBUG or TBLBUILD
TstEqual	proc	near
		assume	ds:nothing
		jne	TstErr
		ret
TstEqual	endp
endif ; DEBUG or TBLBUILD

if DEBUG

  TstBufLinks	proc	near
		assume	ds:nothing
		ja	TstErr
		mov	si,di
		inc	cx
    TstLinkLoop:
		push	cx
		cmp	di,offset FreeBufs
		je	BufChkEnd
ifdef SMALLBUFS
		cmp	di,offset FreeSmal
		je	BufChkEnd
endif ; SMALLBUFS
		mov	cx,es:[di].dHomeList
		cmp	cx,offset FreeBufs
ifdef SMALLBUFS
		je	TstHomeOK
		cmp	cx,offset FreeSmal
endif ; SMALLBUFS
		call	TstEqual
  TstHomeOK:
if DEBUG ge 6
		.386
		push	di
		push	eax

		push	ax
		mov	cx,(dHwDst-dPtrIp)/4
if DEBUG ge 8
		mov	cx,((dHwDst-dPtrIp)+(BUFSIZESML-DESCRLEN))/4
		mov	ax,es:[di].dHomeList
		cmp	ax,offset FreeBufs
		jne	BufChkSml
		mov	cx,((dHwDst-dPtrIp)+(BUFSIZE-DESCRLEN))/4
  BufChkSml:
endif ; DEBUG ge 8
		lea	di,[di].dPtrPhys
		mov	eax,0aaaaaaaah		; contents changed?
		scasw
		repe	scasd
		pop	ax
		call	TstEqual
		pop	eax
		pop	di
		.8086
endif ; DEBUG ge 6
  BufChkEnd:
		mov	bp,bx
		mov	ax,dx
		mov	bx,di
		mov	dx,es
		pop	cx
		les	di,es:[di].dNext
		lds	si,[si].dPrev
		loop	TstLinkLoop

		cmp	si,di
		jne	TstErr
		mov	cx,ds
		cmp	cx,cs:MySegm
		jne	TstErr
		ret
TstBufLinks	endp

endif ; DEBUG

TstErr:
		call	Terminate



Percent		proc	near			; 100 * dx:ax / cx:bx
		push	cx
		mov	cl,2			; compute packet loss
		call	DblShl			;   multiply 32 bits by 100
		mov	si,dx
		mov	bp,ax
		mov	cl,3
		call	DblShl
		add	bp,ax
		adc	si,dx
		shl	ax,1
		rcl	dx,1
		add	ax,bp
		adc	dx,si
		pop	cx

		call	AdjTo16Bits
		jz	PercentRet		; avoid div by zero

		div	bx
		push	ax

		mov	ax,dx			;   fractional loss
		mul	cs:k10000
		div	bx

		pop	dx
		cmp	dx,100
		jb	PercentOk
		and	ax,not 31
  PercentOk:
		or	sp,sp			; dx = %, ax = 1/10000 %
  PercentRet:
		ret
Percent		endp



PutDeciTime	proc	near			; hw time in si:dx:ax
		shr	dx,1
		rcr	ax,1
		div	cs:kTimer50ms
		xchg	ax,si
		mul	cs:k36000
		add	ax,si
		adc	dx,0
		jnz	PutDeciBig

		mov	cs:PutMinDigits,6
		call	PutBigNum		; max time blocked
		dec	di
		mov	ah,es:[di]
		mov	al,'.'
		stosw
		jmp	short PutDeciEnd

  PutDeciBig:
		mov	cs:PutMinDigits,8
		call	PutBigNum
		dec	di
		mov	byte ptr es:[di],' '
  PutDeciEnd:
		ret
PutDeciTime	endp



Div48By16To48	proc	near			; si:dx:ax = ds:[si] / bx
		lodsw
		xor	dx,dx
		div	bx
		push	ax
		lodsw
		div	bx
		push	ax
		lodsw
		div	bx
		pop	dx
		pop	si
		ret
Div48By16To48	endp




EchoDisplay	proc	near
		assume	ds:code_s
if DEBUG or TBLBUILD
		mov	al,'s'-'0'
		cmp	word ptr StackLow,0	; stack overflowed?
		call	TstEqual
endif ; DEBUG or TBLBUILD

if DEBUG
		mov	al,'t'-'0'
		cmp	word ptr phd_dioa,0	; stack overflowed?
		call	TstEqual

		mov	al,'i'-'0'
		test	GenFlags,DBGINTERR	; any interrupt debug errs?
		call	TstEqual

		mov	cx,MyNbufs		; any buffers damaged?
		mov	bx,offset BufStart
		mov	al,'u'-'0'
  BufTestLoop:
		cmp	[bx].dHomeList,offset FreeBufs
		call	TstEqual
		add	bx,MyBufSize
		loop	BufTestLoop

		push	cs
		pop	es
		mov	di,offset FreeBufs
		cli
		mov	cx,[di].lBufsAvail
		cmp	cx,MaxAvail
		call	TstBufLinks
		cmp	di,offset FreeBufs
		call	TstEqual
		sti

ifdef SMALLBUFS
		mov	bx,offset BufStart+NBUFS*BUFSIZE
		mov	cx,NBUFSMALL
		mov	al,'v'-'0'
  TstSmlLoop:
		cmp	[bx].dHomeList,offset FreeSmal
		call	TstEqual
		add	bx,BUFSIZESML
		loop	TstSmlLoop

		cli
		mov	di,offset FreeSmal
		mov	cx,[di].lBufsAvail
		cmp	cx,NBUFSMALL
		call	TstBufLinks
		cmp	di,offset FreeSmal
		call	TstEqual
		sti
endif ; SMALLBUFS
;		SHOW_EVENT	'o'
endif ; DEBUG

                test    GenFlags,ECHO_DISPL	; pinging or hopchecking?
                jnz      EchoDispYes
if TBLBUILD
		test	ArgFlags,MAKE_TABLE
		jz	EchoDispRet

		call	TblDisplay		; -no, must be tbl building
endif ; TBLBUILD
  EchoDispRet:
		ret


  EchoDispYes:					; -yes, we are pinging
		mov	cx,SavedTicks
		shr	cx,1			; update every second tick
		mov	ax,EchoLastDispl
		shr	ax,1
		cmp	ax,cx			; time to update display?
		je	EchoDispRet

		call	HardwareTicks		; get current time
		mov	EchoLastDispl,dx
		push	ax
		push	dx
if DEBUG
		push	si
endif ; DEBUG
		push	ds
		pop	es

		sub	ax,EchoStart+4		; compute elapsed time
		sbb	dx,EchoStart+2
		sbb	si,EchoStart
if DEBUG
		jns	EchoElaPos
		mov	al,'H'-'0'
		call	Terminate
  EchoElaPos:
endif ; DEBUG
		mov	EchoElapsed,si
		mov	EchoElapsed+2,dx
		mov	EchoElapsed+4,ax

		mov	di,offset MsgLoadElap
		call	PutDeciTime

if DEBUG
		pop	si
endif ; DEBUG
		pop	dx
		pop	ax
		dec	EchoLoadCnt		; update load every 9:th time
		jnz	EchoLoad1st
  EchoLoadUpd:
		mov	EchoLoadCnt,9
		mov	bx,ax
		mov	cx,dx
		sub	ax,EchoLoadTime+2
		sbb	dx,EchoLoadTime
		mov	EchoLoadTime+2,bx
		mov	EchoLoadTime,cx
		js	EchoLoad1st		; avoid overflow

		div	kTimerScale
		mov	bx,ax
		cli
		mov	ax,EchoLoad+2
		mov	dx,EchoLoad
		mov	EchoLoad+2,0
		mov	EchoLoad,0
		sti
		div	bx
		push	ax
		mov	ax,dx
		xor	dx,dx
		mov	cl,3
		call	DblShl
		div	bx
		mov	bx,ax
		pop	ax
		mul	k8
		add	ax,bx
		adc	dx,0

		mov	di,offset MsgLoadNum
		mov	PutMinDigits,6
		call	PutBigNum		; load kb/s
  EchoLoad1st:
if 0
		test	MoreFlags,HOP_CHK
		jnz	EchoDispIndLoop

		mov	al,DSPLINLEN
		mul	EchoNumDst
		add	ax,offset MsgEcho
		mov	di,ax
		mov	si,offset MsgLoadStart
		mov	cx,MsgLoadLineLen/2
		rep	movsw
endif


  EchoDispIndLoop:
		mov	al,EchoShowCnt
		or	al,al			; normal, headers or footer?
		jns	EchoDispInd

		cmp	al,-3			; footer?
		je	EchoDispLoad

		test	MoreFlags,HOP_CHK
		jnz	EchoDispInd
		jmp	EchoDispHdr

  EchoDispLoad:
		mov	bp,offset MsgLoadStart
		mov	bx,DspBxMax
		inc	EchoShowCnt
		jmp	EchoDspIt

  EchoDispInd:
if MULTIPING gt 1
		mov	ax,cs			; compute destination index
		add	ax,EchoShowInd
		mov	ds,ax
endif ; MULTIPING

		cli
		mov	dx,Echo.AvgSum		; collect avg delay info
		mov	ax,Echo.AvgSum+2
		mov	cx,Echo.RxHi
		mov	bx,Echo.RxLo
		sti
if DEBUG ge 2
		cmp	cs:EchoShowCnt,0
		jne	EchoDispNot1stRow

		mov	ax,MinAvail		; Show min available bufs
		jmp	short EchoDisp1stRow
  EchoDispNot1stRow:
endif ; DEBUG ge 2
		call	AdjTo16Bits
		jz	EchoSkipAvg		; avoid div by zero

		div	bx
  EchoDisp1stRow:
		mov	Echo.AvgDly,ax		; average delay

  EchoSkipAvg:
		cmp	cs:EchoTarget,0		; ping/hopchecking or not?
		jne	$+5
		jmp	EchoDspDiscard

		SHOW_EVENT	'i'
		mov	dx,Echo.TxHi		; compute difference tx - rx
		mov	ax,Echo.TxLo
		sub	ax,Echo.Fudge		;   subtract one if just
		sbb	dx,0			;   sent a pkt
		push	ax
		push	dx
		cli
		sub	ax,Echo.RxLo
		sbb	dx,Echo.RxHi
		sti
		push	ax
		push	dx
		jns	EchoDifPos		; use abs(tx-rx)
		call	NegDxAx
  EchoDifPos:
		mov	Echo.DifHi,dx
		mov	Echo.DifLo,ax
		pop	dx
		pop	ax
		cli
		add	ax,Echo_ErRepLo		; don't count repeated as loss
		adc	dx,Echo_ErRepHi
		sti
		jns	EchoLossPos		; use abs(tx-rx+rep)
		call	NegDxAx
  EchoLossPos:
		and	Echo.Flag,not PROBABLY_LOST
		mov	si,Echo.MaxDly		; convert ms maxdelay to ticks
		or	si,si
		jnz	EchoGotMax
		mov	si,2000			; assume 2 s if no reply yet
  EchoGotMax:
		add	si,500
		mov	cl,5			;   with a margin
		shr	si,cl
		push	si			;   and save it

		mov	cx,Echo.TxTime
		add	cx,si
		cmp	cx,cs:SavedTicks	; did we stop a while ago?
		jns	EchoDispNotStop

		and	cs:GenFlags,not PING_DELAY
		sub	cx,si
		cmp	Echo.RxTime,cx	;*test
		jns	EchoDispLoss

		mov	Echo.Fudge,0
		or	Echo.Flag,PROBABLY_LOST
		jmp	short EchoDispLoss	; - yes, use diff

  EchoDispNotStop:
		add	si,cs:EchoIvalHi
		cli
		add	si,Echo.RxTime
		sub	si,Echo.TxTime		; received anything lately?
		mov	bx,Echo.RxTimeHiHi
		sti
		sbb	bx,Echo.TxTimeHiHi
		jns	EchoUseLoss

  EchoDispNoRx:
		mov	Echo.Fudge,0		; - no, he
		or	Echo.Flag,PROBABLY_LOST	;    probably died
		and	cs:GenFlags,not (NO_ERR_YET+NO_DROP_YET)
		jmp	short EchoDispLoss

  EchoUseLoss:
		cli
		mov	ax,Echo_ErLosLo		; use loss cntr
		mov	dx,Echo_ErLosHi
		sti
  EchoDispLoss:
		pop	di			; (pushed as si)
		pop	cx
		pop	bx

		call	Percent			; compute total packet loss %
		jz	EchoSkipLoss
		mov	Echo.Loss,dx
		mov	Echo.Loss+2,ax
  EchoSkipLoss:
		shr	di,1
		add	di,Echo.ErTmpTime
		cmp	di,cs:SavedTicks	; err older than max delay?
		jns	EchoDspTmp

		cli
		mov	ax,Echo_ErTmp		; make temp err permanent
		mov	dx,Echo_ErTmpHi
		add	Echo_ErLosLo,ax
		adc	Echo_ErLosHi,dx
		mov	Echo_ErTmpHi,0
		mov	Echo_ErTmp,0
		sti
  EchoDspTmp:

  EchoDspDiscard:
		push	cs			; edit echo values
		pop	es
if HOPCHK
		test	cs:MoreFlags,HOP_CHK	; hop check going on?
		jz	EchoDspNoHop
		jmp	HopDisplay
  EchoDspNoHop:
endif ; HOPCHK
		mov	di,cs:EchoMsgAdr	; point to current row
		push	di
		mov	si,offset Echo.TxHi
		mov     cs:PutNumFiller,' '
		mov	cs:PutMinDigits,8
		mov	cl,1
		call	PutBigNums		; tx
		inc	di
		mov	cl,1
		call	PutBigNums		; rx
		mov	cs:PutMinDigits,7
		inc	di
		mov	cl,1
		call	PutBigNums		; diff

		push	si
		xor	si,si
		mov	dx,Echo_ErRepLo		; any repeated pkts?
		or	dx,Echo_ErRepHi
		jz	EchoDispNoRep

		inc	si
  EchoDispNoRep:
		test	Echo.Flag,PROBABLY_LOST
		jnz	EchoDispLossChr

		mov	dx,Echo_ErLosLo		; any lost packet events?
		or	dx,Echo_ErLosHi
		or	dx,Echo_ErTmp
		or	dx,Echo_ErTmpHi
		jz	EchoDispNoLoss
  EchoDispLossChr:
		lodsw				; add	si,2
  EchoDispNoLoss:
		mov	dx,Echo_ErSeqLo		; any out of sequence?
		or	dx,Echo_ErSeqHi
		jz	EchoDispInSeq

		lodsw				; add	si,4
		lodsw
  EchoDispInSeq:
		mov	al,cs:EchoErrChar[si]
		mov	es:[di],al		; put rep/seq/lost char
		pop	si

		pop	di
		add	di,26
		call	PutNums1D4Fb 		; loss

		mov	al,'.'
		stosb
		mov	cl,1
		call	PutNumsF0		; .0000%

		mov	cs:PutNumFiller,' '
		cmp	word ptr [si+2],-1	; any reply yet?
		jne	EchoDispMinDel

		add	si,8			; -no, leave blank
		add	di,offset MsgEchoBlkStat-offset MsgEchoDelays
		jmp	short EchoDispNoDel
  EchoDispMinDel:
		mov	cs:PutMinDigits,6	; -yes
		call	PutNums1 		; this delay

		mov	cs:PutMinDigits,5	; min delay
		call	PutNums1
		mov	cs:PutMinDigits,6	; max delay
		mov	cx,7f02h
		call	PutNums

  EchoDispNoDel:
		test	cs:MoreFlags,PING_STOPPED
		jz	$+5
		jmp	EchoNoBlStat

		cli
		mov	si,Echo.OffMaxHiHi	; get previous max blocking
		mov	dx,Echo.OffMaxHi
		mov	ax,Echo.OffMaxLo

		mov	bp,Echo.OffAvgHiHi
		mov	cx,Echo.OffAvgHi
		mov	bx,Echo.OffAvgLo
		mov	Echo.OffAvgTmpHiHi,bp
		mov	Echo.OffAvgTmpHi,cx
		mov	Echo.OffAvgTmpLo,bx

		mov	bx,cs:SavedTickCntr	; any ongoing blocking?
		mov	cx,cs:SavedTicks
		mov	bp,cs:SavedTicksHi
		sub	bx,Echo.RxTimeLo
		sbb	cx,Echo.RxTime
		sbb	bp,Echo.RxTimeHiHi
		sti
		sub	bx,cs:EchoIvalLo
		sbb	cx,cs:EchoIvalHi
		sbb	bp,0

		push	bp
		push	cx
		push	bx
		mov	Echo.OffNumTmp,0
		sub	bx,cs:BlockTimLo
		sbb	cx,cs:BlockTimHi
		sbb	bp,0
		pushf
		add	bx,cs:EchoIvalLo
		adc	cx,cs:EchoIvalHi
		adc	bp,0
		mov	bl,' '
		js	EchoDispNoBlking

		mov	bl,'B'			; -yes, show "B" after rec cntr
  EchoDispNoBlking:
		mov	es:[di+MsgEchoBlocking-MsgEchoBlkStat],bl
		popf
		pop	bx
		pop	cx
		pop	bp
		js	EchoDispDropE

		inc	Echo.OffNumTmp		; - yes, show predicted values
		add	Echo.OffAvgTmpLo,bx
		adc	Echo.OffAvgTmpHi,cx
		adc	Echo.OffAvgTmpHiHi,bp

		cmp	bp,si			; ongoing longer than previous?
		jb	EchoDispDropE
		ja	EchoDispOffM
		cmp	cx,dx
		jb	EchoDispDropE
		ja	EchoDispOffM
		cmp	bx,ax
		jbe	EchoDispDropE
  EchoDispOffM:
		mov	ax,bx			; -yes, use ongoing as max
		mov	dx,cx
		mov	si,bp
  EchoDispDropE:
		mov	cx,Echo.OffNum
		or	cx,Echo.OffNumTmp
		jnz	EchoDispBlk		; any blocking?


  EchoDispBlkBlnk:
		mov	ax,' '+256*0fah		; -no, blank field
		mov	cx,(MsgEchoIpnr-MsgEchoBlkStat+1-2)/2
		rep	stosw
		stosb
		stosb
		jmp	EchoNoBlStat
  EchoDispBlk:
		push	di			; -yes
		add	di,MsgEchoBlkMax-MsgEchoBlkStat
		call	PutDeciTime		; max blocking time
		pop	di

		cli
		mov	dx,Echo.OffSumHi	; compute loss due to blocking
		mov	ax,Echo.OffSumLo
		sti

		cmp	Echo.OffNumTmp,0	; ongoing blocking?
		jz	EchoNoTmpBlock

		add	ax,Echo.TxLo		; -yes, estimate loss
		adc	dx,Echo.TxHi
		cli
		sub	ax,Echo.SeqRx
		sbb	dx,Echo.SeqRxHi
		sti
		sub	ax,Echo.Fudge
		sbb	dx,0			; *test - avgdelay/ival
  EchoNoTmpBlock:
		mov	bx,Echo.TxLo
		mov	cx,Echo.TxHi
		call	Percent
		jz	EchoNoBlStat
  EchoDspBlPct:
		push	ax
		mov	ax,dx
		call	PutNumD4Fb		; blocking percent
		mov	al,'.'
		stosb
		pop	ax
		mov	cs:PutNumFiller,'0'
		call	Putnum
		mov	cs:PutNumFiller,' '
		dec	di

  EchoDspMtbf:
		mov	bx,Echo.OffNum
		add	bx,Echo.OffNumTmp
		push	bx
		mov	si,offset EchoElapsed
		push	ds
		push	cs
		pop	ds
		call	Div48By16To48		; elapsed time / # of blockings
		pop	ds
		call	PutDeciTime		; mtbf

		pop	bx
		mov	si,offset Echo.OffAvgTmpHiHi
		call	Div48By16To48		; blking time / # of blockings
		call	PutDeciTime		; Average blocking time
  EchoNoBlStat:

		cmp	cs:EchoShowCnt,0
		jz	EchoDisp1st
		jmp	EchoNot1stLine		; skip if not first line
  EchoDisp1st:
if DEBUG ge 9
		mov	dx,280h+10h		; assume WD card at IO 280h
		xor	ax,ax
		xor	cx,cx
		cli
		out	dx,al			; set page 0
		call	IoDelay
		add	dx,0eh
		in	al,dx			; readnadclear bad CRC ctr
		add	cx,ax
		inc	dx
		in	al,dx			; readandclear lost frames ctr
		sti
		add	cx,ax
		add	EchoDrop,cx		; add out of bufs ctr
endif ; DEBUG ge 9
		mov	PutMinDigits,1
		mov	ax,EchoDrop
if DEBUG eq 0
		or	ax,ax
		jz	EchoNoDrops
endif ; DEBUG eq 0
		mov	di,offset MsgEchoNoBuf	; place before diff
		call	PutNum			; show buffer-dropped packets
		mov	byte ptr [di],' '
  EchoNoDrops:

		mov	ax,EchoChkErr
		or	ax,ax
		jz	EchoNoChkErr

		mov	di,offset MsgEchoChkErr	; place before receive figure
		call	PutNum			; show chksum-dropped packets
		mov	byte ptr [di],' '
  EchoNoChkErr:


  EchoNot1stLine:
		mov	dh,byte ptr Echo.TxStatus ; staus of last Tx

		push	cs			; leave indexed data
		pop	ds

		mov	cx,18			; show in clear last tx stat
		mov	al,cl
		mul	dh
		mov	si,ax
		add	si,offset MsgSerrNoErr
		mov	di,EchoMsgAdr
		add	di,offset MsgEchoSeqEr - offset MsgEcho

		mov	al,[si]
		mov	[di+offset MsgEchoStatus-offset MsgEchoSeqEr],al

		or	dh,dh
		jz	EchoDispStatOk

		mov	di,offset MsgStatusField
		rep	movsb
  EchoDispStatOk:

if MULTIPING gt 1
		mov	dx,EchoShowInd		; prepair next ds offset
		mov	ax,EchoSegInc

		rept	REPVECPWR-4-2
		shl	ax,1
		endm

		add	dx,ax
		mov	EchoShowInd,dx
endif ; MULTIPING

  EchoDispLine:
		or	MoreFlags,UPPD_LINE
  EchoDispHdr:
		mov	bp,EchoMsgAdr		; display next line in sequence
		add	EchoMsgAdr,DSPLINLEN
		mov	al,EchoShowCnt
		cbw
		inc	ax
		mov	bx,ax
		inc	bx
		mov	EchoShowCnt,al
		cmp	al,EchoNumDst		; last echo line?
		jl	EchoDispNotTime

		mov	EchoShowCnt,-3		; -yes, disply load next
		mov	EchoMsgAdr,offset MsgEcho-2*DSPLINLEN
		mov	EchoShowInd,0
  EchoDispNotTime:
		call	EchoDspIt		; display scrollable info
		call	CurrentTicks
;*test		push	cs
;*test		pop	es
		cmp	cx,EchoLastDispl	; time available for next line?
		jne	EchoDspItRet		; (probably remote dsp over POTS)
		jmp	EchoDispIndLoop

  EchoDspItRet:
		ret



EchoDspThis:
		test	MoreFlags,UPPD_LINE+UPPD_HSCR ; anything NEW to display?
		jz	HopDspNoUppd

		and	MoreFlags,not UPPD_LINE
EchoDspIt:
		push	bx
		call	GetDspRow		; get cur screen row
		mov	dh,bl

		add	dh,HopTopRow
		cmp	dh,HopMaxRows
		jle	HopDspOkRow		; below bottom?

		test	MoreFlags,NO_AUTOSCROLL	; up/dn arrow key used?
		jnz	HopDspOutside		; -yes, manual scroll

		sub	dh,HopMaxRows		; -no, auto scroll
		sub	HopTopRow,dh

		mov	al,dh
		mov	ah,6			; scroll up <al> lines
		call	ScrollUpDn

		mov	dh,HopMaxRows
  HopDspOkRow:
		call	DisplayLine		; display bp-buf at row dh
  HopDspOutside:
		pop	bx
  HopDspSkip:

  HopDspNoUppd:
		cmp	bx,DspBxMax		; check scroll once per wipe
		je	HopDspTestScr
		ret


  HopDspTestScr:
		and	MoreFlags,not UPPD_HSCR
		mov	al,HScrollVal
		or	al,al			; left/right keys pressed?
		jz	HopDspNoHscr

		mov	al,1
		mov	HScrollVal,0
		js	HopDspHri
		mov	al,-1
  HopDspHri:
		add	al,HScrollAdj
		js	HopDspNoHscr		; left limit?

		cmp	al,13			; right limit?
		ja	HopDspNoHscr
		
		mov	HScrollAdj,al
		or	MoreFlags,UPPD_HSCR	; enshure one full screen wipe
  HopDspNoHscr: 
		mov	al,ScrollVal
		or	al,al			; up/dn key used?
		jz	HopDspRet
		or	MoreFlags,NO_AUTOSCROLL	; set manual scroll mode
		mov	ScrollVal,0
		or	al,al
		js	HopDspScrUp
  HopDspScrDn:
		mov	al,HopTopRow		; manual scroll down
		or	al,al			; anything more to show?
		jns	HopDspRet

		inc	al
		mov	HopTopRow,al

		neg	al
		xor	ah,ah
		mul	kLinLen
		mov	bp,offset HopTabDsp-2*DSPLINLEN
		test	MoreFlags,HOP_CHK
		jnz	HopDspScrD1
		mov	bp,offset MsgEchoStats+1
  HopDspScrD1:
		add	bp,ax

		mov	ah,7			; scroll down
		xor	dx,dx			; display at 0,0
		jmp	short HopDspScr

  HopDspScrUp:
		mov	bx,DspBxMax		; manual scroll up
		mov	al,HopTopRow		; anything more to show?
		add	bl,al
		cmp	bl,HopMaxRows
		jle	HopDspRet

		dec	al
		mov	HopTopRow,al
		sub	al,HopMaxRows		; compute start addr
		neg	al
		mul	kLinLen
		mov	bp,offset HopTabDsp-2*DSPLINLEN
		test	MoreFlags,HOP_CHK
		jnz	HopDspScrU1
		mov	bp,offset MsgEchoStats+1
  HopDspScrU1:
		add	bp,ax

		mov	ah,6			; scroll up
		mov	dh,HopMaxRows		; display at last row
  HopDspScr:
		mov	al,1			; scroll one line
		call	ScrollUpDn
		call	DisplayLine		; display bp-buf at row dh
  HopDspRet:
		ret



ScrollUpDn	proc	near
		push	dx			; save row to display on
		mov	bh,7			; filler attribute
		xor	cx,cx			; scroll all screen
		mov	dx,EchoDspCols
		shr	dx,1
		dec	dl
		mov	dh,HopMaxRows
		int	10h
		pop	dx
		ret
ScrollUpDn	endp



DisplayLine	proc	near
		or	dh,dh			; above the top?
		jl	HopDspAbovTop

		mov	al,HScrollAdj
		mul	byte ptr k4
		add	bp,ax

		mov	ax,1300h
		cmp	dh,HopLimRow		; lowest line yet?
		jle	HopDspDecr
		inc	ax			; move cursor
		mov	HopLimRow,dh
  HopDspDecr:
		mov	bx,0007h		; page 0 and attr 7
		mov	cx,EchoDspCols		; 80 or 79 chars
		shr	cx,1
		cmp	dh,HopMaxRows
		jne	HopDspNoProbl
		dec	cx			; avoid scroll at last line
  HopDspNoProbl:
		xor	dl,dl			; first col
		test	ArgFlags,AVOID_HDWR
		jnz	HopDspLineDos

		or	al,al			; let DOS handle cursor moves
		jnz	HopDspLineDos

		push	es			; simple fast display routine
		push	si
		push	di
		mov	ax,EchoDspCols
		shr	ax,1
		mul	dh
		xor	dh,dh
		shl	ax,1
		mov	EchoDspInd,ax
		shl	dx,1
		add	ax,dx
		mov	di,ax
		mov	es,EchoDispPar
		mov	si,bp
		mov	ax,es:[di]
  HopDspL1:
		lodsb
		stosw
		loop	HopDspL1

		pop	di
		pop	si
		pop	es
		ret

  HopDspLineDos:
		int	10h			; display one line
  HopDspAbovTop:
		ret
DisplayLine	endp



GetDspRow	proc	near
		test	GenFlags,GOT_DSP_ROW
		jnz	EchoDspGotRow

		mov	ah,15			; get screen mode
		int	10h			; call video BIOS
		cmp	al,7			; is it mono?
		mov	dx,0b000h
		jz	K1			; yes
		mov	dh,0b8h			; no, set for color
  K1:
		mov	EchoDispPar,dx

		xchg	al,ah
		xor	ah,ah
		shl	ax,1
		mov	EchoDspCols,ax

		mov	ah,03h
		xor	bx,bx
		int	10h			; get current row
		mov	HopTopRow,dh
if HOPCHK
		push	es
		mov	ax,0040h
		mov	es,ax
		mov	al,es:[0084h]		; get dsp # of rows
		mov	HopMaxRows,al
		pop	es
endif ; HOPCHK
		mov	ax,EchoDspCols
		mul	word ptr HopTopRow
		mov	EchoDspRow,ax
		or	GenFlags,GOT_DSP_ROW
		cmp	ax,ax
  EchoDspGotRow:
		ret
GetDspRow	endp

  EchoDispPar	dw	0b800h
  EchoDspRow	dw	(25-1)*160
  EchoDspCols	dw	160
  EchoDspInd	dw	0
EchoDisplay	endp


;				  seq   lost   rep
EchoErrChar	db	' '	;   0      0     0  space
		db	0eh	;   0      0     1  double music note
		db	'.'	;   0      1     0  dot
		db	':'	;   0      1     1  colon (double dot)
		db	"'"	;   1      0     0  apostrophe
		db	'"'	;   1      0     1  quote (double apostrophe)
		db	'!'	;   1      1     0  exclamation mark
		db	13h	;   1      1     1  double exclamation mark



;************************************************************************
;*		AdjTo16Bits
;************************************************************************

  Adjust:
		shr	dx,1			; shift 32 bits right
		rcr	ax,1
		shr	cx,1
		rcr	bx,1
AdjTo16Bits:
		or	cx,cx			; div fits in 16 bits?
		jnz	Adjust

		cmp	dx,bx			; will it overflow?
		jb	AdjTo16Ret

		xor	bx,bx
  AdjTo16Ret:
		or	bx,bx			; avoid div by zero
		ret



;************************************************************************
;*		DblShrX
;************************************************************************

DblShrX 	proc	near
		mov	cl,7
		test	cs:ArgFlags,MICRO_100
		jnz	DblShr
DblShr10:
		mov	cl,10
DblShr:
		xor	ch,ch
  DblShrNext:
		shr	dx,1			; shift 32 bits right
		rcr	ax,1
		loop	DblShrNext
		ret
DblShrX 	endp



;************************************************************************
;*		DblShl
;************************************************************************

DblShl		proc	near
		xor	ch,ch
  DblShlNext:
		shl	ax,1			; shift 32 bits left
		rcl	dx,1
		loop	DblShlNext
		ret
DblShl		endp



if 0
;************************************************************************
;*		EchoCalc
;************************************************************************

EchoRepBit	db	001h, 002h, 004h, 008h
		db	010h, 020h, 040h, 080h

EchoCalc	proc	near
		assume	ds:nothing
		mov	si,[bx].dPktLen

		push	ds
		mov	bp,ds
		mov	es,bp
if MULTIPING gt 0
		xor	ah,ah
		mov	al,byte ptr [di].uUdpData
INDMASK1	equ	REPVECLEN*MULTIPING-1
INDMASK2	equ	INDMASK1 XOR (REPVECLEN-1)
INDMASK3	=	INDMASK2 SHR 4

if MULTIPINGPWR + REPVECPWR-4 gt 8
INDMASKSHIFT	equ	REPVECPWR-4-2 - (8-2-MULTIPINGPWR)
INDMASK3	=	INDMASK3 SHR INDMASKSHIFT

if DEBUG
		test	al,not INDMASK3
		jz	EchoCalcDeb1
		mov	al,'m'-'0'
		call	Terminate
  EchoCalcDeb1:
endif ; DEBUG
		and	al,INDMASK3

		rept	INDMASKSHIFT
		shl	ax,1
		endm
else

if DEBUG
		test	al,not INDMASK3
		jz	EchoCalcDeb1
		mov	al,'m'-'0'
		call	Terminate
  EchoCalcDeb1:
endif ; DEBUG
		and	al,INDMASK3
endif ; MULTIPINGPWR
		add	ax,cs:MySegm
		mov	ds,ax
endif ; MULTIPING gt 0
		assume	ds:code_s

		shl	si,1
		dec	word ptr cs:EchoSizeVec[si] ; update error size table

		xor	cx,cx
		add	Echo.RxLo,1		; increment receive counters
		adc	Echo.RxHi,cx
		mov	Echo.Fudge,cx

		mov	ax,Echo.SeqRx
		inc	ax
		mov	cx,es:[di].uUdpData+4

		mov	si,cx
		and	si,8-1
		mov	dl,cs:EchoRepBit[si]
		mov	si,cx
		shr	si,1
		shr	si,1
		shr	si,1
		and	si,cs:EchoRepLen1

					;*test Hi first
		cmp	ax,cx			; packet in sequence?
		jne	EchoCalcChkSeq
  EchoCalcInSeq:
		mov	Echo.SeqRx,ax		; "highest" sequence yet
		cmp	Echo.TxLo,ax
		mov	ax,Echo.TxHi
		sbb	ax,0
		mov	Echo.SeqRxHi,ax
  EchoCalcDelay:
		SHOW_EVENT	'a'
		or	byte ptr EchoRepVec[si],dl ; mark got this seq #

		call	HardwareTicks		; compute delay
		mov	Echo.RxTimeHiHi,si
		mov	Echo.RxTime,dx
		mov	Echo.RxTimeLo,ax
		mov	si,es:[di].uUdpData
		mov	cx,es:[di].uUdpData+2
		sub	ax,si
		sbb	dx,cx
		js	EchoCalcRet

		SHOW_EVENT	'b'
		mov	Echo.RxTxTimeLo,si
		mov	Echo.RxTxTime,cx
		mov	si,Echo.TxTimeHiHi
		cmp	Echo.TxTime,cx	;*test
		sbb	si,0
		mov	Echo.RxTxTimeHiHi,si

		div	cs:kTimerScale
		mov	Echo.ThisDly,ax		; delay for this packet

		add	Echo.AvgSum+2,ax
		adc	Echo.AvgSum,0

		cmp	ax,Echo.MinDly
		jb	EchoSetMin
  EchoChkMax:
		cmp	ax,Echo.MaxDly
		ja	EchoSetMax
  EchoCalcRet:
		pop	ds
		ret

  EchoSetMin:
		mov	Echo.MinDly,ax		; minimum delay
		jmp	short EchoChkMax
  EchoSetMax:
		mov	Echo.MaxDly,ax		; maximum delay
		jmp	short EchoChkMax


  EchoCalcChkSeq:
		SHOW_EVENT	'c'
		js	EchoCalcDrop		; missing packet(s)?

		test	byte ptr EchoRepVec[si],dl ; a repeated packet?
		jz	EchoCalcOos

  EchoCalcRepeat:
		SHOW_EVENT	'e'
		add	Echo_ErRepLo,1		; inc repeated pkts cntr
		adc	Echo_ErRepHi,0
  EchoCalcNonSeq:
		and	cs:GenFlags,not NO_ERR_YET ; note err detected
  EchoCalcDelay2:
		jmp	short EchoCalcDelay
  
  EchoCalcOos:
		SHOW_EVENT	'd'
		add	Echo_ErSeqLo,1		; inc out of sequence cntr
		adc	Echo_ErSeqHi,0

		mov	ax,Echo_ErTmp	;*test Hi
		dec	ax
		js	EchoLostMain		; use tmp or main counter?

		mov	Echo_ErTmp,ax
  EchoCalcIgnSeq:
		test	cs:ArgFlags,SEQ_ERR_IGNORE
		jnz	EchoCalcDelay2
		jmp	short EchoCalcNonSeq

  EchoLostMain:
		mov	ax,Echo_ErLosLo
		or	ax,Echo_ErLosHi		; too much out of seq repeats
		jz	EchoCalcRepeat		;   have occured?

		sub	Echo_ErLosLo,1		; after all: wasn't lost
		sbb	Echo_ErLosHi,0
		jmp	short EchoCalcIgnSeq

  EchoCalcDrop:
		SHOW_EVENT	'f'
		push	dx
		push	si
		mov	Echo.SeqRx,cx		; "highest" sequence yet

		cmp	Echo.TxLo,cx
		mov	dx,Echo.TxHi
		sbb	dx,0
		mov	si,dx

		sub	cx,ax			; # of pkts missing
		sbb	si,Echo.SeqRxHi
		mov	Echo.SeqRxHi,dx

		mov	dx,Echo_ErTmp
		or	dx,dx			; old or new occurance?
		jnz	EchoDropMore	;*test Hi
		push	cs:SavedTicks
		pop	Echo.ErTmpTime		; -new, initialize timer
  EchoDropMore:
		add	Echo_ErTmp,cx		; add to temporary drops
		adc	Echo_ErTmpHi,si
		xchg	ax,cx
		push	si
		push	ax
  EchoDropL:
		mov	si,cx
		and	si,8-1
		mov	dl,cs:EchoRepBit[si]
		mov	si,cx
		shr	si,1
		shr	si,1
		shr	si,1
		and	si,cs:EchoRepLen1
		not	dl
		and	byte ptr EchoRepVec[si],dl ; mark as not received
		inc	cx
		dec	ax
		jnz	EchoDropL		; repeat for all "lost" pkts

		pop	ax
		pop	dx
		or	dx,dx
		jnz	EchoCalcLostMany
		cmp	ax,cs:EchoBlockLim	; enough consecutive pkts lost?
		jb	EchoCalcDropE
  EchoCalcLostMany:
		add	Echo.OffSumLo,ax	; avg blocking length
		adc	Echo.OffSumHi,dx
		inc	Echo.OffNum

		mov	ax,es:[di].uUdpData	; compute blocking time
		mov	dx,es:[di].uUdpData+2
		cmp	Echo.TxTime,dx
		mov	si,Echo.TxTimeHiHi	;*test
		sbb	si,0

		push	si
		push	dx
		push	ax
		sub	ax,Echo.RxTxTimeLo
		sbb	dx,Echo.RxTxTime
		sbb	si,Echo.RxTxTimeHiHi
		pop	Echo.RxTxTimeLo
		pop	Echo.RxTxTime
		pop	Echo.RxTxTimeHiHi
		sub	ax,cs:EchoIvalLo
		sbb	dx,cs:EchoIvalHi
		sbb	si,0
		js	EchoCalcDropE

		add	Echo.OffAvgLo,ax	; sum to avg computation
		adc	Echo.OffAvgHi,dx
		adc	Echo.OffAvgHiHi,si

		cmp	si,Echo.OffMaxHiHi	; assign max blocking time
		jb	EchoCalcDropE
		ja	EchoCalcOffM
		cmp	dx,Echo.OffMaxHi
		jb	EchoCalcDropE
		ja	EchoCalcOffM
		cmp	ax,Echo.OffMaxLo
		jbe	EchoCalcDropE
  EchoCalcOffM:
		mov	Echo.OffMaxLo,ax
		mov	Echo.OffMaxHi,dx
		mov	Echo.OffMaxHiHi,si
  EchoCalcDropE:
		pop	si
		pop	dx
		jmp	EchoCalcNonSeq
EchoCalc	endp



else
;************************************************************************
;*		EchoCalc
;************************************************************************

EchoRepBit	db	001h, 002h, 004h, 008h
		db	010h, 020h, 040h, 080h


EchoCalc	proc	near
		assume	ds:nothing
		mov	si,[bx].dPktLen
		push	ds
		mov	bp,ds
		mov	es,bp
if MULTIPING gt 0
		xor	ah,ah
		mov	al,byte ptr [di].uUdpData
INDMASK1	equ	REPVECLEN*MULTIPING-1
INDMASK2	equ	INDMASK1 XOR (REPVECLEN-1)
INDMASK3	=	INDMASK2 SHR 4

if MULTIPINGPWR + REPVECPWR-4 gt 8
INDMASKSHIFT	equ	REPVECPWR-4-2 - (8-2-MULTIPINGPWR)
INDMASK3	=	INDMASK3 SHR INDMASKSHIFT

if DEBUG
		test	al,not INDMASK3
		jz	EchoCalcDeb1
		mov	al,'m'-'0'
		call	Terminate
  EchoCalcDeb1:
endif ; DEBUG
		and	al,INDMASK3

		rept	INDMASKSHIFT
		shl	ax,1
		endm
else

if DEBUG
		test	al,not INDMASK3
		jz	EchoCalcDeb1
		mov	al,'m'-'0'
		call	Terminate
  EchoCalcDeb1:
endif ; DEBUG
		and	al,INDMASK3
endif ; MULTIPINGPWR
		add	ax,cs:MySegm
		mov	ds,ax
endif ; MULTIPING gt 0
		assume	ds:code_s

		shl	si,1
		dec	word ptr cs:EchoSizeVec[si] ; update error size table

		xor	cx,cx
		add	Echo.RxLo,1		; increment receive counters
		adc	Echo.RxHi,cx
		mov	Echo.Fudge,cx

		mov	ax,Echo.SeqRx		; last received seq #
		inc	ax			; expect this seq #
		mov	cx,es:[di].uUdpData+4	; actual received seq #

		mov	si,cx			; prepare repeat vector tests
		and	si,8-1
		mov	dl,cs:EchoRepBit[si]
		mov	si,cx
		shr	si,1
		shr	si,1
		shr	si,1
		and	si,cs:EchoRepLen1

		mov	bp,Echo.TxHi		; compute SeqRxHi
		cmp	Echo.TxLo,cx
		sbb	bp,0

		cmp	ax,cx			; packet in sequence?
		jne	EchoCalcChkSeq

  EchoCalcHigherSeq:
		mov	Echo.SeqRx,cx		; "highest" sequence yet
		mov	Echo.SeqRxHi,bp

		mov	bp,es:[di].uUdpData	; get time stamp
		mov	cx,es:[di].uUdpData+2

		mov	Echo.RxTxTimeLo,bp	; save received tx time
		mov	Echo.RxTxTime,cx
		mov	ax,Echo.TxTimeHiHi
		cmp	Echo.TxTime,cx
		sbb	ax,0
		mov	Echo.RxTxTimeHiHi,ax

  EchoCalcDelay:
		SHOW_EVENT	'a'
		or	byte ptr EchoRepVec[si],dl ; mark got this seq #

		call	HardwareTicks		; compute delay
		mov	Echo.RxTimeHiHi,si
		mov	Echo.RxTime,dx
		mov	Echo.RxTimeLo,ax
		sub	ax,bp
		sbb	dx,cx

		mov	si,TimerResolution
		cmp	dx,si			; negative time??? (Windows!!)
		jae	EchoCalcRet

		SHOW_EVENT	'b'
		div	si
		mov	Echo.ThisDly,ax		; delay for this packet

		add	Echo.AvgSum+2,ax
		adc	Echo.AvgSum,0

		cmp	ax,Echo.MinDly
		jb	EchoSetMin
  EchoChkMax:
		cmp	ax,Echo.MaxDly
		ja	EchoSetMax
  EchoCalcRet:
		pop	ds
		ret

  EchoSetMin:
		mov	Echo.MinDly,ax		; minimum delay
		jmp	short EchoChkMax
  EchoSetMax:
		mov	Echo.MaxDly,ax		; maximum delay
		jmp	short EchoCalcRet


  EchoCalcChkSeq:
		SHOW_EVENT	'c'
		push	cx
		push	bp
		mov	ax,Echo.SeqRx		; # of missing packets
		add	ax,1
		sbb	bp,0
		sub	cx,ax
		sbb	bp,Echo.SeqRxHi
		jns	EchoCalcDrop		; any missing packet(s)?

		pop	bp
		pop	cx
		test	byte ptr EchoRepVec[si],dl ; a repeated packet?
		jz	EchoCalcOos

  EchoCalcRepeat:
		SHOW_EVENT	'e'
		add	Echo_ErRepLo,1		; inc repeated pkts cntr
		adc	Echo_ErRepHi,0
  EchoCalcNonSeq:
		and	cs:GenFlags,not NO_ERR_YET ; note err detected
  EchoCalcDelay2:
		mov	bp,es:[di].uUdpData	; get time stamp
		mov	cx,es:[di].uUdpData+2
		jmp	EchoCalcDelay
  
  EchoCalcOos:
		SHOW_EVENT	'd'
		add	Echo_ErSeqLo,1		; inc out of sequence cntr
		adc	Echo_ErSeqHi,0

		mov	ax,Echo_ErTmp	;*test Hi
		dec	ax
		js	EchoLostMain		; use tmp or main counter?

		mov	Echo_ErTmp,ax
  EchoCalcIgnSeq:
		test	cs:ArgFlags,SEQ_ERR_IGNORE
		jnz	EchoCalcDelay2
		jmp	short EchoCalcNonSeq

  EchoLostMain:
		mov	ax,Echo_ErLosLo
		or	ax,Echo_ErLosHi		; too much out of seq repeats
		jz	EchoCalcRepeat		;   have occured?

		sub	Echo_ErLosLo,1		; after all: wasn't lost
		sbb	Echo_ErLosHi,0
		jmp	short EchoCalcIgnSeq

  EchoCalcDrop:
		SHOW_EVENT	'f'
		push	dx
		push	si

		mov	dx,Echo_ErTmp
		or	dx,dx			; old or new occurance?
		jnz	EchoDropMore	;*test Hi
		push	cs:SavedTicks
		pop	Echo.ErTmpTime		; -new, initialize timer
  EchoDropMore:
		add	Echo_ErTmp,cx		; add to temporary drops
		adc	Echo_ErTmpHi,bp
		xchg	ax,cx
		push	ax
		or	bp,bp			; dropped more than 2**16?
		jz	EchoDropL
		xor	ax,ax			; -yes, clear all of RepVec
  EchoDropL:
		mov	si,cx
		and	si,8-1
		mov	dl,cs:EchoRepBit[si]
		mov	si,cx
		shr	si,1
		shr	si,1
		shr	si,1
		and	si,cs:EchoRepLen1
		not	dl
		and	byte ptr EchoRepVec[si],dl ; mark as not received
		inc	cx
		dec	ax
		jnz	EchoDropL		; repeat for all "lost" pkts

		pop	ax
		or	bp,bp
		jnz	EchoCalcLostMany
		cmp	ax,cs:EchoBlockLim	; enough consecutive pkts lost?
		jb	EchoCalcDropE
  EchoCalcLostMany:
		add	Echo.OffSumLo,ax	; avg blocking length
		adc	Echo.OffSumHi,bp
		inc	Echo.OffNum

		mov	ax,es:[di].uUdpData	; compute blocking time
		mov	dx,es:[di].uUdpData+2
		cmp	Echo.TxTime,dx
		mov	si,Echo.TxTimeHiHi
		sbb	si,0

		push	si
		push	dx
		push	ax
		sub	ax,Echo.RxTxTimeLo
		sbb	dx,Echo.RxTxTime
		sbb	si,Echo.RxTxTimeHiHi
		pop	Echo.RxTxTimeLo
		pop	Echo.RxTxTime
		pop	Echo.RxTxTimeHiHi
		sub	ax,cs:EchoIvalLo
		sbb	dx,cs:EchoIvalHi
		sbb	si,0
		js	EchoCalcDropE

		add	Echo.OffAvgLo,ax	; sum to avg computation
		adc	Echo.OffAvgHi,dx
		adc	Echo.OffAvgHiHi,si

		cmp	si,Echo.OffMaxHiHi	; assign max blocking time
		jb	EchoCalcDropE
		ja	EchoCalcOffM
		cmp	dx,Echo.OffMaxHi
		jb	EchoCalcDropE
		ja	EchoCalcOffM
		cmp	ax,Echo.OffMaxLo
		jbe	EchoCalcDropE
  EchoCalcOffM:
		mov	Echo.OffMaxLo,ax
		mov	Echo.OffMaxHi,dx
		mov	Echo.OffMaxHiHi,si
  EchoCalcDropE:
		pop	si
		pop	dx
		pop	bp
		pop	cx
		and	cs:GenFlags,not NO_ERR_YET ; note err detected
		jmp	EchoCalcHigherSeq
EchoCalc	endp
endif


;========================================================================
;		endinclude
