/*+
    Name:	hlstart.c
    Date:	12-Jul-1988
    Author:	Kent J. Quirk
		(c) Copyright 1988 Ziff Communications Co.
    Abstract:	Displays the starting screen for the PC Tech Journal
		benchmarks.
    History:	09-Sep-88   kjq     Version 1.00
-*/    

#include <stdio.h>
#include <stdlib.h>
#include <graph.h>
#include <conio.h>

#include "hl.h"

typedef unsigned char BYTE;
typedef unsigned int WORD;

typedef struct {
    BYTE pcx_id;
    BYTE version;
    BYTE encoding;
    BYTE bpp;
    WORD upleftx, uplefty;
    WORD lorightx, lorighty;
    WORD display_xres, display_yres;
    BYTE palette[48];
    BYTE reserved;
    BYTE nplanes;
    WORD bytesperline;
    BYTE reserved2[60];
} PCX_HDR;

PCX_HDR header;
struct videoconfig config;
struct videoconfig far *configp = &config;

#define COMPRESSED 0xC0
#define MASK 0x3F

int line, bc;

/**** d r a w d a t a ****
    Abstract:	Given a byte and a length, this draws that number of
		pixels onto the screen.
****************************/
void drawdata(BYTE c, int len)
{
    int ls, start, end;

    _setcolor(0xFF);
    ls = ((int)c << 8) + c;
    _setlinestyle(ls);
    start = bc * 8;
    end = start + len * 8;
    if (end <= header.bytesperline * 8)
    {
	_moveto(start+1, line);
	_lineto(end, line);
	bc += len;
    }
    else
    {
	_moveto(start+1, line);
	_lineto(header.bytesperline * 8, line);
	_moveto(1, ++line);
	bc = (end - (header.bytesperline * 8)) / 8;
	_lineto(bc * 8, line);
	++bc;
    }
    if (bc >= header.bytesperline)
    {
	bc = 0;
	++line;
    }
}

/**** d i s p l a y _ p i c t u r e ****
    Abstract:	Reads a PCX file and displays its data
****************************/
void display_picture(FILE *f, long datalen)
{
    int len;
    char c;
    char *data, *endptr;

    data = malloc((int)datalen);
    endptr = data + datalen;
    fread(data, 1, (int)datalen, f);
    _clearscreen(_GCLEARSCREEN);
    
    line = 1;
    bc = 0;
    while (data < endptr)
    {
	c = *data++;
	if ((c & COMPRESSED) == COMPRESSED)
	{
	    len = c & MASK;
	    c = *data++;
	    drawdata((char)c, len);
	}
	else
	{
	    drawdata((char)c, 1);
	}
    }
}

main(int argc, char *argv[])
{
    FILE *f;
    int i;
    char fname[64];
    long flen;

    if (argc > 1)
    {
	i = atoi(argv[1]);
	if (_setvideomode(i) == 0)
	    return(1);
	_getvideoconfig(&config);
    }
    else
    {	
	if (!init_video(configp))
	    return(1);
	if (config.numxpixels == 320)	    /* if low res CGA mode */
	{
	    if (_setvideomode(_HRESBW) == 0)
		return(1);
	    _getvideoconfig(&config);
	}
    }

    sprintf(fname, "TJ640%d.PCX", config.numypixels);

    if ((f = fopen(fname, "rb")) == NULL)
    {	 
	_setvideomode(_DEFAULTMODE);
	return(1);			    /* can't find file */
    }
    fseek(f, 0L, SEEK_END);		    /* measure length of file */
    flen = ftell(f);
    fseek(f, 0L, SEEK_SET);		    /* and go back to top */
    fread(&header, sizeof(header), 1, f);
	
	/* if made with color image, or wrong kind of file, abort */
    if ((header.pcx_id != 0x0A) || (header.nplanes != 1))
    {	 
	fclose(f);
	_setvideomode(_DEFAULTMODE);
	return(1);
    }
	
    display_picture(f, flen - sizeof(header));
    fclose(f);
    while (!kbhit())
	;
    
    _setvideomode(_DEFAULTMODE);
    if (getch() == 27)
	return(2);
    else
	return(0);
}
