; ATKEY -- PC Tech Journal AT Keyboard Compatibility Test
;
; Version 1.00
; Last modified 05/23/86
; Copyright (c) 1986, PC Tech Journal
; Program by: Paul Pierce, Ted Forgeron, Steven Armbrust
;
; Checks for AT keyboard compatibility by trying to speed
; the keyboard typematic rate to 30 reps per second and a
; keyboard delay of 1/4 second.
;
; See AT Technical Reference Manual pages 4-5 thru 4-8 for
; more information on programming the AT keyboard.

code    segment public

assume cs:code,ds:code

        org     100h                    ;set up as a COM file
start:  jmp     begin

msg     db 0dh,0ah
        db 'ATKEY -- PC Tech Journal AT Keyboard Compatibility '
        db 'Test',0dh,0ah
        db 'Version 1.00, Copyright (c) 1986 PC Tech Journal',
        db 0dh,0ah,0ah,'$'
badmsg  db 'Keyboard is incompatible with IBM PC/AT keyboard',
        db 0dh,0ah,'$'
goodmsg db 'Keyboard is compatible with IBM PC/AT keyboard',
        db 0dh,0ah,0dh,0ah
        db 'Keyboard will now repeat at 30 characters per second',
        db 0dh,0ah,'with 1/4 second delay.',0dh,0ah,'$'

begin:  mov     ax,cs                   ;set up ds
        mov     ds,ax                   ;to same seg as cs
        mov     dx,offset msg           ;print msg on screen
        mov     ah,09h                  ;dos print string funct
        int     21h                     ;call dos
        mov     al,0f3h                 ;typematic rate cmd
        mov     dx,60h                  ;8042 scan/diag port
        mov     cx,2000                 ;ack retry count
        out     dx,al                   ;send command to 8042
ack:    in      al,60h                  ;in from 8042
        dec     cx                      ;decrement retry count
        jnz     cont                    ;try again
        mov     dx,offset badmsg        ;print msg on screen
        mov     ah,09h                  ;dos print string funct
        int     21h                     ;call dos
        jmp     done                    ;give up and terminate
cont:   cmp     al,0fah                 ;is it an ack?
        jne     ack                     ;no, try again
        mov     al,0                    ;set rate to code for 30
        out     dx,al                   ;output command to 8042
        mov     dx,offset goodmsg       ;print msg on screen
        mov     ah,09h                  ;dos print string funct
        int     21h                     ;call dos
done:   mov     ah,4ch                  ;dos terminate process
        int     21h                     ;call dos
code    ends                            ;end of code segement
        end     start                   ;start is the entry point
