/*

	pcwin.hpp
	7-30-91
	Text windowing class

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef PCWIN_HPP
#define PCWIN_HPP

#ifndef PCCURSOR_HPP
#include <pccursor.hpp>
#endif
#ifndef PCVIDEO_HPP
#include <pcvideo.hpp>
#endif
#ifndef PCFRAME_HPP
#include <pcframe.hpp>
#endif

class TextScreenState  {
	CursorShape cursor;
	int oattr, owscroll, odirectvideo;
	int ol, ot, or, ob, ox, oy;
public:
	void save();
	void restore();
};

class TextWindow  {
	TextScreenState prevTxtScrState;
	static int dbuf[];
	PalettE P;
	int l, t, r, b;
	char *buf;
	int castShadow, openned;
	enum BSTYLE bs;
	int statusLine;
	void dressing(const unsigned char *msg, int d);
public:
	static Palette defaultP;
	CursorShape cursor;
	enum TW_PALETTE { COLOR, FRAME, TITLE, FOOTER,
		STATUS, NORMAL, HILITE, AUX };
	void setPalette(PalettE P = PalettE0)
		{ this->P = (P? P : defaultP); }
	int mapattr(enum TW_PALETTE attr_id)
		{ return ::mapattr(attr_id,P); }
	void mapvideo(enum TW_PALETTE attr_id)
		{ ::mapvideo(attr_id,P); }
	TextWindow(PalettE P = PalettE0) { buf = (char *)0;
		openned = 0; setPalette(P); }
	int window(int left, int top, int right,
		int bottom, enum BSTYLE bs = DOUBLE_FRAME,
		int statusLine = 0, int saveShadow = 1,
		int castShadow = 1);
	void putTitle(const char *msg)
		{ dressing((const unsigned char *)msg,1); }
	void putFooter(const char *msg)
		{ dressing((const unsigned char *)msg,2); }
	void putStatus(const char *msg)
		{ dressing((const unsigned char *)msg,3); }
	void close();
	~TextWindow() { close(); }
};

#define MAX_TW_DBUF  132

#endif
