/*

	pcled.hpp
	7-30-91
	Line Edit for the IBM PC Text Modes.

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef PCLED_HPP
#define PCLED_HPP

#ifndef PCWIN_HPP
#include <pcwin.hpp>
#endif


typedef int (*TFvaliD)(char * response, int maxlen);
#define TFvaliD0 ((TFvaliD)0)

class LineEdit {
	PalettE P;
public:
	static Palette defaultP;
	enum LE_PALETTE { COLOR, PROMPT, RESPONSE,
		PREFERENCE };
	void setPalette(PalettE P = PalettE0)
		{ this->P = (P? P : defaultP); }
	LineEdit(PalettE P = PalettE0)
		{ setPalette(P); }
	int edit(char *response, int sizeofResponse,
		int flen, int x = 0, int y = 0,
		const char *pref = (char *)0,
		const char *prompt = (char *)0,
		TFvaliD validate = TFvaliD0);
};

class LineEditWindow : TextWindow, LineEdit  {
public:
	LineEditWindow() : TextWindow(), LineEdit() {}
	void setPalette(PalettE TWP = PalettE0,
		PalettE LEP = PalettE0)
	{
		TextWindow::setPalette(TWP);
		LineEdit::setPalette(LEP);
	}
	int edit(char *response, int sizeofResponse,
		int flen, int x = 0, int y = 0,
		const char *pref = (char *)0,
		const char *prompt = (char *)0,
		TFvaliD validate = TFvaliD0);
};


#endif

