/*

	pcdir.cpp
	7-30-91
	dir.h enhancements

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233

*/


#include <string.h>
#include <ctype.h>
#include <dir.h>
#include <pcdir.hpp>

int fnflags;

static char path[MAXPATH];
static char drive[MAXDRIVE];
static char dir[MAXDIR];
static char file[MAXFILE];
static char ext[MAXEXT];


char * fnexpand(const char *pathname)
{

	char *d1, *d2;
	int l;

	if (!pathname) return (char *)0;
	(void) fnsplit(pathname,drive,dir,file,ext);
	if (!strlen(drive))  {
		drive[0] = 'A' + getdisk();
		strcpy(&drive[1],":");
	}
	if (!strlen(dir))  {
		dir[0] = '\\';
		(void) getcurdir(toupper(drive[0])-'A'+1,&dir[1]);
		if (dir[1] != '\0')
			strcat(dir,"\\");
	}
	else  {
		if (dir[0] != '\\')  {
			l = strlen(dir);
			dir[0] = '\\';
			dir[1] = '\0';
			(void) getcurdir(toupper(drive[0])-'A'+1,&dir[1]);
			if (strlen(dir) > 1)
				strcat(dir,"\\");
			if (l + strlen(dir) >= MAXDIR)
				return (char *) 0;
			(void) fnsplit(pathname,0,&dir[strlen(dir)],0,0);
		}
		/*  "\\.\\" -> "\\"  */
		while ((d1 = strstr(dir,"\\.\\")) != (char *)0)
			strcpy(d1,d1+2);
		/*  "\\X\\..\\" -> "\\"  */
		while ((d2 = strstr(dir,"\\..\\")) != (char *)0)  {
			for (d1 = d2 - 1; d1 >= dir && *d1 != '\\'; d1--);
			if (d1 < dir) return (char *) 0;
			strcpy(d1,d2+3);
		}
		/*  "\\X\\.." -> "\\"  */
		if ((d2 = strstr(dir,"\\..")) != (char *)0)  {
			for (d1 = d2 - 1; d1 >= dir && *d1 != '\\'; d1--);
			if (d1 < dir) return (char *) 0;
			strcpy(d1+1,d2+3);
		}
		/*  "\\." -> "\\"  */
		if ((d1 = strstr(dir,"\\.")) != (char *)0)
			strcpy(d1+1,d1+2);
	}
	fnmerge(path,drive,dir,file,ext);
	for (l = strlen(path); l > 3 && path[l-1] == '\\'; l--)
		path[l-1] = '\0';
	fnflags = fnsplit(path,0,0,0,0);
	return path;
}

char *fndefault (const char *pathname,
	char *driveDefault, char *dirDefault,
	char *fileDefault, char *extDefault)
{
	(void) fnsplit(pathname,drive,dir,file,ext);
	fnmerge(path,
		strlen(drive)? drive : driveDefault,
		strlen(dir)? dir : dirDefault,
		strlen(file)? file : fileDefault,
		strlen(ext)? ext : extDefault);
	fnflags = fnsplit(path,0,0,0,0);
	return path;
}

