GUIDE1.BAL
User Guide for Talking Balance 1 Program, version TLKBAL1E. 
Last Update:  June 18, 1997 by MMG
Reference File:  USRGD1EG.WP

Copyright 1996-1997, East Carolina University, Greenville, NC

Table of Contents

I.   Introduction

II.  Minimum Requirements and Installation on a Hard Disk Drive
     A.   Minimum Requirements
          1.   Computer and Operating System 
          2.   Memory
          3.   Monitor
          4.   Disk Drives
     B.   Installation on a Hard Disk Drive

III. Output -- Speech and Enlarged Text
     A.   General comments
     B.   Using a Sound Blaster sound card
          Important Notes About SBTALKER
     C.   Using other speech synthesizers 
          1.   Assigning a port to the speech synthesizer
          2.   Setting up a serial COM port for the speech
               synthesizer
          3.   Setting up the synthesizer
               a.   General comments
               b.   Using the command line to set up the
                    synthesizer
          4.   Screen reader programs should be unloaded
          5.   Loss of communication with the speech synthesizer
               during a run
     D.   Using the program without a speech synthesizer
     E.   Using screen magnification software with the program

IV.  OHAUS CT and TP Series Balances, and Serial Communication 
     A.   Serial port and cable requirements
     B.   Balance serial port settings
     C.   Assigning a computer serial port to the balance
          Important Notes about Port Assignment to the Balance

V.   Starting and Running the Program
     A.   Starting the Talking Balance program
          1.   Without a batch file
          2.   With a batch file
     B.   Initial checks
          Step 1.   Checking for the file BALPORT.DAT
          Step 2.   Checking for a Sound Blaster sound card
          Step 3.   Checking for the file TALKPORT.DAT
          Step 4.   Checking for port conflict
          Step 5.   Checking the speech device status
          Step 6.   Checking the balance status
     C.   Main menu
     D.   Using the keyboard
          1.   General comments
          2.   With speech output
          3.   Without speech output
          4.   What about typing mistakes
     E.   Taking balance readings
     F.   Saving balance readings to a file
          1.   Entering a file name
          2.   Checking the file
          3.   Entering your own name
          4.   Obtaining balance readings
          5.   Entering a sample label
          6.   Reviewing the saved file

VI.  Operating notes
     A.   Balance errors
     B.   Accidental disconnection of balance, power-off, etc.
     C.   The data file:  data insurance

VII. Contributing Programmers

VIII. License and Legal Information

End of Table of Contents


I.   Introduction

The Talking Balance 1 Program, TLKBAL1E, was written to enable
students, scientists, and engineers with visual disabilities to
read laboratory balances independently using synthetic speech and
large text, and to record their balance readings in an electronic
notebook.  The program runs under MS-DOS on an ordinary IBM-
compatible PC, and reads balances through a serial port.  It is
capable of using the Creative Labs Sound Blaster sound card to
generate synthetic speech, because the Sound Blaster is the most
economical way to equip a computer with speech output.  However,
the program also can be used with several commercial speech
synthesizers. 

The program was designed to work with the popular OHAUS CT series
and TP series of electronic balances.  It has been tested
thoroughly with the OHAUS CT200 centigram balance and the OHAUS
TP200 milligram balance, and it will probably read other OHAUS
models as well. 

This software was developed in the Department of Chemistry and
the Science Institute for the Disabled at East Carolina
University under Grant Nos. 9254330, 9153492, and 9053907 from
the National Science Foundation's Directorate for Education and
Human Resources. 


II.  Minimum Requirements and Installation on a Hard Disk Drive

A.   Minimum Requirements

1.   Computer and Operating System 

The program is designed to work on an IBM-compatible computer 
under MS-DOS version 6.22 or higher.  If you have Windows on your
machine, we recommend that you exit Windows before running the
Talking Balance program. (No Macintosh version is available.)

2.   Memory

We have not determined the exact memory requirements, but tests
show the program will run on a computer with 2Mb RAM.   For users
with more than 1Mb RAM, memory may be optimized by running the
MS-DOS memory manager, MEMMAKER.  This will load the Sound
Blaster text-to-speech driver, SBTALKER, into upper memory.  (See
section  III.B., "Using a Sound Blaster sound card.")

3.   Monitor

The enlarged text graphics employed by TLKBAL1E require a VGA
monitor or other monitor capable of being run in VGA mode.  On
EGA monitors the program will run, but the letters will be too
small.  No drivers are provided for other types of monitors.  So
for example, if you have a CGA monitor the program will halt and
display an error message. 

4.   Disk Drives

The program will run best on a hard drive, but it can be run from
a floppy drive.  It is significantly slower when run from a
floppy drive.

B.   Installation on a hard disk drive

The self-extracting version of this program is named
TALKBAL1.EXE.  Do the following if you have the self-extracting
version:
1.   In the root directory of your hard drive, make a
     subdirectory named TALKBAL1.
2.   Copy the TALKBAL1.EXE file into the TALKBAL1 subdirectory. 
     This is a self-extracting file.
3.   In MS-DOS, change to the TALKBAL1 subdirectory.
4.   Type TALKBAL1 and the self-extracting file will install the
     following files into the TALKBAL1 subdirectory:

          TLKBAL1E.EXE   --   The Talking Balance 1 Program
          README.BAL     --   Quick start instruction file
          GUIDE1.BAL     --   User Guide for the Talking       
                              Balance 1 Program
          J.BAT          --   An example batch file to run the
                              Talking Balance 1 Program
          LICENSE.TXT    --   GNU General Public License
          NOWARR.GNU     --   Disclaimer from GNU General Public
                              License
     Also, the following seven files containing the source code:

          BALTALK0.PAS
          DOSFUNKS.PAS
          FILUTIL4.PAS
          SBTLKGR3.PAS
          SERIAL2A.PAS
          TLKBAL1E.PAS
          TXTUTIL4.PAS

     And the following two Borland Pascal graphics units:
     
          BGIDRIV.TPU
          BGIFONT.TPU

The zipped version of the program has a .ZIP extension in the
file name. Do the following if you have the zipped version:
1.   In the root directory of your hard drive, make a
     subdirectory named TALKBAL1.
2.   Copy the zipped file into the TALKBAL1 subdirectory.
3.   Use PKUNZIP to extract the files listed above from the
     zipped file into the TALKBAL1 subdirectory.

The source code for the Talking Balance 1 Program was written in
Borland Pascal version 7.  The source code has ample internal
documentation to enable a skilled programmer to modify the
program.  Please be sure to see the GNU General Public License
for the terms under which a modified version of the Talking
Balance 1 Program can be distributed.


III. Output -- Speech and Enlarged Text

A.   General comments

The program will work with or without speech.  Speech output can
be obtained with either an internal Sound Blaster sound card, or
with an external speech synthesizer connected to any of your
computer's serial or parallel ports, or with an internal
synthesizer which emulates a serial or parallel port.  Until you
become very familiar with the Talking Balance program, we
recommend that you allow the synthesizer to complete each spoken
message before you type any response on the keyboard.  Messages
and data are displayed as enlarged white-on-black text on the
screen whether or not you are using a speech synthesizer.

B.   Using a Sound Blaster sound card

In order for this program to operate with a Sound Blaster, your
computer must have the Creative Labs DOS-based text-to-speech
driver SBTALKER, which is not included with this software.  The
SBTALKER driver can be loaded by executing the Creative Labs
batch file, SBTALK.BAT.  The location of SBTALK.BAT depends on
the model of Sound Blaster you have.  Look for SBTALK.BAT in
either the C:\SBTALKER subdirectory, the C:\SB\SBTALKER
subdirectory, or the C:\SBPRO\SBTALKER subdirectory.  

Important Notes about SBTALKER

1.   If you want to use the Sound Blaster for speech output, the
SBTALKER driver must be loaded before attempting to run the
Talking Balance program.  

2.   SBTALKER should be the last driver loaded.  We have found
that other terminate-and-stay-resident programs (known as TSRs)
tend to cause SBTALKER to work improperly.  (An example of a TSR
program is Borland Sidekick, a pop-up desk organizer program.) 
We therefore recommend that you unload all TSRs before loading
SBTALKER.

3.   SBTALKER is no longer packaged with Sound Blaster cards, but
if you have a card that came with "Dr. Sbaitso" (a sort of
talking digital shrink) you will have the SBTALKER program.

4.   Some computers will not run our software using the SBTALKER
driver if the file SMARTDRV.EXE is executed in the AUTOEXEC.BAT
file.  If you're using a Sound Blaster and you experience
problems with the Talking Balance program try removing
SMARTDRV.EXE (don't forget to put it back if you operate
Windows). 

C.   Using other speech synthesizers 

1.   Assigning a port to the speech synthesizer

The Talking Balance program can drive an external synthesizer
connected to any of serial ports COM1 through COM4 or parallel
ports LPT1 through LPT3, or an internal synthesizer which
emulates one of those ports.  If the program does not detect both
a Sound Blaster sound card and SBTALKER, it will look in the
balance subdirectory for a MS-DOS text file named TALKPORT.DAT. 
If you want to use a speech device other than the Sound Blaster,
then you must assign a port to your speech device in the
TALKPORT.DAT file.  TALKPORT.DAT is not included with our
software; you can create and edit this file with the MS-DOS text
editor before running the Talking Balance program.  Just enter
one line of text in the file specifying the port to which your
speech synthesizer is connected (or which your internal
synthesizer emulates).  The line must end with a carriage return
(the "ENTER" key).  For example, if you are using an internal
synthesizer which emulates serial port COM3, TALKPORT.DAT should
contain the single line

          COM3

followed by a carriage return (the "ENTER" key).  As another
example, if you are using a SmarTalk which is plugged into
printer port LPT2, TALKPORT.DAT should contain the single line

          LPT2

followed by a carriage return. 

2.   Setting up a serial COM port for the speech synthesizer
 
Your speech synthesizer and your computer must be able to
communicate with each other before you run this program. If you
are using an external synthesizer connected to a serial port, you
will need to set up the communications parameters for the port to
match the synthesizer.  This can be done using the MS-DOS "MODE"
command.

For example, the default parameters of the Accent SA are 9600
baud, NO parity, 8 data bits, 1 stop bit. If you have the
synthesizer plugged into serial port COM3, the correct MODE
command would be

          MODE COM3: 96,n,8,1,p  

followed, as usual, by the "ENTER" key.  

The letter "p" in this command is essential: it tells MS-DOS to
keep trying if the external device is busy. Without the "p", the
balance program will lock up the first time the program sends the
synthesizer more text than it can speak immediately.  

A line which sets up the port can be included in the same batch
file which runs the balance program, like this:

          @ECHO OFF
          CD \TALKBAL1
          MODE COM3: 96,n,8,1,p  
          TLKBAL1E
          CD\

(See section V. "Starting and Running the Program," below, for
more information about starting the Talking Balance program with
a batch file.)

It is important that the serial port be set up again every time
the computer is turned on. The computer forgets its port settings
when it's turned off, and it has to be reminded.

Note:  You do not need to use the MS-DOS "MODE" command to set
the communication parameters for the COM port used by the
balance.  The program sets them itself, because it knows what the
balance's factory default settings are.  See section IV., "OHAUS
CT and TP Series Balances, and Serial Communication" for
information about the COM port settings for the balance. 

3.   Setting up the synthesizer

a.   General comments

You should set up your synthesizer so that it speaks immediately
when it receives a carriage return character (ASCII 13).  Many
synthesizers do this without any special commands, but the Accent
synthesizers wait for a period character before speaking.  Some
other synthesizers, including the Sound Blaster with SBTALKER,
insert a pause when they see a period.  This inconsistency can
cause problems when you're trying to get an immediate echo of a
keyboard character.  Our program echoes characters from the
keyboard to the synthesizer with each character followed by a
carriage return, and without a period.
 
b.   Using the command line to set up the synthesizer

Most speech synthesizers can be sent a control character or
escape sequence which will cause an immediate halt to speech
output.  Synthesizers with this feature can be set up from the
command line when you start the Talking Balance program.

If you have an Accent speech synthesizer, from the MS-DOS prompt
in the balance subdirectory, enter

          TLKBAL1E ACCENT

and when the Talking Balance program begins, it will
automatically set up the Accent speech synthesizer so that when a
key is pressed, it will halt speech output immediately and echo
the pressed key.  When the program ends, the Accent speech
synthesizer will be reset to factory default values.

If you have a synthesizer which stops talking in response to a
control character (CTRL), enter the character on the command
line: "X" for CTRL-X, "S" for CTRL-S, etc.  As an example, most
synthesizers use CTRL-X.  If your synthesizer is one of these,
the command line you enter to start the program would look like
this:

          TLKBAL1E X

You may also enter this as TLKBAL1E CRTL-X with the letters C R T
L spelled out.  (Do not use the control key to enter this:  MS-
DOS  cannot read control characters from the keyboard.)

If your synthesizer uses an escape sequence to halt speech, such
as ESC=X, enter the string "ESC=X" on the command line.  Note: 
the letters E S C must be spelled out; do not use the escape key
itself ("ESC").  In this case, the command line you enter would
look like this:

          TLKBAL1E ESC=X

You may also enter this as follows, with square brackets around
the letters E S C:

          TLKBAL1E [ESC]=X

Of course, before entering the command line you must:  1) assign
a port to the speech synthesizer as instructed in section
III.C.1., above; and 2) if your synthesizer is connected to a
serial COM port, set up the port using the MS-DOS "MODE" command,
as instructed in section III.C.2., above.

The command line is not case-sensitive -- it may be entered as
all capital letters or all lower-case letters, except for escape
sequences:  they are case-sensitive.  The program sends the
synthesizer the exact characters that you enter after the letters
ESC.

The command line can be included in the same batch file which
sets up the serial port for the synthesizer and runs the balance
program.  For example, if you're using an Accent speech
synthesizer connected to serial port COM3, a batch file to run
the Talking Balance program would look like this:

          @ECHO OFF
          CD C:\TALKBAL1
          MODE COM3: 96,n,8,1,p  
          TLKBAL1E ACCENT
          CD\

(See section V. "Starting and Running the Program," below, for
more information about starting the Talking Balance program with
a batch file.)

4.   Screen reader programs should be unloaded

We suggest that you unload any screen reader program (ASAP, JAWS,
etc.) from the computer before running the Talking Balance
program.  This program writes text output directly to the
synthesizer, and does not need a screen reader.  It is also
possible that a screen reader will interfere with it, and
possibly cause the program to fail. 

5.   Loss of communication with the speech synthesizer during a 
     run

Do not turn off or unplug an external speech synthesizer in the
middle of the Talking Balance program.  Your MS-DOS operating
system is guaranteed to "hang" if this happens.  If your speech
device does become disconnected somehow and your system hangs,
turn the speech synthesizer back on, reconnect it, and reboot
your computer. This is the only known malfunction which causes
the program to hang during a run.

D.   Using the program without a speech synthesizer 

If no Sound Blaster speech driver is detected and no file named
TALKPORT.DAT is found in the balance subdirectory, the program
just runs without speech (the "speechless" mode).  Messages and
data will be displayed in enlarged white-on-black text on the
screen.  The only thing lacking in the speechless mode is that
the contents of the data file are not read back to the user after
a run.     

E.   Using screen magnification software with the program

We have operated the Talking Balance program with the screen
magnification software, MAGic Deluxe, available from Microsystems
Software, Inc. (MSI).  MSI also sells a cheaper version, called
MAGic.  MAGic Deluxe offers higher magnification levels of text
screens than MAGic.  For graphics screens, however, both versions
offer the same level of magnification, 2x.  The Talking Balance
program uses a graphics screen, not a text screen, to display the
enlarged text.  Therefore, the cheaper version, MAGic, should
work just as well with the Talking Balance program as the more
expensive version, MAGic Deluxe.    

To use MAGic with the Talking Balance program and the Sound
Blaster, load MAGic first, then load SBTALKER, then start the
Talking Balance program.  This works best if you start with a
"freshly booted" computer.  

MAGic (and MAGic Deluxe) is a terminate-and-stay resident program
(TSR), and we've already warned you about using TSRs with the
Sound Blaster in section III.B., "Using a Sound Blaster sound
card," above.  When you've finished using the Talking Balance
program it is important that you unload the MAGic and SBTALKER
drivers in the proper order to prevent a system crash. The order
for unloading the drivers should be:  first in, last out.  If you
loaded MAGic first, then SBTALKER, you should unload SBTALKER
first, then MAGic.

We are aware of other screen magnification software packages, but
we have not tried the Talking Balance program with any of them.  


IV.  OHAUS CT and TP Series Balances, and Serial Communication 

A.   Serial port and cable requirements 

The Talking Balance 1 Program was designed to work with the
popular OHAUS CT series and TP series of electronic balances.  It
has been tested thoroughly with the OHAUS CT200 centigram balance
and the OHAUS TP200 milligram balance, and it will probably read
other OHAUS models as well.
 
The OHAUS balance you use must be equipped with an OHAUS
bidirectional RS-232 serial communication port.  (The OHAUS TP200
balance comes with the RS-232 serial port pre-installed while the
OHAUS CT200 balance does not.)  Additionally, the Talking Balance
program requires the special OHAUS serial interface cable, which
is usable with both the TP series and CT series balances.  A
standard RS-232 interface cable will not work.  Both the RS-232
interface kit for the CT series balances and the serial interface
cable may be ordered separately from OHAUS or from a laboratory
supply house.  Here are the part numbers (as of 1995):

 Description                          OHAUS Part Number
 CT series RS-232 Interface Kit       77172-00
 RS-232 Interface Cable               AS017-09      

At the time of this writing, the two ends of the OHAUS interface
cable look identical.  It does matter, however, which end is
connected to the balance and which end is connected to the
computer.  If the balance program doesn't work with the cable
plugged in one way, reverse the ends and try it again.  

B.   Balance serial port settings  

Before running the Talking Balance program, the OHAUS balance
must be set up as follows for serial communication:  2400 baud,
NO parity, 7 data bits, and 2 stop bits. (These are the 1995
OHAUS default settings.)  If the balance settings differ from
these, the program will not operate:  it will display an error
message and halt.  Additionally, both the Auto Print and the
Stable Data Only printing features should be disabled. (These are
also 1995 OHAUS factory default settings). OHAUS user manuals
provide instructions for checking and changing these settings on
the balance.  

C.   Assigning a computer serial port to the balance

The balance can be used only on serial ports COM1 or COM2.  The
program will automatically set COM1 as the default balance port. 
Simply connect your OHAUS balance to COM1, make sure it is
powered on at the front panel and then start the Talking Balance
program.

If you want to assign serial port COM1 or COM2 to the balance,
then you must use a MS-DOS text file named BALPORT.DAT. 
BALPORT.DAT is not included with our software; you can create and
edit this file with the MS-DOS text editor before running the
Talking Balance program.  Just enter one line of text in the file
specifying the serial port to which your balance is connected. 
The line must end with a carriage return (the "ENTER" key).  For
example, if your balance is connected to serial port COM2,
BALPORT.DAT should contain the single line

          COM2

followed by a carriage return (the "ENTER" key). 

Important Notes about Port Assignment to the Balance

1.   The port named in the BALPORT.DAT file overrides the program
default port setting.   

2.   If BALPORT.DAT exists, but contains the name of an invalid
port (something other than COM1 or COM2) an error message will be
issued and the program will halt and exit to MS-DOS.  The program
also halts if the same serial port is specified for both the
balance and an external speech synthesizer. (You can't plug two
devices into the same port!)  

3.   You do not need to use the MS-DOS "MODE" command to set the
communication parameters for the COM port used by the balance. 
The program sets them itself, because it knows what the balance's
factory default settings are.  For using the MS-DOS "MODE"
command to set up a serial port for an external speech
synthesizer, see section III.C.2., "Setting up a serial COM port
for the speech synthesizer."  


V.   STARTING AND RUNNING THE PROGRAM

A.   Starting the Talking Balance program

1.   Without a batch file

Change to the balance subdirectory, and at the MS-DOS prompt
enter

          TLKBAL1E

The program will begin immediately.  This is what we refer to in
other sections of this document as the "command line."  If you
are using a speech synthesizer other than the Sound Blaster, you
may be able to set up your speech synthesizer from the command
line so that it halts speech output immediately when a key is
pressed.  See section III.C.3. "Setting up the synthesizer,"
above.

2.   With a batch file 

Since the program can't start talking until it starts running, it
is helpful to run the program from a MS-DOS batch file with a
simple, short name located in the "root" directory.  A MS-DOS
batch file is a text file containing a sequence of MS-DOS
commands which are executed in order just as if they had been
entered from the keyboard.  A sample batch file "J.BAT" has been
provided and its contents are shown below.

          @ECHO OFF
          CD \TALKBAL1
          TLKBAL1E
          CD\

As usual, each line ends with a carriage return (the "ENTER"
key).  The first line prevents the commands in this batch file
from being displayed on the screen.  The second line changes to
the balance subdirectory on the active drive.  The third line
runs the balance program and is what we refer to in other
sections of this document as the "command line."  The fourth line
returns you to the root directory on the active drive when you
exit the Talking Balance 1 Program.  With this file in the root
directory, a blind user only has to type the single letter "J"
followed by the "ENTER" key to run the program.  (We chose "J"
because it is one of the "home" keys, and often has a raised mark
that can be felt by a blind user.)  If you are using a speech
synthesizer other than the Sound Blaster, you can edit the
command line in the "J.BAT" file to set up your speech
synthesizer so that it halts speech output immediately when a key
is pressed.  See section III.C.3. "Setting up the synthesizer,"
above.


B.   Initial checks

This section leads you step by step through the initial checks
the program makes to determine whether a speech device is being
used, and to determine the operational status of the speech
device and balance.  These initial steps are numbered 1 through
6.

Step 1.   Checking for the file BALPORT.DAT  

The program seeks a file named BALPORT.DAT in the balance
subdirectory.  If the BALPORT.DAT file is found, the port
specified in the file is used to control and read the balance, if
it is valid (COM1 or COM2).  If the BALPORT.DAT file is not
found, two short beeps are issued, a message appears on the
screen indicating that COM1 will be used for the balance, and the
program continues. 

Note: The balance can only be connected to ports COM1 and COM2. 

Step 2.   Checking for a Sound Blaster sound card  

The program looks for the presence of a Sound Blaster sound card
and the SBTALKER text-to-speech driver.  If both are found, the
program continues at Step 6, "Checking the balance status."  If a
Sound Blaster sound card or SBTALKER are not found, the program
will look for a different speech device and continues at Step 3,
"Checking for the file TALKPORT.DAT."

Step 3.   Checking for the file TALKPORT.DAT

Being unable to send speech to the Sound Blaster sound card, the
program looks for a different speech device by seeking a file
named TALKPORT.DAT in the balance subdirectory.  (See section
III.C., "Using other speech synthesizers," above.)  If the
TALKPORT.DAT file is found, the program continues at Step 4,
"Checking for port conflict."  If the TALKPORT.DAT file is not
found, the program continues operation without speech at Step 6,
"Checking the balance status."

Step 4.   Checking for port conflict

Having found the TALKPORT.DAT file, the program next checks to
ensure that the balance port and speech device port are
different.  If the balance port and speech device port are the
same (for example, COM2 is listed in both the BALPORT.DAT and
TALKPORT.DAT files), one tone is emitted which is slightly longer
and lower than the two beeps in Step 1, a message appears on the
screen and the program waits for any key to be pressed.  Upon key
press, the program halts and exits to MS-DOS.

Step 5.   Checking the speech device status

Having determined that the balance port and speech device port
are different, the program now checks the speech port to see if
the speech device is ready.  If the speech device is not ready,
an error message is sent to the screen and the program waits for
any key to be pressed.  Upon key press, the program halts and
exits to MS-DOS.

Step 6.   Checking the balance status

At this point, the program has determined whether or not any
speech device is being used, and if there is a speech device,
that it is on and ready.  The message, "Talking Balance 1, A
Program to Read OHAUS Balances" is now displayed and spoken. 
After issuing this message, the program checks the balance port
to determine whether the balance is on and ready.  If there is a
problem with the balance -- for instance, it is not turned on or
it is connected to the wrong computer port -- the program issues
five beeps and then an error message with information about the
suspected problem, and an instruction to press any key for more
information.  Upon key press, it issues another five beeps and an
additional message, then the program halts and exits to MS-DOS.

C.   Main menu

The main program menu is now displayed on the screen and sent out
to the speech device.  You will be instructed to PRESS "I" for
general information and instructions, "C" to continue, and "ESC"
to quit.  We invite you to explore each of these commands.

D.   Using the keyboard

1.   General comments

The Talking Balance program employs two different keystroke
strategies:  at some points in the program it is expecting only a
single key to be pressed, at other points in the program it is
expecting a string of characters which must be ended with a
carriage return (the "ENTER" key).  Do not press the "ENTER" key
after giving a single key response.

2.   With speech output

When a single key press is expected, the spoken message will
instruct you to "press" a key.  Press one key on the keyboard,
nothing else.  Menus employ this strategy.  When a keyboard entry
is expected to end with a carriage return (the "ENTER" key), the
spoken message will instruct you to "enter" the information.  If
you choose to save balance readings in a file you will be
instructed to "enter" the file name, your own name, and an
identifying sample label for each balance reading.  These
keyboard entries require more than one character and each
character string must end with a carriage return (the "ENTER"
key) in order for the program to accept and record it.

In the Talking Balance program, the Sound Blaster halts speech
output immediately in response to a key press and echoes the
typed key.  Consequently, if you type fast, the Sound Blaster
will try to keep up and will chop off a character being spoken
when the next character is typed.  Most other speech synthesizers
can be set up so that they too will halt speech output
immediately in response to a key press.  Please see section
III.C.3. "Setting up the synthesizer," above, for more
information.

3.   Without speech output

All menus display the instruction to "press" a key for your
selection.  Press one key on the keyboard, nothing else.  During
the course of the program, questions will be displayed.  If the
screen displays a choice of single key answers within
parentheses, with the choices separated by slashes, a single key
press is expected.  Press one key on the keyboard, nothing else. 
If you choose to save balance readings to a file, you will be
asked for a file name, your own name, and an identifying sample
label for each balance reading.  These keyboard entries require
more than one character and each character string must end with a
carriage return (the "ENTER" key) in order for the program to
accept and record it.

4.   What about typing mistakes 

When the program gives you a list of single keys to press, only
the listed keys will allow you to progress through the program. 
The pressed key is echoed by the speech device and, if it is a
printable character, it is displayed in the lower right-hand
corner of the screen.  If you press a key that is not on the
list, the computer emits a short beep, the current menu or
instruction remains on the screen, the error message, "Invalid
answer, try again." is sent to the speech device, and the current
menu or instruction is again sent out to be reiterated by the
speech device. 

You can correct typing mistakes in longer keyboard entries --
file names, your name, and sample labels -- by using the
"BACKSPACE" key before pressing the "ENTER" key.  Each press of
the "BACKSPACE" key will erase the last displayed letter.  For
those using speech output, the message "Wipe out ____" will be
spoken.  If the letter erased is an "E" then you will hear, "Wipe
out E."  You may erase all the way back to the beginning of the
entry.  If you hear three short beeps when you press the
"BACKSPACE" key you know the cursor is positioned at the
beginning of the line and there are no more letters to erase.

E.   Taking balance readings

Upon pressing "C" to continue from the main menu, you will be
asked whether balance readings should be saved to a file.  Press
"Y" if you want to save your readings, and see the next section,
V.F., "Saving balance readings to a file," for more information.
If you do not wish to save balance readings to a file, press "N"
and the next menu will be displayed and sent to the speech
device.  This menu gives you instructions for zeroing the
balance, taking a balance reading, exiting back to the main menu,
or obtaining help.

Notes: 

1.   To zero (or tare) the balance, you are instructed to press
the space bar twice.  The second press of the space bar must be
within one second of the first press in order for the program to
interpret the command as one to zero the balance.

2.   Pressing "H" for help at this point sends the displayed menu
back out to the speech device.  For those who are not using
speech output, pressing "H" has no effect.  The displayed menu
remains unchanged on the screen. 

F.   Saving balance readings to a file

1.   Entering a file name

If you are saving balance readings to a file (see section V.E.,
"Taking balance readings," above) you will be instructed to enter
a file name.  The file name you enter must be a valid MS-DOS file
name and it may include a valid MS-DOS drive, path, and
extension.  See your MS-DOS user manual for information about MS-
DOS conventions for naming files, using extensions, specifying a
drive and using paths.  If no drive or path is specified, the
program assumes that the file will be located in the balance
subdirectory.  If you specify a drive, the program will check to
ensure that the drive is valid, that it is ready, and whether it
is a read-only drive.  If you specify a path, the program will
check to ensure that the directory exists.  If you enter a file
name longer than eight characters (a MS-DOS convention), the file
name entered will be truncated to eight characters.  Likewise, if
you include an extension longer than three characters (another
MS-DOS convention), the extension will be truncated to three
characters.  Other errors which are illegal in a MS-DOS file name
are also corrected.
 
After the drive, path, file name, and extension have been checked
(and corrected, if necessary) the entry will be displayed and you
will have the option of accepting it as is or of re-entering a
new file name.

2.   Checking the file

The program checks whether the file specified already exists.  If
it does exist you are given the option of appending (adding on)
to the file or of entering a new file name.  Because good
laboratory practice forbids the complete obliteration of any data
recorded in a laboratory notebook, the Talking Balance program
will not over-write existing data files.  The program also checks
whether an existing file is read-only.  Furthermore, it will not
append data to a file unless that file is a text file:  this
avoids accidentally tacking your data onto the end of a binary
file.

3.   Entering your own name

You will be instructed to enter your name.  This information is
also saved to the file.  The name you enter may be up to 80
characters long.  If you have a long name, it will be displayed
as two or more lines on the screen because the letters are so
large. 
Don't worry if the program breaks your first name or last name
somewhere in the middle:  it knows that the name is one word. 
Don't press the "ENTER" key until you have entered your name as
you want it to appear in the data file. 

4.   Obtaining balance readings

After entering your name, the menu for taking a balance reading
will be displayed.  See section V.E., "Taking balance readings,"
above.

5.   Entering a sample label

If you are saving readings to a file, you will be instructed to
enter a sample label (a few words which identify the sample).   
This label is saved to the file.  The label may be up to 80
characters long.  If the label is long, it will be displayed as
two or more lines on the screen because the letters are so large. 
Again, don't worry if the program breaks a word in the middle. 
Press the "ENTER" key after you have typed in the complete label.

6.   Reviewing the saved file

If you are using a speech device, you will be asked whether you
wish to have the saved file read back to you before you exit the
program.  (The saved file is in MS-DOS text format and may be
viewed from MS-DOS or any other text editor.)  The option of
displaying the contents of the file as large text is not
available at this time. 


VI.  Operating notes

A.   Balance errors

There are several conditions which may cause errors in the
balance display and its serial output.  The program checks for
balance error conditions (for example, balance overload) and
informs the user when those conditions have been detected.  If
the balance reading is unstable, the program says "Balance
reading is unstable," and displays big question marks on the
screen, but does not halt.  For more serious errors (including
overload) the program displays an error message and halts.   

Please see the OHAUS user manual for your balance for more
information about balance error conditions.

B.   Accidental disconnection of balance, power-off, etc.

Before taking a reading, the program checks the balance to ensure
that it is still on and connected.  If an error occurs during
this check, the program will inform you that there is a problem
with the balance and that your data have been stored in the your
data file.  Then the program will halt and exit to MS-DOS. 

C.   The data file:  data insurance

If you are saving your readings in a file (a practice we highly
recommend) you will not lose any data if the balance is
accidentally disconnected or turned off, has a malfunction, or
becomes overloaded, because readings are stored as soon as they
are made.  If the program halts and exits to MS-DOS for any
reason, your readings up to that point will be preserved.  Even
if an external synthesizer is disconnected or turned off or
malfunctions during a run (which will cause the system to hang)
data taken up to that time will be safe.  Then after the problem
is fixed, you can append more data to the same file or open a new
file.


VII. Contributing Programmers

Rosa McMillan, Jason M. Johnson, Margaret M. Gemperline, Jonathon
Hoggard, and David Lunney


VIII. License and Legal Information

The Talking Balance 1 Program, TLKBAL1E, is Copyright 1992-1997,
East Carolina University, Greenville, NC 27858. All Rights
Reserved.

The Talking Balance 1 Program, TLKBAL1E, is free software; you
can redistribute it and/or modify it under the terms of the GNU
General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
with this program; if not, write to the Free Software Foundation,
Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

One of the authors, David Lunney, can be contacted through the
Department of Chemistry, East Carolina University, Greenville, NC
27858; or by e-mail at lunney@delphi.com.

No Warranty.  EAST CAROLINA UNIVERSITY DISCLAIMS AND MAKES NO
REPRESENTATIONS AND EXTENDS NO WARRANTIES, EITHER EXPRESS OR
IMPLIED. THERE ARE NO EXPRESS OR IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  The User
shall assume all liability for all damages whatsoever that may or
do arise from the User's use, inability to use, performance, or
storage of the TLKBAL1E software.  East Carolina University shall
not be liable to the User for any loss, claims, damages or
demands whatsoever made by the User or made against the User by
any other party, due to or arising from the performance of, use
of, and/or inability to use the TLKBAL1E software by the User
and/or anyone else.

Sound Blaster is a trademark of Creative Technology Ltd.  
MS-DOS is a registered trademark and Windows is a trademark of
Microsoft Corporation.
IBM is a registered trademark of International Business Machines,
Inc.
Macintosh is a registered trademark of Apple Computer, Inc.
SmarTalk is a trademark of Automated Functions, Inc.
Accent is a registered trademark of Aicom Corporation.
ASAP is a trademark of MicroTalk.
JAWS is a trademark of Henter-Joyce.
MAGic is a trademark of Microsystems Software, Inc.
OHAUS is a registered trademark of Ohaus Corporation.
All Borland products are trademarks or registered trademarks of
Borland International, Inc.
PKUNZIP is a registered trademark of PKWARE, Inc.
All other trademarks, registered trademarks, company names and
product names are the sole property of their respective owners.

The executable code for this program (TLKBAL1E.EXE) incorporates
a unit (SBC_TP7.TPU) from the Creative Labs Developer Kit,
copyright 1993 Creative Technology, Ltd.

The self-extracting version of this program is distributed under
a license from PKWARE, Inc.

Disclaimer of Endorsement:  Mention of any particular commercial
product or company does not constitute or imply an endorsement by
the authors or by East Carolina University or by any employee of
East Carolina University, nor does it imply that the product is
necessarily the best available for the purpose.

Any opinions, findings, and conclusions or recommendations
expressed in this material are those of the authors and do not
necessarily reflect the views of the National Science Foundation. 
