100     '
105     ' gc.bas
110     '
115     ' Great Circle.  This program is used to determine bearing
120     ' and range to a station given the latitude and longitude
125     ' of both stations.
130     '
135     ' Ver 1.02 Public Domain (p) November 1989 By S. R. Sampson, N5OWK
145     '
150     ' Ref: Air Force Manual 51-40, "Air Navigation", 1 February 1987
155     '
160     RADIAN = (180 / 3.14159)
165     GOTO 215
170     '
175     T = INT(V1) : V1 = V1 - T : V1 = V1 / .6 : V1 = (T + V1)
180     RETURN
185     '
190     ACOS = -ATN(TMP / SQR(1 - TMP * TMP)) + 1.570796
195     RETURN
200     '
205     ' Get the user data
210     '
215     PRINT "East Longitudes and South Latitudes are negative" : PRINT
220     PRINT
225     INPUT "Latitude of your QTH [+-]dd.mm : ", V1
230     GOSUB 175
235     IF V1 > 90 OR V1 < -90 THEN 225
240     L1 = V1
245     INPUT "Longitude of your QTH [+-]ddd.mm : ", V1
250     GOSUB 175
255     IF V1 > 180 OR V1 < -180 THEN 245
260     A1 = V1
265     PRINT
270     INPUT "Latitude of destination [+-]dd.mm : ", V1
275     GOSUB 175
280     IF V1 > 90 OR V1 < -90 THEN 270
285     L2 = V1
290     INPUT "Longitude of destination [+-]ddd.mm : ", V1
295     GOSUB 175
300     IF V1 > 180 OR V1 < -180 THEN 290
305     A2 = V1
310     '
315     ' Compute the Bearing and Range, From the Formula in Chapter 23
320     '
325     DELTA = A2 - A1
330     '
335     ' Convert variables to Radians
340     '
345     L1 = L1 / RADIAN
350     A1 = A1 / RADIAN
355     L2 = L2 / RADIAN
360     DELTA = DELTA / RADIAN
365     TMP = (SIN(L1) * SIN(L2)) + (COS(L1) * COS(L2) * COS(DELTA))
370     GOSUB 190
375     DIST = ACOS
380     RANGE = 60 * (DIST * RADIAN)
385     TMP = (SIN(L2) - (SIN(L1) * COS(DIST))) / (SIN(DIST) * COS(L1))
390     GOSUB 190
395     BEARING = ACOS * RADIAN
400     IF DELTA > 0 THEN BEARING = 360 - BEARING
405     '
410     ' Computations complete, show answer
415     '
420     PRINT
425     PRINT "Bearing is "; BEARING; " Degrees for "; RANGE; " Nautical Miles"
430     PRINT
435 END
