1 LATHDEG=35     'home latitude degrees
2 LATHMIN=12     'home latitude minutes
3 LATH$="N"      'home latitude direction
4 LONGHDEG=80    'home longitude degrees
5 LONGHMIN=45   'home longitude minutes
6 LONGH$="W"     'home longitude direction
7 STATION$="MATTHEWS   NC"
8 COUNT=1
10 CLS
11 PRINT"     ͻ"
12 PRINT"                        BEAM HEADING PROGRAM                        
13 PRINT"                                                                    
14 PRINT"                                by                                  
15 PRINT"                                                                    
16 PRINT"                      J. Scott Douglass  K2SD                       
17 PRINT"     ͹
18 PRINT"                                                                    
19 PRINT"          CURRENT HOME LATITUDE  =                                  
20 PRINT"          CURRENT HOME LONGITUDE =                                  
21 PRINT"                                                                    
22 PRINT"                      New York City, New York                       
23 PRINT"                                                                    
24 PRINT"                                                                    
25 PRINT"          Change Home Location                                      
26 PRINT"                                                                    
27 PRINT"          Output to Printer (P) or Display (D)                      
28 PRINT"                                                                    
29 PRINT"                                                                    
30 PRINT"                                                                    
31 PRINT"                                                                    
32 PRINT"     ͼ
100 PI=3.1415927#
110 REM BEAM HEADING PROGRAM
120 REM COPYRIGHT 1982 by J. Scott Douglass
130 REM                   Matthews, NC 28105
180 LOCATE 9,38:PRINT LATHDEG;" Degrees,";LATHMIN;"Minutes ";LATH$
190 LOCATE 10,38:PRINT LONGHDEG;" Degrees,";LONGHMIN;"Minutes ";LONGH$
195 LOCATE 12,24:X$=SPACE$(35):PRINT X$
200 LOCATE 12,24:PRINT STATION$
222 LOCATE 15,36:PRINT "":R$=INKEY$:IF R$="" THEN 222
224 IF LEFT$(R$,1)="Y" THEN GOTO 2500
225 IF LEFT$(R$,1)="y" THEN GOTO 2500
230 LOCATE 17,49:PRINT "":OUTDEV$=INKEY$:IF OUTDEV$="" THEN 230:COLOR 7
240 IF LEFT$(OUTDEV$,1)="D" THEN PSWITCH=0
250 IF LEFT$(OUTDEV$,1)="d" THEN PSWITCH=0
260 IF LEFT$(OUTDEV$,1)="P" THEN PSWITCH=1
270 IF LEFT$(OUTDEV$,1)="p" THEN PSWITCH=1
272 CLS:LOCATE 12,24:INPUT "PLEASE ENTER HOME CALL SIGN ";HOMECALL$
275 IF PSWITCH=1 THEN LPRINT CHR$(143)
276 IF PSWITCH=1 THEN GOSUB 10000
280 IF PSWITCH = 0 THEN GOTO 310
290 IF PSWITCH = 1 THEN GOTO 310
300 GOTO 10
310 CLS
320 RESTORE
330 READ PF$,CT$,LC$,LATTDEG,LATTMIN,LATT$,LONGTDEG,LONGTMIN,LONGT$
340 IF PF$="QQ" THEN GOTO 30000
350 A=(LATHDEG+(LATHMIN/60))*PI/180     ' CONVERT HOME LATITUDE TO RADIANS
360 B=(LATTDEG+(LATTMIN/60))*PI/180     ' TARGET LATITUDE IN RADIANS
370 HOMELONG=(LONGHDEG+(LONGHMIN/60))*PI/180  ' HOME LONGITUDE IN RADIANS
380 TARGLONG=(LONGTDEG+(LONGTMIN/60))*PI/180   ' TARGET LONGITUDE IN RADIANS
390 IF LATH$="S" THEN A=-A     ' SET UP SIGN CONVENTIONS
400 IF LATT$="S" THEN B=-B
410 IF LONGH$="E" THEN HOMELONG=-HOMELONG
420 IF LONGT$="E" THEN TARGLONG=-TARGLONG
430 L=HOMELONG-TARGLONG
440 IF L > PI THEN L=L-2*PI    ' MUST KEEP WITHIN + OR - 180 DEGREES
450 IF L < -PI THEN L=L+2*PI
460 COSL=COS(L)
470 COTB=1/TAN(B)           ' COTANGENT FUNCTION
480 TANPHI=COSL*COTB
490 PHI=ATN(TANPHI)
500 SINPHI=SIN(PHI)
510 COTL=1/TAN(L)
520 APLUS=A+PHI
530 COSAPLUS=COS(APLUS)
540 COTC=(COTL*COSAPLUS)/SINPHI
550 C=1.57096-ATN(COTC)
560 LSIGN=SGN(L)
570 CSIGN=SGN(C)
580 IF LSIGN=1 AND CSIGN=1 THEN C=C
590 IF LSIGN=1 AND CSIGN=-1 THEN C=C+PI
600 IF LSIGN=-1 AND CSIGN=1 THEN C=C+PI
610 IF LSIGN=-1 AND CSING=-1 THEN C=C+2*PI
620 C=CINT(C*180/PI)       ' convert radians to angle
630 CL=180+C:IF CL > 360 THEN CL=CL-360
640 REM now we will do the distance calculation
650 REM  cosD=sinAsinB+cosAcosBcosL
660 COSB=COS(B)
670 COSA=COS(A)
680 SINA=SIN(A)
690 SINB=SIN(B)
700 COSD=SINA*SINB+COSA*COSB*COSL
710 D=1.570796-ATN(COSD/SQR(1-COSD*COSD))  ' arc of great circle path
720 D=D*180/PI   'convert to degrees
730 DD=CINT(D)     ' take degrees only
740 NM=DD*60  ' each degree equals 60 nautical miles
750 DM=D-DD       ' take minutes only
760 DM=CINT(60*DM) ' convert decimal minutes to minute minutes
770 NM=NM+DM*1 ' each minute adds one additional nautical mile
780 SR=CINT(NM*1.1508)  'convert to statute miles
2000 IF PSWITCH=0 THEN GOTO 2020
2001 IF COUNT=56 THEN GOSUB 20000
2005 LPRINT PF$TAB(10)CT$TAB(30)LC$TAB(46);C;TAB(54);CL;TAB(62);SR
2006 COUNT=COUNT+1
2020 PRINT PF$TAB(10)CT$TAB(30)LC$TAB(46);C;TAB(54);CL;TAB(62);SR
2030 GOTO 330
2500 CLS:LOCATE 6
2505 INPUT "PLEASE ENTER NEW HOME LATITUDE (DEGREES,MINUTES,N/S)";LATHDEG,LATHMIN,LATH$
2506 IF LATHDEG > 90 THEN GOTO 2900
2507 IF LATHMIN > 59 THEN GOTO 2900
2510 PRINT:INPUT "PLEASE ENTER NEW HOME LONGITUDE (DEGREES,MINUTES,E/W)";LONGHDEG,LONGHMIN,LONGH$
2511 IF LONGHDEG >180 THEN GOTO 2900
2512 IF LONGHMIN > 59 THEN GOTO 2900
2515 PRINT:INPUT "PLEASE ENTER THE NAME OF THIS LOCATION ";STATION$
2520 COLOR 7:GOTO 10
2900 PRINT:PRINT:PRINT "INPUT ERROR - HIT ANY KEY TO TRY AGAIN ":INPUT;IN$
2901 GOTO 2500
3000 DATA A2,BOTSWANA,GABORONE,24,30,S,26,0,E
3005 DATA A35,TONGA,NUKUALOFA,21,0,S,175,0,W
3010 DATA A4X,OMAN,MUSCAT,23,40,N,58,30,E
3015 DATA A51,BHUTAN,THIMPHU,27,30,N,90,0,E
3020 DATA A6X,U. ARAB EMIRATES,,25,18,N,55,18,E
3025 DATA A7X,QATAR,DOHA,25,30,N,51,30,E
3030 DATA A9X,BAHRAIN,,26,10,N,50,40,E
3035 DATA AP,PAKISTAN,KARACHI,24,59,N,67,0,E
3040 DATA BV,TAIWAN,TAIPEI,25,02,N,121,38,E
3045 DATA BY,CHINA,PEKING,39,55,N,116,23,E
3050 DATA C2,REP. OF NAURU,,0,30,S,167,0,E
3055 DATA C3,ANDORRA,,42,38,N,1,30,E
3060 DATA C5,THE GAMBIA,BATHURST,13,20,N,15,55,W
3061 DATA C6,BAHAMAS,NASSAU,25,0,N,77,30,W
3062 DATA C9,MOZAMBIQUE,L. MARQUES,26,0,S,33,0,E
3063 DATA C9,MOZAMBIQUE,MOZAMBIQUE,15,0,S,41,0,E
3065 DATA CE,CHILE,SANTIAGO,33,28,S,70,55,W
3070 DATA CE0A,EASTER ISLAND,,28,0,S,109,0,W
3075 DATA CE0X,SAN FELIX,,26,20,S,80,10,W
3080 DATA CE0Z,JAUN FERNANDEZ,,34,0,S,78,0,W
3085 DATA CO,CUBA,HAVANA,23,08,N,82,23,W
3090 DATA CN,MOROCCO,CASABLANCA,33,0,N,8,0,W
3095 DATA CP,BOLIVIA,LA PAZ,16,31,S,68,03,W
3100 DATA CR3,GUINEA-BISSAU,,10,48,N,12,28,W
3105 DATA CR9,MACAO,,22,10,N,113,35,E
3110 DATA CT,PORTUGAL,LISBON,38,42,N,9,5,W
3115 DATA CT2,AZORES,,38,0,N,25,0,W
3120 DATA CT3,MADERIA,,32,41,N,16,15,W
3125 DATA CX,URUGUAY,MONTEVIDEO,34,50,S,56,10,W
3130 DATA D2,ANGOLA,LUANDA,8,48,S,13,14,E
3135 DATA D4,CAPE VERDE,,15,48,N,26,02,W
3140 DATA D6,COMOROS,,11,26,S,44,12,E
3145 DATA DA,GERMANY,BONN,51,0,N,6,0,E
3150 DATA DM,GERMANY,BERLIN,52,27,N,13,26,E
3155 DATA DU,PHILIPPINES,LUZON,17,10,N,119,45,E
3156 DATA DU,PHILIPPINES,MANILA,14,36,N,121,0,E
3160 DATA EA,SPAIN,MADRID,40,26,N,3,42,W
3165 DATA EA6,BALEARIC ISLANDS,,39,25,N,1,28,E
3170 DATA EA8,CANARY ISLANDS,,29,15,N,16,30,W
3175 DATA EA9,CEUTA,,36,04,N,5,36,W
3180 DATA EA9,MELILLA,,35,24,N,3,30,W
3185 DATA EI,REP IRELAND,DUBLIN,53,20,N,6,15,W
3190 DATA EL,LIBERIA,MONROVIA,6,18,N,10,47,W
3195 DATA EP,IRAN,TEHRAN,35,45,N,51,30,E
3200 DATA ET,ETHIOPIA,ADDIS ABABA,9,0,N,38,44,E
3201 DATA ET,ETHIOPIA,ASMARA,15,0,N,38,0,N
3205 DATA F,FRANCE,PARIS,48,51,N,2,20,E
3210 DATA FB8W,CROZET,,46,20,S,51,30,E
3215 DATA FB8X,KERGUELEN,,49,50,S,69,30,E
3220 DATA FB8Z,AMSTERDAM ISL,,37,0,S,75,0,E
3225 DATA FC,CORSICA,,42,10,N,8,55,E
3230 DATA FG,GUADELOUPE,,16,40,N,61,10,W
3235 DATA FS,ST. MARTIN,,18,6,N,62,54,W
3240 DATA FH,MAYOTTE,,13,7,S,45,32,E
3245 DATA FK,NEW CALEDONIA,,21,28,S,167,0,E
3250 DATA FM,MARTINIQUE,,14,50,N,60,40,W
3255 DATA FO,CLIPPERTON ISL.,,11,0,N,110,0,W
3260 DATA FO,FR. POLYNESIA,,17,30,S,149,30,W
3265 DATA FP,ST. PIERRE,,46,47,N,56,11,W
3270 DATA FR,GLORIOSO ISL.,,11,28,S,47,50,E
3275 DATA FR,JUAN DE NOVA,,21,50,S,40,0,E
3280 DATA FR,REUNION,,21,6,S,55,36,E
3285 DATA FR,TROMELIN,,15,30,S,54,30,E
3286 DATA FS,ST. MARTIN,,18,0,N,63,0,W
3290 DATA FW,WALLIS & FUTUNA,,13,0,S,176,10,E
3295 DATA FY,FR. GUIANA,CAYENNE,4,56,N,52,18,W
3300 DATA G,ENGLAND,LONDON,51,30,N,0,7,W
3305 DATA GD,ISLE OF MANN,,54,10,N,4,24,W
3310 DATA GI,N. IRELAND,BELFAST,54,36,N,5,45,W
3315 DATA GJ,JERSEY,,49,13,N,2,7,W
3320 DATA GM,SCOTLAND,GLASGOW,55,54,N,4,25,W
3325 DATA GU,GUERNSEY,,49,27,N,2,36,W
3330 DATA GW,WALES,CARDIFF,51,30,N,3,18,W
3335 DATA H4,SOLOMONS,,9,48,S,158,43,E
3340 DATA HA,HUNGARY,BUDAPEST,47,30,N,19,5,E
3345 DATA HB9,SWITZERLAND,GENEVA,46,14,N,6,4,E
3350 DATA HB0,LIECHTENSTEIN,,47,10,N,9,32,E
3355 DATA HC,ECUADOR,QUITO,0,17,S,78,32,W
3360 DATA HC8,GALAPAGOS ISLS.,,0,10,S,92,0,W
3365 DATA HH,HAITI,PORTA-PRINCE,18,35,N,72,20,W
3370 DATA HI,DOMINICAN REP.,,18,20,N,69,55,W
3375 DATA HK,COLOMBIA,BOGOTA,4,38,N,74,6,W
3380 DATA HK0,BAJO NUEVO,,15,50,N,78,50,W
3385 DATA HK0,MALPELO,,3,55,N,81,30,W
3390 DATA HK0,SAN ANDRES,,12,30,N,81,44,W
3391 DATA HK0,SERRANA BANK,,14,18,N,81,18,W
3395 DATA HM,KOREA,SEOUL,37,35,N,127,3,E
3400 DATA HP,PANAMA,PANAMA CITY,8,35,N,81,8,W
3405 DATA HR,HONDURAS,TEGULIGALPA,14,8,N,87,15,W
3410 DATA HS,THAILAND,BANKOK,13,50,N,100,29,E
3415 DATA HV,VATICAN CITY,,41,54,N,12,22,E
3416 DATA HZ,SAUDI ARABIA,MECCA,22,0,N,40,0,E
3417 DATA HZ,SAUDI ARABIA,DHARAN,26,18,N,50,0,E
3420 DATA I,ITALY,ROME,41,52,N,12,37,E
3421 DATA I,ITALY,TRIESTE,45,30,N,14,0,E
3425 DATA IS,SARDINIA,,40,8,N,9,5,E
3426 DATA IT,ITALY,SICILY,37,30,N,14,0,E
3430 DATA J2,DJIBOUTI,,12,0,N,43,0,E
3435 DATA J3,GRENADA,,12,2,N,61,15,W
3436 DATA J5,GUINEA-BISSAU,,12,0,N,15,0,W
3437 DATA J6,ST. LUCIA,,14,0,N,61,0,W
3438 DATA J7,DOMINICA,,15,24,N,61,18,W
3440 DATA JA,JAPAN,TOYKO,35,41,N,139,44,E
3445 DATA JD,MINAMI TORI-SHIMA,,24,0,N,155,0,E
3450 DATA JD,OGASAWARA,,26,30,N,141,0,E
3460 DATA JT,MONGOLIA,ULAN BATOR,47,56,N,107,0,E
3465 DATA JW,SVALBARD,,78,0,N,16,0,E
3470 DATA JX,JAN MAYEN,,70,59,N,8,5,W
3475 DATA JY,JORDON,AMMAN,31,57,N,35,57,E
3485 DATA KC4,ANTARCTICA,BYRD STATION,80,0,S,120,0,W
3490 DATA KC4,ANTARCTICA,McMURDO,77,30,S,167,0,E
3495 DATA KC4,ANTARCTICA,PALMER,65,0,S,64,0,W
3500 DATA KC6,E. CAROLINE ISL.,,8,0,N,158,0,E
3505 DATA KC6,W. CAROLINE ISL.,,9,30,N,138,12,E
3510 DATA KG4,GUATANAMO BAY,,20,0,N,75,0,W
3515 DATA KH1,BAKER-AM PHOENIX,,0,30,N,176,0,W
3520 DATA KH2,GUAM,,14,0,N,145,0,E
3525 DATA KH3,JOHNSTON ISLAND,,17,0,N,170,0,W
3530 DATA KH4,MIDWAY ISLAND,,28,0,N,177,30,W
3535 DATA KH5,PALMYRA ISLAND,,6,0,N,162,0,W
3540 DATA KH5K,KINGMAN REEF,,7,30,N,162,48,W
3545 DATA KH6,HAWAII,HILO,19,42,N,155,6,W
3550 DATA KH6,HAWAII,HONOLULU,21,18,N,157,54,W
3555 DATA KH7,KURE ISLAND,,28,30,N,178,30,W
3560 DATA KH8,AMERICAN SAMOA,,14,0,S,171,0,W
3565 DATA KH9,WAKE ISLAND,,19,0,N,167,0,E
3570 DATA KH0,MARIANA ISLAND,SAIPAN,16,0,N,146,0,E
3575 DATA KL7,ALASKA,ADAK,51,48,N,176,36,W
3580 DATA KL7,ALASKA,ANCHORAGE,61,12,N,150,0,W
3585 DATA KL7,ALASKA,FAIRBANKS,64,48,N,147,54,W
3590 DATA KL7,ALASKA,JUNEAU,58,18,N,134,24,W
3595 DATA KL7,ALASKA,NOME,64,30,N,165,24,W
3600 DATA KP1,NAVASSA ISLAND,,18,0,N,75,0,W
3605 DATA KP2,VIRGIN ISLANDS,,18,0,N,64,30,W
3610 DATA KP4,DESECHEO ISLAND,,18,18,N,67,30,W
3615 DATA KP4,PUERTO RICO,SAN JUAN,18,30,N,66,12,W
3620 DATA KX,MARSHALL ISLANDS,,12,0,N,167,0,E
3625 DATA LA-LJ,NORWAY,OSLO,60,0,N,10,42,E
3630 DATA LU,ARGENTINA,BUENOS AIRES,34,36,S,58,24,W
3635 DATA LX,LUXEMBOURG,,49,0,N,6,30,E
3640 DATA LZ,BULGARIA,SOFIA,42,42,N,23,18,E
3645 DATA OA,PERU,LIMA,12,0,S,77,0,W
3650 DATA OD,LEBANON,BEIRUT,33,54,N,35,30,E
3655 DATA OE,AUSTRIA,VIENNA,48,12,N,16,18,E
3660 DATA OH,FINLAND,HELSINKI,60,12,N,25,0,E
3665 DATA OH0,ALAND ISLAND,,60,12,N,20,0,E
3670 DATA OJ0,MARKET,,60,18,N,19,0,E
3675 DATA OK,CZECHOSLOVAKIA,PRAGUE,50,6,N,14,24,E
3680 DATA ON,BELGIUM,BRUSSELS,50,54,N,4,24,E
3685 DATA OX-XP,GREENLAND,GODTHAAB,63,0,N,52,0,W
3690 DATA OY,FAEROE,,62,0,N,7,0,W
3695 DATA OZ,DENMARK,COPENHAGEN,55,42,N,12,36,E
3700 DATA P2,PAPUA NEW GUINEA,MADANG,5,12,S,145,36,E
3705 DATA P2,PAPUA NEW GUIAEA,P. MORESBY,9,24,S,147,6,E
3710 DATA PA-PI,NETHERLANDS,AMSTERDAM,52,24,N,4,54,E
3715 DATA PJ,NETH. ANTILLES,,12,0,N,69,0,W
3720 DATA PJ,ST. MAARTEN,SABA,18,0,N,63,0,W
3725 DATA PT2,BRAZIL,BRASILLIA,16,0,S,48,0,W
3730 DATA PY6,BRAZIL,RIO DE JANEIRO,23,0,S,43,12,W
3735 DATA PY6,BRAZIL,NATAL,6,0,S,35,12,W
3740 DATA PY0,FERNANDO DE NORONHA,,3,0,S,32,0,W
3745 DATA PY0,ST. PETER & PAULS,,1,30,N,30,0,W
3750 DATA PY0,TRINDADE & M. VAZ,,19,0,N,29,0,W
3755 DATA PZ,SURINAM,,6,0,S,55,0,W
3760 DATA S2,BANGLADESH,DACCA,24,0,N,90,30,E
3765 DATA S7,SEYCHELLES ISLANDS,,4,0,S,56,0,E
3770 DATA S9,SAO TOME,,0,18,N,6,0,E
3775 DATA SK-SM,SWEDEN,STOCKHOLM,59,18,N,18,6,E
3780 DATA SP,POLAND,CRACOW,50,0,N,20,0,E
3785 DATA SP,POLAND,WARSAW,52,12,N,21,0,E
3790 DATA ST,SUDAN,KHARTOUM,15,30,N,32,30,E
3795 DATA ST0,SOUTHERN SUDAN,JUBA,5,0,N,31,36,E
3800 DATA SU,EGYPT,CAIRO,30,0,N,31,24,E
3805 DATA SV,CRETE,,34,24,N,25,12,E
3810 DATA SV,DODECANESE,,36,30,N,27,30,E
3815 DATA SV,GREECE,ATHENS,38,0,N,23,42,E
3820 DATA SV,MT. ATHOS,,40,12,N,24,18,E
3825 DATA T2,TUVALU,FUNAFUTI,8,42,S,178,36,E
3830 DATA T3,KIRIBATI,CENTRAL,4,0,S,171,0,W
3835 DATA T3,KIRIBATI,WEST,5,0,S,175,0,E
3840 DATA T3,KIRIBATI,EAST,10,0,S,150,0,W
3845 DATA TA,TURKEY,ANKARA,39,54,N,32,54,E
3850 DATA TF,ICELAND,REYKJAVIK,64,6,N,22,0,W
3855 DATA TG,GUATEMALA,G. CITY,14,36,N,90,30,W
3860 DATA TI,COSTA RICA,,10,0,N,84,0,W
3865 DATA TI9,COCOS ISLAND,,5,0,N,87,0,W
3870 DATA TJ,CAMEROON,YAOUNDE,4,0,N,12,0,E
3875 DATA TL,CENTRAL AF. REP.,BANGUI,4,30,N,18,0,E
3880 DATA TN,REP. OF CONGO,BRAZZAVILLE,4,0,S,15,0,E
3885 DATA TR,GABON,LIBREVILLE,0,30,N,9,0,E
3890 DATA TT,CHAD,FT. LAMY,12,0,N,15,0,E
3895 DATA TU,IVORY COAST,ABIDJAN,5,30,N,4,0,W
3900 DATA TY,BENIN,,6,18,N,2,18,E
3905 DATA TZ,MALI REPUBLIC,BAMAKO,13,0,N,8,0,W
3910 DATA UA1,EUR. RUSSIA,LENINGRAD,60,0,N,30,0,E
3915 DATA UA3,EUR. RUSSIA,MOSCOW,56,0,N,37,30,E
3920 DATA UA4,EUR. RUSSIA,KUIBYSHEV,53,30,N,50,30,E
3925 DATA UA6,EUR. RUSSIA,ROSTOV,47,0,N,40,0,E
3930 DATA UA1,FRANZ JOSEF LAND,,80,0,N,50,0,E
3935 DATA UA2,KALININGRAD,,55,0,N,20,30,E
3940 DATA UA9-0,ASIATIC RUSSIA,NOVOSIBIRSK,55,0,N,83,0,E
3945 DATA UA9,ASIATIC RUSSIA,PERM,57,30,N,56,0,E
3950 DATA UA0,ASIATIC RUSSIA,KHABAROVSK,48,0,N,135,0,E
3955 DATA UA0,ASIATIC RUSSIA,KRASNOYARSK,56,0,N,93,0,E
3960 DATA UA0,ASIATIC RUSSIA,YAKUTSK,62,0,N,130,0,E
3965 DATA UB5,UKRAINE,KIEV,50,30,N,31,0,E
3970 DATA UC2,WHITE RUSSIA,MINSK,54,0,N,27,30,E
3975 DATA UD6,AZERBAIJAN,BAKU,40,30,N,50,0,E
3980 DATA UF6,GEORGIA,TBILISI,41,30,N,45,0,E
3985 DATA UG6,ARMENIA,ERIVAN,40,30,N,44,30,E
3990 DATA UH8,TURKOMAN,ASHKHABAD,38,0,N,58,0,E
3995 DATA UI8,UZBEK,BUKHARA,40,0,N,64,0,E
4000 DATA UJ8,TADZHIK,SAMARKAND,39,30,N,67,0,E
4005 DATA UL7,KAZAKH,ALMA-ATA,53,0,N,76,0,E
4010 DATA UM8,KIRGHIZ,,42,0,N,75,0,E
4015 DATA UO5,MOLDAVIA,KISHINEV,47,0,N,29,0,E
4020 DATA UP2,LITHUANIA,VILNA,54,30,N,25,30,E
4025 DATA UQ2,LATVIA,RIGA,57,0,N,24,0,E
4030 DATA UR2,ESTONIA,TALLINN,59,0,N,25,0,E
4035 DATA VE1,SABLE ISLAND,,43,48,N,60,0,W
4040 DATA VE1,ST. PAUL ISLAND,,47,12,N,60,6,W
4045 DATA VK1,AUSTRALIA,CANBERRA,35,30,S,149,0,E
4050 DATA VK2,AUSTRALIA,SYDNEY,34,0,S,151,0,E
4055 DATA VK3,AUSTRALIA,MELBOURNE,38,0,S,145,0,E
4060 DATA VK4,AUSTRALIA,BRISBANE,27,30,S,153,0,E
4065 DATA VK5,AUSTRALIA,ADELAIDE,34,54,S,138,36,E
4070 DATA VK6,AUSTRALIA,PERTH,32,0,S,115,54,E
4075 DATA VK7,AUSTRALIA,TASMANIA,42,54,S,147,18,E
4080 DATA VK8,AUSTRALIA,DARWIN,12,30,S,130,54,E
4085 DATA VK2,LORD HOWE ISLAND,,31,36,S,159,6,E
4090 DATA VK9,CHRISTMAS ISLAND,,10,30,S,105,42,E
4095 DATA VK9,COCOS (KEELING) IS.,,12,12,S,96,48,E
4100 DATA VK9,MELLISH REEF,,17,36,S,155,48,E
4105 DATA VK9,NORFOLK ISLAND,,29,0,S,168,0,E
4110 DATA VK9,WILLIS ISLAND,,16,0,S,149,30,E
4115 DATA VK0,HEARD ISLAND,,53,0,S,73,24,E
4120 DATA VK0,MACQUARIE ISLAND,,54,42,S,158,48,E
4125 DATA VP1,BELIZE,,17,30,N,88,18,W
4130 DATA VP2A,ANTIGUA,,17,0,N,59,48,W
4135 DATA VP2E,ANGUILLA,,18,18,N,63,0,W
4140 DATA VP2K,ST. KITTS & NEVIS,,17,18,N,62,36,W
4145 DATA VP2M,MONTSERRAT,,16,48,N,62,12,W
4150 DATA VP2S,ST. VINCENT,,13,18,N,61,18,W
4155 DATA VP2V,BRITISH VIRGIN IS.,,18,24,N,64,36,W
4160 DATA VP5,TURKS & CAICOS IS.,,22,0,N,72,0,W
4165 DATA VP8,FALKLAND ISLANDS,,52,0,S,60,0,W
4170 DATA VP8,SO. GEORGIA ISL.,,54,0,S,37,0,W
4175 DATA VP8,SO. ORKNEY IS.,,60,0,S,46,0,W
4180 DATA VP8,SO. SANDWICH IS.,,57,0,S,28,0,W
4185 DATA VP8,SO. SHETLAND IS.,,62,0,S,58,30,W
4190 DATA VP9,BERMUDA,,32,18,N,64,42,W
4195 DATA VQ9,CHAGOS,DIEGO GARCIA,7,18,S,72,24,E
4200 DATA VR6,PITCAIRN IS.,,25,6,S,130,6,W
4205 DATA VS6,BRUNEI,,5,0,N,115,0,E
4210 DATA VS6,HONG KONG,,22,30,N,114,0,E
4215 DATA VS9K,KAMARAN IS.,,15,18,N,42,48,E
4220 DATA VU,INDIA,BOMBAY,19,0,N,72,48,E
4225 DATA VU,INDIA,CALCUTTA,22,36,N,88,24,E
4230 DATA VU,INDIA,NEW DELHI,28,0,N,77,0,E
4235 DATA VU7,ANDAMAN IS.,,10,0,N,94,0,E
4240 DATA VU7,LACCADIVE IS.,,10,0,N,70,0,E
4245 DATA XE1,MEXICO,MEXICO CITY,19,24,N,99,6,W
4250 DATA XE2,MEXICO,CHIHUAHHA,28,42,N,106,0,W
4255 DATA XE3,MEXICO,MERIDA,21,0,N,89,42,W
4260 DATA XF4,REVILLA GIGEDO IS.,,18,0,N,112,0,W
4265 DATA XT,UPPER VOLTA,,12,18,N,1,42,W
4270 DATA XU,KHMER REP.,PHNOM PENH,11,30,N,105,0,E
4275 DATA XV,VIETNAM,SAIGON,10,48,N,106,42,E
4280 DATA XW,LAO PEOPLES D. REP.,,18,0,N,102,30,E
4285 DATA XZ,BURMA,RANGOON,16,48,N,96,0,E
4290 DATA Y2-9,GERMAN DEM. REP.,BERLIN,52,30,N,13,24,E
4295 DATA YA,AFGHANISTAN,KANDAHAR,32,0,N,65,0,E
4300 DATA YB-YC,INDONESIA,,6,0,S,107,0,E
4305 DATA YI,IRAQ,BAGHDAD,33,0,N,44,30,E
4310 DATA YJ,NEW HEBRIDES,VILLA,18,0,S,168,0,E
4315 DATA YK,SYRIA,,34,0,N,36,30,E
4320 DATA YN-HT,NICARAGUA,MANAGUA,12,0,N,86,0,W
4325 DATA YO,ROMANIA,BUCHAREST,44,24,N,26,6,E
4330 DATA YS,EL SALVADOR,,14,0,N,89,0,W
4335 DATA YU,YUGOSLAVIA,BELGRADE,44,54,N,20,30,E
4340 DATA YV,VENEZUELA,CARACAS,10,30,N,67,0,W
4345 DATA YV0,AVES ISLAND,,12,0,N,67,30,W
4350 DATA ZA,ALBANIA,TIRANA,41,30,N,19,30,E
4355 DATA ZB,GIBRALTAR,,36,0,N,5,30,W
4360 DATA ZD7,ST. HELENA,,16,0,S,6,0,W
4365 DATA ZD8,ASCENSION IS.,,8,0,S,14,0,W
4370 DATA ZD9,TRISTAN DA CUNHA,,38,0,S,20,0,W
4375 DATA ZE,ZIMBABWE,SALISBURY,18,0,S,31,0,E
4380 DATA ZF,CAYMAN IS.,,19,30,N,81,12,W
4385 DATA ZK1,COOK IS. (N),MANIHIKI,10,30,S,161,0,W
4390 DATA ZK1,COOK IS. (S),RARATONGA,21,0,S,159,30,W
4395 DATA ZK2,NIUE IS.,,19,0,S,170,0,W
4400 DATA ZL1,NEW ZEALAND,AUCKLAND,36,54,S,174,48,E
4405 DATA ZL2,NEW ZEALAND,WELLINGTON,41,18,S,174,48,E
4410 DATA ZL3,NEW ZEALAND,CHRISTCHURCH,43,0,S,172,30,E
4415 DATA ZL4,NEW ZEALAND,DUNEDIN,46,0,S,170,0,E
4420 DATA ZL5,ANTARCTICA,SCOTT BASE,78,0,S,165,0,E
4425 DATA ZL,AUCKLAND & CAMPBELL,,52,30,S,169,0,E
4430 DATA ZL,CHARHAM IS.,,44,0,S,176,0,W
4435 DATA ZL,KERMADEC IS.,,30,0,S,178,0,W
4440 DATA ZM7,TOKELAUS,,11,0,S,165,0,W
4445 DATA ZP,PARAGUAY,ASUNCION,25,18,S,57,42,W
4450 DATA ZS1,SO. AFRICA,CAPE TOWN,33,54,S,18,24,E
4455 DATA ZS5,SO. AFRICA,DURBAN,29,54,S,30,54,E
4460 DATA ZS6,SO. AFRICA,JOHANNESBURG,26,12,S,28,6,E
4465 DATA ZS2,P. EDWARD & MARION,,46,48,S,37,48,E
4470 DATA 1A,S.W.O.M.,,41,54,N,12,24,E
4475 DATA 1S,SPRATLY IS.,,8,48,N,111,54,E
4480 DATA 3A,MONACO,,44,0,N,7,30,E
4485 DATA 3B8,MAURITIUS,,20,18,S,57,30,E
4490 DATA 3B9,RODRIGUEZ,,19,42,S,63,24,E
4495 DATA 3C,EQUATORIAL GUINEA,,1,48,N,10,0,E
4500 DATA 3C0,ANNOBON,,3,30,N,8,30,E
4505 DATA 3D2,FIJI IS.,,17,0,S,178,0,E
4510 DATA 3D6,SWAZILAND,,27,0,S,31,30,E
4515 DATA 3V,TUNISIA,TUNIS,36,48,N,10,12,E
4520 DATA 3X,REP. OF GUINEA,CONAKRY,10,0,N,13,0,W
4525 DATA 3Y,BOUVET IS.,,54,30,S,3,0,E
4530 DATA 4S,SRI LANKA,COLOMBO,7,0,N,79,54,E
4535 DATA 4U,ITU GENEVA,,46,12,N,6,12,E
4540 REM DATA 4U,UNITED NATIONS HQ,,40,48,N,74,0,W
4545 DATA 4W,YEMAN,,15,0,N,44,0,E
4550 DATA 4X-4Z,ISRAEL,,32,0,N,35,0,E
4555 DATA 5A,LIBYA,TRIPOLI,32,30,N,12,30,E
4560 DATA 5B-ZC,CYPRUS,,35,0,N,33,0,E
4565 DATA 5H,TANZANIA,DAR ES SALAAM,7,0,S,39,30,E
4570 DATA 5N,NIGERIA,LAGOS,6,30,N,3,0,E
4575 DATA 5R,MALAGASY REP,TANANARIVE,18,30,S,47,0,E
4580 DATA 5T,MAURITANIA,NOUAKCHOTT,18,0,N,16,0,W
4585 DATA 5U,NIGER,NIAMEY,13,30,N,2,0,E
4590 DATA 5V,TOGO,,6,0,N,1,30,E
4595 DATA 5W,WESTERN SAMOA,,13,0,S,172,0,W
4600 DATA 5X,UGANDA,,1,0,N,32,30,E
4605 DATA 5Z,KENYA,NAIROBI,1,30,S,37,30,E
4610 DATA 6O,SOMALI,MOGADISHO,2,0,N,46,0,E
4615 DATA 6W,SENEGAL,DAKAR,15,0,N,18,0,W
4620 DATA 6Y,JAMAICA,,18,0,N,76,0,W
4625 DATA 7O,YEMAN P. DEM.,ADEN,13,0,N,45,0,E
4630 DATA 7P,LESOTHO,,29,30,S,28,0,E
4635 DATA 7Q,MALAWI,ZOMBA,15,0,S,35,0,E
4640 DATA 7X,ALGERIA,ALGIERS,36,42,N,3,0,E
4645 DATA 8P,BARBADOS,,11,30,N,59,30,W
4650 DATA 8Q,MALDIVE IS.,,0,30,N,73,0,E
4655 DATA 8R,GUYANA,GEORGETOWN,6,48,N,58,12,W
4660 DATA 8Z4,IRAQ NEUT.ZONE,SAMAH,27,48,N,47,0,E
4665 DATA 9A-M1,SAN MARINO,,44,0,N,13,0,E
4670 DATA 9G,GHANA,ACCRA,5,30,N,0,12,W
4675 DATA 9H,MALTA,,36,0,N,14,24,E
4680 DATA 9J,ZAMBIA,LUSAKA,15,0,S,28,0,E
4685 DATA 9K,KUWAIT,,29,0,N,48,0,E
4690 DATA 9L,SIERRA LEONE,FREETOWN,8,30,N,13,12,W
4695 DATA 9M2,WEST MALAYSIA,,3,0,N,102,0,E
4700 DATA 9M6,EAST MALAYSIA,SABAH,5,0,N,117,0,E
4705 DATA 9M8,EAST MALAYSIA,SARAWAK,2,0,N,113,0,E
4710 DATA 9N,NEPAL,KATMANDU,27,30,N,85,0,E
4715 DATA 9Q,ZAIRE,KINSHASA,4,18,S,15,18,E
4720 DATA 9Q,ZAIRE,KISANGANI,1,0,N,25,0,E
4725 DATA 9Q,ZAIRE,LUBUMBASHI,12,0,S,27,30,E
4730 DATA 9U,BURUNDI,,3,0,S,29,0,E
4735 DATA 9V,SINGAPORE,,1,18,N,103,48,E
4740 DATA 9X,RWANDA,,1,30,S,30,0,E
4745 DATA 9Y,TRINIDAD IS.,,11,0,N,62,30,W
4750 DATA --,ABU AIL,,27,30,N,50,0,E
9999 DATA QQ,QQ,QQ,0,0,Q,0,0,Q
10000 REM SUBROUTINE TO PRINT PAGE HEADER
10005 LPRINT CHR$(155)CHR$(142);"      BEAM HEADINGS FOR ";HOMECALL$;CHR$(155)
10010 LPRINT "BASED ON  ";LATHDEG;"DEG ";LATHMIN;"MIN ";LATH$;"  ";LONGHDEG;"DEG ";LONGHMIN;" MIN ";LONGH$;"   ";STATION$
10014 LPRINT "PFX      COUNTRY             CITY             SP      LP      MILES"
10015 LPRINT "----------------------------------------------------------------------"
10020 RETURN
20000 COUNT=1
20005 LPRINT CHR$(140)   'FORM FEED TO PRINTER
20010 GOSUB 10000        'PRINT HEADER ON PAGE
20015 RETURN
30000 LPRINT:LPRINT:LPRINT:LPRINT:LPRINT
30005 LPRINT "THIS LISTING WAS PRODUCED BY A PROGRAM WRITTEN BY J. SCOTT DOUGLASS, K2SD"
30010 LPRINT "2440 WILLIAMS ROAD, MATTHEWS, NC 28105"
30015 LPRINT "LATITUDE AND LONGITUDE DATA WAS TAKEN FROM THE 1982 ARRL ANTENNA HANDBOOK."
30020 LPRINT "PLEASE REPORT ANY ERRORS IN THE LATITUDE AND LONGITUDE DATA TO THE
30021 LPRINT "ABOVE ADDRESS."
30025 LPRINT
30030 LPRINT "THIS PROGRAM MAY BE FREELY COPIED AND DISTRUBUTED AS NEEDED. PLEASE"
30035 LPRINT "RETAIN THIS NOTICE IF COPIES ARE MADE......THANKS!"
30040 LPRINT CHR$(140)
30045 END
