/*	view - view a synthetic object in 3D

	history...
		8 Oct 90	1.51: Extra new_frame removed, so PostScript
					output works.  '+' and '-' also change amount
					of enlargement or shrinking.  Hitting any key
					interrupts the current display.
		4 Aug 90	1.50: Help display is now properly centered.
					Final viewpoint is printed when program finishes.
					pgup and pgdn move observer in and out.
					Hard copy versions accept configuration files,
					and no longer require the user to type 'Q'.
		11 Aug 88	1.44: clipping at box surface
		17 Jun 88	1.43: improved help page, fixed index bug, general
					code cleanup.
		29 Mar 88	1.42: Storing points as floats rather than doubles,
					enlarged arrays to 3000, specifying multiple
					linestyles implies -b.
		29 Jun 87	Can initialize observer location
		13 Apr 87	Multiple linestyles/markerstyles, breaking
	-- v 1.3  --
		11 May 85	Allowing two-character cursor keys.
		6 May 85	Always calling terminate_view_surface(1) before exit().
	Obeying ^S ^X ^D ^E in addition to regular cursor keys.
 		18 Apr 85	Using cursor control keys defined in g.h.
*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include "g3.h"
#include "g.h"
#include "scr_ci.h"

char *malloc();

#define VERSION "1.51"
#define RIGHT "Copyright (c) 1985, 1990 by James R. Van Zandt.  All rights reserved.\n"
#define RESTRICTION "This program may be reproduced for personal, non-profit use only.\n"

#define d2r (3.1415926535/180.)
#define ENTRIES 3000
#define MAXLAB 200
#define MAXSTYLES 50
#define BUFSIZE 200

extern double best_width, best_height;

extern int debugging;
char string[80];
static char buf[BUFSIZE], buf2[BUFSIZE], buf3[BUFSIZE];
char *default_script_file = "";
char *program_name = NULL;
int style[MAXSTYLES];		/* array of requested line styles	*/
int repeat[MAXSTYLES];		/* array of repeat counts for line styles	*/
int persp=1,	/* nonzero if perspective projection desired */
markers=0,		/* nonzero if marker desired at each data point */
framing=1;		/* nonzero if frame desired around plot */
int tails=0;
int observer_viewpoint=0;
int scaling=0;	/* nonzero if scaling data to fill a cube */
int breaking=0;				/* nonzero if breaking (disconnecting) graph
								after each label in input */
int automatic_abscissas=0;	/* nonzero if abscissas are to be generated */
int abscissa_arguments=0;	/* number specified: abscissa spacing & start */
int logx=0;					/* nonzero if x axis is to be logrithmic */
int logy=0;					/* nonzero if y axis is to be logrithmic */
int logz=0;					/* nonzero if z axis is to be logrithmic */

int x_arguments=0;			/* number specified: xmin, xmax, xdel	*/
int y_arguments=0;			/* number specified: ymin, ymax, ydel	*/
int z_arguments=0;			/* number specified: zmin, zmax, zdel	*/
int standard_input=0;		/* nonzero if data is coming from standard input */
int labels=0;				/* number of user-supplied labels
								 (index into next two arrays) */
int numstyles=0;			/* # linestyles specified by user */
int p_data[MAXLAB]; char *p_text[MAXLAB];
char null_label[]="";

static double cc, ss, angle, step, factor=1.,
	enlarge=1.,			/* scale factor for display size */
	growth=1.414,		/* factor for changing scale factor */
	abscissa=0.,		/* default starting value for automatic abscissas */
	abscissa_step=1.,	/* default step for automatic abscissas */
p1=-3., p2=0., p3=0.,	/* observer location */
ox, oy,					/* screen coordinates of top left corner */
diag,					/* extent of viewable volume */
data_size;				/* extent of data */

#define REAL float

REAL *x, *y, *z;
double xmin, xmax, ymin, ymax, zmin, zmax;
int last;

main(argc, argv) int argc; char **argv;
{	int i, j;

	if(argc<2 || (argc>1 && streq(argv[1], "?"))) sample();
	read_data(argc, argv);
	
	initialize_core(0,0,3);
	select_view_surface(1);
	initialize_view_surface(1);

	initialize_parameters(argc, argv);
	while(1)
		{if(!plotting_device)
			new_frame();				/* clears the screen */
		if(persp) perspective(p1, p2, p3);
		else parallel(p1, p2, p3);
		view_plane_normal(-p1, -p2, -p3);
		create_temporary_segment(1); /* finds viewing transformation */
		frame();			/* draw framework around image */
		image();			/* use drawing primitives to create image */
		close_temporary_segment();	
		if(plotting_device) quit();
		update_parameters();
		}
}

initialize_parameters(argc, argv) int argc; char **argv;
{/*	if(want("use right handed coordinate system? ")) */
		coordinate_system_type(1);		/* default coordinates are LH */
	ndc_space_2(best_width, best_height); /* enable use of all of screen */
	viewport2(0., best_width, 0., best_height); /* viewport is all of screen */
	/*	if(want("enable clipping? ")) */
		clip_window(1);
	view_up_3(0., 0., 1.);		/* vector in this direction appears
									   vertical in final view		*/
	angle=3.14159/12.;
	ss=sin(angle); cc=cos(angle);
}

update_parameters()
{	int c;
	static double t;

	while(1)
		{c=scr_ci();
		switch(c)
			{case '+':	angle *= 4.; step *= 4.; factor *= 4.;
						growth *= growth;
						growth *= growth;
						ss=sin(angle); cc=cos(angle);
						break;
			case '-':	angle /= 4.; step /= 4.; factor /= 4.;
						growth = sqrt(sqrt(growth));
						ss=sin(angle); cc=cos(angle);
						break;
			case '?':	help();	return;
			case 'q':
			case 'Q':	quit();
			default:
				{c &= 0xff;
				if((c==up_char)|(c==('E'-64))) {p3+=step; return;}
				else if((c==down_char)|(c==('X'-64))) {p3-=step; return;}
				else if((c==right_char)|(c==('D'-64)))
					{t=cc*p1-ss*p2; p2= ss*p1+cc*p2; p1=t; return;
					}
				else if((c==left_char)|(c==('S'-64)))
					{t=cc*p1+ss*p2; p2=-ss*p1+cc*p2; p1=t; return;
					}
				else if(c == pgup_char)
					{if(!persp) goto BIGGER;
					p1/=growth; p2/=growth; p3/=growth; step/=growth; return;
					}
				else if(c == pgdn_char)
					{if(!persp) goto SMALLER;
					p1*=growth; p2*=growth; p3*=growth; step*=growth; return;
					}
				else if(c == home_char)
					{
BIGGER:				enlarge *= growth;
					diag = data_size/enlarge;
					window(-diag*best_width, diag*best_width, 
					       -diag*best_height, diag*best_height);
    				ox=-diag*best_width; oy=diag*best_height*.95;
					return;
					}
				else if(c == end_char)
					{
SMALLER:			enlarge /= growth;
					diag = data_size/enlarge;
					window(-diag*best_width, diag*best_width, 
					       -diag*best_height, diag*best_height);
    				ox=-diag*best_width; oy=diag*best_height*.95;
					return;
					}
						
{
FILE *dfile;
dfile = fopen("debug","a");
fprintf(dfile, "illegal character %d = %02xH\n", c, c);
fclose(dfile);
}				
				putchar(7);  /* beep */
				break;
				}
			}
		puts("\008 \008");	/* erase that character */
		}
}

quit()
{
	terminate_view_surface(1); 
	printf("last viewpoint was (%f, %f, %f),\n", p1, p2, p3);
	printf("scale factor %f\n", enlarge);
	exit(0);
}

char *msg[]={
"            --- Status ---",
"",
buf,
buf2,
buf3,
"",
"",
"            --- Key Commands ---",
"",
"cursor keys     move observer along a cylinder: higher, ",
"                lower, around to left, or around to right.",
"   pg up        move closer",
"   pg dn        move back",
"    home        enlarge",
"    end         shrink",
"     +          enlarge cursor key steps by a factor of 4",
"     -          shrink cursor key steps by a factor of 4",
"     Q          exit program",
"",
"     ?          print this help menu",
"",
"",
"   <press any key to continue>",
0
};

help()
{	char **sp, c;
	double x0, y0, z0, dz;
	x0 = (xmax+xmin)/2.-diag*best_width;
	z0 = (zmax+zmin)/2.+diag*best_height*.7;
	dz = diag/24.;
	new_frame();
	parallel(0., -1., 0.);
	view_plane_normal(0., 1., 0.);
	create_temporary_segment(1); /* finds viewing transformation */
	sprintf(buf,"current viewpoint is (%f, %f, %f)\n", p1, p2, p3);
	sprintf(buf2,"                  or %3.2f degrees right of the x axis",
		atan2(p2, p1)/d2r);
	sprintf(buf3,
		"current step sizes are %f and %3.2f degrees  (default * %3.2f)",
		step, angle/d2r, factor);
	for (sp=msg; *sp; sp++)
		{move_abs_3(x0, 0., z0); z0-=dz;
		text(*sp);
		}
	
	c=tolower(scr_ci());
	if(c == 'q') quit();

	close_temporary_segment();	
}

read_data(argc, argv) int argc; char **argv;
{	int i, n, length, skipping, ac;
	FILE *ifile;
	double xx, yy, zz, xscale, yscale, zscale;
	double data_xmin, data_xmax, data_ymin, data_ymax, data_zmin, data_zmax;
	char *t, *s, **av;

	sscanf("1.9","%lf",&xx);		/* workaround for bug in strtod() */

	data_xmin = data_ymin = data_zmin = 1.e100;
	data_xmax = data_ymax = data_zmax = -1.e100;
	x = (REAL *)malloc(ENTRIES*sizeof(REAL));
	y = (REAL *)malloc(ENTRIES*sizeof(REAL));
	z = (REAL *)malloc(ENTRIES*sizeof(REAL));
	if(x==NULL || y==NULL || z==NULL) 
		{puts("can\'t allocate buffer"); 
		exit(1);
		}
	p_data[0]=-1;
	argc--; argv++;
  	if(argc>=1 && **argv=='?') sample();
	ac = argc; av = argv; argc = 0;
	while(ac>0)
		{
		if(**av == '&') 		/* device driver configuration file */
			{config_file = (*av)+1;
			ac--; av++;
			}
		else if(**av=='-')
			{i=get_parameter(ac, av);
			ac-=i; av+=i;
			}
		else {argv[argc++] = *av++; ac--;}
		}
	if(!plotting_device) 
		printf("after data is plotted, type 'Q' to exit or '?' \
for help display");
	if(automatic_abscissas && abscissa_arguments==0 && x_arguments)
		{abscissa = xmin;
		}
	i = 0;
	while(1)
		{if(argc>0)
			{ifile=fopen(argv[0], "r");
			if(ifile==0) {printf("file %s not found\n", argv[0]); exit(1);}
			else
				{if(*default_script_file==0)
					{				/* construct default script file name */
					s = malloc(3+strlen(argv[0]));
					if(s)
						{default_script_file = s;
						strcpy(default_script_file, argv[0]);
						if(s = strchr(default_script_file, '.')) *s=0;
						strcat(default_script_file, ".f");
						}
					}
				}
			}
		else {ifile = stdin; standard_input++;}
		argc--; argv++;
		while(i<ENTRIES)
			{if(fgets(buf, BUFSIZE, ifile)==0)
				{if(standard_input) 
					{fclose(ifile); 
					ifile=fopen("/dev/con", "r");
					}
				break;
				}
			if(buf[0]==';') continue;	/* ignore comments */
			t=buf+strlen(buf)-1;
			while(t>buf && (*t=='\015' || *t=='\n')) *t--=0;
			t=buf; while(*t && isspace(*t)) t++;
			if(*t==0) continue;			/* ignore blank lines */
			if(automatic_abscissas)
				{xx=abscissa;
				abscissa+=abscissa_step;
				sscanf(buf, "%lf %lf", &yy, &zz);
				}
			else
				{sscanf(buf, "%lf %lf %lf", &xx, &yy, &zz);
				}
			x[i]=xx; y[i]=yy; z[i]=zz;	/* convert to REAL */
			s=buf;
			skipping=3;
			if(automatic_abscissas) skipping--;   
			while(skipping--)
				{while(*s==' ')s++;						/* skip a number */
				while(*s && (*s!=' '))s++;
				}
			while(*s==' ')s++;
			if((length=strlen(s))&&(labels<MAXLAB))
				{if(*s=='\"')
					{t=++s;
					while(*t && (*t!='\"')) t++;
					}
				else
					{t=s;
					while(*t && (*t!=' '))t++;
					}
				*t=0;
				length=t-s;
				p_data[labels]=i;
				p_text[labels]=(char *)malloc(length+1);
				if(p_text[labels]) strcpy(p_text[labels++], s);
				}
			if(logx) {if(x[i]<=0.) gripe_negative(); x[i]=log10(x[i]);}
			if(logy) {if(y[i]<=0.) gripe_negative(); y[i]=log10(y[i]);}
			if(logz) {if(z[i]<=0.) gripe_negative(); z[i]=log10(z[i]);}
			if(x[i]<data_xmin) data_xmin=x[i];
			if(y[i]<data_ymin) data_ymin=y[i];
			if(z[i]<data_zmin) data_zmin=z[i];
	
			if(x[i]>data_xmax) data_xmax=x[i];
			if(y[i]>data_ymax) data_ymax=y[i];
			if(z[i]>data_zmax) data_zmax=z[i];
			if(labels==MAXLAB) break;
			i++;
			}
		if(argc<=0) break;
		breaking=1;
		if(labels && (p_data[labels-1]==i-1)) continue;
		p_data[labels]=i-1;
		p_text[labels++]= null_label;
		}
	switch(x_arguments)
		{case 0:	xmin=data_xmin;
		case 1:		xmax=data_xmax;
		case 2:		;
		case 3:		;
		default:	;
		}
	switch(y_arguments)
		{case 0:	ymin=data_ymin;
		case 1:		ymax=data_ymax;
		case 2:		;
		case 3:		;
		default:	;
		}
	switch(z_arguments)
		{case 0:	zmin=data_zmin;
		case 1:		zmax=data_zmax;
		case 2:		;
		case 3:		;
		default:	;
		}
	xx=xmax-xmin; yy=ymax-ymin; zz=zmax-zmin;
	if(scaling)
		{n=i;
		xscale=1./xx; yscale=1./yy; zscale=1./zz;
		for (i=0; i<n; i++) {x[i]*=xscale; y[i]*=yscale; z[i]*=zscale;}
		xmin*=xscale; ymin*=yscale; zmin*=zscale;
		xmax*=xscale; ymax*=yscale; zmax*=zscale;
		xx=yy=zz=1.;
		}
	data_size=sqrt(xx*xx+yy*yy+zz*zz)/2./best_height;
	diag=data_size/enlarge;
	view_reference_point((xmax+xmin)/2., (ymin+ymax)/2., (zmin+zmax)/2.);
	window(-diag*best_width, diag*best_width, 
	       -diag*best_height, diag*best_height); /* use all of view surface */
    ox=-diag*best_width; oy=diag*best_height*.95;
	step=diag;	
	switch(observer_viewpoint)
		{default:	p1=2.*step; 
		case 1:		p2=-2.*sqrt(3.)*step; 
		case 2:		p3=step;
		case 3:		;
		}		
	last=i-1;
	if(last<=0)
		{puts("no data points found \n");
		sample();
		}
/*	printf("x in (%f, %f), \ny in (%f, %f), \nz in (%f, %f) \n", xmin, xmax,
	ymin, ymax, zmin, zmax);
	printf("xx, yy, zz=(%f,%f,%f), diag=%f, step=%f \n",xx, yy, zz, diag, step);
	printf("points 0 through %d \n", last); getchar();
*/
}

char *sample_msg[]={
"display 3D vector graphics\n",
"sample usage:   dots  alpha.dat  [options]\n",
"options are:\n",
"   -a [step [start]] automatic abscissas \n",
"   -b     break graph after each label\n",
"   -f     omit frame around plot \n",
"   -m  n1 n2 n3...    n positive for line styles: n = WCS, \n",
"                      where W=width, C=color, S=dash style,\n",
"                      or n = -CS for markers \n",
"   -o  ox oy oz       specify initial observer location\n",
"   -p     use parallel rather than perspective projection\n",
"   -s     scale data to fill a cube\n",
"   -s  num            enlarge display by factor num\n",
"   -t     draw line from each data point to the XY plane\n",
"   -x  NUM1 NUM2      let x axis extend from NUM1 to NUM2\n",
"   -y  NUM1 NUM2      let y axis extend from NUM1 to NUM2\n",
"   -z  NUM1 NUM2      let z axis extend from NUM1 to NUM2\n\n",
RIGHT,
RESTRICTION,
0};

sample()
{	char **sp;
	printf("DOTS   version %s, interface %s for %s \n",
	VERSION, interface_version, machine);
	for (sp=sample_msg; *sp; sp++) printf(*sp);
	exit(0);
}

/* get_parameter - process one command line option
		(return # parameters used) */
get_parameter(argc, argv) int argc; char **argv;
{	int i;
	double junk;
	char *s;

	if(streq(*argv, "-x"))
		{
/*
		if(argc<3) gripe(argv);
		xmin=atof(argv[1]); xmax=atof(argv[2]); x_arguments=2; return 3;
*/
		i=get_double(argc, argv, 2, &xmin, &xmax, &xmax);
		x_arguments=i-1;
		return i;
		}
	else if(streq(*argv, "-y"))
		{
/*
		if(argc<3) gripe(argv);
		ymin=atof(argv[1]); ymax=atof(argv[2]); return 3;
*/
		i=get_double(argc, argv, 2, &ymin, &ymax, &ymax);
		y_arguments=i-1;
		return i;
		}
	else if(streq(*argv, "-z"))
		{
/*
		if(argc<3) gripe(argv);
		zmin=atof(argv[1]); zmax=atof(argv[2]); return 3;
*/
		i=get_double(argc, argv, 2, &zmin, &zmax, &zmax);
		z_arguments=i-1;
		return i;
		}
	else if(streq(*argv, "-a"))
		{i=get_double(argc, argv, 2, &abscissa_step, &abscissa, &abscissa);
		abscissa_arguments=i-1;
		automatic_abscissas=1;
		return i;
		}
	else if(streq(*argv, "-b")) {breaking=1; return 1;}
	else if(streq(*argv, "-d")) {debugging=1; return 1;}
	else if(streq(*argv, "-f")) {framing=0; return 1;}
	else if(streq(*argv,"-m"))
		{numstyles=0;
		if(argc>1 && hexanumeric(argv[1]))
			{i=1;
			while((--argc >0) && hexanumeric(argv[1]) && numstyles<MAXSTYLES)
				{if(s=strchr(*++argv,'*'))
					{repeat[numstyles]=atoi(*argv);
					s++;
					}
				else {repeat[numstyles]=1; s=*argv;}
				style[numstyles++]=atox(s);
				i++;
				}
			if(numstyles>1 || repeat[0]>1) breaking=1;
			return i;
			}
		else 
			{markers=1; return 1;
			}
		}
	else if(streq(*argv, "-o"))
		{i=get_double(argc, argv, 3, &p1, &p2, &p3);
		observer_viewpoint=i-1;
		return i;
		}
	else if(streq(*argv, "-p")) {persp=0; return 1;}
	else if(streq(*argv, "-s")) 
		{i = get_double(argc, argv, 1, &enlarge, &enlarge, &enlarge);
		if(enlarge <= 0.) enlarge = 1.;
		if(i < 2) scaling = 1;
		return i;
		}
	else if(streq(*argv, "-t")) {tails=1; return 1;}
	else gripe(argv);
}

atox(s) char *s;
{	int n, c, sign;
	while(*s==' '||*s=='\t') s++;
	if(*s=='-')
		{sign=1;
		s++;
		}
	else sign=0;
	n=0;
	while(1)
		{c=*s++;
		if(c>='0' && c<='9') c-='0';
		else
			{if(c>='a') c-=0x20;		/* convert to upper case */
			if(c>='A' && c<='F') c=c-'A'+10;
			else return (sign?-n:n);
			}
		n=(n<<4)+c;
		}
}
get_double(argc, argv, permitted, a, b, c)
int argc, permitted; char **argv; double *a, *b, *c;
{	int i=1;
	if((permitted--)>0 && (argc>i) && numeric(argv[i])) *a=atof(argv[i++]);
	if((permitted--)>0 && (argc>i) && numeric(argv[i])) *b=atof(argv[i++]);
	if((permitted--)>0 && (argc>i) && numeric(argv[i])) *c=atof(argv[i++]);
	return i;
}

numeric(s) char *s;
{	char c;
	while(c=*s++)
		{if((c<='9' && c>='0') || c=='e' || c=='E' || 
			c=='+' || c=='-' || c=='.') continue;
		return 0;
		}
	return 1;
}

hexanumeric(s) char *s;
{	char c; 
	int numeral_found=0;
	if(numeric(s)) return 1;
	while(c=*s++)
		{c=toupper(c);
		if((c<='9' && c>='0') || (c<='F' && c>='A')) 
			{numeral_found=1; continue;
			}
		else if(strchr("*-", c)) continue;
		return 0;
		}
	return numeral_found;
}

int streq(a, b) char *a, *b;
{	while(*a)
		{if(*a!=*b)return 0;
		a++; b++;
		}
	return 1;
}

gripe_negative()
{	puts("nonpositive value along logrithmic axis ");
	exit(1);
}

gripe(argv) char **argv;
{	puts(*argv); puts(" isn\'t a legal argument \n");
	sample();
}

frame()
{	double xx, yy, zz;

							/* draw axes */
	set_color(1);
	if((xmin<=0.)&&(xmax>=0.)) xx=0.; else xx=xmin;
	if((ymin<=0.)&&(ymax>=0.)) yy=0.; else yy=ymin;
	if((zmin<=0.)&&(zmax>=0.)) zz=0.; else zz=zmin;
	move_abs_3(xmin, yy, zz); line_abs_3(xmax, yy, zz); text("x");
	move_abs_3(xx, ymin, zz); line_abs_3(xx, ymax, zz); text("y");
	move_abs_3(xx, yy, zmin); line_abs_3(xx, yy, zmax); text("z");

	if(!framing) return;

							/* draw frame */
	set_color(5);
	move_abs_3(xmin, ymin, zmin);
	line_abs_3(xmax, ymin, zmin);
	line_abs_3(xmax, ymax, zmin);
	line_abs_3(xmin, ymax, zmin);
	line_abs_3(xmin, ymin, zmin);
	
	line_abs_3(xmin, ymin, zmax);

	line_abs_3(xmax, ymin, zmax);
	line_abs_3(xmax, ymin, zmin);
	line_abs_3(xmax, ymin, zmax);

	line_abs_3(xmax, ymax, zmax);
	line_abs_3(xmax, ymax, zmin);
	line_abs_3(xmax, ymax, zmax);

	line_abs_3(xmin, ymax, zmax);
	line_abs_3(xmin, ymax, zmin);
	line_abs_3(xmin, ymax, zmax);

	line_abs_3(xmin, ymin, zmax);

}

image()
{	int i, j, j_style=1, k, st, group, segment, n;

	for(segment=group=i=0; i<=last; group++)
		{if(!plotting_device && kbhit()) break;
		if(group<numstyles) {j_style=style[group]; n=repeat[group];}
		else n=1;
		while(n--)
			{
			j=j_style;
			if(j>0)
				{if(st=j%16) st--;
				set_linestyle(st); j/=16;
				set_color(j%16); j/=16;
				set_linewidth(j);
				move_abs_3(x[i],y[i],z[i]);
				markers=0;
				}
			else
				{j=-j;
				st=j%16;
				set_marker_symbol(st ? st : 6);
				j/=16;
				k=j%16;
				set_color(j ? k : 0);
				markers=1;
				}
			while(i<=last)
				{if(xmin<=x[i] && x[i]<=xmax &&
				    ymin<=y[i] && y[i]<=ymax &&
				    zmin<=z[i] && z[i]<=zmax)	
					{if(markers)
						marker_abs_3(x[i],y[i], z[i]);
					else line_abs_3(x[i],y[i], z[i]);
					if(tails)
						{line_abs_3(x[i], y[i], 0.);
						if(i && (markers == 0))
							line_abs_3(x[i-1], y[i-1], 0.);
						move_abs_3(x[i], y[i], z[i]);
						}
					if(i++ == p_data[segment])
						{text(p_text[segment]);
						if(breaking) break;
						else {segment++; move_abs_3(x[i-1],y[i-1], z[i-1]);}
						}
					}
				else /* point not visible */
					{
					if(i++ != p_data[segment])
						{segment--;	/* compensate for later increment */
						n++;
						}
					break;			/* force a line break */
					}
				}
			segment++;
			}
		}
	set_linewidth(1);
	set_linestyle(0);
	set_color(0);
}

want(s) char *s;
{	printf(s);
	scanf("%s", &string);
	if((string[0]=='y')|(string[0]=='Y'))return 1;
	else return 0;
}

goodbye()
{	printf("\n<press any key to continue>"); (void)getchar();
	terminate_view_surface(1);
	exit(0);
}
