; ExLite, by Inbar Raz, Jan. 12th, 1992.
; From the FIDO PC Assembly Language Echo
; Origin: Inbar's Point, Yavne, ISRAEL. True ZMailH Point. (2:403/123.5)
;
; Run: ExLite <filename>.
; Produces a decompressed program EXLITED.COM (which you can rename
; as desired).
;
; This program is hard-coded to uncompress PKLITE'ed .COM files.
; It scans the PKLITE decompressor code for a 'MOV DI,AX' and replaces it
; with INT3. Before that instruction is executed, DI holds
; the filesize+100, so that gives us the file size.
; The new int3 service code imply writes the uncompressed program to disk.
; This will NOT work with .EXE files (which require relocation tables).

;v1.2	Toad Hall, 8 Apr 92
; - Got approval from author to release to public domain.
; - Added slight documentation.
; - Minor tweaks.
;v1.1	Toad Hall Tweak, 25 Mar 92
; - Insured CS: overrides where required (just to keep the assembler
;   and programmers informed).
; - Significant tightening
; - Per EMail messages with the author, Inbar Raz,
;   this program is released to the public domain.
;   Please do not remove the author's credits.
;
; David Kirschbaum
; Toad Hall
; kirsch@usasoc.soc.mil

CSEG	SEGMENT
	ASSUME	cs:CSEG, ds:CSEG
	ORG	0
progstart equ	$			;for computing program length	v1.1
	ORG	100h

ExLite:  jmp	Begin			;v1.1

oldInt3 dd	0
NewName db	'EXLITED.COM', 0
NoFile_ db	'No file specified$'					;v1.1
BadName_ db     'Bad file name, or file name can not be opened$'	;v1.1
NotLite_ db     'File is not compressed under PKLite or is of '
	db	'unknown version of PKlite$'				;v1.1
ReadErr_ db	'Error reading source file$'				;v1.1
CantCreat_ db	'Error creating destination file'			;v1.1
Abort_	db	'.',0DH,0AH,'Program aborting.$'			;v1.2

;New INT 3 server writes decompressed program code out to file.
NewInt3:
	mov	ax,cs
	mov	ds,ax
	ASSUME	DS:CSEG			;v1.1

	mov	ax,3C00h		; Create file
	mov	cx,20H			;file attribute			v1.1
	mov	dx,offset NewName	;'EXLITED.COM'
	int	21h
	jb	CantCreat		;create failed
	mov	bx,ax			;into BX for upcoming write	v1.1
	mov	ax,es
	mov	ds,ax
	ASSUME	DS:NOTHING		;Actually, the seg of the	v1.1
					;decompressed file
	mov	ah,40h			; Write file
	mov	cx,di			;program length
	mov	dx,100h			;write from .COM program onward
	sub	cx,dx		;100H	;minus PSP length		v1.1
	int	21h
	jb	CantCreat		;write error			v1.2
	mov	ah,3Eh			; Close file
	int	21h
	mov	ax,2503h		; Restore old Int 3 vector
	lds	dx,cs:oldInt3
	int	21h
	xor	ax,ax			;ERRORLEVEL 0			v1.2
	jmp	short Exit1

CantCreat:
	push	ax			;save file create error		v1.2
	mov	ax,cs
	mov	ds,ax
	ASSUME	DS:CSEG			;v1.1
	mov	dx,offset CantCreat_	;'Error creating destination file'
	mov	ah,9			; Display string
	int	21h
	pop	ax			;restore ERRORLEVEL		v1.2
Exit1:  mov	ah,4CH			;terminate, AL=ERRORLEVEL	v1.2 
	int	21h

;-!!!!!!!!! Installation Code !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!-

NEWSTACK = progend+4DH			;v1.2
Begin:	mov	sp,offset NEWSTACK	;new stack pointer		v1.2

	mov	si,80h			;PSP cmdline
	cld				;insure fwd			v1.1
	lodsb				;snarf cmdline length, bump SI	v1.1
	or	al,al			;any cmdline chars?		v1.1
	jz	NoFile			;nope				v1.1

	mov	ax,3503h		; Get old Int 3 vector
	int	21h			;(breakpoint)
	mov	word ptr [oldInt3],bx	;save it
	mov	word ptr [oldInt3+2],es
	mov	ax,2503h		; Set new Int 3 vector
	mov	dx,offset NewInt3	;to our code
	int	21h
Spc:	lodsb
	cmp	al,20h			; Space - 20h, 32d
	jz	Spc			;gobble leading spaces
	dec	si			;back up from last LODSB
	mov	dx,si			; Save name pointer in DX	v1.2
Loop1:  lodsb				; Search for end of line
	cmp	al,0DH			;terminating CR?		v1.2
	jnz	Loop1			;nope
	dec	si			;back up to terminating CR
	mov	byte ptr [si],0h	; Set it to ASCIIZ string
	mov	ax,3D00h		; Open for read only
	int	21h			;DX -> filename			v1.2
	jb	BadName			;open failed			v1.1

	mov	bx,ax			;handle for upcoming read	v1.1
CODELEN	=	(progend-progstart+0Fh) SHR 4	;program length in paras v1.1
	mov	ax,CS			;v1.1
	add	ax,CODELEN+5		;v1.1
	mov	ES,ax			;into ES			v1.1
	mov	cx,100h /2		;PSP length in words		v1.1
	xor	si,si		;0	;v1.1
	xor	di,di		;0	;v1.1
	rep	movsw			;copy PSP (words are faster)	v1.1

	mov	ax,es
	mov	ds,ax
	ASSUME	DS:NOTHING,ES:NOTHING	;v1.1
	mov	ah,3Fh			; Read from file
	mov	cx,0FFFFh		; Can't be more than that...
	mov	dx,100h			;  (it's a COM file...)
	int	21h
	jb	ReadErr			;Read failed
	mov	cx,ax			;save real file size for later	v1.1
	mov	ah,3Eh			; Close file
	int	21h			;(BX still unchanged)		v1.1
	jmp	short Label1

NoFile:	mov	dx,offset NoFile_	;'No file specified'		v1.1
	jmp	short Print
BadName:
	mov	dx,offset BadName_	;'Bad file name'		v1.1
	jmp	short Print

;v1.1	CX has bytes read (file size).
Label1:	mov	al,8Bh			; ( equ MOV DI )		v1.1
	mov	di,100h			;search from prog start onward

Scan:	repnz	scasb			; Search for it
	jcxz	NotLite			;didn't find it
	cmp	word ptr [di],0CBF8h	; ( equ ,AX RETF )
	jnz	Scan			;wrong MOV DI, keep scanning

	dec	di			;back up to that MOV DI
	mov	byte ptr [di],0CCh	; ( equ INT 3 )
;Set up stack for the decompressing .COM program
;(Just like MS-DOS would do it)
	mov	ax,ds
	mov	ss,ax
	mov	sp,0FFFEh
	push	ax			;.COM program's CSEG
	mov	ax,100h			;first line of code
	push	ax			;fake a FAR's return address
	retf				; Jump to original program
					;where our breakpoint will	v1.1
					;handle the file write		v1.1
NotLite:mov	al,0FFH			;-1 error			v1.1
	mov	dx,offset NotLite_	;'Not compressed under PkLite...'
	jmp	short Print
ReadErr:mov	dx,offset ReadErr_	;'Error reading source file...'
Print:	push	ax			;save ERRORLEVEL in AL		v1.1
	mov	ax,cs
	mov	ds,ax
	ASSUME	DS:CSEG			;v1.1
	mov	ah,9h			; Display string
	int	21h
	mov	dx,offset Abort_	;'Program aborting.'		v1.1
	mov	ah,9			;v1.1
	int	21H			;v1.1
	pop	ax			;restore ERRORLEVEL in AL	v1.1
	EVEN				;To insure stack alignment	v1.1
progend	EQU	$			;v1.1
	mov	ah,4Ch			; Terminate process
	int	21h
CSEG	ENDS
	END	ExLite			;v1.1
