#include <stdio.h>
#include <memory.h>

typedef unsigned char BYTE;
typedef unsigned uint;

#define MUL(xx,yy,zz,ww) { _CL = yy;  \
	_AL = xx;		\
	asm mul cl;   \
	zz = _AL;     \
	ww = _AH;  }
	
BYTE ten[12] = { 0x40, 02, 0, 0, 0xa0, 0, 0, 0, 0, 0, 0, 0 };
BYTE pow7[8][12] = { 0x3f,0xff,0,0,0x80,0,0,0,0,0,0,0,0,0 };
BYTE powpow[12][12];

void rotr(BYTE *fl, int bytes, int bits)
{
	int bytemove = bits >> 3;
	int i,mask = 0,r=0;
	bits = bits & 7;
	for (i=0; i < bits; i++) {
		mask <<=1;
		mask |= 1;
	}
	for (i=0; i <bytes-bytemove; i++) {
		BYTE t = fl[i] & mask;
		BYTE q = fl[i] >> bits;
		
		fl[i+bytemove] = q+r;
		r = t << (8-bits);
	}
	for (i=0; i < bytemove; i++)
		fl[i] = 0;
}
void rotl(BYTE *fl, int bytes, int bits)
{
	int bytemove = bits >> 3;
	int i, mask = 0x00, r=0;
	bits = bits & 7;
	for (i=0; i <bits; i++) {
		mask >>= 1;
		mask |= 0x80;
	}
	for (i=bytes-1; i >=bytemove; i--) {
		BYTE t = fl[i] & mask;
		BYTE q = fl[i] << bits;
		fl[i-bytemove] = q+r;
		r = t >> (8-bits);
	}
}
int signif(BYTE *fl, int bytes)
{
	int j;
	for (j=0; j < bytes; j++) {
		int mask = 0x80,i=1;
		while (mask) {
			if (mask & fl[j])
				return((bytes-j)*8-i);
			i++;
			mask>>=1;
		}
	}
	return(-1);
}
void mul(BYTE *dest, BYTE *src)
{
	BYTE interrim[16], *srcw;
	long expd = ((dest[0] &0x7f)<< 8) + dest[1];
	long exps = ((src[0] &0x7f)<< 8) + src[1];
	long exp = expd + exps - 16383;
	int sign = (dest[0] ^ src[0]) & 0x80;
	int i,j;
	for (i=0; i < 16; i++)
		interrim[i] = 0;
	srcw = src+11;
	for (i=0; i < 8; i++) {
		BYTE carry = 0;
		BYTE temp;
		BYTE *ip = &interrim[15-i];
		BYTE *dstw = dest+11;
		for (j=0; j< 8; j++) {
			BYTE oldcarry = carry;
			MUL(*srcw,*dstw,temp,carry);
			carry+= (*ip + oldcarry + temp)>>8;
			*ip += oldcarry + temp;
			ip--;
			dstw--;
		}
		srcw--;
		*ip += carry;
	}
	if (interrim[0] & 0x80)
		exp++;
	else {
		j = 16*8-1-signif(interrim,16);
		rotl(interrim,16,j);
		exp-=j-1;
	}
	if (exp < 0)
		if (exp < -63) {
			for (i=0; i < 12; i++)
				dest[i] = 0;
			return;
		}
		else {
			rotr(interrim,8,-exp);
			exp = 0;
		}
	else
		if (exp > 32766) {
			exp = 32767;
			for (i=0; i < 8; i++)
				dest[i+4] = 0;
			return;
		}
	for (i=0; i < 8; i++)
		dest[i+4] = interrim[i];
	dest[0] = (exp >> 8) | sign;
	dest[1] = exp & 0xff;
}
void main(void)
{
	int i,j;
	BYTE dest[12];
	memcpy(dest,ten,12);
	memcpy(pow7[1],ten,12);
	for (i=2; i < 8; i++) {
		mul(dest,ten);
		memcpy(pow7[i],dest,12);
	}
	memcpy(dest,pow7[4],12);
	for (i=0; i <12; i++) {
		mul(dest,dest);
		memcpy(powpow[i],dest,12);
	}
	printf("\n = {");
	for (i=0; i <8; i++) {
		fputc('\n',stdout);
		for(j=0; j <12; j++)
			printf("0x%02x, ",pow7[i][j]);
	}
	printf(" } ;");
	for (i=0; i <12; i++) {
		printf("\n = {");
		for(j=0; j <12; j++)
			printf("0x%02x, ",powpow[i][j]);
		printf(" } ;");
	}
}