#include <stdio.h>   
#include <ctype.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include "cmdline.h"
#include "umem.h"
#include "asmcom.h"
#include "locgen.h"
#include "locopt.h"

extern int usedrevision;
extern int branchdefault;
extern BOOL usefp;

BOOL sizeoneisbad = TRUE;
int bytesize = 8;
int wordsize = 4;
char endian = 'M';
int macstyle = 1,ifstyle = 0;
long lconfig = LK_SIGNEDADDR;
char *typelist[] = { "","","" };
char *sectiontypes[] = { "","","" };

#define NUM_OPTIONS 6
char *tnames[] = { "68000","68010","68020","68030","xxxxx","CPU32" };
char procname[] = { "AS68K" };
uint prm_procrevision = 0;

void option(long type)
{
	if (!globoption(type)) {
		switch (type) {
			case OPTBRB:
			case OPTBRS:
				branchdefault = TBYTE;
				break;
			case OPTBRL:
				branchdefault = TLONG;
				break;
			case OPTBRW:
				branchdefault = TWORD;
				break;
			default:
				BadOption();
		}
	}
	dolist();
}
int poption( char *string)
{
	int i;
	for (i=0; i <strlen(string); i++)
		string[i] = toupper(string[i]);
	for (i=0; i < NUM_OPTIONS; i++)
		if (!strncmp(tnames[i], string,5)) {
			if (string[5]) {
				if (prm_procrevision != 5 && !strcmp(&string[5],"/68881"))
					usefp = TRUE;
				else 
					return 1;
			}
			prm_procrevision = i;
			if (i == 4)
				usefp = TRUE;
			if (i == 5)
				usedrevision = 5;
			return 0;
		}
	return 1;
}
void noption( EXPRESSION *q, EXPRESSION *r)
{
	if (checkval(q))
		switch (q->x.value) {
			case 68040L:
			case 40:
			case 4:
				prm_procrevision = 4;
				usefp = TRUE;
				break;
			case 68030L:
			case 30:
			case 3:
				prm_procrevision = 3;
				break;
			case 68020L:
			case 20:
			case 2:
				prm_procrevision = 2;
				break;
			case 68010L:
			case 10:
			case 1:
				prm_procrevision = 1;
				break;
			case 68000L:
			case 00:
				prm_procrevision = 0;
				break;
			default:
				BadOption();
		}
	if (r)
		if (checkval(r) && (r->x.value == 81 || r->x.value == 881 || r->x.value == 68881L))
			usefp = TRUE;
		else
			BadOption();
}
void optequexp(long type, EXPRESSION *exp, EXPRESSION *exp2)
{
	if (!checkval(exp))
		BadOption();
	else if (!globoptequexp(type,exp,exp2)) {
		switch(type) {
			case OPTEQUTARGET:
				noption(exp,exp2);
				break;
			default:
				BadOption();
		}
	}
	dolist();
}
void optequstring(long type, char *string)
{
	if (!globoptequstring(type,string))
		BadOption();
	dolist();
}
void getLinkName(int rev, char *buf)
{
	if (rev != 5) 
		sprintf(buf,"680%d0",rev);
	else
		strcpy(buf,"CPU32");
}